package com.jsegov.tddj.services;

import com.gtis.spring.Container;
import com.jsegov.tddj.dao.BHDAO;
import com.jsegov.tddj.services.interf.IBHService;
import com.jsegov.tddj.services.interf.IDWXXService;
import com.jsegov.tddj.services.interf.ITDZHBHService;
import com.jsegov.tddj.util.Common;
import com.jsegov.tddj.util.CommonUtil;
import com.jsegov.tddj.vo.*;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.List;

@Service
public class BhService implements IBHService {

    @Autowired
    BHDAO bhDAO;

    public String getZSGSBH() {
        // TODO Auto-generated method stub
        String currYear = CommonUtil.getCurrYear();
        String zsgsBHID = bhDAO.getZSGSBHID();
        StringBuffer sb = new StringBuffer();
        sb.append(currYear);
        sb.append("-");
        sb.append(zsgsBHID);
        return sb.toString();
    }

    private String getXZQShortName() {
        Common common = new Common();
        XZQ xzq = common.getXZQ();
        String xzqShortName = xzq.getXzqShortName();
        return xzqShortName;
    }

    private XZQ getXZQByXML() {
        Common common = new Common();
        XZQ xzq = common.getXZQ();
        return xzq;
    }

    private String getTDZHShortName(String projectId) {
        //获取土地证号简称


        ProjectService projectService = (ProjectService) Container.getBean("projectService");
        Project project = projectService.getProject(projectId);
        String dwdm = project.getDwdm();
        IDWXXService dwxxService = (IDWXXService) Container.getBean("dwxxService");
        DWXX dwxx = dwxxService.getDwxx(dwdm);
        String shortName = "";
        if (dwxx != null) {
            shortName = dwxx.getShortname();
        }
        return shortName;
    }

    //获取土地证流水号
    private String getTDZBH(String projectId, String zsType) {
        ProjectService projectService = (ProjectService) Container.getBean("projectService");
        Project project = projectService.getProject(projectId);
        String dwdm = project.getDwdm();
        ITDZHBHService tdzbhService = (ITDZHBHService) Container.getBean("tdzhBhService");
        TDZHBH tdzhbh = tdzbhService.getTDZHBH(dwdm, zsType);
        String zsno = "";
        if (tdzhbh != null) {
            Integer maxval = tdzhbh.getMaxval();
            if (maxval == null) {
                Integer minval = tdzhbh.getMinval();
                maxval = minval + 1;
                tdzhbh.setMaxval(maxval);
                tdzbhService.updateTDZHBH(tdzhbh);
            } else {
                maxval = maxval + 1;
                tdzhbh.setMaxval(maxval);
                tdzbhService.updateTDZHBH(tdzhbh);
            }
            zsno = maxval + "";
        } else {
            zsno = "1";
            tdzhbh = new TDZHBH();
            tdzhbh.setDwdm(dwdm);
            tdzhbh.setZstype(zsType);
            tdzhbh.setMinval(1);
            tdzhbh.setMaxval(1);
            tdzbhService.insertTDZHBH(tdzhbh);
        }
        return zsno;
    }

    public String getDJKBH() {
        // TODO Auto-generated method stub
        String currYear = CommonUtil.getCurrYear();
        String djkBHID = bhDAO.getDJKBHID();
        StringBuffer sb = new StringBuffer();
        String xzqShortName = getXZQShortName();
        sb.append(xzqShortName);
        sb.append("(");
        sb.append(currYear);
        sb.append(")");
        sb.append(djkBHID);
        return sb.toString();
    }

    public String getGYTDSYZBH() {
        // TODO Auto-generated method stub
        String currYear = CommonUtil.getCurrYear();
        String gytdsyzBHID = getTdzhFromDelTdzh("gytdsyz", null);
        if (StringUtils.isBlank(gytdsyzBHID)) {
            gytdsyzBHID = bhDAO.getGYTDSYZBHID();
        }else{
            return gytdsyzBHID;
        }
        StringBuffer sb = new StringBuffer();
        String xzqShortName = getXZQShortName();
        sb.append(xzqShortName);
        sb.append("国用(");
        sb.append(currYear);
        sb.append(")第");
        sb.append(gytdsyzBHID);
        sb.append("号");
        return sb.toString();
    }

    public String getGYTDSYZBH(String projectId) {
        String currYear = CommonUtil.getCurrYear();
        XZQ xzq = getXZQByXML();
        String xzqShortName = xzq.getXzqShortName();
        String townShortName = getTDZHShortName(projectId);
        String gytdsyzBHID = getTDZBH(projectId, "gytdsyz");
        String bh = xzq.getBh();
        if (bh != null && !bh.equals("")) {
            while (gytdsyzBHID.length() < bh.length()) {
                gytdsyzBHID = "0" + gytdsyzBHID;
            }
        }
        String tdzh = xzq.getGytdsyzFormat();
        //$countyShortName$$townShortName$国用($currYear$)第$bh$号


        tdzh = tdzh.replace("$countyShortName$", xzqShortName);
        tdzh = tdzh.replace("$townShortName$", townShortName);
        tdzh = tdzh.replace("$currYear$", currYear);
        tdzh = tdzh.replace("$bh$", gytdsyzBHID);
        return tdzh;
    }

    public String getJTTDSUZBH() {
        // TODO Auto-generated method stub
        String currYear = CommonUtil.getCurrYear();
        String jttdsuzBHID = getTdzhFromDelTdzh("jttdsuz", null);
        if (StringUtils.isBlank(jttdsuzBHID)) {
            jttdsuzBHID = bhDAO.getJTTDSUZBHID();
        }else{
            return jttdsuzBHID;
        }
        StringBuffer sb = new StringBuffer();
        String xzqShortName = getXZQShortName();
        sb.append(xzqShortName);
        sb.append("集有(");
        sb.append(currYear);
        sb.append(")第");
        sb.append(jttdsuzBHID);
        sb.append("号");
        return sb.toString();
    }

    public String getJTTDSUZBH(String projectId) {
        String currYear = CommonUtil.getCurrYear();
        XZQ xzq = getXZQByXML();
        String xzqShortName = xzq.getXzqShortName();
        String townShortName = getTDZHShortName(projectId);
        String jttdsuzBHID = getTDZBH(projectId, "jttdsuz");
        String bh = xzq.getBh();
        if (bh != null && !bh.equals("")) {
            while (jttdsuzBHID.length() < bh.length()) {
                jttdsuzBHID = "0" + jttdsuzBHID;
            }
        }
        String tdzh = xzq.getJttdsuzFormat();
        //$countyShortName$$townShortName$国用($currYear$)第$bh$号


        tdzh = tdzh.replace("$countyShortName$", xzqShortName);
        tdzh = tdzh.replace("$townShortName$", townShortName);
        tdzh = tdzh.replace("$currYear$", currYear);
        tdzh = tdzh.replace("$bh$", jttdsuzBHID);
        return tdzh;
    }

    public String getJTTDSYZBH() {
        // TODO Auto-generated method stub
        String currYear = CommonUtil.getCurrYear();
        String jttdsyzBHID = getTdzhFromDelTdzh("jttdsyz", null);
        if (StringUtils.isBlank(jttdsyzBHID)) {
            jttdsyzBHID = bhDAO.getJTTDSYZBHID();
        }else{
            return jttdsyzBHID;
        }
        StringBuffer sb = new StringBuffer();
        String xzqShortName = getXZQShortName();
        sb.append(xzqShortName);
        sb.append("集用(");
        sb.append(currYear);
        sb.append(")第");
        sb.append(jttdsyzBHID);
        sb.append("号");
        return sb.toString();
    }

    public String getJTTDSYZBH(String projectId) {
        String currYear = CommonUtil.getCurrYear();
        XZQ xzq = getXZQByXML();
        String xzqShortName = xzq.getXzqShortName();
        String townShortName = getTDZHShortName(projectId);
        String jttdsyzBHID = getTDZBH(projectId, "jttdsyz");
        String bh = xzq.getBh();
        if (bh != null && !bh.equals("")) {
            while (jttdsyzBHID.length() < bh.length()) {
                jttdsyzBHID = "0" + jttdsyzBHID;
            }
        }
        String tdzh = xzq.getJttdsyzFormat();
        //$countyShortName$$townShortName$国用($currYear$)第$bh$号


        tdzh = tdzh.replace("$countyShortName$", xzqShortName);
        tdzh = tdzh.replace("$townShortName$", townShortName);
        tdzh = tdzh.replace("$currYear$", currYear);
        tdzh = tdzh.replace("$bh$", jttdsyzBHID);
        return tdzh;
    }

    public String getSJDBH() {
        // TODO Auto-generated method stub
        String currYear = CommonUtil.getCurrYear();
        String sjdBHID = bhDAO.getSJDBHID();
        StringBuffer sb = new StringBuffer();
        String xzqShortName = getXZQShortName();
        sb.append(xzqShortName);
        sb.append("收件(");
        sb.append(currYear);
        sb.append(")第");
        sb.append(sjdBHID);
        sb.append("号");
        // sjdBH="镇土收件("+currYear+")第("+sjdBH+")号";
        return sb.toString();
    }

    public String getTXQLZMSBH() {
        String currYear = CommonUtil.getCurrYear();
        String txqlzmsBHID = getTdzhFromDelTdzh("txqlzms", null);
        if (StringUtils.isBlank(txqlzmsBHID)) {
            txqlzmsBHID = bhDAO.getTXQLZMSBHID();
        }else{
            return txqlzmsBHID;
        }
        String xzqShortName = getXZQShortName();
        StringBuffer sb = new StringBuffer();
        sb.append(xzqShortName);
        sb.append("他项(");
        sb.append(currYear);
        sb.append(")第");
        sb.append(txqlzmsBHID);
        sb.append("号");
        return sb.toString();
    }

    public String getTXQLZMSBH(String projectId) {
        String currYear = CommonUtil.getCurrYear();
        XZQ xzq = getXZQByXML();
        String xzqShortName = xzq.getXzqShortName();
        String townShortName = getTDZHShortName(projectId);
        String txqlzmsBHID = getTDZBH(projectId, "txqlzms");
        String bh = xzq.getBh();
        if (bh != null && !bh.equals("")) {
            while (txqlzmsBHID.length() < bh.length()) {
                txqlzmsBHID = "0" + txqlzmsBHID;
            }
        }
        String tdzh = xzq.getTxqlzmsFormat();
        //$countyShortName$$townShortName$国用($currYear$)第$bh$号


        tdzh = tdzh.replace("$countyShortName$", xzqShortName);
        tdzh = tdzh.replace("$townShortName$", townShortName);
        tdzh = tdzh.replace("$currYear$", currYear);
        tdzh = tdzh.replace("$bh$", txqlzmsBHID);
        return tdzh;
    }

    public Integer getBSM() {
        // TODO Auto-generated method stub
        return bhDAO.getBSM();
    }

    public Integer getReSetBH() {
        // TODO Auto-generated method stub
        return bhDAO.getReSetBH();
    }

    public String getGHKBH() {
        // TODO Auto-generated method stub
        String currYear = CommonUtil.getCurrYear();
        String ghkBHID = bhDAO.getGHKBHID();
        StringBuffer sb = new StringBuffer();
        String xzqShortName = getXZQShortName();
        sb.append(xzqShortName);
        sb.append("(");
        sb.append(currYear);
        sb.append(")第");
        sb.append(ghkBHID);
        sb.append("号");
        return sb.toString();
    }

    public String getFGZBH() {
        // TODO Auto-generated method stub
        String currYear = CommonUtil.getCurrYear();
        String fgzBHID = bhDAO.getFGZBHID();
        StringBuffer sb = new StringBuffer();
        String xzqShortName = getXZQShortName();
        sb.append(xzqShortName);
        sb.append("分割(");
        sb.append(currYear);
        sb.append(")第");
        sb.append(fgzBHID);
        sb.append("号");
        return sb.toString();
    }

    public String getZXBH() {
        // TODO Auto-generated method stub
        String currYear = CommonUtil.getCurrYear();
        String zxBHID = bhDAO.getZXBHID();
        StringBuffer sb = new StringBuffer();
        String xzqShortName = getXZQShortName();
        sb.append(xzqShortName);
        sb.append("注销(");
        sb.append(currYear);
        sb.append(")第");
        sb.append(zxBHID);
        sb.append("号");
        return sb.toString();
    }

    public String getSPBBH() {
        // TODO Auto-generated method stub
        String currYear = CommonUtil.getCurrYear();
        String spbBHID = bhDAO.getSPBBHID();
        StringBuffer sb = new StringBuffer();
        String xzqShortName = getXZQShortName();
        sb.append(xzqShortName);
        sb.append("审批(");
        sb.append(currYear);
        sb.append(")第");
        sb.append(spbBHID);
        sb.append("号");
        return sb.toString();
    }

    public String getSQBBH() {
        // TODO Auto-generated method stub
        String currYear = CommonUtil.getCurrYear();
        String sqbBHID = bhDAO.getSQBBHID();
        StringBuffer sb = new StringBuffer();
        String xzqShortName = getXZQShortName();
        sb.append(xzqShortName);
        sb.append("申请(");
        sb.append(currYear);
        sb.append(")第");
        sb.append(sqbBHID);
        sb.append("号");
        return sb.toString();
    }

    public String getSPBHBySqlx(String projectId, String sqlx, String qsxz) {
        // TODO Auto-generated method stub
        String spbh = "";
        if (qsxz.equals("国有土地使用权") || qsxz.equals("国有建设用地使用权") || qsxz.equals("国有农用地使用权")) {
            if (sqlx.equals("土地抵押权变更登记") || sqlx.equals("地役权变更登记") || sqlx.equals("土地使用权抵押权初始登记")
                    || sqlx.equals("土地使用权租赁权初始登记") || sqlx.equals("土地使用权地役权初始登记")
                    || sqlx.equals("他项权利证明书遗失补发登记") || sqlx.equals("土地租赁权变更登记")) {
                spbh = getTXQLZMSBH();
            } else if (sqlx.equals("国有土地使用权注销登记") || sqlx.equals("他项权利证明书注销登记")) {
                spbh = getZXBH();
            } else {
                spbh = getGYTDSYZBH();
            }
        } else if (qsxz.equals("集体土地使用权") || qsxz.equals("集体建设用地使用权") || qsxz.equals("集体农用地使用权") || qsxz.equals("宅基地使用权")) {
            if (sqlx.equals("土地抵押权变更登记") || sqlx.equals("地役权变更登记") || sqlx.equals("土地使用权抵押权初始登记")
                    || sqlx.equals("土地使用权租赁权初始登记") || sqlx.equals("土地使用权地役权初始登记")
                    || sqlx.equals("他项权利证明书遗失补发登记") || sqlx.equals("土地租赁权变更登记")) {
                spbh = getTXQLZMSBH();
            } else if (sqlx.equals("集体土地使用权注销登记") || sqlx.equals("他项权利证明书注销登记")) {
                spbh = getZXBH();
            } else {
                spbh = getJTTDSYZBH();
            }
        } else if (qsxz.equals("集体土地所有权")) {
            if (sqlx.equals("土地抵押权变更登记") || sqlx.equals("地役权变更登记") || sqlx.equals("土地使用权抵押权初始登记")
                    || sqlx.equals("土地使用权租赁权初始登记") || sqlx.equals("土地使用权地役权初始登记")
                    || sqlx.equals("他项权利证明书遗失补发登记") || sqlx.equals("土地租赁权变更登记")) {
                spbh = getTXQLZMSBH();
            } else if (sqlx.equals("集体土地所有权注销登记") || sqlx.equals("他项权利证明书注销登记")) {
                spbh = getZXBH();
            } else {
                spbh = getJTTDSUZBH();
            }
        }
        if (spbh == null || spbh.equals("")) {
            if (sqlx.equals("土地抵押权变更登记") || sqlx.equals("地役权变更登记") || sqlx.equals("土地使用权抵押权初始登记")
                    || sqlx.equals("土地使用权租赁权初始登记") || sqlx.equals("土地使用权地役权初始登记")
                    || sqlx.equals("他项权利证明书遗失补发登记") || sqlx.equals("土地租赁权变更登记")) {
                spbh = getTXQLZMSBH();
            } else if (sqlx.equals("国有土地使用权注销登记") || sqlx.equals("他项权利证明书注销登记")) {
                spbh = getZXBH();
            } else {
                spbh = getGYTDSYZBH();
            }
        }
        return spbh;
    }

    /**
     * 从删掉的证书编号表里获取tdzh
     *
     * @param zsType 必填
     * @param dwdm   可选
     * @return
     */
    public String getTdzhFromDelTdzh(String zsType, String dwdm) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (StringUtils.isNotBlank(zsType)) {
            map.put("zstype", zsType);
            if (StringUtils.isNotBlank(dwdm)) {
                map.put("dwdm", dwdm);
            }
            List<DelTdzh> listDelTdzhs = selectDelTdzh(map);
            if (listDelTdzhs != null && listDelTdzhs.size() > 0) {
                String tdzh = listDelTdzhs.get(0).getTdzh();
                deleteDelTdzh(listDelTdzhs.get(0).getProjectId());
                return tdzh;
            }
        } else {
            return null;
        }
        return null;
    }

    public Void createSq_GYTDSYZID() {
        // TODO Auto-generated method stub
        return bhDAO.createSq_GYTDSYZID();
    }

    public Void dropSq_GYTDSYZID() {
        // TODO Auto-generated method stub
        return bhDAO.dropSq_GYTDSYZID();
    }

    public Void createSq_DJKBHID() {
        // TODO Auto-generated method stub
        return bhDAO.createSq_DJKBHID();
    }

    public Void createSq_FGZBHID() {
        // TODO Auto-generated method stub
        return bhDAO.createSq_FGZBHID();
    }

    public Void createSq_GHKBHID() {
        // TODO Auto-generated method stub
        return bhDAO.createSq_GHKBHID();
    }

    public Void createSq_JTTDSUZBHID() {
        // TODO Auto-generated method stub
        return bhDAO.createSq_JTTDSUZBHID();
    }

    public Void createSq_JTTDSYZBHID() {
        // TODO Auto-generated method stub
        return bhDAO.createSq_JTTDSYZBHID();
    }

    public Void createSq_SJDBHID() {
        // TODO Auto-generated method stub
        return bhDAO.createSq_SJDBHID();
    }

    public Void createSq_SPBBHID() {
        // TODO Auto-generated method stub
        return bhDAO.createSq_SPBBHID();
    }

    public Void createSq_SQBBHID() {
        // TODO Auto-generated method stub
        return bhDAO.createSq_SQBBHID();
    }

    public Void createSq_TXQLZMSBHID() {
        // TODO Auto-generated method stub
        return bhDAO.createSq_TXQLZMSBHID();
    }

    public Void createSq_ZXBHID() {
        // TODO Auto-generated method stub
        return bhDAO.createSq_ZXBHID();
    }

    public Void dropSq_DJKBHID() {
        // TODO Auto-generated method stub
        return bhDAO.dropSq_DJKBHID();
    }

    public Void dropSq_FGZBHID() {
        // TODO Auto-generated method stub
        return bhDAO.dropSq_FGZBHID();
    }

    public Void dropSq_GHKBHID() {
        // TODO Auto-generated method stub
        return bhDAO.dropSq_GHKBHID();
    }

    public Void dropSq_JTTDSUZBHID() {
        // TODO Auto-generated method stub
        return bhDAO.dropSq_JTTDSUZBHID();
    }

    public Void dropSq_JTTDSYZBHID() {
        // TODO Auto-generated method stub
        return bhDAO.dropSq_JTTDSYZBHID();
    }

    public Void dropSq_SJDBHID() {
        // TODO Auto-generated method stub
        return bhDAO.dropSq_SJDBHID();
    }

    public Void dropSq_SPBBHID() {
        // TODO Auto-generated method stub
        return bhDAO.dropSq_SPBBHID();
    }

    public Void dropSq_SQBBHID() {
        // TODO Auto-generated method stub
        return bhDAO.dropSq_SQBBHID();
    }

    public Void dropSq_TXQLZMSBHID() {
        // TODO Auto-generated method stub
        return bhDAO.dropSq_TXQLZMSBHID();
    }

    public Void dropSq_ZXBHID() {
        // TODO Auto-generated method stub
        return bhDAO.dropSq_ZXBHID();
    }

    public Void createSq_ZSXL() {
        // TODO Auto-generated method stub
        return bhDAO.createSq_ZSXL();
    }

    public Void dropSq_ZSXL() {
        // TODO Auto-generated method stub
        return bhDAO.dropSq_ZSXL();
    }

    public Void createReSetBH(Integer startVal) {
        // TODO Auto-generated method stub
        return bhDAO.createReSetBH(startVal);
    }

    public Void dropReSetBH() {
        // TODO Auto-generated method stub
        return bhDAO.dropReSetBH();
    }

    public Integer getReSetBHCurrVal() {
        // TODO Auto-generated method stub
        return bhDAO.getReSetBHCurrVal();
    }

    public List<DelTdzh> selectDelTdzh(HashMap<String, Object> map) {
        return bhDAO.selectDelTdzh(map);
    }

    public void deleteDelTdzh(String projectId) {
        bhDAO.deleteDelTdzh(projectId);
    }

    public void insertDelTdzh(DelTdzh delTdzh) {
        bhDAO.insertDelTdzh(delTdzh);
    }

    /**
     * 获取数据库中四本证书类型的最大的编号
     * @param projectId
     * @param sqlx
     * @param qsxz
     * @return
     */
    public String getMaxTdzhBySqlx(String projectId, String sqlx, String qsxz) {
        String spbh = "";
        if (qsxz.equals("国有土地使用权") || qsxz.equals("国有建设用地使用权") || qsxz.equals("国有农用地使用权")) {
            if (sqlx.equals("土地抵押权变更登记") || sqlx.equals("地役权变更登记") || sqlx.equals("土地使用权抵押权初始登记")
                    || sqlx.equals("土地使用权租赁权初始登记") || sqlx.equals("土地使用权地役权初始登记")
                    || sqlx.equals("他项权利证明书遗失补发登记") || sqlx.equals("土地租赁权变更登记")) {
                spbh = getMaxTXQLZMSBH();
            } else if (sqlx.equals("国有土地使用权注销登记") || sqlx.equals("他项权利证明书注销登记")) {
//                spbh = getZXBH();
            } else {
                spbh = getMaxGYTDSYZBH();
            }
        } else if (qsxz.equals("集体土地使用权") || qsxz.equals("集体建设用地使用权") || qsxz.equals("集体农用地使用权") || qsxz.equals("宅基地使用权")) {
            if (sqlx.equals("土地抵押权变更登记") || sqlx.equals("地役权变更登记") || sqlx.equals("土地使用权抵押权初始登记")
                    || sqlx.equals("土地使用权租赁权初始登记") || sqlx.equals("土地使用权地役权初始登记")
                    || sqlx.equals("他项权利证明书遗失补发登记") || sqlx.equals("土地租赁权变更登记")) {
                spbh = getMaxTXQLZMSBH();
            } else if (sqlx.equals("集体土地使用权注销登记") || sqlx.equals("他项权利证明书注销登记")) {
//                spbh = getZXBH();
            } else {
                spbh = getMaxJTTDSYZBH();
            }
        } else if (qsxz.equals("集体土地所有权")) {
            if (sqlx.equals("土地抵押权变更登记") || sqlx.equals("地役权变更登记") || sqlx.equals("土地使用权抵押权初始登记")
                    || sqlx.equals("土地使用权租赁权初始登记") || sqlx.equals("土地使用权地役权初始登记")
                    || sqlx.equals("他项权利证明书遗失补发登记") || sqlx.equals("土地租赁权变更登记")) {
                spbh = getMaxTXQLZMSBH();
            } else if (sqlx.equals("集体土地所有权注销登记") || sqlx.equals("他项权利证明书注销登记")) {
//                spbh = getZXBH();
            } else {
                spbh = getMaxJTTDSUZBH();
            }
        }
        if (spbh == null || spbh.equals("")) {
            if (sqlx.equals("土地抵押权变更登记") || sqlx.equals("地役权变更登记") || sqlx.equals("土地使用权抵押权初始登记")
                    || sqlx.equals("土地使用权租赁权初始登记") || sqlx.equals("土地使用权地役权初始登记")
                    || sqlx.equals("他项权利证明书遗失补发登记") || sqlx.equals("土地租赁权变更登记")) {
                spbh = getMaxTXQLZMSBH();
            } else if (sqlx.equals("国有土地使用权注销登记") || sqlx.equals("他项权利证明书注销登记")) {
//                spbh = getZXBH();
            } else {
                spbh = getMaxGYTDSYZBH();
            }
        }
        return spbh;
    }

    /**
     * 获取数据库中证书最大的号
     * @return
     */
    public String getMaxTXQLZMSBH() {
        String currYear = CommonUtil.getCurrYear();
        String txqlzmsBHID = getTdzhFromDelTdzh("txqlzms", null);
        if (StringUtils.isBlank(txqlzmsBHID)) {
            txqlzmsBHID = bhDAO.getMaxTXQLZMSBHID();
            if(StringUtils.isBlank(txqlzmsBHID))
                txqlzmsBHID="1";
        }else{
            return txqlzmsBHID;
        }
        String xzqShortName = getXZQShortName();
        StringBuffer sb = new StringBuffer();
        sb.append(xzqShortName);
        sb.append("他项(");
        sb.append(currYear);
        sb.append(")第");
        sb.append(txqlzmsBHID);
        sb.append("号");
        return sb.toString();
    }

    public String getMaxGYTDSYZBH() {
        String currYear = CommonUtil.getCurrYear();
        String gytdsyzBHID = getTdzhFromDelTdzh("gytdsyz", null);
        if (StringUtils.isBlank(gytdsyzBHID)) {
            gytdsyzBHID = bhDAO.getMaxGYTDSYZBHID();
            if(StringUtils.isBlank(gytdsyzBHID))
                gytdsyzBHID="1";
        }else{
            return gytdsyzBHID;
        }
        StringBuffer sb = new StringBuffer();
        String xzqShortName = getXZQShortName();
        sb.append(xzqShortName);
        sb.append("国用(");
        sb.append(currYear);
        sb.append(")第");
        sb.append(gytdsyzBHID);
        sb.append("号");
        return sb.toString();
    }

    public String getMaxJTTDSYZBH() {
        String currYear = CommonUtil.getCurrYear();
        String jttdsyzBHID = getTdzhFromDelTdzh("jttdsyz", null);
        if (StringUtils.isBlank(jttdsyzBHID)) {
            jttdsyzBHID = bhDAO.getMaxJTTDSYZBHID();
            if(StringUtils.isBlank(jttdsyzBHID))
                jttdsyzBHID="1";
        }else{
            return jttdsyzBHID;
        }
        StringBuffer sb = new StringBuffer();
        String xzqShortName = getXZQShortName();
        sb.append(xzqShortName);
        sb.append("集用(");
        sb.append(currYear);
        sb.append(")第");
        sb.append(jttdsyzBHID);
        sb.append("号");
        return sb.toString();
    }

    public String getMaxJTTDSUZBH() {
        String currYear = CommonUtil.getCurrYear();
        String jttdsuzBHID = getTdzhFromDelTdzh("jttdsuz", null);
        if (StringUtils.isBlank(jttdsuzBHID)) {
            jttdsuzBHID = bhDAO.getMaxJTTDSUZBHID();
            if(StringUtils.isBlank(jttdsuzBHID))
                jttdsuzBHID="1";
        }else{
            return jttdsuzBHID;
        }
        StringBuffer sb = new StringBuffer();
        String xzqShortName = getXZQShortName();
        sb.append(xzqShortName);
        sb.append("集有(");
        sb.append(currYear);
        sb.append(")第");
        sb.append(jttdsuzBHID);
        sb.append("号");
        return sb.toString();
    }
}
