package com.jsegov.tddj.platform;

import com.gtis.plat.vo.*;
import com.jsegov.tddj.vo.Project;

import java.util.List;

public interface IPlatUtil {
    /**
     * 创建工作流
     *
     * @param project
     * @param userId
     * @return taskId
     */
    public String createWorkFlowInstance(Project project, String userId);

    /**
     * 获取承诺期限(项目时限)
     *
     * @param wdid
     * @return
     */
    public int getCNQX(String wdid);

    /**
     * 根据taskid获取活动实例Id
     *
     * @param taskId
     * @return activityName
     */
    public String getPfActivityIdByTaskId(String taskId);

    /**
     * 通过projectId 获取工作流定义的remark
     *
     * @param projectId
     * @return
     */
    public String getWfRemarkByProjectId(String projectId);

    /**
     * 通过工作流定义ID(Wdid) 获取工作流定义的remark
     *
     * @param wdid
     * @return
     */
    public String getWfRemarkByWdid(String wdid);

    /**
     * 获取实例时限
     *
     * @param wdid
     * @return
     */
    public int getTimeLimit(String wdid);

    /**
     * 修改实例名称
     *
     * @param projectId
     * @param projectName
     */
    public void editWorkFlowInstanceName(String projectId, String projectName);

    /**
     * 修改实例remark+projectName projectname可以为空
     *
     * @param projectId
     * @param remark
     * @param projectName
     */
    public void editWorkFlowInstance(String projectId, String remark,
                                     String projectName);

    /**
     * 根据taskid获取活动实例名称
     *
     * @param taskId
     * @return activityName
     */
    public String getPfActivityNameByTaskId(String taskId);

    /**
     * 获取活动定义的描述
     *
     * @param wfInstance
     * @param wfActivity
     * @return
     */
    public String getActivityDesc(String projectId, String activityId);

    /**
     * zdd 根据用户Id，查找其所属部门。如果用户属于多个部门，则默认读取第一个
     *
     * @param userId
     * @return List<String>
     */
    public String getOrganByUser(String userId);

    /**
     * 返回所有平台用户
     *
     * @return
     */
    public List<String> getAllUser();

    /**
     * zdd 返回所有部门
     *
     * @return
     */
    public List<String> getAllOrgan();

    public void updateGlobalVal(String projectId, String GobalValName, Object value);

    /**
     * zdd 根据项目ID获取项目对应文件中心的文件ID
     *
     * @param projectId
     * @return
     */
    public List<String> getFileId(String projectId);

    /**
     * zdd 根据项目ID于附件的描述获取文件的Id
     *
     * @param projectId
     * @param desc
     * @return
     */
    public List<String> getFileId(String projectId, String desc);

    public void saveNodeDesc(Integer fileId, String desc);

    public void removeFile(Integer fileId);

    public List<PfWorkFlowDefineVo> getWorkFlowDefine();

    public List<PfBusinessVo> getBusinessVo();

    List<String> getSystemResrouceFunAuthorList(String roles, String rid);

    /**
     * 根据用户ID  获取同部门的科长  默认第一个
     *
     * @param userId
     * @return
     */
    public String getOrganManger(String userId);

    public PfWorkFlowDefineVo getPfWorkFlowDefineVo(String wdid);

    /**
     * 根据用户获取部门信息(如果一个用户在多个部门取第一个部门)
     *
     * @param userId
     * @return
     */
    public PfOrganVo getOrganByUserId(String userId);

    /**
     * 根据用户id和角色id获取同一部门的所有用户名称
     *
     * @param userId
     * @param rid
     * @return
     */
    public List<String> getUserNameInOrganByUserId(String userId);

    /**
     * 根据用户id获取所有角色
     *
     * @param userId
     * @return
     */
    public List<PfRoleVo> getRoleListByUser(String userId);

    /**
     * 根据用户id获取用户信息
     *
     * @param userId
     * @return
     */
    public PfUserVo getUserVo(String userId);

    /**
     * 编辑文件描述和姓名
     *
     * @param fileId
     * @param desc
     * @param projectId
     */
    public void saveNodeDescByProjectId(Integer fileId, String desc, String projectId);
}