package com.jsegov.tddj.fileUpload;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.tools.zip.ZipEntry;
import org.apache.tools.zip.ZipFile;
import org.apache.tools.zip.ZipOutputStream;

public class ZipUtil {   
    Log logger = LogFactory.getLog(ZipUtil.class);   
  
    
    /**
     * 压缩文件
     * @param sourceDir　　源文件目录

     * @param zipFile　　　压缩后的zip文件名称
     */
    public static void zip(String sourceDir, String zipFile) { 

        OutputStream os; 

        try { 

            os = new FileOutputStream(zipFile); 
            BufferedOutputStream bos = new BufferedOutputStream(os); 
            ZipOutputStream zos = new ZipOutputStream(bos); 
            File file = new File(sourceDir); 
            String basePath = null ; 
            if (file.isDirectory()) { 
               basePath = file.getPath(); 
            } else { 
               basePath = file.getParent(); 
            } 
            zipFile (file, basePath, zos); 
            zos.closeEntry(); 
            zos.close(); 
            bos.close();
        } catch (Exception e) { 
            e.printStackTrace(); 
        } 
    } 


    /**
     * 
     * @param source
     * @param basePath
     * @param zos
     */
     private static void zipFile(File source, String basePath, 

            ZipOutputStream zos) { 

        File[] files = new File[0]; 

   

        if (source.isDirectory()) { 

            files = source.listFiles(); 

        } else { 

            files = new File[1]; 

            files[0] = source; 

        } 

   

        String pathName; 

        byte [] buf = new byte [1024]; 

        int length = 0; 

        try { 

            for (File file : files) { 

               if (file.isDirectory()) { 
                   pathName = file.getPath().substring(basePath.length() + 1) + "/" ; 
                   zos.putNextEntry( new ZipEntry(pathName)); 
                   zipFile (file, basePath, zos); 
               } else { 
                   pathName = file.getPath().substring(basePath.length() + 1); 
                   InputStream is = new FileInputStream(file); 
                   BufferedInputStream bis = new BufferedInputStream(is); 
                   zos.putNextEntry( new ZipEntry(pathName)); 
                   while ((length = bis.read(buf)) > 0) { 
                      zos.write(buf, 0, length); 
                   }
                   bis.close();
                   is.close(); 
               } 

            } 

        } catch (Exception e) { 

            // TODO Auto-generated catch block 

            e.printStackTrace(); 

        } 
     } 
  
    public static void unZip(String zipfile, String destDir) throws Exception{ 

        destDir = destDir.endsWith("\\") ? destDir : destDir + "\\";
		byte b[] = new byte[1024];
		int length;
		ZipFile zipFile = new ZipFile(new File(zipfile));
		Enumeration enumeration = zipFile.getEntries();
		ZipEntry zipEntry = null;
		while (enumeration.hasMoreElements()) {
			zipEntry = (ZipEntry) enumeration.nextElement();
			File loadFile = new File(destDir + zipEntry.getName());
			if (zipEntry.isDirectory()) {
				// 这段都可以不要，因为每次都貌似从最底层开始遍历的
				loadFile.mkdirs();
			} else {
				if (!loadFile.getParentFile().exists())
					loadFile.getParentFile().mkdirs();
				OutputStream outputStream = new FileOutputStream(loadFile);
				InputStream inputStream = zipFile.getInputStream(zipEntry);
				while ((length = inputStream.read(b)) > 0)
					outputStream.write(b, 0, length);
				inputStream.close();
				outputStream.close();
			}
		}
	} 

    /**
	 * 判断zip文件是否格式有效
	 * 
	 * @param filePath
	 * @return
	 * @throws ZipFileInvalidException
	 */
    public static boolean checkZipFileValid(String filePath) throws ZipFileInvalidException{ 
    	if (filePath == null || filePath.trim().length() ==0){
    		throw new ZipFileInvalidException(ZipFileInvalidException.FILEPATH_NULL_EXCEPTION_DESC,ZipFileInvalidException.FILEPATH_NULL_EXCEPTION);
    	}
    	try {
			ZipFile zipFile = new ZipFile( new File(filePath));
		} catch (IOException e) {
			// TODO Auto-generated catch block
			//e.printStackTrace();
			throw new ZipFileInvalidException(
					ZipFileInvalidException.ZIPFILE_FORMAT_ERROR_EXCEPTION_DESC,
					ZipFileInvalidException.ZIPFILE_FORMAT_ERROR_EXCEPTION);
		}

		return true;
    }
  
    /**  
     * @param args  
     */  
    public static void main(String[] args) {   
        String unzipfile = "D:\\Downloads\\book\\天下衙门.TXT"; // 解压缩的文件名   
        String saveTo = "D:\\Downloads\\book\\天下衙门";   
//         ZipUtil.unZip(unzipfile, saveTo);   
         
    }  
}
