package com.jsegov.tddj.fileUpload;

public class ZipFileInvalidException extends Exception{
	
	
	public final static  int  UNKNOWN_EXCEPTION = 0;
	public final static  int  FILEPATH_NULL_EXCEPTION = 1;
	public final static  int  ZIPFILE_FORMAT_ERROR_EXCEPTION = 2;
	
	
	public final static  String UNKNOWN_EXCEPTION_DESC = "未知的zip文件无效异常";
	public final static  String FILEPATH_NULL_EXCEPTION_DESC = "文件名为空或者文件路径不存在";
	public final static  String ZIPFILE_FORMAT_ERROR_EXCEPTION_DESC = "zip文件格式无效";
	
	
	
	private int exceptionType = UNKNOWN_EXCEPTION;
	
	
	
	public int getExceptionType() {
		return exceptionType;
	}
	public void setExceptionType(int exceptionType) {
		this.exceptionType = exceptionType;
	}
	
	public ZipFileInvalidException() {
		super();
	}
	public ZipFileInvalidException(String msg) {
		super(msg);
	}
	public ZipFileInvalidException(String msg,int exceptionType) {
		super(msg);
		this.exceptionType = exceptionType;
	}
	public ZipFileInvalidException(String msg, Throwable cause) {
		super(msg, cause);
	}
	
	public ZipFileInvalidException(String msg, Throwable cause,int exceptionType) {
		super(msg, cause);
		this.exceptionType = exceptionType;
	}
	public ZipFileInvalidException(Throwable cause) {
		super(cause);
	}
	
}
