package com.jsegov.tddj.fileUpload;

import java.io.File;
import java.util.Calendar;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.jsegov.tddj.vo.BWDVo;

public class DataParse {
	public final static String CHANGE_INFO_FILE_SUFFIX="变更一览表";
	public final static String PROJ_INFO_FILE_SUFFIX="信息表";
	public final static String METADATA_FILE_SUFFIX="增量元数据";
	public final static String PNT_COORD_FILE_SUFFIX="坐标";
	public final static String BWD_FILE_SUFFIX="批次信息";

	public final static int CHANGE_INFO_FILE_BEGIN_ROW_NO=4;
	public final static int PROJ_INFO_FILE_BEGIN_ROW_NO=1;
	
	private String importZipFile = null;
	private boolean zipFileValid = true;
	private StringBuffer checkLogBuf = new StringBuffer();
	private String destDir;
	
	
	
	Log log = LogFactory.getLog(this.getClass());
	
	
	public DataParse(String importZipFile) throws Exception{
		this.importZipFile = importZipFile;
//		zipFileValid = ZipUtil.checkZipFileValid(importZipFile);
		
	}
	
	/**
	 * 解析ZIP数据,并生成对应的map数据集

	 */
	public DataParseResult parseProjZipData(String regionCode) throws Exception{
		
		DataParseResult dataParseResult = new DataParseResult();
		dataParseResult.setRegionCode(regionCode);
		String curClassDir = this.getClass().getResource("").getPath();
	
		destDir = curClassDir.substring(0,curClassDir.indexOf("WEB-INF"));
		
		if (importZipFile == null || importZipFile.trim().length()==0){
			return dataParseResult;
		}
		destDir = destDir +"\\temp\\" + String.valueOf(Calendar.getInstance().getTimeInMillis());
		
		File destDirFile = new File(destDir);
		if (destDirFile.exists()){
			destDirFile.delete();
		}
		
		destDirFile.mkdir();
		try {
			ZipUtil.unZip(importZipFile, destDir);
		} catch (Exception e) {
			e.printStackTrace();
			throw new Exception("文件解压失败，请检查zip文件是否正确!");
		}
		File file = new File(destDir);
		if (file.isDirectory()){
			File[] projDirList = file.listFiles();
			if (projDirList != null && projDirList.length > 0){
				for (int i=0 ;i < projDirList.length;i++){
					//对每个项目的材料进行遍历
					File tempProjDirFile = projDirList[i];
					if(tempProjDirFile.isFile()){
						String tempFileName = tempProjDirFile.getName();
						if (tempFileName == null){
							tempFileName = "";
						}
						tempFileName = tempFileName.trim();
						String  fileFullPath = tempProjDirFile.getAbsolutePath();
					}
				}
			}
		} 
		return dataParseResult;
	}

	public String getDestDir() {
		return destDir;
	}

	public void setDestDir(String destDir) {
		this.destDir = destDir;
	}


}
