package com.jsegov.tddj.dao;

import java.util.HashMap;
import java.util.List;

import org.springframework.orm.ibatis.support.SqlMapClientDaoSupport;
import com.jsegov.tddj.util.CommonUtil;
import com.jsegov.tddj.vo.FGZ;
import com.jsegov.tddj.vo.XZQ;

public class FGZDAO extends SqlMapClientDaoSupport {

	public FGZ getFGZ(FGZ fgz) {
		// TODO Auto-generated method stub
		return (FGZ)getSqlMapClientTemplate().queryForObject("selectFGZ", fgz);
	}

	public List getFGZByProjectID(String projectId) {
		// TODO Auto-generated method stub
		FGZ fgz = new FGZ();
		fgz.setProjectId(projectId);
		return (List) getSqlMapClientTemplate().queryForList("selectFGZ", fgz);
	}

	public void insertFGZ(FGZ fgz) {
		// TODO Auto-generated method stub
		getSqlMapClientTemplate().insert("insertFGZ", fgz);
	}

	public void updateFGZ(FGZ fgz) {
		// TODO Auto-generated method stub
		getSqlMapClientTemplate().update("updateFGZ", fgz);
	}

	public void deleteFGZ(FGZ fgz) {
		// TODO Auto-generated method stub
		getSqlMapClientTemplate().delete("deleteFGZ", fgz);
	}

	public void updateFGZH(String projectId) {
		// TODO Auto-generated method stub
		HashMap<String, String> map= new HashMap<String, String>();
		map.put("projectId", projectId);
		XZQ xzq = new XZQ();
		xzq = CommonUtil.getXZQ();
		map.put("tdzh1",xzq.getXzqShortName()+"分割(");
		map.put("tdzh2",")第");
		map.put("tdzh3","号");
		getSqlMapClientTemplate().update("updateFGZH", map);
	}

	public FGZ getFGZById(String fgzid) {
		// TODO Auto-generated method stub
		return (FGZ)getSqlMapClientTemplate().queryForObject("selectFGZById", fgzid);
	}

	public List<FGZ> getFGZByDjh(String djh) {
		// TODO Auto-generated method stub
		FGZ fgz = new FGZ();
		fgz.setDjh(djh);
		return (List) getSqlMapClientTemplate().queryForList("selectFGZ", fgz);
	}

	public List getFGZ(HashMap<String, Object> map) {
		// TODO Auto-generated method stub
		//System.out.println(map);
		return (List) getSqlMapClientTemplate().queryForList("queryFGZ", map);
	}

	public List<Object> expFgz(HashMap<String, Object> map) {
		// TODO Auto-generated method stub
		return getSqlMapClientTemplate().queryForList("queryFGZ", map);
	}
	
	
}
