package com.jsegov.tddj.check;

import com.jsegov.tddj.dao.YYDJDAO;
import com.jsegov.tddj.vo.CheckReturnMsg;
import com.jsegov.tddj.vo.YYDJ;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.Map;

/**
 * Created by IntelliJ IDEA.
 * User: pyonline
 * Date: 12-4-17
 * Time: 上午11:31
 * Des:
 * To change this template use File | Settings | File Templates.
 */
@Service
public class CreateTaskCheckYydjImpl implements CreateTaskCheck {
    @Autowired
    YYDJDAO  yydjDAO;

    @Override
    public CheckReturnMsg run(Map params) {
        CheckReturnMsg msg = null;
        String tdzh = (params.get("tdzh")==null)?"":params.get("tdzh").toString();

        HashMap<String , String> map = new HashMap<String , String>();
        map.put("tdzh", tdzh);
        map.put("isjc", "0");  //  判断 未 解除异议 的

        YYDJ yydj = yydjDAO.getYYDJ(map);
        if (yydj != null ){
            //returnMessage = yydj.getSqr() + "对该土地证有异议，原因：" + yydj.getYyyy() + "！";
            msg= new CheckReturnMsg();
            msg.setCheckModel(CheckReturnMsg.MsgModel.ALERT);
            msg.setReturnMessage(yydj.getSqr() + "对该土地证有异议！");
        }
        return msg;
    }
}
