package com.jsegov.tddj.check;

import com.gtis.spring.Container;
import com.jsegov.tddj.dao.YGDJDAO;
import com.jsegov.tddj.services.interf.IYGDJService;
import com.jsegov.tddj.vo.CheckReturnMsg;
import com.jsegov.tddj.vo.YGDJ;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;

/**
 * Created by IntelliJ IDEA.
 * User: pyonline
 * Date: 12-4-17
 * Time: 上午11:38
 * Des:
 * To change this template use File | Settings | File Templates.
 */
@Service
public class CreateTaskCheckYgdjImpl implements CreateTaskCheck {
    @Autowired
    YGDJDAO ygdjDAO;

    @Override
    public CheckReturnMsg run(Map params) {
        CheckReturnMsg msg = null;
        String djlx = (params.get("djlx")==null)?"":params.get("djlx").toString();
        String tdzl = (params.get("tdzl")==null)?"":params.get("tdzl").toString();
        String qlr = (params.get("qlr")==null)?"":params.get("qlr").toString();

        HashMap<String , String> map = new HashMap<String , String>();
        map.put("zl", tdzl);
        map.put("islogout", "0");
        YGDJ ygdj = ygdjDAO.getYGDJ(map);
        //权利人与预告登记中记录的权利人不一致

        if (ygdj != null){
            if ("预告登记".equals(djlx) && ygdj.getYgsqr().equals(qlr)){
                //预告登记时检查避免重复申请预告登记
                msg = new CheckReturnMsg();
                msg.setCheckModel(CheckReturnMsg.MsgModel.ALERT);
                msg.setReturnMessage(ygdj.getYgsqr()  + "已对该土地申请预告登记！");
                //returnMessage = ygdj.getQlr() + "于" + ygdj.getShrq() + "对该土地申请预告登记，原因：" + ygdj.getYgyy() + "！";
            }else if (!ygdj.getYgsqr().equals(qlr)){
                //其它流程，检查是否预告登记中预告申请人与项目申请人是否一致
                Date sxrq = ygdj.getSxrq();
                //当前日期大于失效日期时 自动注销预告登记
                if (sxrq==null || sxrq.compareTo(new Date())>0){
                    msg = new CheckReturnMsg();
                    msg.setCheckModel(CheckReturnMsg.MsgModel.ALERT);
                    msg.setReturnMessage(ygdj.getYgsqr()  + "已对该土地申请预告登记！");
                } else {
                    ygdj.setIslogout(1);
                    IYGDJService ygdjService = (IYGDJService) Container.getBean("ygdjService");
                    ygdjService.updateYGDJ(ygdj);
                }
            }
        }
        return msg;
    }
}
