package com.jsegov.tddj.check;

import com.jsegov.tddj.dao.GytdsyzDAO;
import com.jsegov.tddj.dao.JttdsuzDAO;
import com.jsegov.tddj.dao.JttdsyzDAO;
import com.jsegov.tddj.dao.TxqlzmsDAO;
import com.jsegov.tddj.vo.*;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Map;

/**
 * Created by IntelliJ IDEA.
 * User: pyonline
 * Date: 12-4-17
 * Time: 上午11:47
 * Des:
 * To change this template use File | Settings | File Templates.
 */
@Service
public class CreateTaskCheckTdzhIsExistImpl implements CreateTaskCheck {
    @Autowired
    GytdsyzDAO gytdsyzDAO;
    @Autowired
    JttdsyzDAO jttdsyzDAO;
    @Autowired
    JttdsuzDAO jttdsuzDAO;
    @Autowired
    TxqlzmsDAO txqlzmsDAO;

    @Override
    public CheckReturnMsg run(Map params) {
        CheckReturnMsg msg = new CheckReturnMsg();

        String tdzh = (params.get("tdzh")==null)?"":params.get("tdzh").toString();
        String qsxz = (params.get("qsxz")==null)?"":params.get("qsxz").toString();
        String sqlx = (params.get("sqlx")==null)?"":params.get("sqlx").toString();
        if(sqlx.indexOf("他项")>-1){
            qsxz = "TX";
        }

        if ("GY".equals(qsxz)){
            GYTDSYZ gytdsyz = new GYTDSYZ();
            gytdsyz.setTdzh(tdzh);
            GYTDSYZ resultGytdsyz = (GYTDSYZ)gytdsyzDAO.getGytdsyz(gytdsyz);
            if (resultGytdsyz == null){
                msg = new CheckReturnMsg();
                msg.setCheckModel(CheckReturnMsg.MsgModel.ALERT);
                msg.setReturnMessage("该土地证：" + tdzh + "不存在！");
            }
        }else if("JY".equals(qsxz)){
            JTTDSYZ jttdsyz = new JTTDSYZ();
            jttdsyz.setTdzh(tdzh);
            JTTDSYZ resultJttdsyz = (JTTDSYZ)jttdsyzDAO.getJTTDSYZ(jttdsyz);
            if (resultJttdsyz == null){
                msg = new CheckReturnMsg();
                msg.setCheckModel(CheckReturnMsg.MsgModel.ALERT);
                msg.setReturnMessage("该土地证：" + tdzh + "不存在！");
            }
        }else if("JU".equals(qsxz)){
            JTTDSUZ jttdsuz = new JTTDSUZ();
            jttdsuz.setTdzh(tdzh);
            JTTDSUZ resultJttdsuz = (JTTDSUZ)jttdsuzDAO.getJTTDSUZ(jttdsuz);
            if (resultJttdsuz ==  null){
                msg = new CheckReturnMsg();
                msg.setCheckModel(CheckReturnMsg.MsgModel.ALERT);
                msg.setReturnMessage("该土地证：" + tdzh + "不存在！");
            }
        }else if("TX".equals(qsxz)){
            TXQLZMS txqlzms = new TXQLZMS();
            txqlzms.setTdzh(tdzh);
            TXQLZMS resultTxqlzms = (TXQLZMS)txqlzmsDAO.getTXQLZMS(txqlzms);
            if (resultTxqlzms ==  null){
                msg = new CheckReturnMsg();
                msg.setCheckModel(CheckReturnMsg.MsgModel.ALERT);
                msg.setReturnMessage("该土地证：" + tdzh + "不存在！");
            }
        }
        return msg;
    }
}
