package com.jsegov.tddj.check;

import com.gtis.spring.Container;
import com.jsegov.tddj.dao.GytdsyzDAO;
import com.jsegov.tddj.services.ZdDjdcbService;
import com.jsegov.tddj.services.interf.IZD_DJDCBService;
import com.jsegov.tddj.util.CommonUtil;
import com.jsegov.tddj.vo.CheckReturnMsg;
import com.jsegov.tddj.vo.GYTDSYZ;
import com.jsegov.tddj.vo.ZD_DJDCB;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Map;

/**
 * Created by IntelliJ IDEA.
 * User: pyonline
 * Date: 12-4-17
 * Time: 下午6:35
 * Des:
 * To change this template use File | Settings | File Templates.
 */
@Service
public class CreateTaskCheckFgdjImpl implements CreateTaskCheck {
    @Autowired
    GytdsyzDAO gytdsyzDAO;

    @Autowired
    ZdDjdcbService dcbService;

    @Override
    public CheckReturnMsg run(Map params) {
        CheckReturnMsg msg = null;

        String tdzh = (params.get("tdzh")==null)?"":params.get("tdzh").toString();
        String djh = (params.get("djh")==null)?"":params.get("djh").toString();
        if(StringUtils.isBlank(djh))
             return null;

        Double zsmj = 0.0;
        Double zdmj = 0.0;
        GYTDSYZ gytdsyz = new GYTDSYZ();
        gytdsyz.setTdzh(tdzh);
        gytdsyz = (GYTDSYZ)gytdsyzDAO.getGytdsyz(gytdsyz);
        if (gytdsyz!=null && gytdsyz.getSyqmj() !=null && gytdsyz.getSyqmj()!=0.0){
            zsmj = gytdsyz.getSyqmj();
        }

        ZD_DJDCB djdcb = new ZD_DJDCB();
        djdcb.setDjh(djh);
        djdcb = dcbService.selectDjdcb(djdcb);
        if (djdcb!=null &&  djdcb.getFzmj() !=null &&  djdcb.getFzmj()!=0.0){
            zdmj = djdcb.getFzmj();
        }
        zdmj = CommonUtil.formatNumber(zdmj);
        if (gytdsyz!=null && djdcb!=null && zsmj<zdmj){
            msg = new CheckReturnMsg();
            msg.setCheckModel(CheckReturnMsg.MsgModel.ALERT);
            msg.setReturnMessage("总土地证："+tdzh+"的面积小于"+djh+"的面积！");
        }
        return msg;
    }
}
