package com.jsegov.tddj.action;

import java.io.PrintWriter;
import java.util.ArrayList;

import javax.servlet.http.HttpServletResponse;

import com.jsegov.tddj.platform.IPlatUtil;
import com.jsegov.tddj.platform.IqlygUtil;
import com.jsegov.tddj.services.interf.ISPBService;
import com.jsegov.tddj.util.CommonUtil;
import com.jsegov.tddj.vo.SPB;
import org.apache.commons.lang.StringUtils;
import org.apache.struts2.ServletActionContext;

import com.gtis.plat.service.SysTaskService;
import com.gtis.plat.service.SysWorkFlowInstanceService;
import com.gtis.plat.vo.PfActivityVo;
import com.gtis.plat.vo.PfWorkFlowInstanceVo;
import com.gtis.spring.Container;
import com.jsegov.tddj.workflow.WfActivity;
import com.jsegov.tddj.workflow.WfInstance;
import com.jsegov.tddj.workflow.WorkFlowEvent;
import com.opensymphony.xwork2.ActionSupport;

/**
 * <p/>
 * 工作流事件处理类，负责处理各类工作流事件,工作流事件在处理时首先进入该类，然后由该类实例化
 * 相关具体的事件处理类进行处理
 * @author xtdi
 * @version V1.0, 2010-3-3
 */
public class WfEventHandleAction extends ActionSupport {

    public final static String  EVENT_TYPE_WORKFLOW_BEGIN = "WorkFlow_Begin";           //工作流创建以后执行本事件
    public final static String  EVENT_TYPE_WORKFLOW_BEFORETURN = "WorkFlow_BeforeTurn";  //转发之前执行本事件

    public final static String  EVENT_TYPE_WORKFLOW_TURN = "WorkFlow_Turn";               //转发之后执行本事件

    public final static String  EVENT_TYPE_WORKFLOW_BACK = "WorkFlow_Back";      //回退之后执行本事件

    public final static String  EVENT_TYPE_WORKFLOW_STOP = "WorkFlow_Stop";      //中止之后执行本事件

//    public final static String  EVENT_TYPE_TURE_OVER_AFTER = "TureOverAfter";      //转发结束后执行本事件
    public final static String  EVENT_TYPE_WORKFLOW_DEL = "WorkFlow_Del";           //工作流删除后执行本事件             
//    public final static String  EVENT_TYPE_GET_BACK_AFTER = "GetBackAfter";        //任务取回后执行本事件
    public final static String  EVENT_TYPE_WORKFLOW_END = "WorkFlow_End";               //工作流办结束后执行本事件




    private String  proid;   //项目的主键id
    private String  eventHandleClass; //事件处理的类路径
    private String  eventName;//事件处理的方法

//    private SysWorkFlowInstanceService sysWorkFlowInstanceService;
//    private SysTaskService sysTaskService;
    private String activityid;
    private String userid;
    private String taskid;
    private String msg;
    
  	public String execute() throws Exception {
 //       String url = ServletActionContext.getRequest().getRequestURI();
        if(eventHandleClass == null || eventHandleClass.trim().length() == 0
                || eventName == null || eventName.trim().length()==0){
             return ActionSupport.NONE;
        }                          
        try{
          Class eventHandle  = Class.forName(eventHandleClass);
          Object instance = eventHandle.newInstance();
          if (instance  instanceof WorkFlowEvent)   {     
              //如果是工作流事件处理类则处理事件
              WorkFlowEvent workflowEvent = (WorkFlowEvent)instance;
              invokeMethod(workflowEvent);             
          }
        }catch(Exception ex){
            ex.printStackTrace();
        }
        
        if(msg!=null && !msg.equals("")){
			HttpServletResponse response=ServletActionContext.getResponse();
			response.setContentType("text/xml;charset=GBK");
			PrintWriter out = response.getWriter();
			out.println(msg);
			out.flush();
			out.close();
        }
        
        return ActionSupport.NONE;
    }

    /**
     * 调用方法
     * @param workflowEvent   
     */
    private void invokeMethod(WorkFlowEvent workflowEvent) {

        //SysTaskService   sysTaskService = PlatUtil.getSysTaskService();
        SysTaskService sysTaskService = (SysTaskService)Container.getBean("SysTaskService");
        SysWorkFlowInstanceService   sysWorkFlowInstanceService = (SysWorkFlowInstanceService)Container.getBean("SysWorkFlowInstanceService");
        PfWorkFlowInstanceVo pfWorkFlowInstanceVo = sysWorkFlowInstanceService.getWorkflowInstanceByProId(proid);
        PfActivityVo pfActivityVo = sysTaskService.getActivity(this.activityid);
        WfInstance wfInstance=transformtoWfInstance(pfWorkFlowInstanceVo);
        WfActivity wfActivity=transformtoWfActivity(pfActivityVo);
        IqlygUtil qlygUtil = (IqlygUtil)Container.getBean("qlygUtil");

        if (eventName.equalsIgnoreCase(EVENT_TYPE_WORKFLOW_BEGIN)) {
            workflowEvent.doCreateAfter(pfWorkFlowInstanceVo);
        } else if (eventName.equalsIgnoreCase(EVENT_TYPE_WORKFLOW_BEFORETURN)) {
        	msg = workflowEvent.doTurnBefore(wfInstance,wfActivity);
            String projectId = wfInstance.getPRO_ID();
            IPlatUtil platUtil=(IPlatUtil)Container.getBean("platUtil");
            String projecttype = platUtil.getWfRemarkByProjectId(projectId);
            String remark = platUtil.getActivityDesc(projectId, wfActivity.getWfacdefineid());
            ISPBService spbService = (ISPBService)Container.getBean("spbService");
            SPB spb = spbService.getSPB(projectId);
            if (spb!=null){
                SPB spb_sheet = CommonUtil.checkSheetinfo(projecttype, remark, spb, userid);
                if (spb_sheet!=null && spb_sheet.getProjectId()!=null)
                    spbService.updateSPB(spb_sheet);
            }
        } else if (eventName.equalsIgnoreCase(EVENT_TYPE_WORKFLOW_TURN)) {
            msg=workflowEvent.doTurnAfter(wfInstance,wfActivity) ;
        } else if (eventName.equalsIgnoreCase(EVENT_TYPE_WORKFLOW_BACK)) {
            workflowEvent.doTurnBackAfter(pfWorkFlowInstanceVo,pfActivityVo);
        } else if (eventName.equalsIgnoreCase(EVENT_TYPE_WORKFLOW_STOP)) {
            workflowEvent.doStopAfter(pfWorkFlowInstanceVo);
        } else if (eventName.equalsIgnoreCase(EVENT_TYPE_WORKFLOW_DEL)) {
           workflowEvent.doDelAfter(pfWorkFlowInstanceVo);
        }else if (eventName.equalsIgnoreCase(EVENT_TYPE_WORKFLOW_END)) {
           workflowEvent.doTurnOverAfter(wfInstance,wfActivity);
        }else {
           //System.out.println("-------------未知的方法调用："+eventName);
        }

    }

    private  WfInstance  transformtoWfInstance(PfWorkFlowInstanceVo pfWorkFlowInstanceVo){
        WfInstance wfInstance = new   WfInstance();
        wfInstance.setHANDLES_DAY(pfWorkFlowInstanceVo.getHandlesDay());
        wfInstance.setPRIORITY(pfWorkFlowInstanceVo.getPriority());
        wfInstance.setPRO_ID(pfWorkFlowInstanceVo.getProId());
        wfInstance.setRegionCode(pfWorkFlowInstanceVo.getRegionCode());
        wfInstance.setREMARK(pfWorkFlowInstanceVo.getRemark());
        if(StringUtils.isNotBlank(pfWorkFlowInstanceVo.getTimeLimit()))
            wfInstance.setTIME_LIMIT(Integer.parseInt(pfWorkFlowInstanceVo.getTimeLimit()));
        wfInstance.setWORKFLOW_DEFINITION_ID(pfWorkFlowInstanceVo.getWorkflowDefinitionId());
        wfInstance.setWORKFLOW_INSTANCE_ID(pfWorkFlowInstanceVo.getWorkflowIntanceId());
        wfInstance.setWORKFLOW_INSTANCE_NAME(pfWorkFlowInstanceVo.getWorkflowIntanceName());
        wfInstance.setWORKFLOW_STATE(pfWorkFlowInstanceVo.getWorkflowState());
        return wfInstance;
    }

    private WfActivity transformtoWfActivity( PfActivityVo pfActivityVo){
        WfActivity wfActivity = new WfActivity();
        if(pfActivityVo==null)   {
            return null;
        }
        wfActivity.setAcName(pfActivityVo.getActivityName());
//        wfActivity.setBackState();
        if(pfActivityVo.getBeginTime() != null ){
            wfActivity.setBeginTime(CommonUtil.formateDate(pfActivityVo.getBeginTime()));
        }
        if (pfActivityVo.getFinishTime() != null){
            wfActivity.setFinishTime(CommonUtil.formateDate(pfActivityVo.getFinishTime()));
        }
        wfActivity.setHeight(pfActivityVo.getHeight());
        wfActivity.setLeft(pfActivityVo.getLeft());
        wfActivity.setRemark(pfActivityVo.getRemark());
        wfActivity.setTop(pfActivityVo.getTop());
        wfActivity.setWfacdefineid(pfActivityVo.getActivityDefinitionId());
        wfActivity.setWfacid(pfActivityVo.getActivityId());
        wfActivity.setWfinstanceid(pfActivityVo.getWorkflowInstanceId());
        ArrayList organList = new ArrayList();
        if (pfActivityVo.getOrganId() != null &&pfActivityVo.getOrganId().trim().length()>0){
             wfActivity.setWforganlist(organList);
        }
//        wfActivity.setWfuser();
        wfActivity.setWidth(pfActivityVo.getWidth());
        return wfActivity;
    }

        public String getProid() {
        return proid;
    }

    public String getEventHandleClass() {
        return eventHandleClass;
    }

    public String getEventName() {
        return eventName;
    }



    public void setProid(String proid) {
        this.proid = proid;
    }

    public void setEventHandleClass(String eventHandleClass) {
        this.eventHandleClass = eventHandleClass;
    }

    public void setEventName(String eventName) {
        this.eventName = eventName;
    }
   public String getActivityid() {
        return activityid;
    }

    public String getUserid() {
        return userid;
    }

    public String getTaskid() {
        return taskid;
    }

    public void setActivityid(String activityid) {
        this.activityid = activityid;
    }

    public void setUserid(String userid) {
        this.userid = userid;
    }

    public void setTaskid(String taskid) {
        this.taskid = taskid;
    }

}
