package com.jsegov.tddj.action;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.gtis.config.AppConfig;
import com.jsegov.tddj.vo.QSZD_DJDCB;
import com.jsegov.tddj.vo.ZD_DJDCB;
import org.apache.commons.lang.StringUtils;
import org.apache.struts2.ServletActionContext;

import com.gtis.spring.Container;
import com.jsegov.tddj.services.interf.IProjectService;
import com.jsegov.tddj.services.interf.IQSZD_DJDCBService;
import com.jsegov.tddj.services.interf.ISPBService;
import com.jsegov.tddj.services.interf.IZD_DJDCBService;
import com.jsegov.tddj.vo.Project;
import com.jsegov.tddj.vo.SPB;
import com.opensymphony.xwork2.ActionSupport;

import java.net.URLEncoder;

public class ViewSimpleZDTAction extends ActionSupport {

	/**
	 * 
	 */
	private static final long serialVersionUID = -7195059756261218309L;
	public String djh;
	public String projectId;
	public String uniqueId;
	private String ompZDTTpl;
	private String ompZDTLayerAlias;

    /*
    宗地图定位
     */
    public String ZDTLocation() throws Exception{

       HttpServletRequest request =   ServletActionContext.getRequest();
       HttpServletResponse response = ServletActionContext.getResponse();
       response.setCharacterEncoding("UTF-8");
       String djh = "";
       String url = "";
       if(request.getParameter("djh")!=null){
           djh=request.getParameter("djh");
       }
       if(StringUtils.isNotBlank("djh")){
           IQSZD_DJDCBService djdcbService =(IQSZD_DJDCBService) Container.getBean("qszd_DjdcbService");
           ompZDTLayerAlias = AppConfig.getProperty("ompZDT.layerAlias");
       }
		String str = djh.substring(0,6);
		ompZDTLayerAlias = ompZDTLayerAlias +"(" +str+")";
        //街坊号取地籍号的前12位
        url=ompZDTTpl+"?hideTopBar=true&hideLeftPanel=true&action=location&params={\"type\":\"layerLocation\",\"params\":{\"layerAlias\":\""+ URLEncoder.encode(ompZDTLayerAlias, "UTF-8")+"\",\"where\":\"djh='"+djh+"'\",\"showInfo\":true}}";
        System.out.println("url="+url);
        if(djh!=null && !djh.equals("") && StringUtils.isNotBlank(ompZDTTpl) && StringUtils.isNotBlank(ompZDTLayerAlias)){
            response.sendRedirect(url);
        }
        else {
            response.sendRedirect("noZDT.jsp");
        }
        return null;
    }
	@Override
	public String execute() throws Exception {
		HttpServletRequest request=ServletActionContext.getRequest();
		uniqueId="";
		djh="";
        projectId="";
		if (request.getParameter("proid")!=null) projectId=request.getParameter("proid");
		IProjectService projectService=(IProjectService)Container.getBean("projectService");
		Project project=projectService.getProject(projectId);
		if(project==null){
			if (request.getParameter("djh")!=null)
                djh=request.getParameter("djh");
		}
		else{
			djh=project.getDjh();
		}
		
		if (djh==null || djh.equals("") || djh.length()!=19){
			ISPBService spbService = (ISPBService)Container.getBean("spbService");
			if (projectId!=null && !projectId.equals("")){
				SPB spb = spbService.getSPB(projectId);
				if (spb!=null)
					djh = spb.getDjh();
			}
		}
		String url="noZDT";
		
		if(djh!=null && !djh.equals("")){
			IZD_DJDCBService zd_djdcbService = (IZD_DJDCBService)Container.getBean("zdDjdcbService");
			uniqueId=zd_djdcbService.getUniqueIdByDjh(djh);
			if(StringUtils.isBlank(uniqueId)){
				IQSZD_DJDCBService qszd_djdcbService = (IQSZD_DJDCBService)Container.getBean("qszd_DjdcbService");
				uniqueId=qszd_djdcbService.getUniqueIdByDjh(djh);
			}
			url="viewSimpleZDT";
		}
		return url;
	}


    public String getDjh() {
		return djh;
	}

	public void setDjh(String djh) {
		this.djh = djh;
	}

	public String getProjectId() {
		return projectId;
	}

	public void setProjectId(String projectId) {
		this.projectId = projectId;
	}

	public String getUniqueId() {
		return uniqueId;
	}

	public void setUniqueId(String uniqueId) {
		this.uniqueId = uniqueId;
	}
	public String getOmpZDTTpl() {
		return ompZDTTpl;
	}

	public void setOmpZDTTpl(String ompZDTTpl) {
		this.ompZDTTpl = ompZDTTpl;
	}

	public String getOmpZDTLayerAlias() {
		return ompZDTLayerAlias;
	}

	public void setOmpZDTLayerAlias(String ompZDTLayerAlias) {
		this.ompZDTLayerAlias = ompZDTLayerAlias;
	}
}
