package com.jsegov.tddj.action;

import java.net.URLDecoder;
import java.net.URLEncoder;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.lang.StringUtils;
import org.apache.struts2.ServletActionContext;

import com.gtis.spring.Container;
import com.jsegov.tddj.services.interf.IProjectService;
import com.jsegov.tddj.services.interf.ISPBService;
import com.jsegov.tddj.vo.Project;
import com.jsegov.tddj.vo.SPB;
import com.opensymphony.xwork2.ActionSupport;

public class ViewOmpJFTAction extends ActionSupport{
    private String ompJFTTpl;
    private String ompJFTLayerAlias;
    private String url;
    private String djh;
    private String tdzh;
    @Override
    public String execute() throws Exception {
        HttpServletRequest request=ServletActionContext.getRequest();
        HttpServletResponse response=ServletActionContext.getResponse();
        response.setCharacterEncoding("UTF-8");
        String projectId="";
        String djh="";
        if (request.getParameter("proid")!=null) projectId=request.getParameter("proid");
        Project project=null;
        if(StringUtils.isNotBlank(projectId)){
            IProjectService projectService=(IProjectService)Container.getBean("projectService");
            project=projectService.getProject(projectId);
        }
        if(project==null){
            if (request.getParameter("djh")!=null) djh=request.getParameter("djh");
        }
        else{
            djh=project.getDjh();
        }
        if (djh==null || djh.equals("") || djh.length()!=19){
            ISPBService spbService = (ISPBService)Container.getBean("spbService");
            if (projectId!=null && !projectId.equals("")){
                SPB spb = spbService.getSPB(projectId);
                if (spb!=null)
                    djh = spb.getDjh();
            }
        }
		String str = djh.substring(0,6);
		ompJFTLayerAlias = ompJFTLayerAlias +"(" +str+")";
        //if(StringUtils.isNotBlank(ompJFTLayerAlias))
        // ompJFTLayerAlias=URLDecoder.decode(ompJFTLayerAlias, "UTF-8");
        //街坊号取地籍号的前12位
        url=ompJFTTpl+"?hideTopBar=true&hideLeftPanel=true&action=location&params={\"type\":\"layerLocation\",\"params\":{\"layerAlias\":\""+URLEncoder.encode(ompJFTLayerAlias,"UTF-8")+"\",\"where\":\"XZQDM like'"+djh.substring(0,12)+"%25"+"'\",\"showInfo\":true,\"layerDefinition\":\"XZQDM like '"+djh.substring(0,12)+"%25"+"'\"}}";
        System.out.println("url="+url);
		if(djh!=null && !djh.equals("") && StringUtils.isNotBlank(ompJFTTpl) && StringUtils.isNotBlank(ompJFTLayerAlias)){
            response.sendRedirect(url);
        }
        else {
            response.sendRedirect("noZDT.jsp");
        }
        return null;
    }

    public String getOmpJFTTpl() {
        return ompJFTTpl;
    }

    public void setOmpJFTTpl(String ompJFTTpl) {
        this.ompJFTTpl = ompJFTTpl;
    }

    public String getOmpJFTLayerAlias() {
        return ompJFTLayerAlias;
    }

    public void setOmpJFTLayerAlias(String ompJFTLayerAlias) {
        this.ompJFTLayerAlias = ompJFTLayerAlias;
    }
}