/**      
 * @{#} UserConfigManagerAction.java Create on 2009-4-1 上午09:18:10      
 *      
 * Copyright (c) 2009 by GTIS All rights reserved..      
 */
package com.jsegov.tddj.action;

import javax.servlet.http.HttpServletRequest;

import org.apache.struts2.ServletActionContext;

import com.jsegov.tddj.platform.TddjUtil;
import com.jsegov.tddj.util.UserConfigManager;
import com.opensymphony.xwork2.ActionSupport;

/**
 * @author <a href="mailto:liuwei40301@163.com">LiuW</a>
 * @version 1.0
 */

public class UserConfigManagerAction extends ActionSupport {

	private static final long serialVersionUID = 3799839906209464856L;

	private String colorSelect;

	private UserConfigManager userManager = new UserConfigManager();

	private String userName;
	private String msg = "";

	@Override
	public String execute() throws Exception {
		getUserName();
		// 根据登录的用户名获取必填字段颜色代码 如：#FFFFFF
		colorSelect = userManager.getColor(userName);
		return SUCCESS;
	}

	/**
	 * 保存
	 * 
	 * @return
	 */
	public String save() {
		getUserName();
		if (!isNullOrEmpty(colorSelect)) {
			userManager.setColor(userName, colorSelect);
		}
		setMsg("保存成功！");
		return SUCCESS;
	}

	/**
	 * 判断String 是否为null或空
	 * 
	 * @param str
	 * @return str为null或空,返回true;否则返回false;多个空格也返回true
	 */
	private boolean isNullOrEmpty(String str) {
		boolean flag = false;

		if (str == null || "".equals(str.trim())) {
			flag = true;
		}
		return flag;
	}

	/**
	 * 获取当前登录人员的姓名

	 * 
	 */
	private void getUserName() {
		HttpServletRequest request = ServletActionContext.getRequest();
		//String userId = UserUtil.getUserId(request);
		//userName = UserUtil.getUserName(request, userId);
		
		
		userName = TddjUtil.getCurrentUserName();
	}

	/**
	 * @return
	 */
	public String getColorSelect() {
		return colorSelect;
	}

	/**
	 * @param colorSelect
	 */
	public void setColorSelect(String colorSelect) {
		this.colorSelect = colorSelect;
	}

	public String getMsg() {
		return msg;
	}

	public void setMsg(String msg) {
		this.msg = msg;
	}

}
