package com.jsegov.tddj.action;

import javax.servlet.http.HttpServletRequest;

import org.apache.struts2.ServletActionContext;

import com.gtis.spring.Container;
import com.jsegov.tddj.platform.TddjUtil;
import com.jsegov.tddj.services.interf.IProjectService;
import com.jsegov.tddj.services.interf.ISPBService;
import com.jsegov.tddj.services.interf.ISQBService;
import com.jsegov.tddj.services.interf.ITDDJQSBService;
import com.jsegov.tddj.util.CommonUtil;
import com.jsegov.tddj.vo.Project;
import com.jsegov.tddj.vo.SPB;
import com.jsegov.tddj.vo.SQB;
import com.jsegov.tddj.vo.TDDJQSB;
import com.opensymphony.xwork2.ActionSupport;

public class TDDJQSBAction extends ActionSupport{

	/**
	 * 
	 */
	private static final long serialVersionUID = -5996997791294974748L;

	private TDDJQSB tddjqsb;
	private String projectId = "";
	private String djlx = "";
	private String tdzh = "";
	private String qlr = "";
	private String djh = "";
	private String zl = "";
	private String tdqlmj = "";
	private String djf = "";
	private String crj = "";
	
	public String execute() throws Exception {
		HttpServletRequest request = ServletActionContext.getRequest();
		if (request.getParameter("proid") != null){
			projectId = request.getParameter("proid");
		}
		//System.out.println("execute========"+projectId);
		ITDDJQSBService tddjqsbService = (ITDDJQSBService)Container.getBean("tddjQsbService");
		tddjqsb = tddjqsbService.getTDDJQSB(projectId);
		if (tddjqsb == null){
			String userName = TddjUtil.getCurrentUserName();			
			tddjqsb = new TDDJQSB();
			tddjqsb.setFzr(userName);
			tddjqsb.setQsrq(CommonUtil.getCurrStrDate());
		}
		IProjectService projectService = (IProjectService)Container.getBean("projectService");
		Project project = projectService.getProject(projectId);
		if (project != null){
			djlx = project.getDjlx();
		}
		if (djlx.equals("分割证换发证")){
			//分割换证从申请表中取数据
			ISQBService sqbService = (ISQBService)Container.getBean("sqbService");
			SQB sqb = sqbService.getSQB(projectId);
			if (sqb != null){
				tdzh = sqb.getSqsbh();
				qlr = sqb.getRf2_dwmc();
				djh = sqb.getDjh();
				zl = sqb.getZl();
				//tdqlmj = sqb.getTdqlmj().toString();
			}
		}else if (djlx.equals("查封") || djlx.equals("注销登记") || djlx.equals("异议登记") || djlx.equals("预告登记") || djlx.equals("分割登记") || djlx.equals("解封")){
			//这6个流程没有出件节点

		}else{
			//从审批表取数据

			ISPBService spbService=(ISPBService)Container.getBean("spbService");
			SPB spb = spbService.getSPB(projectId);
			if (spb != null){
				tdzh = spb.getSpbh();
				qlr = spb.getRf2_dwmc();
				if (qlr.equals("")){
					qlr = spb.getRf1_dwmc();
				}
				djh = spb.getDjh();
				zl = spb.getZl();
				//tdqlmj = spb.getTdqlmj().toString();
				//djf = spb.getDjf().toString();
				//crj = spb.getCrj().toString();
			}
		}		
		return SUCCESS;
	}
	
	public String savaQsr() throws Exception {
		tddjqsb.setProjectId(projectId);
		//System.out.println(projectId);
		ITDDJQSBService tddjqsbService = (ITDDJQSBService)Container.getBean("tddjQsbService");
		if (tddjqsbService.getTDDJQSB(projectId) == null){
			tddjqsbService.insertTDDJQSB(tddjqsb);
		}else{
			tddjqsbService.updateTDDJQSB(tddjqsb);
		}
		return execute();
	}

	public TDDJQSB getTddjqsb() {
		return tddjqsb;
	}

	public void setTddjqsb(TDDJQSB tddjqsb) {
		this.tddjqsb = tddjqsb;
	}

	public String getProjectId() {
		return projectId;
	}

	public void setProjectId(String projectId) {
		this.projectId = projectId;
	}

	public String getDjlx() {
		return djlx;
	}

	public void setDjlx(String djlx) {
		this.djlx = djlx;
	}

	public String getTdzh() {
		return tdzh;
	}

	public void setTdzh(String tdzh) {
		this.tdzh = tdzh;
	}

	public String getQlr() {
		return qlr;
	}

	public void setQlr(String qlr) {
		this.qlr = qlr;
	}

	public String getDjh() {
		return djh;
	}

	public void setDjh(String djh) {
		this.djh = djh;
	}

	public String getZl() {
		return zl;
	}

	public void setZl(String zl) {
		this.zl = zl;
	}

	public String getTdqlmj() {
		return tdqlmj;
	}

	public void setTdqlmj(String tdqlmj) {
		this.tdqlmj = tdqlmj;
	}

	public String getDjf() {
		return djf;
	}

	public void setDjf(String djf) {
		this.djf = djf;
	}

	public String getCrj() {
		return crj;
	}

	public void setCrj(String crj) {
		this.crj = crj;
	}
}
