package com.jsegov.tddj.action;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;

import org.apache.struts2.ServletActionContext;

import com.gtis.spring.Container;
import com.gtis.web.SplitParam;
import com.gtis.web.SplitParamImpl;
import com.jsegov.tddj.platform.TddjUtil;
import com.jsegov.tddj.services.interf.IStatDJSJService;
import com.jsegov.tddj.util.CommonUtil;
import com.jsegov.tddj.vo.Project;
import com.jsegov.tddj.vo.SPB;
import com.jsegov.tddj.vo.StatDJSJ;
import com.opensymphony.xwork2.ActionSupport;

public class StatZSAction extends ActionSupport {

	/**
	 * 用途：证书统计 参数： 修改日期：2008-12-10 修改人：刘仲阳

	 */
	private static final long serialVersionUID = -8255128437433550102L;

	private SplitParam splitParam;
	//查询参数
	private String ksrq;
	private String jsrq;
	private String yt;
	private String djlx;
	private String sqlx;
	private String syqlx;
	private String dwmc;
	private String dwxz;
	private String qsxz;
	private String dwdm;
	private String zsstate;
	private String zslx;
	//选择列表框内容

	private List<SPB> listDwxz;
	private List<SPB> listQsxz;
	private List<SPB> listSqlx;
	private List<SPB> listSyqlx;
	private List<Project> listDjlx;
	private List<SPB> listYt;
	private List<String> listOrgan;
	// 分组字段 形式为 xxx,yyy,zzz
	private String fzzd; 
	//是否显示图表
	private String showChart;
	//是否显示饼图
	private String showPie;
	//是否显示柱状图

	private String showCatagory; 
	
	public String execute() throws Exception {
		//控制是否显示统计图表
		if(showChart!=null && !showChart.equals("")){
			showChart = "true";		
		}else {
			showChart = "false";
		}
		//是否显示饼图
		if(showPie!=null && !showPie.equals("")){
			showPie = "true";		
		}else {
			showPie = "false";
		}
		//是否显示柱图
		if(showCatagory!=null && !showCatagory.equals("")){
			showCatagory = "true";		
		}else {
			showCatagory = "false";
		}
		
		getListDate();
		return SUCCESS;
	}

	public String query() {
		/**
		 * 用途：证书统计页面上"统计"按钮对应的Action 
		 * 参数： 
		 * 修改日期：2008-12-10 
		 * 修改人：刘仲阳

		 */
		HttpServletRequest request = ServletActionContext.getRequest();
		HashMap<String, Object> map = new HashMap<String, Object>();
        		map = CommonUtil.getDwdmQuery(request, map);
		map.put("dwdm","3208%");
//		Date queryFzrq1 = null;
//		Date queryFzrq2 = null;

		String queryZslx = null;
		String queryYt = "";
		String queryDjlx = "";
		String querySqlx = "";
		String querySyqlx = "";
		String queryDwmc = "";
		String queryDwxz = "";
		String queryQsxz = "";
		String queryZsstate = "";
		String[] queryFzzd = null;

		if (zsstate != null && !zsstate.equals("")) {
			queryZsstate =  zsstate ;
		}

		if (zslx != null && !zslx.equals("")) {
			queryZslx = zslx ;
		}

		if (dwmc != null && !dwmc.equals("")) {
			queryDwmc = dwmc ;
		}

		if (qsxz != null && !qsxz.equals("")) {
			queryQsxz = qsxz ;
		}

		ksrq = "";
		if (request.getParameter("ksrq") != null){
			ksrq = request.getParameter("ksrq");
			if (!ksrq.equals("")){
				map.put("ksrq", ksrq);
			}
		}
		jsrq = "";
		if (request.getParameter("jsrq") != null){
			jsrq = request.getParameter("jsrq");
			if (!jsrq.equals("")){
				map.put("jsrq", jsrq);
			}
		}
//		if (ksrq != null && !ksrq.equals("")) {
//			queryFzrq1 = CommonUtil.formateDateToStr(ksrq);
//		}
//
//		if (jsrq != null && !jsrq.equals("")) {
//			queryFzrq2 = CommonUtil.formateDateToStr(jsrq);
//		}

		if (yt != null && !yt.equals("")) {
			queryYt = yt ;
		}

		if (sqlx != null && !sqlx.equals("")) {
			querySqlx = sqlx ;
		}

		if (djlx != null && !djlx.equals("")) {
			queryDjlx = djlx ;
		}

		if (syqlx != null && !syqlx.equals("")) {
			querySyqlx = syqlx ;
		}

		if (dwxz != null && !dwxz.equals("")) {
			queryDwxz = dwxz ;
		}

//		map.put("ksrq", queryFzrq1);
//		map.put("jsrq", queryFzrq2);

		map.put("dwmc", queryDwmc);
		map.put("dwxz", queryDwxz);
		map.put("djlx", queryDjlx);
		map.put("sqlx", querySqlx);

		map.put("zsstate", queryZsstate);
		map.put("syqlx", querySyqlx);
		map.put("yt", queryYt);

		map.put("zslx", queryZslx);
		map.put("qsxz", queryQsxz);

		// groupClause orderClause selectClaue字段前缀参考

		// d.dwdm, a.rf1_dwxz, a.qsxz, d.yt, d.syqlx
		StringBuffer groupClause = new StringBuffer();
		StringBuffer selectClause = new StringBuffer();
		StringBuffer orderClause = new StringBuffer();

		queryFzzd = fzzd.split(",");
		for (Integer i = 0; i < queryFzzd.length; i++) {
			if (queryFzzd[i].equals("证书类型")) {
				groupClause.append("d.zslx,");
			} else if (queryFzzd[i].equals("单位名称")) {
				groupClause.append("b.dwmc,");
			} else if (queryFzzd[i].equals("权属性质")) {
				groupClause.append("a.qsxz,");
			} else if (queryFzzd[i].equals("登记类型")) {
				groupClause.append("c.djlx,");
			} else if (queryFzzd[i].equals("申请类型")) {
				groupClause.append("a.sqlx,");
			} else if (queryFzzd[i].equals("使用权类型")) {
				groupClause.append("d.syqlx,");
			} else if (queryFzzd[i].equals("用途")) {
				groupClause.append("d.yt,");
			} else if (queryFzzd[i].equals("证书状态")) {
				groupClause.append("d.zsstate,");
			} else if (queryFzzd[i].equals("单位性质")) {
				groupClause.append("a.rf1_dwxz,");
			}
		}
		if (groupClause.length() > 0) {
			groupClause.deleteCharAt(groupClause.length() - 1);
			selectClause = groupClause;
		}

		map.put("groupClause", groupClause.toString());
		map.put("selectClause", selectClause.toString());
		map.put("orderClause", orderClause.toString());

		// 按证书类型选择要执行的统计sql 用resultList方式传给页面
		ArrayList<StatDJSJ> resultList = null;
		// ArrayList<StatDJSJ> resultListGyz = null;
		// ArrayList<StatDJSJ> resultListJyz = null;
		// ArrayList<StatDJSJ> resultListTxz = null;
		IStatDJSJService statDJSJService = (IStatDJSJService) Container
				.getBean("statDjsjService");

		resultList = statDJSJService.getStatDJSJList(map);
		request.setAttribute("resultList", resultList);
		request.setAttribute("paramMap", map);

		/*
		 * if (zslx.equals("statGYTDSYZ")){
		 * 
		 * resultListGyz = statDJSJService.getStatDJSJGyz(map);
		 * request.setAttribute("resultListGyz", resultListGyz); } else if
		 * (zslx.equals("statJTTDSYZ")) {
		 * 
		 * resultListJyz = statDJSJService.getStatDJSJJyz(map);
		 * request.setAttribute("resultListJyz", resultListJyz); } else
		 * if(zslx.equals("statTXQLZMS")){
		 * 
		 * resultListTxz = statDJSJService.getStatDJSJTxz(map);
		 * request.setAttribute("resultListTxz", resultListTxz); } else
		 * if(zslx.equals("statJTTDSUZ")){
		 *  } else if(zslx.equals("")){
		 *  }
		 */
		//控制是否显示统计图表
		if(showChart!=null && !showChart.equals("")){
			showChart = "true";		
		}else {
			showChart = "false";
		}
		//是否显示饼图
		if(showPie!=null && !showPie.equals("")){
			showPie = "true";		
		}else {
			showPie = "false";
		}
		//是否显示柱图
		if(showCatagory!=null && !showCatagory.equals("")){
			showCatagory = "true";		
		}else {
			showCatagory = "false";
		}
		getListDate();
		return SUCCESS;
	}

	private void getListDate() {
		/**
		 * 用途：获取页面选择框的LIST值 
		 * 参数：无 
		 * 修改日期：2008-12-09 
		 * 修改人：刘仲阳

		 */
		HttpServletRequest request = ServletActionContext.getRequest();		
		dwdm = TddjUtil.getCurrentUserDwdm();
		
		String bool = "false";
		// 根据单位代码判断默认分组类型
		if (dwdm.length() <= 4) {
			bool = "true";
			if (fzzd == null || fzzd.equals(""))
				fzzd = "证书类型,单位名称";
		} else {
			if (fzzd == null || fzzd.equals(""))
				fzzd = "证书类型";
		}
		request.setAttribute("bool", bool);
		request.setAttribute("fzzd", fzzd);
		
		listOrgan =  TddjUtil.getAllOrgan();// 部门列表
		
		//listOrgan = WfOperate.getOrgan(request);// 部门列表

		IStatDJSJService statDJSJService = (IStatDJSJService) Container
				.getBean("statDjsjService");

		listQsxz = statDJSJService.getListQsxz();
		listDjlx = statDJSJService.getListDjlx();
		listSyqlx = statDJSJService.getListSyqlx();
		listSqlx = statDJSJService.getListSqlx();
		listYt = statDJSJService.getListYt();
		listDwxz = statDJSJService.getListDwxz();
	}

	public String showDetail() throws ServletException, IOException {
		/**
		 * 用途：页面双击一条记录或者点击查询详细列出详细信息 
		 * 参数：无 
		 * 修改日期：2008-12-11 
		 * 修改人：刘仲阳

		 */
		HttpServletRequest request = ServletActionContext.getRequest();
		request.setCharacterEncoding("utf-8");
		HashMap<String, Object> map = new HashMap<String, Object>();
		map = CommonUtil.getDwdmQuery(request, map);
		
		Date queryFzrq1 = null;
		Date queryFzrq2 = null;

		String queryZslx = "";
		String queryYt = "";
		String queryDjlx = "";
		String querySqlx = "";
		String querySyqlx = "";
		String queryDwmc = "";
		String queryDwxz = "";
		String queryQsxz = "";
		String queryZsstate = "";

		if (request.getParameter("zslx") != null && !request.getParameter("zslx").equals("null")) {
//			System.out.println(new String(request.getParameter("zslx").getBytes("ISO8859_1"), "GBK"));
			queryZslx =  new String(request.getParameter("zslx").getBytes("ISO8859_1"), "GBK");
			zslx=queryZslx;
		}else if (request.getParameter("zslx").equals("null")){
			queryZslx = null;
		}
		if (request.getParameter("yt") != null && !request.getParameter("yt").equals("null")) {
			queryYt = new String(request.getParameter("yt").getBytes("ISO8859_1"), "GBK");
		}else if (request.getParameter("yt").equals("null")){
			queryYt = null;
		}
		if (request.getParameter("djlx") != null && !request.getParameter("djlx").equals("null")) {
			queryDjlx = new String(request.getParameter("djlx").getBytes("ISO8859_1"), "GBK");
		}else if (request.getParameter("djlx").equals("null")){
			queryDjlx = null;
		}
		if (request.getParameter("sqlx") != null && !request.getParameter("sqlx").equals("null")) {
			querySqlx = new String(request.getParameter("sqlx").getBytes("ISO8859_1"), "GBK");
		}else if (request.getParameter("sqlx").equals("null")){
			querySqlx = null;
		}
		if (request.getParameter("syqlx") != null  && !request.getParameter("syqlx").equals("null")) {
			querySyqlx = new String(request.getParameter("syqlx").getBytes("ISO8859_1"), "GBK");
		}else if (request.getParameter("syqlx").equals("null")){
			querySyqlx = null;
		}
		if (request.getParameter("dwmc") != null  && !request.getParameter("dwmc").equals("null")) {
			queryDwmc = new String(request.getParameter("dwmc").getBytes("ISO8859_1"), "GBK");
		}else if (request.getParameter("dwmc").equals("null")){
			queryDwmc = null;
		}
		if (request.getParameter("dwxz") != null && !request.getParameter("dwxz").equals("null") ) {
			queryDwxz = new String(request.getParameter("dwxz").getBytes("ISO8859_1"), "GBK");
		}else if (request.getParameter("dwxz").equals("null")){
			queryDwxz = null;
		}
		if (request.getParameter("qsxz") != null && !request.getParameter("qsxz").equals("null") ) {
			queryQsxz = new String(request.getParameter("qsxz").getBytes("ISO8859_1"), "GBK");
		}else if (request.getParameter("qsxz").equals("null")){
			queryQsxz = null;
		}
		if (request.getParameter("zsstate") != null  ) {
			queryZsstate = new String(request.getParameter("zsstate").getBytes("ISO8859_1"), "GBK");	
		}
		if (request.getParameter("ksrq") != null && !request.getParameter("ksrq").equals("")) {
			queryFzrq1 = CommonUtil.formateDateToStr(request.getParameter("ksrq"));	
		}
		if (request.getParameter("jsrq") != null && !request.getParameter("jsrq").equals("")) {
			queryFzrq2 = CommonUtil.formateDateToStr(request.getParameter("jsrq"));
		}

		// 不模糊

		map.put("ksrq", queryFzrq1);
		map.put("jsrq", queryFzrq2);

		map.put("dwmc", queryDwmc);
		map.put("dwxz", queryDwxz);
		map.put("djlx", queryDjlx);
		map.put("sqlx", querySqlx);

		map.put("zsstate", queryZsstate);
		map.put("syqlx", querySyqlx);
		map.put("yt", queryYt);

		map.put("zslx", queryZslx);
		map.put("qsxz", queryQsxz);

		SplitParamImpl s = new SplitParamImpl();
		s.setQueryString("showDetail");
		s.setQueryParam(map);
		this.splitParam = s;
		return "showDetail";
	}

	public String getFzzd() {
		return fzzd;
	}

	public void setFzzd(String fzzd) {
		this.fzzd = fzzd;
	}

	public String getZslx() {
		return zslx;
	}

	public void setZslx(String zslx) {
		this.zslx = zslx;
	}

	public String getZsstate() {
		return zsstate;
	}

	public void setZsstate(String zsstate) {
		this.zsstate = zsstate;
	}

	public List<SPB> getListQsxz() {
		return listQsxz;
	}

	public void setListQsxz(List<SPB> listQsxz) {
		this.listQsxz = listQsxz;
	}

	public List<SPB> getListSqlx() {
		return listSqlx;
	}

	public void setListSqlx(List<SPB> listSqlx) {
		this.listSqlx = listSqlx;
	}

	public List<SPB> getListSyqlx() {
		return listSyqlx;
	}

	public void setListSyqlx(List<SPB> listSyqlx) {
		this.listSyqlx = listSyqlx;
	}

	public List<Project> getListDjlx() {
		return listDjlx;
	}

	public void setListDjlx(List<Project> listDjlx) {
		this.listDjlx = listDjlx;
	}

	public List<SPB> getListYt() {
		return listYt;
	}

	public void setListYt(List<SPB> listYt) {
		this.listYt = listYt;
	}

	public String getDwdm() {
		return dwdm;
	}

	public void setDwdm(String dwdm) {
		this.dwdm = dwdm;
	}

	public SplitParam getSplitParam() {
		return splitParam;
	}

	public void setSplitParam(SplitParam splitParam) {
		this.splitParam = splitParam;
	}

	public String getKsrq() {
		return ksrq;
	}

	public void setKsrq(String ksrq) {
		this.ksrq = ksrq;
	}

	public String getJsrq() {
		return jsrq;
	}

	public void setJsrq(String jsrq) {
		this.jsrq = jsrq;
	}

	public String getYt() {
		return yt;
	}

	public void setYt(String yt) {
		this.yt = yt;
	}

	public String getDjlx() {
		return djlx;
	}

	public void setDjlx(String djlx) {
		this.djlx = djlx;
	}

	public String getSqlx() {
		return sqlx;
	}

	public void setSqlx(String sqlx) {
		this.sqlx = sqlx;
	}

	public String getSyqlx() {
		return syqlx;
	}

	public void setSyqlx(String syqlx) {
		this.syqlx = syqlx;
	}

	public String getDwmc() {
		return dwmc;
	}

	public void setDwmc(String dwmc) {
		this.dwmc = dwmc;
	}

	public String getQsxz() {
		return qsxz;
	}

	public void setQsxz(String qsxz) {
		this.qsxz = qsxz;
	}


	public List<String> getListOrgan() {
		return listOrgan;
	}

	public void setListOrgan(List<String> listOrgan) {
		this.listOrgan = listOrgan;
	}

	public String getDwxz() {
		return dwxz;
	}

	public void setDwxz(String dwxz) {
		this.dwxz = dwxz;
	}

	public List<SPB> getListDwxz() {
		return listDwxz;
	}

	public void setListDwxz(List<SPB> listDwxz) {
		this.listDwxz = listDwxz;
	}

	public String getShowChart() {
		return showChart;
	}

	public void setShowChart(String showChart) {
		this.showChart = showChart;
	}

	public String getShowPie() {
		return showPie;
	}

	public void setShowPie(String showPie) {
		this.showPie = showPie;
	}

	public String getShowCatagory() {
		return showCatagory;
	}

	public void setShowCatagory(String showCatagory) {
		this.showCatagory = showCatagory;
	}
}
