package com.jsegov.tddj.action;

import java.util.ArrayList;

import com.gtis.spring.Container;
import com.jsegov.tddj.services.interf.IStatTDZService;
import com.jsegov.tddj.util.CommonUtil;
import com.jsegov.tddj.util.GetStatSQL;
import com.jsegov.tddj.vo.StatTDZResult;
import com.opensymphony.xwork2.ActionSupport;
import org.springframework.beans.factory.annotation.Autowired;

public class StatTDZAction extends ActionSupport{

	/**
	 * 
	 */
	private static final long serialVersionUID = -492163689476174750L;
	
	//private SplitParam splitParam;
    @Autowired
	private IStatTDZService statTDZService;
	private String zslx;
	private String spectype;
	private String tjnr;
	private String ksrq;
	private String jsrq;
	private String chartType;
	private String isFullScr;
	private String specTypeName;
	private ArrayList<StatTDZResult> statList;
	
	public String execute() throws Exception {
		//SplitParamImpl s = new SplitParamImpl();
		//.setQueryString("statTDZ");
		statList=new ArrayList<StatTDZResult>();
		if(spectype==null || spectype.equals("")){
			spectype="zslx";
			specTypeName="证书类型";
		}
		if(tjnr==null || tjnr.equals("")){
			tjnr="sl";
		}
		if(spectype!=null && spectype.equals("zslx")){
			specTypeName="证书类型";
		}else if(spectype!=null && spectype.equals("fzqy")){
			specTypeName="发证区域";
		}else if(spectype!=null && spectype.equals("djlx")){
			specTypeName="登记类型";
		}else if(spectype!=null && spectype.equals("syqlx")){
			specTypeName="使用权类型";
		}else if(spectype!=null && spectype.equals("qsxz")){
			specTypeName="权属性质";
		}else if(spectype!=null && spectype.equals("yt")){
			specTypeName="土地用途";
		}else if(spectype!=null && spectype.equals("dwxz")){
			specTypeName="单位性质";
		}
		//统计证书
		String sqlstr=GetStatSQL.getStatTDZSQLForChart(spectype, zslx, ksrq, jsrq).toString();
		
//		System.out.println("===>"+sqlstr.toString());
		statList = statTDZService.getStatTDZ(sqlstr);
		
		//将面积保留一位小数

		for(int i=0;i<statList.size();i++){
			statList.get(i).setMj(CommonUtil.formatNumber(statList.get(i).getMj()));
		}
		
		if(isFullScr!=null && isFullScr.equals("true")){
			return "fullStatTDZ";
		}else{
			return SUCCESS;
		}
	}
	public String getZslx() {
		return zslx;
	}

	public void setZslx(String zslx) {
		this.zslx = zslx;
	}

	public String getKsrq() {
		return ksrq;
	}

	public void setKsrq(String ksrq) {
		this.ksrq = ksrq;
	}

	public String getJsrq() {
		return jsrq;
	}

	public void setJsrq(String jsrq) {
		this.jsrq = jsrq;
	}

	public String getChartType() {
		return chartType;
	}

	public void setChartType(String chartType) {
		this.chartType = chartType;
	}

	public String getIsFullScr() {
		return isFullScr;
	}

	public void setIsFullScr(String isFullScr) {
		this.isFullScr = isFullScr;
	}

	public IStatTDZService getStatTDZService() {
		return statTDZService;
	}

	public void setStatTDZService(IStatTDZService statTDZService) {
		this.statTDZService = statTDZService;
	}

	public String getSpectype() {
		return spectype;
	}

	public void setSpectype(String spectype) {
		this.spectype = spectype;
	}

	public String getTjnr() {
		return tjnr;
	}

	public void setTjnr(String tjnr) {
		this.tjnr = tjnr;
	}
	
	public String getSpecTypeName() {
		return specTypeName;
	}
	
	public void setSpecTypeName(String specTypeName) {
		this.specTypeName = specTypeName;
	}
	
	public ArrayList<StatTDZResult> getStatList() {
		return statList;
	}
	
	public void setStatList(ArrayList<StatTDZResult> statList) {
		this.statList = statList;
	}

}
