package com.jsegov.tddj.action;

import java.util.HashMap;
import java.util.List;

import javax.servlet.http.HttpServletRequest;

import com.gtis.spring.Container;
import com.jsegov.tddj.services.interf.IZDDZBService;
import com.jsegov.tddj.vo.ZDDZB;
import org.apache.commons.lang.StringUtils;
import org.apache.struts2.ServletActionContext;

import com.gtis.web.SplitParam;
import com.gtis.web.SplitParamImpl;
import com.jsegov.tddj.util.CommonUtil;
import com.jsegov.tddj.vo.ZD_DJDCB;
import com.opensymphony.xwork2.ActionSupport;
import com.jsegov.tddj.util.DjhConvert;

public class SelectDjdcb extends ActionSupport{
	private static final long serialVersionUID = 102075653434624095L;
	private SplitParam splitParam;
	private ZD_DJDCB djdcb = new ZD_DJDCB();
    private String oldDjh;
    private String rtnMsg = "OK";

    public String getRtnMsg() {
        return rtnMsg;
    }

    public void setRtnMsg(String rtnMsg) {
        this.rtnMsg = rtnMsg;
    }

    public String getOldDjh() {
        return oldDjh;
    }

    public void setOldDjh(String oldDjh) {
        this.oldDjh = oldDjh;
    }

    public ZD_DJDCB getDjdcb() {
		return djdcb; 
	}

	public void setDjdcb(ZD_DJDCB djdcb) {
		this.djdcb = djdcb;
	}

	public SplitParam getSplitParam() {
		return splitParam;
	}

	public void setSplitParam(SplitParam splitParam) {
		this.splitParam = splitParam;
	}
	
	public String execute() throws Exception {
		HttpServletRequest request = ServletActionContext.getRequest();
		String urlFrom = request.getParameter("urlFrom");		
		HashMap<String, Object> map = new HashMap<String, Object>();

		map = CommonUtil.getDjhQuery(request,map);
		if (StringUtils.isNotBlank(djdcb.getDjh())){
			map.put("djh", "%"+djdcb.getDjh()+"%");
		}
		if(djdcb.getQlrmc()!=null && !djdcb.getQlrmc().equals("")){
			map.put("qlrmc", "%"+djdcb.getQlrmc()+"%");
		}
		if(djdcb.getTdzl()!=null && !djdcb.getTdzl().equals("")){
			map.put("tdzl", "%"+djdcb.getTdzl()+"%");
		}
		if(djdcb.getQsxz()!=null && !djdcb.getQsxz().equals("")){
			map.put("qsxz", djdcb.getQsxz()+"%");
		}
		if(StringUtils.isNotBlank(oldDjh)){
			IZDDZBService zddzbService = (IZDDZBService) Container.getBean("zddzbService");
			List<ZDDZB> zddzbList = zddzbService.selectNewDjhFromZddzb("%"+oldDjh+"%");
			String addDjh = null;
            //oracle in只支持1000个
            if(zddzbList!=null && zddzbList.size()>1000){
               rtnMsg = "模糊匹配数据超过1000条，请输入更精确的老地号信息";
                int i = 0;
                for(ZDDZB zddzb :zddzbList){
                    if(zddzb!=null){
                        if(addDjh == null){
                            addDjh = "('"+zddzb.getDh()+"'";
                        }else{
                            addDjh += ",'"+zddzb.getDh()+"'";
                        }
                    }
                    i++;
                    if(i==1000){
                        break;
                    }
                }
                if(addDjh!=null){
                    addDjh += ")";
                }
                map.put("addDjh",addDjh);
            }else{
                for(ZDDZB zddzb :zddzbList){
                    if(zddzb!=null){
                        if(addDjh == null){
                            addDjh = "('"+zddzb.getDh()+"'";
                        }else{
                            addDjh += ",'"+zddzb.getDh()+"'";
                        }
                    }
                }
                if(addDjh!=null){
                    addDjh += ")";
                }
                map.put("addDjh",addDjh);
            }
		}
		SplitParamImpl s = new SplitParamImpl();

		if (urlFrom==null){
			s.setQueryString("selectDJDCBForSplit");
		}else if(urlFrom.equals("fgdj")){
			s.setQueryString("selectDJDCBForSplit");
		}else if(urlFrom.equals("newProject")){
			s.setQueryString("selectDJDCBForSplit");
		}else if(urlFrom.equals("")){
			s.setQueryString("selectDJDCBForSplit");
		}
		if (djdcb.getQsxz().equals("3")){
			s.setQueryString("selectSYQDCB");
		}
		request.setAttribute("urlFrom", urlFrom);
		s.setQueryParam(map);
		this.splitParam = s;
		return SUCCESS;
	}
}
