package com.jsegov.tddj.action;

import com.gtis.spring.Container;
import com.gtis.web.SplitParam;
import com.gtis.web.SplitParamImpl;
import com.jsegov.tddj.platform.TddjUtil;
import com.jsegov.tddj.services.interf.IGytdsyzService;
import com.jsegov.tddj.services.interf.IJttdsuzService;
import com.jsegov.tddj.services.interf.IJttdsyzService;
import com.jsegov.tddj.services.interf.ITxqlzmsService;
import com.jsegov.tddj.util.CommonUtil;
import com.jsegov.tddj.util.DjhConvert;
import com.jsegov.tddj.vo.GYTDSYZ;
import com.jsegov.tddj.vo.JTTDSUZ;
import com.jsegov.tddj.vo.JTTDSYZ;
import com.jsegov.tddj.vo.TXQLZMS;
import com.opensymphony.xwork2.ActionSupport;
import org.apache.struts2.ServletActionContext;

import javax.servlet.http.HttpServletRequest;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;

/**
 * Created with IntelliJ IDEA.
 * User: trr
 * Date: 15-11-2
 * Time: 下午2:45
 * To change this template use File | Settings | File Templates.
 */
public class SdTDZAction extends ActionSupport {
    /**
     *
     */
    private static final long serialVersionUID = 5330488916418857331L;
    private SplitParam splitParam;
    private GYTDSYZ gytdsyz;
    private JTTDSUZ jttdsuz;
    private JTTDSYZ jttdsyz;
    private TXQLZMS txqlzms;
    private String tdzh;
    private String qlr;
    private String djh;
    private String zl;
    private String syqlx;
    private String fzrq1;
    private String fzrq2;
    private String zsno;
    private String organ;
    private String yt;
    private String zsstate;
    private String oldDjh;
    private String userDwdm;
    private String zjbh;
    private String projectId;
    private String sdyy;
    private String zslx;
    private String issd;
    private String msg;

    private LinkedHashMap<String,String> issdList;
    private LinkedHashMap<String,String> zslxlist;
    private LinkedHashMap<String,String> zsstatelist;
    private List<String> organlist;
    public SdTDZAction() {
        this.issdList = new LinkedHashMap<String, String>();
        this.issdList.put("0","未锁定");
        this.issdList.put("1","锁定");
        this.zslxlist = new LinkedHashMap<String, String>();
        this.zslxlist.put("gytdsyz","国有土地使用证");
        this.zslxlist.put("jttdsyz","集体土地使用证");
        this.zslxlist.put("txqlzms", "他项权利证明书");
        this.zslxlist.put("jttdsuz","集体土地所有证");
        this.zsstatelist = new LinkedHashMap<String, String>();
        this.zsstatelist.put("0", "正常");
        this.zsstatelist.put("1", "注销");
        this.zsstatelist.put("2", "变更");
        this.zsstatelist.put("3", "部分抵押");
        this.zsstatelist.put("4", "完全抵押");
        this.zsstatelist.put("5", "部分租赁");
        this.zsstatelist.put("6", "完全租赁");
        this.zsstatelist.put("7", "部分变更");
        this.zsstatelist.put("8", "分割登记产生的证");
        this.zsstatelist.put("20", "房改房");
    }

    public String execute() throws Exception {
        HttpServletRequest request = ServletActionContext.getRequest();
        organlist = TddjUtil.getAllOrgan();
        HashMap<String, Object> map = new HashMap<String, Object>();

        map = CommonUtil.getDwdmQuery(request, map);
        if(map.get("dwdm")!=null)
            userDwdm = TddjUtil.getCurrentUserDwdm();
        SplitParamImpl s = new SplitParamImpl();
        String queryTdzh = null;
        String queryDjh = null;
        String queryQlr = null;
        String queryZl = null;
        String querySyqlx = null;
        Date queryFzrq1 = null;
        Date queryFzrq2 = null;
        String queryZsNo = null;
        String queryTdzhYear = null;
        String queryOrgan = null;
        String queryYt = null;
        String queryZsstate = null;
        String queryZjbh = null;

        if (tdzh != null && !tdzh.equals("")) {
            queryTdzh = "%" + tdzh + "%";
        }
        /*if (djh != null && !djh.equals("")) {
              queryDjh = "%" + djh + "%";
          }*/
        if (djh != null && !djh.equals("")) {
            HashMap param=new HashMap();
            param= DjhConvert.ConvertToNewDjh(djh);
            queryDjh=(String)param.get("addDjh");

        }
//        if(oldDjh!=null&&!oldDjh.equals(""))
//        {
//            HashMap param=new HashMap();
//            param=DjhConvert.ConvertToOldDjh(oldDjh);
//            queryDjh=(String)param.get("addDjh");
//        }
        if(oldDjh !=null && !oldDjh.equals("")){
            map.put("oldDjh","%" + oldDjh + "%");
        }
        if (qlr != null && !qlr.equals("")) {
            queryQlr = "%" + qlr + "%";
        }
        if (zl != null && !zl.equals("")) {
            queryZl = "%" + zl + "%";
        }
        if (syqlx != null && !syqlx.equals("")) {
            querySyqlx = "%" + syqlx + "%";
        }
        if (fzrq1 != null && !fzrq1.equals("")) {
            queryFzrq1 = CommonUtil.formateDateToStr(fzrq1);
        }
        if (fzrq2 != null && !fzrq2.equals("")) {
            queryFzrq2 = CommonUtil.formateDateToStr(fzrq2);
        }

        if (zsno != null && !zsno.equals("")) {
            queryZsNo = "%" + zsno + "%";
        }
        if (yt != null && !yt.equals("")) {
            queryYt = "%" + yt + "%";
        }
        // ‘部门名称’和‘证书状态’不模糊查询
        if (organ != null && !organ.equals("")) {
            queryOrgan = organ;
        }
        if (zsstate != null && !zsstate.equals("")) {
            queryZsstate = zsstate;
        }

        if(zjbh !=null && !zjbh.equals("")){
            queryZjbh = "%"+ zjbh + "%";
        }

        map.put("tdzh", queryTdzh);
        map.put("transDjh", queryDjh);
        map.put("qlr", queryQlr);
        map.put("zl", queryZl);
        map.put("syqlx", querySyqlx);
        map.put("fzrq1", queryFzrq1);
        map.put("fzrq2", queryFzrq2);
        map.put("zsno", queryZsNo);
        map.put("yt", queryYt);
        map.put("islogout", queryZsstate);
        map.put("iscomplete", "1");
        map.put("dwdm","3208%");//STORY #6048 【淮安】登记发证系统_查询、调取土地证书时方式进行修改 (#3 #2 #1 )
        map.put("zjbh",queryZjbh);
        if (queryOrgan != null && !queryOrgan.equals("")) {

            map.put("organ", queryOrgan);

        }
        if (zslx == null || zslx.equals("gytdsyz")) {
            //s.setQueryString("queryGytdsyz");
            s.setQueryString("queryGytdsyzForSplit");
            s.setQueryParam(map);
        } else if (zslx.equals("jttdsyz")) {
            //s.setQueryString("queryJttdsyz");
            s.setQueryString("queryJttdsyzForSplit");
            s.setQueryParam(map);
        } else if (zslx.equals("jttdsuz")) {
            //s.setQueryString("queryJttdsuz");
            s.setQueryString("queryJttdsuzForSplit");
            s.setQueryParam(map);
        } else if (zslx.equals("txqlzms")) {
            //s.setQueryString("editTxqlzms");
            s.setQueryString("queryTxqlzmsForSplit");
            s.setQueryParam(map);
        }
        /*}*/
        // System.out.println("====="+map);
        this.splitParam = s;
        return SUCCESS;
    }
    /*
    保存锁定信息
     */
    public String saveSdInfo(){
        if(zslx.equals("gytdsyz")){
            IGytdsyzService gytdsyzService = (IGytdsyzService) Container.getBean("gyTdsyzService");
            gytdsyz = gytdsyzService.getGYTDSYZ(projectId );
            if(issd.equals("1")){
                gytdsyz.setSdyy(sdyy);
                gytdsyz.setIssd(issd);
                gytdsyz.setSdr(TddjUtil.getCurrentUserName());
                gytdsyz.setSdsj(CommonUtil.getCurrStrTime());
            }else{
                gytdsyz.setSdyy("");
                gytdsyz.setSdsj("");
                gytdsyz.setIssd("0");
                gytdsyz.setSdr("");
            }
            gytdsyzService.updateGYTDSYZ(gytdsyz);
        }else if(zslx.equals("jttdsyz")){
            IJttdsyzService jttdsyzService = (IJttdsyzService) Container.getBean("jtTdsyzService");
            jttdsyz = jttdsyzService.getJTTDSYZ(projectId);
            if(issd.equals("1")){
                jttdsyz.setSdyy(sdyy);
                jttdsyz.setIssd(issd);
                jttdsyz.setSdr(TddjUtil.getCurrentUserName());
                jttdsyz.setSdsj(CommonUtil.getCurrStrTime());
            }else{
                jttdsyz.setSdyy("");
                jttdsyz.setSdsj("");
                jttdsyz.setIssd("0");
                jttdsyz.setSdr("");
            }
            jttdsyzService.updateJTTDSYZ(jttdsyz);
        }else if(zslx.equals("jttdsuz")){
            IJttdsuzService jttdsuzService = (IJttdsuzService) Container.getBean("jtTdsuzService");
            jttdsuz = jttdsuzService.getJTTDSUZ(projectId);
            if(issd.equals("1")){
                jttdsuz.setSdyy(sdyy);
                jttdsuz.setIssd(issd);
                jttdsuz.setSdr(TddjUtil.getCurrentUserName());
                jttdsuz.setSdsj(CommonUtil.getCurrStrTime());
            }else{
                jttdsuz.setSdyy("");
                jttdsuz.setSdsj("");
                jttdsuz.setIssd("0");
                jttdsuz.setSdr("");
            }
            jttdsuzService.updateJTTDSUZ(jttdsuz);
        }else if(zslx.equals("txqlzms")){
            ITxqlzmsService txqlzmsService = (ITxqlzmsService) Container.getBean("txqlzmsService");
            txqlzms = txqlzmsService.getTXQLZMS(projectId);
            if(issd.equals("1")){
                txqlzms.setSdyy(sdyy);
                txqlzms.setIssd(issd);
                txqlzms.setSdr(TddjUtil.getCurrentUserName());
                txqlzms.setSdsj(CommonUtil.getCurrStrTime());
            }else{
                txqlzms.setSdyy("");
                txqlzms.setSdsj("");
                txqlzms.setIssd("0");
                txqlzms.setSdr("");
            }
            txqlzmsService.updateTXQLZMS(txqlzms);
        }
        msg = "修改成功!";
        return "saveSdInfo";
    }

    public String  sdZs() throws Exception{
//        HttpServletRequest request = ServletActionContext.getRequest();
//        String zslx = request.getParameter("zslx");
        if(zslx.equals("gytdsyz")){
            IGytdsyzService gytdsyzService = (IGytdsyzService) Container.getBean("gyTdsyzService");
            gytdsyz = gytdsyzService.getGYTDSYZ(projectId );
            gytdsyz.setSdyy("宗地近期拆迁");
            if(gytdsyz.getIssd()==null){
                 gytdsyz.setIssd("0");
            }
            gytdsyzService.updateGYTDSYZ(gytdsyz);
            zsno = gytdsyz.getZsno();
            tdzh = gytdsyz.getTdzh();
            djh = gytdsyz.getDjh();
            qlr = gytdsyz.getQlr();
            sdyy = gytdsyz.getSdyy();
            zl = gytdsyz.getZl();
            issd = gytdsyz.getIssd();
        }else if(zslx.equals("jttdsyz")){
            IJttdsyzService jttdsyzService = (IJttdsyzService) Container.getBean("jtTdsyzService");
            jttdsyz = jttdsyzService.getJTTDSYZ(projectId);
            jttdsyz.setSdyy("宗地近期拆迁");
            if(jttdsyz.getIssd()==null){
                jttdsyz.setIssd("0");
            }
            jttdsyzService.updateJTTDSYZ(jttdsyz);
            zsno = jttdsyz.getZsno();
            tdzh = jttdsyz.getTdzh();
            djh = jttdsyz.getDjh();
            qlr = jttdsyz.getQlr();
            sdyy = jttdsyz.getSdyy();
            zl = jttdsyz.getZl();
            issd = jttdsyz.getIssd();
        }else if(zslx.equals("jttdsuz")){
            IJttdsuzService jttdsuzService = (IJttdsuzService) Container.getBean("jtTdsuzService");
            jttdsuz = jttdsuzService.getJTTDSUZ(projectId);
            jttdsuz.setSdyy("宗地近期拆迁");
            if(jttdsuz.getIssd()==null){
                jttdsuz.setIssd("0");
            }
            jttdsuzService.updateJTTDSUZ(jttdsuz);
            zsno = jttdsuz.getZsno();
            tdzh = jttdsuz.getTdzh();
            djh = jttdsuz.getDjh();
            qlr = jttdsuz.getQlr();
            sdyy = jttdsuz.getSdyy();
            zl = jttdsuz.getZl();
            issd = jttdsuz.getIssd();
        }else if(zslx.equals("txqlzms")){
            ITxqlzmsService txqlzmsService = (ITxqlzmsService) Container.getBean("txqlzmsService");
            txqlzms = txqlzmsService.getTXQLZMS(projectId);
            txqlzms.setSdyy("宗地近期拆迁");
            if(txqlzms.getIssd()==null){
                txqlzms.setIssd("0");
            }
            txqlzmsService.updateTXQLZMS(txqlzms);
            zsno = txqlzms.getZsno();
            tdzh = txqlzms.getTdzh();
            djh = txqlzms.getDjh();
            qlr = txqlzms.getQlr();
            sdyy = txqlzms.getSdyy();
            zl = txqlzms.getZl();
            issd = txqlzms.getIssd();
        }
        return "sdZs";
    }
    public SplitParam getSplitParam() {
        return splitParam;
    }

    public void setSplitParam(SplitParam splitParam) {
        this.splitParam = splitParam;
    }

    public String getZslx() {
        return zslx;
    }

    public void setZslx(String zslx) {
        this.zslx = zslx;
    }

    public String getTdzh() {
        return tdzh;
    }

    public void setTdzh(String tdzh) {
        this.tdzh = tdzh;
    }

    public String getQlr() {
        return qlr;
    }

    public void setQlr(String qlr) {
        this.qlr = qlr;
    }

    public String getDjh() {
        return djh;
    }

    public void setDjh(String djh) {
        this.djh = djh;
    }

    public String getZl() {
        return zl;
    }

    public void setZl(String zl) {
        this.zl = zl;
    }

    public String getSyqlx() {
        return syqlx;
    }

    public void setSyqlx(String syqlx) {
        this.syqlx = syqlx;
    }

    public String getFzrq1() {
        return fzrq1;
    }

    public void setFzrq1(String fzrq1) {
        this.fzrq1 = fzrq1;
    }

    public String getFzrq2() {
        return fzrq2;
    }

    public void setFzrq2(String fzrq2) {
        this.fzrq2 = fzrq2;
    }


    public LinkedHashMap<String, String> getZslxlist() {
        return zslxlist;
    }

    public void setZslxlist(LinkedHashMap<String, String> zslxlist) {
        this.zslxlist = zslxlist;
    }
    public String getOrgan() {
        return organ;
    }

    public void setOrgan(String organ) {
        this.organ = organ;
    }

    public String getZsno() {
        return zsno;
    }

    public void setZsno(String zsno) {
        this.zsno = zsno;
    }

    public String getYt() {
        return yt;
    }

    public void setYt(String yt) {
        this.yt = yt;
    }

    public String getZsstate() {
        return zsstate;
    }

    public void setZsstate(String zsstate) {
        this.zsstate = zsstate;
    }

    public LinkedHashMap<String, String> getZsstatelist() {
        return zsstatelist;
    }

    public void setZsstatelist(LinkedHashMap<String, String> zsstatelist) {
        this.zsstatelist = zsstatelist;
    }

    public String getUserDwdm() {
        return userDwdm;
    }

    public void setUserDwdm(String userDwdm) {
        this.userDwdm = userDwdm;
    }

    public List<String> getOrganlist() {
        return organlist;
    }

    public void setOrganlist(List<String> organlist) {
        this.organlist = organlist;
    }

    public String getOldDjh() {
        return oldDjh;
    }

    public void setOldDjh(String oldDjh) {
        this.oldDjh = oldDjh;
    }

    public String getZjbh() {
        return zjbh;
    }

    public void setZjbh(String zjbh) {
        this.zjbh = zjbh;
    }

    public String getProjectId() {
        return projectId;
    }

    public void setProjectId(String projectId) {
        this.projectId = projectId;
    }

    public String getSdyy() {
        return sdyy;
    }

    public void setSdyy(String sdyy) {
        this.sdyy = sdyy;
    }

    public GYTDSYZ getGytdsyz() {
        return gytdsyz;
    }

    public void setGytdsyz(GYTDSYZ gytdsyz) {
        this.gytdsyz = gytdsyz;
    }

    public JTTDSUZ getJttdsuz() {
        return jttdsuz;
    }

    public void setJttdsuz(JTTDSUZ jttdsuz) {
        this.jttdsuz = jttdsuz;
    }

    public JTTDSYZ getJttdsyz() {
        return jttdsyz;
    }

    public void setJttdsyz(JTTDSYZ jttdsyz) {
        this.jttdsyz = jttdsyz;
    }

    public TXQLZMS getTxqlzms() {
        return txqlzms;
    }

    public void setTxqlzms(TXQLZMS txqlzms) {
        this.txqlzms = txqlzms;
    }

    public LinkedHashMap<String, String> getIssdList() {
        return issdList;
    }

    public void setIssdList(LinkedHashMap<String, String> issdList) {
        this.issdList = issdList;
    }

    public String getIssd() {
        return issd;
    }

    public void setIssd(String issd) {
        this.issd = issd;
    }

    public String getMsg() {
        return msg;
    }

    public void setMsg(String msg) {
        this.msg = msg;
    }
}
