package com.jsegov.tddj.action;

import java.util.HashMap;

import com.gtis.web.SplitParam;
import com.gtis.web.SplitParamImpl;
import com.jsegov.tddj.vo.DHDZB;
import com.opensymphony.xwork2.ActionSupport;

public class QueryDHDZBAction extends ActionSupport {

	/**
	 * 查询地号对照表 
	 * (镇江用)
	 */
	private static final long serialVersionUID = -6551334819874624741L;
	private SplitParam splitParam;
	private DHDZB dhdzb = new DHDZB();

	@Override
	public String execute() throws Exception {
		// TODO Auto-generated method stub
		HashMap<String, Object> map = new HashMap<String, Object>();
		if (dhdzb != null) {
			if (dhdzb.getNewdh() != null && !dhdzb.getNewdh().equals("")) {
				map.put("newdh", "%" + dhdzb.getNewdh() + "%");
			}
			if (dhdzb.getOlddh() != null && !dhdzb.getOlddh().equals("")) {
				map.put("olddh", "%" + dhdzb.getOlddh() + "%");
			}
			if (dhdzb.getFldm() != null && !dhdzb.getFldm().equals("")) {
				map.put("fldm", "%" + dhdzb.getFldm() + "%");
			}
		}
		SplitParamImpl s = new SplitParamImpl();
		s.setQueryString("queryDHDZB");
		s.setQueryParam(map);
		this.splitParam = s;
		return SUCCESS;
	}

	public SplitParam getSplitParam() {
		return splitParam;
	}

	public void setSplitParam(SplitParam splitParam) {
		this.splitParam = splitParam;
	}

	public DHDZB getDhdzb() {
		return dhdzb;
	}

	public void setDjhdzb(DHDZB dhdzb) {
		this.dhdzb = dhdzb;
	}

}
