package com.jsegov.tddj.action;

import java.util.Date;
import java.util.HashMap;

import javax.servlet.http.HttpServletRequest;

import com.jsegov.tddj.util.DjhConvert;
import org.apache.struts2.ServletActionContext;

import com.gtis.spring.Container;
import com.gtis.web.SplitParam;
import com.gtis.web.SplitParamImpl;
import com.jsegov.tddj.platform.TddjUtil;
import com.jsegov.tddj.services.interf.ICFService;
import com.jsegov.tddj.services.interf.IJFService;
import com.jsegov.tddj.util.CommonUtil;
import com.jsegov.tddj.vo.CF;
import com.jsegov.tddj.vo.JF;
import com.opensymphony.xwork2.ActionSupport;

public class QueryCFJFAction extends ActionSupport {

	/**
	 * 
	 */
	private static final long serialVersionUID = -5207069405937634022L;
	private SplitParam splitParam;
	private String djh;
	private String tdzh;
	private String zl;
	private String zxsqr;
	private String bzxr;
	private String isjf;
	private String BeginDate_CF;
	private String EndDate_CF;
	private String BeginDate_JF;
	private String EndDate_JF;
	private String sdrq;
	private String cfksrq;
	private String cfjsrq;
	private String userDwdm;
	
	private CF cf;
	private JF jf;
	private String iscfjf;
	private String oldDjh;
	
	public String getSdrq() {
		return sdrq;
	}

	public void setSdrq(String sdrq) {
		this.sdrq = sdrq;
	}

	public String getCfksrq() {
		return cfksrq;
	}

	public void setCfksrq(String cfksrq) {
		this.cfksrq = cfksrq;
	}

	public String getCfjsrq() {
		return cfjsrq;
	}

	public void setCfjsrq(String cfjsrq) {
		this.cfjsrq = cfjsrq;
	}

	public CF getCf() {
		return cf;
	}

	public void setCf(CF cf) {
		this.cf = cf;
	}

	public JF getJf() {
		return jf;
	}

	public void setJf(JF jf) {
		this.jf = jf;
	}

	public String getIscfjf() {
		return iscfjf;
	}

	public void setIscfjf(String iscfjf) {
		this.iscfjf = iscfjf;
	}

	public String execute() throws Exception {
		HashMap<String, Object> map=new HashMap<String, Object>();
		HttpServletRequest request = ServletActionContext.getRequest();
		map = CommonUtil.getDwdmQuery(request, map);
		if (map.get("dwdm")!=null)
			userDwdm = TddjUtil.getCurrentUserDwdm();

        if(userDwdm.equals("320800")){
            map.put("dwdm","3208");
        }
		String queryDjh=null;
		String queryTdzh=null;
		String queryZl=null;
		String queryZxsqr=null;
		String queryBzxr=null;
		String queryIsjf=null;
		Date queryBeginDate_CF=null;
		Date queryEndDate_CF=null;
		String queryBeginDate_JF=null;
		String queryEndDate_JF=null;
		
		/*if(djh!=null && !djh.equals("")){
			queryDjh="%"+djh+"%";
		}*/
        if (djh != null && !djh.equals("")) {
            HashMap param=new HashMap();
            param= DjhConvert.ConvertToNewDjh(djh);
            queryDjh=(String)param.get("addDjh");

        }
        if(oldDjh!=null&&!oldDjh.equals(""))
        {
            HashMap param=new HashMap();
            param=DjhConvert.ConvertToOldDjh(oldDjh);
            queryDjh=(String)param.get("addDjh");

        }
		if(tdzh!=null && !tdzh.equals("")){
			queryTdzh="%"+tdzh+"%";
		}
		if(zl!=null && !zl.equals("")){
			queryZl="%"+zl+"%";
		}
		if(zxsqr!=null && !zxsqr.equals("")){
			queryZxsqr="%"+zxsqr+"%";
		}
		if(bzxr!=null && !bzxr.equals("")){
			queryBzxr="%"+bzxr+"%";
		}
		if(isjf!=null && !isjf.equals("")){
			queryIsjf=isjf;
		}
		if(BeginDate_CF!=null && !BeginDate_CF.equals("")){
			queryBeginDate_CF=CommonUtil.formateDateToStr(BeginDate_CF);
		}
		if(EndDate_CF!=null && !EndDate_CF.equals("")){
			queryEndDate_CF=CommonUtil.formateDateToStr(EndDate_CF);
		}
		if(BeginDate_JF!=null && !BeginDate_JF.equals("")){
			queryBeginDate_JF=BeginDate_JF;
		}
		if(EndDate_JF!=null && !EndDate_JF.equals("")){
			queryEndDate_JF=EndDate_JF;
		}

		map.put("transDjh", queryDjh);
		map.put("tdzh", queryTdzh);
		map.put("zl", queryZl);
		map.put("zxsqr", queryZxsqr);
		map.put("bzxr", queryBzxr);
		map.put("isjf", queryIsjf);
		map.put("BeginDate_CF", queryBeginDate_CF);
		map.put("EndDate_CF", queryEndDate_CF);
		map.put("BeginDate_JF", queryBeginDate_JF);
		map.put("EndDate_JF", queryEndDate_JF);
		
		//System.out.println("map="+map);
		SplitParamImpl s = new SplitParamImpl();
		s.setQueryString("queryCFJF");
		s.setQueryParam(map);
		this.splitParam = s;
		return SUCCESS;
	}

	public String viewCfJfInFo(){
		HttpServletRequest request = ServletActionContext.getRequest();
		String cfProjectId = "";
		iscfjf = "已查封";
		if (request.getParameter("cfProjectId") != null){
			cfProjectId = request.getParameter("cfProjectId");
		}
		ICFService cfService = (ICFService)Container.getBean("cfService");
		cf = cfService.getCFByProjectId(cfProjectId);
		if (cf != null && cf.getIsjf() != null && cf.getIsjf()==1){
			iscfjf = "已解封";
			IJFService jfService = (IJFService)Container.getBean("jfService");
			jf = jfService.getJFByCfProjectId(cfProjectId);
		}
		
		//if (cf.getSdrq()!=null && !cf.getSdrq().equals("")) sdrq = CommonUtil.formateDate(cf.getSdrq());
		if (cf.getSdrq()!=null && !cf.getSdrq().equals("")) sdrq = CommonUtil.formateTime(cf.getSdrq());
		if (cf.getCfksrq()!=null && !cf.getCfksrq().equals(""))cfksrq = CommonUtil.formateDate(cf.getCfksrq());
		if (cf.getCfjsrq()!=null && !cf.getSdrq().equals(""))cfjsrq = CommonUtil.formateDate(cf.getCfjsrq());
		
		return "viewCfJfInFo";
	}
	
	public SplitParam getSplitParam() {
		return splitParam;
	}


	public void setSplitParam(SplitParam splitParam) {
		this.splitParam = splitParam;
	}


	public String getDjh() {
		return djh;
	}

	public void setDjh(String djh) {
		this.djh = djh;
	}

	public String getTdzh() {
		return tdzh;
	}

	public void setTdzh(String tdzh) {
		this.tdzh = tdzh;
	}

	public String getZl() {
		return zl;
	}

	public void setZl(String zl) {
		this.zl = zl;
	}

	public String getZxsqr() {
		return zxsqr;
	}

	public void setZxsqr(String zxsqr) {
		this.zxsqr = zxsqr;
	}

	public String getBzxr() {
		return bzxr;
	}

	public void setBzxr(String bzxr) {
		this.bzxr = bzxr;
	}

	public String getIsjf() {
		return isjf;
	}

	public void setIsjf(String isjf) {
		this.isjf = isjf;
	}

	public String getBeginDate_CF() {
		return BeginDate_CF;
	}

	public void setBeginDate_CF(String beginDate_CF) {
		BeginDate_CF = beginDate_CF;
	}

	public String getEndDate_CF() {
		return EndDate_CF;
	}

	public void setEndDate_CF(String endDate_CF) {
		EndDate_CF = endDate_CF;
	}

	public String getBeginDate_JF() {
		return BeginDate_JF;
	}

	public void setBeginDate_JF(String beginDate_JF) {
		BeginDate_JF = beginDate_JF;
	}

	public String getEndDate_JF() {
		return EndDate_JF;
	}

	public void setEndDate_JF(String endDate_JF) {
		EndDate_JF = endDate_JF;
	}

	public String getUserDwdm() {
		return userDwdm;
	}

	public void setUserDwdm(String userDwdm) {
		this.userDwdm = userDwdm;
	}
	
	public String getOldDjh() {
		return oldDjh;
	}

	public void setOldDjh(String oldDjh) {
		this.oldDjh = oldDjh;
	}

}
