package com.jsegov.tddj.action;

import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;

import javax.servlet.http.HttpServletRequest;

import org.apache.struts2.ServletActionContext;

import com.gtis.web.SplitParam;
import com.gtis.web.SplitParamImpl;
import com.jsegov.tddj.platform.TddjUtil;
import com.jsegov.tddj.util.CommonUtil;
import com.jsegov.tddj.vo.XZQ;
import com.opensymphony.xwork2.ActionSupport;

/**
 * 签收簿打印ACTION
 * 
 * @return printQSB.jsp
 *
 */
public class PrintQSBAction extends ActionSupport{
	/**
	 * 
	 */
	private static final long serialVersionUID = -8833879954544137821L;
	
	private SplitParam splitParam;
	private String zslx; 
	private String fzrq1;
	private String fzrq2; 
	private String tdzh1;
	private String tdzh2; 
	private LinkedHashMap<String,String> zslxlist;
	private String userDwdm;

	public String getUserDwdm() {
		return userDwdm;
	}

	public void setUserDwdm(String userDwdm) {
		this.userDwdm = userDwdm;
	}

	public PrintQSBAction() { 
		this.zslxlist = new LinkedHashMap<String, String>();
		this.zslxlist.put("gytdsyz", "国有土地使用证");
		this.zslxlist.put("jttdsyz", "集体土地使用证");
		this.zslxlist.put("txqlzms", "他项权利证明书");
		//this.zslxlist.put("jttdsuz", "集体土地所有证");
	}

	public String execute() throws Exception {
		HashMap<String, Object> map = new HashMap<String, Object>();
		HttpServletRequest request = ServletActionContext.getRequest();		
        String userId = TddjUtil.getCurrentUserId();
		//request.setAttribute("userDwdm", userDwdm);
		 
		SplitParamImpl s = new SplitParamImpl();
		Date queryFzrq1 = null;
		Date queryFzrq2 = null;
		String queryTdzh1 = null;
		String queryTdzh2 = null;
		
		String queryTdzhYear = null;
		
		if (fzrq1 != null && !fzrq1.equals("")) {
			queryFzrq1 = CommonUtil.formateDateToStr(fzrq1);
		}
		if (fzrq2 != null && !fzrq2.equals("")) {
			queryFzrq2 = CommonUtil.formateDateToStr(fzrq2);
		}
		XZQ xzq = CommonUtil.getXZQ();
		String xzqShortName = xzq.getXzqShortName();
        if (tdzh1 != null && !tdzh1.equals("")) {
            queryTdzh1 = tdzh1.replace("(", "");
            queryTdzh1 = queryTdzh1.replace(")", "");
            queryTdzh1 = queryTdzh1.replace("（", "");
            queryTdzh1 = queryTdzh1.replace("）", "");
            queryTdzh1 = queryTdzh1.replace(xzqShortName + "国用", "");
            queryTdzh1 = queryTdzh1.replace(xzqShortName + "集用", "");
            queryTdzh1 = queryTdzh1.replace(xzqShortName + "集有", "");
            queryTdzh1 = queryTdzh1.replace(xzqShortName + "他项", "");
            queryTdzh1 = queryTdzh1.replace("第", "");
            queryTdzh1 = queryTdzh1.replace("号", "");
            try{
                queryTdzhYear = "(" + queryTdzh1.substring(0, 4) + ")";
                queryTdzh1 = queryTdzh1.substring(4, queryTdzh1.length());
            }catch (Exception e) {
                // TODO: handle exception
            }
            if (queryTdzhYear!=null && !queryTdzhYear.equals("")) map.put("TdzhYear", "%" + queryTdzhYear + "%");
            if (queryTdzhYear!=null && !queryTdzhYear.equals("")) map.put("queryTdzhYear", queryTdzhYear);
        }

        if (tdzh2 != null && !tdzh2.equals("")) {
            queryTdzh2 = tdzh2.replace("(", "");
            queryTdzh2 = queryTdzh2.replace(")", "");
            queryTdzh2 = queryTdzh2.replace("（", "");
            queryTdzh2 = queryTdzh2.replace("）", "");
            queryTdzh2 = queryTdzh2.replace(xzqShortName + "国用", "");
            queryTdzh2 = queryTdzh2.replace(xzqShortName + "集用", "");
            queryTdzh2 = queryTdzh2.replace(xzqShortName + "集有", "");
            queryTdzh2 = queryTdzh2.replace(xzqShortName + "他项", "");
            queryTdzh2 = queryTdzh2.replace("第", "");
            queryTdzh2 = queryTdzh2.replace("号", "");
            try{
                queryTdzhYear = "(" + queryTdzh2.substring(0, 4) + ")";
                queryTdzh2 = queryTdzh2.substring(4, queryTdzh2.length());
            }catch (Exception e) {
                // TODO: handle exception
            }
            if (queryTdzhYear!=null && !queryTdzhYear.equals("")) map.put("TdzhYear", "%" + queryTdzhYear + "%");
            if (queryTdzhYear!=null && !queryTdzhYear.equals("")) map.put("queryTdzhYear", queryTdzhYear);
        }

        map.put("fzrq1", queryFzrq1);
		map.put("fzrq2", queryFzrq2);
        if (queryTdzh1!=null && !queryTdzh1.equals("")) map.put("tdzh1", queryTdzh1);
        if (queryTdzh2!=null && !queryTdzh2.equals("")) map.put("tdzh2", queryTdzh2);;
		map.put("zsstate","0");//查找可用用的证书 
		map.put("iscomplete","1");//查找项目已经完成的证书

		map = CommonUtil.getDwdmQuery(request, map);
		if (map.get("dwdm")!=null)
			userDwdm = TddjUtil.getCurrentUserDwdm();
		if (zslx == null || zslx.equals("gytdsyz")) {
			s.setQueryString("queryGytdsyzForSplit");
			s.setQueryParam(map);
		} else if (zslx.equals("jttdsyz")) {
			s.setQueryString("queryJttdsyzForSplit");
			s.setQueryParam(map);
		} else if (zslx.equals("jttdsuz")) {
			s.setQueryString("queryJttdsuzForSplit");
			s.setQueryParam(map);
		} else if (zslx.equals("txqlzms")) {
			s.setQueryString("queryTxqlzmsForSplit");
			s.setQueryParam(map);
		}
        map.put("dwdm","3208%");
		this.splitParam = s;
		return SUCCESS;
	}

	public SplitParam getSplitParam() {
		return splitParam;
	}

	public void setSplitParam(SplitParam splitParam) {
		this.splitParam = splitParam;
	}

	public String getZslx() {
		return zslx;
	}

	public void setZslx(String zslx) {
		this.zslx = zslx;
	}

	public String getFzrq1() {
		return fzrq1;
	}

	public void setFzrq1(String fzrq1) {
		this.fzrq1 = fzrq1;
	}

	public String getFzrq2() {
		return fzrq2;
	}

	public void setFzrq2(String fzrq2) {
		this.fzrq2 = fzrq2;
	}

	public String getTdzh1() {
		return tdzh1;
	}

	public void setTdzh1(String tdzh1) {
		this.tdzh1 = tdzh1;
	}

	public String getTdzh2() {
		return tdzh2;
	}

	public void setTdzh2(String tdzh2) {
		this.tdzh2 = tdzh2;
	}
	
	public LinkedHashMap<String, String> getZslxlist() {
		return zslxlist;
	}

	public void setZslxlist(LinkedHashMap<String, String> zslxlist) {
		this.zslxlist = zslxlist;
	}
}
