package com.jsegov.tddj.action;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.List;

import javax.servlet.http.HttpServletRequest;

import org.apache.struts2.ServletActionContext;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.SAXReader;
import org.dom4j.io.XMLWriter;

import com.jsegov.tddj.platform.TddjUtil;
import com.opensymphony.xwork2.ActionSupport;

public class PrintManageAction extends ActionSupport {

	/**
	 * 
	 */
	
	private static final long serialVersionUID = -7016497225026476106L;
    protected String userPrintManage;
    private String path = this.getClass().getResource("/").getPath() + "conf/tddj/printManage.xml";
    
	public String getUserPrintManage() {
		String userName=TddjUtil.getCurrentUserName();
		userPrintManage = readUser(userName);
		return userPrintManage;
	}

	public void setUserPrintManage(String userPrintManage) {
		this.userPrintManage = userPrintManage;
	}

	
	public String execute() throws Exception {
		HttpServletRequest request = ServletActionContext.getRequest();
		// TODO Auto-generated method stub
		if (request.getParameter("userValue")!=null){
			String userValue = request.getParameter("userValue");
			String userName=TddjUtil.getCurrentUserName();
			editUser(userName,userValue);
		}
		return SUCCESS;
	}

//	public static void main(String[] args) {
//		
//		//System.out.println(this.getClass().getResource("/").getPath());
//		String ii = readUser("admin1");
//		System.out.println(ii);
//
//	}
	public Document readXml(){
		SAXReader sr = new SAXReader();
		Document document = null;
		//String path = this.getClass().getResource("/").getPath() + "conf/tddj/printManage.xml";
		try {
			document = sr.read(path);
		} catch (DocumentException e) {
			e.printStackTrace();
		}
		return document;
	}
	
	public void saveXml(Document document){
		try {
			OutputFormat format = OutputFormat.createPrettyPrint();
			format.setEncoding("GBK");
			XMLWriter output = new XMLWriter(new FileWriter(new File(path)),format);
			output.write(document);
	        output.close();
		} catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
	}
	
	public void editUser(String userName,String userValue){
		Document document = readXml();
		boolean isExistUser = false;
		List<Element> nameList = document.selectNodes("/Config/user/name"); 
		List<Element> valueList = document.selectNodes("/Config/user/value");
		for(int i =0;i<nameList.size();i++){
			Element nameElement = (Element)nameList.get(i);
			if (nameElement.getText().equals(userName)){
				isExistUser = true;
				((Element)valueList.get(i)).setText(userValue);
				break;
			}
		}
		if (!isExistUser){
			Element root = document.getRootElement();
			Element user = root.addElement("user");
			Element addUserName = user.addElement("name");
			addUserName.setText(userName);
			Element addUserValue = user.addElement("value");
			addUserValue.setText(userValue);
		}
		saveXml(document);
	}
	
	public String readUser(String userName){
		String userPrint = "";
		Document document = readXml();
		List<Element> nameList = document.selectNodes("/Config/user/name"); 
		List<Element> valueList = document.selectNodes("/Config/user/value");
		for(int i =0;i<nameList.size();i++){
			Element nameElement = (Element)nameList.get(i);
			if (nameElement.getText().equals(userName)){
				userPrint = ((Element)valueList.get(i)).getText();
				break;
			}
		}
		if (userPrint.equals("")){
			userPrint = "1";
			Element root = document.getRootElement();
			Element user = root.addElement("user");
			Element addUserName = user.addElement("name");
			addUserName.setText(userName);
			Element addUserValue = user.addElement("value");
			addUserValue.setText(userPrint);
			saveXml(document);
			//formatXMLFile(path);
		}
		return userPrint;
	}
	
	/** 格式化输出,类型IE浏览一样 */
	public void formatXMLFile(String filename){
		try{
			SAXReader saxReader = new SAXReader(); 
			Document document = saxReader.read(new File(filename));
			XMLWriter writer = null;
			OutputFormat format = OutputFormat.createPrettyPrint();
			format.setEncoding("GBK");
			writer= new XMLWriter(new FileWriter(new File(filename)),format);
			writer.write(document);
			writer.close();      
		}catch(Exception ex){
			ex.printStackTrace();
		}
	}
}
