package com.jsegov.tddj.action;

import java.util.Calendar;
import java.util.List;

import javax.servlet.http.HttpServletRequest;

import com.jsegov.tddj.platform.IqlygUtil;
import com.jsegov.tddj.services.interf.*;
import com.jsegov.tddj.vo.*;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts2.ServletActionContext;

import com.gtis.spring.Container;
import com.gtis.util.UUIDGenerator;
import com.jsegov.tddj.platform.IPlatUtil;
import com.jsegov.tddj.platform.TddjUtil;
import com.jsegov.tddj.util.CommonUtil;
import com.opensymphony.xwork2.ActionSupport;

public class NewProjectAction extends ActionSupport {
    /**
     * 新增项目ACTION
     */
    private static final long serialVersionUID = 1L;
    private Project project = new Project();
    private NewProject newProject = new NewProject();
    private String userId;
    private String userName;
    private String userDwdm;
    private String workflowIntanceId;
    private IBHService bhService;
    private Integer bsm;
    private String createOrgan;

    private String sfzmNum;
    private String address;
    private String crf;
    private String rf2_sfzmtype;
    private String rf2_sfzmnum;
    private String rf2_dwxz;
    private String rf2_txdz;
    private String rf2_yb;
    private String rf2_fddbr;
    private String rf2_lxr;
    private String rf2_lxdh;
    private String rf2_dzyj;
    private String rf2_dlrxm;
    private String rf2_dlrzsh;
    private String rf2_dljgmc;
    private String rf2_dllxdh;
    static Log log = LogFactory.getLog("NewProjectAction");
    private SQB sqb_qlyg = new SQB();
    private Integer isjfAllLHCF;
    private Integer isXCF;

    //校验地籍号 如果为旧号统一转化为新地籍号
    public void turnDjh() {
        if (StringUtils.isNotBlank(project.getDjh())) {
            try {
                IZDDZBService zddzbService = (IZDDZBService) Container.getBean("zddzbService");

                List<ZDDZB> zddzbList = zddzbService.selectNewDjhFromZddzb(project.getDjh());
                if (zddzbList != null && zddzbList.size() != 0) {
                    project.setDjh(zddzbList.get(0).getDh());
                }
            } catch (Exception e) {
                e.printStackTrace();
            }


        }
    }

    public String execute() throws Exception {
        //创建项目前更新老登记卡
        IDJKService djkService = (IDJKService) Container.getBean("djkService");
        djkService.updateDjk(project.getDjh());
        //地籍号转换改由前台选择
        //turnDjh();
        userId = TddjUtil.getCurrentUserId();
        userName = TddjUtil.getCurrentUserName();
        userDwdm = TddjUtil.getCurrentUserDwdm();
        createOrgan = TddjUtil.getCurrentUserOrgan();
        workflowIntanceId = UUIDGenerator.generate();
        project.setProjectId(workflowIntanceId);
        String taskId = createWfInstance();
        if (taskId == null || taskId.equals("")) {
            log.error("taskId为空，请检查该流程首节点角色挂载等！");
        }
        //System.out.println(request.getSession().getId());
        // 保存项目信息
        createProject(taskId);
        // 创建收件单 (生成编号,申请类型,申请人,收件人,收件日期、默认承诺期限),返回标识码

        bsm = createSJD();//得到收件单的标识码
        //System.out.println(project.getDjlx());
        if (project.getDjlx().equals("初始登记") || project.getDjlx().equals("土地总登记")) {
            SaveCSDJ(1);
        } else if (project.getDjlx().equals("名称地址用途变更登记")) {
            SaveMCBGDJ();
        } else if (project.getDjlx().equals("房改房登记") || project.getDjlx().equals("变更登记")) {
            SaveBGDJ();
        } else if (project.getDjlx().equals("他项登记")) {
            SaveTXDJ();
        } else if (project.getDjlx().equals("分割登记")) {
            SaveFGDJ();
        } else if (project.getDjlx().equals("分割证换发证")) {
            SaveFGZHFZ();
        } else if (project.getDjlx().equals("换证与遗失补证")) {
            SaveYSBF();
        } else if (project.getDjlx().equals("查封")) {
            SaveCFDJ();
        } else if (project.getDjlx().equals("轮候查封")) {
            SaveLHCFDJ();
        } else if (project.getDjlx().equals("注销登记")) {
            SaveZXDJ();
        } else if (project.getDjlx().equals("异议登记")) {
            SaveYYDJ();
        } else if (project.getDjlx().equals("注销异议登记")) {
            SaveZXYYDJ();
        } else if (project.getDjlx().equals("预告登记")) {
            SaveYGDJ();
        } else if (project.getDjlx().equals("更正登记")) {
            SaveBGDJ();
        } else if (project.getDjlx().equals("解封")) {
            SaveJFDJ();
        } else if (project.getDjlx().equals("证书挂失")) {
            SaveZSGS();
        }

        //zdd 工作流创建后调用权力阳光接口
        IqlygUtil qlygUtil = (IqlygUtil)Container.getBean("qlygUtil");
        IPlatUtil platUtil = (IPlatUtil)Container.getBean("platUtil");
        System.out.println("开始调用权力阳光接口！！！！");
        qlygUtil.workflowBegin(workflowIntanceId, platUtil.getPfActivityIdByTaskId(taskId), sqb_qlyg.getQsxz(), sqb_qlyg.getSqlx());
        return "success";
    }

    //证书挂失
    public void SaveZSGS() throws Exception {
        IZSGSService zsgsService = (IZSGSService) Container.getBean("zsgsService");
        ZSGS zsgs = new ZSGS();
        try {
            String qsxz = getQSXZ(project.getSqlx());
            if (qsxz.equals("")) {
                qsxz = getQSXZ(project.getQsxz());
            }
            zsgs.setSqr(project.getQlr());
            zsgs.setZl(project.getTdzl());
            zsgs.setTdzh(project.getTdzh());
            zsgs.setDjh(project.getDjh());
//			zsgs.setSqrq(CommonUtil.getCurrStrDate());
            zsgs.setSqrq(CommonUtil.getCurrDate());
            zsgs.setProjectId(project.getProjectId());
            zsgs.setIslogout(0);
            String oldZslx = project.getQsxz();
            if (oldZslx.equals("GY")) {
                IGytdsyzService gytdsyzService = (IGytdsyzService) Container.getBean("gyTdsyzService");
                GYTDSYZ gytdsyz = gytdsyzService.getGYTDSYZbyTdzh(project.getTdzh());
                if (gytdsyz != null) {
                    zsgs.setQlr(gytdsyz.getQlr());
                    zsgs.setSyqmj(gytdsyz.getSyqmj());
                }
            } else if (oldZslx.equals("JY")) {
                IJttdsyzService jttdsyzService = (IJttdsyzService) Container.getBean("jtTdsyzService");
                JTTDSYZ jttdsyz = jttdsyzService.getJTTDSYZByTdzh(project.getTdzh());
                if (jttdsyz != null) {
                    zsgs.setQlr(jttdsyz.getQlr());
                    zsgs.setSyqmj(jttdsyz.getSyqmj());
                }
            }
            IBHService bhService = (IBHService) Container.getBean("bhService");
            zsgs.setBh(bhService.getZSGSBH());
            sqb_qlyg.setQsxz(qsxz);
            sqb_qlyg.setSqlx(project.getSqlx());
        } catch (Exception e) {
            // TODO: handle exception
            log.error(e);
        } finally {
            zsgsService.insertZSGS(zsgs);
        }
    }

    //初始登记
    public void SaveCSDJ(Integer rfNum) {
        //保存申请表(人方1单位名称，申请类型，使用权类型，权属性质，土地座落)

//		SQB sqb = new SQB();
//		String qsxz = getQSXZ(project.getSqlx());
//		if (qsxz.equals("")) {
//			qsxz = getQSXZ(project.getQsxz());	
//		}
//		String rf1="";
//		if (project.getQsxz().equals("GY")){
//			rf1 = "ʹ��Ȩ��";
//		}else if(project.getQsxz().equals("JY")){
//			rf1 = "ʹ��Ȩ��";
//		}else if(project.getQsxz().equals("JU")){
//			rf1 = "����Ȩ��";
//		}
//		sqb.setProjectId(project.getProjectId());
//		sqb.setRf1(rf1);
//		sqb.setSqsbh(bhService.getSQBBH());
//		//System.out.println(project.getProjectId());
//		sqb.setBsm(bsm);
//		//System.out.println(bsm+"=========bsm");
//		sqb.setSqlx(project.getSqlx());
//		sqb.setDjh(project.getDjh());
//		sqb.setZl(project.getTdzl());
//		sqb.setDwdm(userDwdm);
//		sqb.setQsxz(qsxz);
//		//sqb.setSjr(userName);
//		//sqb.setSjrq(Calendar.getInstance().getTime());
//		sqb.setRmzf(CommonUtil.getXZQ().getXzqName());
//		sqb.setRf1_dwmc(project.getQlr());
//		sqb.setSyqlx(getSyqlx(project.getSqlx()));
//		ISQBService sqbService = (ISQBService)Container.getBean("sqbService");
//		if (qsxz.equals("�����u�����Ȩ")){
//			if (project.getSqlx().equals("�����u�����Ȩ�����ʼ�Ǽ�")){
//				ISyqfzService syqfzService = (ISyqfzService)Container.getBean("syqfzService");
//				Double zdmj = syqfzService.statZmj(project.getDjh());
//				if(zdmj!=null)sqb.setZdmj(zdmj.toString());
//			}else{
//				if (project.getDjh()!=null && !project.getDjh().equals("")){
//					QSZD_DJDCB djdcb = new QSZD_DJDCB();
//					if (project.getDjh()!=null && !project.getDjh().equals("")){
//						djdcb.setDjh(project.getDjh());
//						IQSZD_DJDCBService qszddcb_Service = (IQSZD_DJDCBService)Container.getBean("qszd_DjdcbService");
//						djdcb = qszddcb_Service.selectDjdcb(djdcb);
//					}
//					sqbService.readSYQDCB(sqb, djdcb, rfNum);
//				}
//			}
//			sqb.setDw("���ꡢ��Ԫ");
//		}else{
//			ZD_DJDCB djdcb = new ZD_DJDCB();
//			if (project.getDjh()!=null && !project.getDjh().equals("")){
//				djdcb.setDjh(project.getDjh());
//				IZD_DJDCBService djdcbService = (IZD_DJDCBService)Container.getBean("zdDjdcbService");
//				djdcb = djdcbService.selectDjdcb(djdcb);
//			}
//			sqb=sqbService.readDJDCB(sqb, djdcb, rfNum);
//		}
//		sqbService.insertSQB(sqb);

        SQB sqb = new SQB();
        String qsxz = getQSXZ(project.getSqlx());
        if (qsxz.equals("")) {
            qsxz = getQSXZ(project.getQsxz());
        }
        String rf1 = "";
        if (project.getQsxz().equals("GY")) {
            rf1 = "使用权人";
        } else if (project.getQsxz().equals("JY")) {
            rf1 = "使用权人";
        } else if (project.getQsxz().equals("JU")) {
            rf1 = "所有权人";
        }
        sqb.setProjectId(project.getProjectId());
        sqb.setRf1(rf1);
        sqb.setSqsbh(bhService.getSQBBH());
        //System.out.println(project.getProjectId());
        sqb.setBsm(bsm);
        //System.out.println(bsm+"=========bsm");
        sqb.setSqlx(project.getSqlx());
        sqb.setDjh(project.getDjh());
        sqb.setZl(project.getTdzl());
        sqb.setDwdm(userDwdm);
        sqb.setQsxz(qsxz);
        //sqb.setSjr(userName);
        //sqb.setSjrq(Calendar.getInstance().getTime());
        sqb.setRmzf(CommonUtil.getXZQ().getXzqName());
        sqb.setRf1_dwmc(project.getQlr());
        sqb.setRf1_sfzmnum(sfzmNum);
        sqb.setRf1_txdz(address);
        sqb.setSyqlx(getSyqlx(project.getSqlx()));
        //申请表读取卖方信息
        sqb.setRf2_dwmc(crf);
        sqb.setRf2_sfzmnum(rf2_sfzmnum);
        sqb.setRf2_sfzmtype(rf2_sfzmtype);
        sqb.setRf2_dwxz(rf2_dwxz);
        sqb.setRf2_dzyj(rf2_dzyj);
        sqb.setRf2_fddbr(rf2_fddbr);
        sqb.setRf2_lxdh(rf2_lxdh);
        sqb.setRf2_lxr(rf2_lxr);
        sqb.setRf2_txdz(rf2_txdz);
        sqb.setRf2_yb(rf2_yb);
        sqb.setRf2_dljgmc(rf2_dljgmc);
        sqb.setRf2_dllxdh(rf2_dllxdh);
        sqb.setRf2_dlrxm(rf2_dlrxm);
        sqb.setRf2_dlrzsh(rf2_dlrzsh);
        ISQBService sqbService = (ISQBService) Container.getBean("sqbService");
        if (qsxz.equals("集体土地所有权")) {
            if (project.getSqlx().equals("集体土地所有权按村初始登记")) {
                ISyqfzService syqfzService = (ISyqfzService) Container.getBean("syqfzService");
                Double zdmj = syqfzService.statZmj(project.getDjh());
                if (zdmj != null) sqb.setZdmj(zdmj.toString());
            } else {
                if (project.getDjh() != null && !project.getDjh().equals("")) {
                    QSZD_DJDCB djdcb = new QSZD_DJDCB();
                    if (project.getDjh() != null && !project.getDjh().equals("")) {
                        djdcb.setDjh(project.getDjh());
                        IQSZD_DJDCBService qszddcb_Service = (IQSZD_DJDCBService) Container.getBean("qszd_DjdcbService");
                        djdcb = qszddcb_Service.selectDjdcb(djdcb);
                    }
                    sqbService.readSYQDCB(sqb, djdcb, rfNum);
                }
            }
            sqb.setDw("公顷、万元");
        } else {
            ZD_DJDCB djdcb = new ZD_DJDCB();
            if (project.getDjh() != null && !project.getDjh().equals("")) {
                djdcb.setDjh(project.getDjh());
                IZD_DJDCBService djdcbService = (IZD_DJDCBService) Container.getBean("zdDjdcbService");
                djdcb = djdcbService.selectDjdcb(djdcb);
            }
            sqb = sqbService.readDJDCB(sqb, djdcb, rfNum);
        }
        sqbService.insertSQB(sqb);

    }

    //遗失补发
    public void SaveYSBF() {
        String rf1 = "";
        String qsxz = getQSXZ(project.getSqlx());
        if (project.getSqlx().equals("集体土地所有证换发证") || project.getSqlx().equals("集体土地所有证遗失补发登记")) {
            rf1 = "所有权人";
        } else if (project.getSqlx().equals("他项权利证明书遗失补发登记")) {
            SaveBGDJ();

            return;
        } else {
            rf1 = "使用权人";
        }

        SQB sqb = new SQB();
        sqb.setProjectId(project.getProjectId());
        sqb.setBsm(bsm);
        sqb.setSqsbh(bhService.getSQBBH());
        sqb.setSqlx(project.getSqlx());
        sqb.setDjh(project.getDjh());
        sqb.setZl(project.getTdzl());
        sqb.setDwdm(userDwdm);
        sqb.setQsxz(qsxz);
        //sqb.setSjr(userName);
        //sqb.setSjrq(Calendar.getInstance().getTime());
        sqb.setRmzf(CommonUtil.getXZQ().getXzqName());
        sqb.setZtdzh(project.getTdzh());
        sqb.setSyqlx(getSyqlx(project.getSqlx()));
        sqb.setRf1_dwmc(project.getQlr());
        sqb.setRf1(rf1);
        sqb.setRf1_sfzmnum(sfzmNum);
        sqb.setRf1_txdz(address);
        //看老证是否存在审批表


        ISPBService spbService = (ISPBService) Container.getBean("spbService");
        SPB querySPB = new SPB();
        querySPB.setTdzh(project.getTdzh());
        SPB spb = new SPB();
        try {
            spb = spbService.getSPB(querySPB);
        } catch (Exception e) {
            // TODO: handle exception
            log.error(e.getMessage());
        }
        //
        IZD_DJDCBService zd_djdcbService = (IZD_DJDCBService) Container.getBean("zdDjdcbService");
        //System.out.println(spb.getZdmj()+"---spb.getZdmj()");
        if (spb != null && spb.getProjectId() != null) {
            //从老证的审批表中拷贝数据至申请表


            ISQBService sqbService = (ISQBService) Container.getBean("sqbService");
            if ((spb.getZdmj() == null || spb.getZdmj().equals("")) && project.getDjh() != null && !project.getDjh().equals("")) {
                //sqb.setZdmj(zd_djdcbService.getFzmj(project.getDjh()));
                Double zdmj = zd_djdcbService.getFzmj(project.getDjh());
                if (zdmj != null) sqb.setZdmj(zdmj.toString());
            }
            //sqbService.insertSQB(sqb, spb, rfNum);
            sqbService.readSPB(sqb, spb, "YSBF");
            sqbService.insertSQB(sqb);
        } else {
            String oldZslx = "";
            if (project.getQsxz().equals("GY")) {
                oldZslx = "GY";
            } else if (project.getQsxz().equals("JY")) {
                oldZslx = "JY";
            } else if (project.getQsxz().equals("JU")) {
                oldZslx = "JU";
            }
            if (project.getDjh() != null && !project.getDjh().equals("")) {
                //sqb.setZdmj(zd_djdcbService.getFzmj(project.getDjh()));
                Double zdmj = zd_djdcbService.getFzmj(project.getDjh());
                if (zdmj != null) sqb.setZdmj(zdmj.toString());
            }
            ISQBService sqbService = (ISQBService) Container.getBean("sqbService");
            if (oldZslx.equals("GY")) {
                //从国有证考数据


                IGytdsyzService gytdsyzService = (IGytdsyzService) Container.getBean("gyTdsyzService");
                GYTDSYZ gytdsyz = gytdsyzService.getGYTDSYZbyTdzh(project.getTdzh());
                //sqbService.insertSQB(sqb, gytdsyz, rfNum);
                sqbService.readGYTDSYZ(sqb, gytdsyz, 1);
                sqbService.insertSQB(sqb);
            } else if (oldZslx.equals("JY")) {
                //从集体证考数据

                IJttdsyzService jttdsyzService = (IJttdsyzService) Container.getBean("jtTdsyzService");
                JTTDSYZ jttdsyz = jttdsyzService.getJTTDSYZByTdzh(project.getTdzh());
                //sqbService.insertSQB(sqb, jttdsyz, rfNum);
                sqbService.readJTTDSYZ(sqb, jttdsyz, 1);
                sqbService.insertSQB(sqb);
            } else if (oldZslx.equals("JU")) {
                //从集有证考数据


                IJttdsuzService jttdsuzService = (IJttdsuzService) Container.getBean("jtTdsuzService");
                JTTDSUZ jttdsuz = jttdsuzService.getJTTDSUZByTdzh(project.getTdzh());
                //sqbService.insertSQB(sqb, jttdsuz, rfNum);
                sqbService.readJTTDSUZ(sqb, jttdsuz, 1);
                sqbService.insertSQB(sqb);
            } else if (oldZslx.equals("TX")) {
                //从他项证考数据


                ITxqlzmsService txqlzmsService = (ITxqlzmsService) Container.getBean("txqlzmsService");
                TXQLZMS txqlzms = txqlzmsService.getTXQLZMSByTdzh(project.getTdzh());
                //sqbService.insertSQB(sqb, txqlzms, rfNum);
                sqbService.readTXQLZMS(sqb, txqlzms, 2);
                sqbService.insertSQB(sqb);


            }
        }
        sqb_qlyg.setQsxz(qsxz);
        sqb_qlyg.setSqlx(project.getSqlx());
    }

    //变更登记
    public void SaveBGDJ() {
        //保存申请表(人方1单位名称，申请类型，使用权类型，权属性质，土地座落)
        String rf1 = "", rf2 = "";
        String qsxz = getQSXZ(project.getSqlx());
        if (qsxz.equals("")) {
            qsxz = getQSXZ(project.getQsxz());
        }
        if (project.getSqlx().equals("名称变更登记") || project.getSqlx().equals("地址变更登记") || project.getSqlx().equals("土地用途变更登记")) {
            rf1 = "使用权人";
            rf2 = "使用权人";
        } else if (project.getSqlx().equals("土地抵押权变更登记") || project.getSqlx().equals("土地租赁权变更登记")
                || project.getSqlx().equals("地役权变更登记") || project.getSqlx().equals("他项权利证明书遗失补发登记")) {
            rf1 = "抵押权人";
            rf2 = "抵押人";
        } else {
            rf1 = "权利受让人";
            rf2 = "权利转让人";
        }

        SQB sqb = new SQB();
        sqb.setProjectId(project.getProjectId());
        sqb.setBsm(bsm);
        sqb.setSqsbh(bhService.getSQBBH());
        sqb.setSqlx(project.getSqlx());
        sqb.setDjh(project.getDjh());
        sqb.setZl(project.getTdzl());
        sqb.setDwdm(userDwdm);
        sqb.setQsxz(qsxz);
        //sqb.setSjr(userName);
        //sqb.setSjrq(Calendar.getInstance().getTime());
        sqb.setRmzf(CommonUtil.getXZQ().getXzqName());
        sqb.setZtdzh(project.getTdzh());
        sqb.setSyqlx(getSyqlx(project.getSqlx()));
        sqb.setRf1_dwmc(project.getQlr());
        sqb.setRf1(rf1);
        sqb.setRf2(rf2);
        sqb.setRf1_sfzmnum(sfzmNum);
        sqb.setRf1_txdz(address);

        //申请表读取卖方信息
        if(project.getDjlx().equals("变更登记")){
            sqb.setRf2_dwmc(crf);
            sqb.setRf2_sfzmnum(rf2_sfzmnum);
            sqb.setRf2_sfzmtype(rf2_sfzmtype);
            sqb.setRf2_dwxz(rf2_dwxz);
            sqb.setRf2_dzyj(rf2_dzyj);
            sqb.setRf2_fddbr(rf2_fddbr);
            sqb.setRf2_lxdh(rf2_lxdh);
            sqb.setRf2_lxr(rf2_lxr);
            sqb.setRf2_txdz(rf2_txdz);
            sqb.setRf2_yb(rf2_yb);
            sqb.setRf2_dljgmc(rf2_dljgmc);
            sqb.setRf2_dllxdh(rf2_dllxdh);
            sqb.setRf2_dlrxm(rf2_dlrxm);
            sqb.setRf2_dlrzsh(rf2_dlrzsh);
        }
        //看老证是否存在审批表


        ISPBService spbService = (ISPBService) Container.getBean("spbService");
        SPB querySPB = new SPB();
        querySPB.setTdzh(project.getTdzh());
        SPB spb = new SPB();
        try {
            spb = spbService.getSPB(querySPB);
        } catch (Exception e) {
            // TODO: handle exception
            log.error(e.getMessage());
        }

        //
        IZD_DJDCBService zd_djdcbService = (IZD_DJDCBService) Container.getBean("zdDjdcbService");
        if (spb != null && spb.getProjectId() != null) {
            //从老证的审批表中拷贝数据至申请表


            ISQBService sqbService = (ISQBService) Container.getBean("sqbService");
            if ((spb.getZdmj() == null || spb.getZdmj().equals("")) && project.getDjh() != null && !project.getDjh().equals("")) {
                //sqb.setZdmj(zd_djdcbService.getFzmj(project.getDjh()));
                Double zdmj = zd_djdcbService.getFzmj(project.getDjh());
                if (zdmj != null) sqb.setZdmj(zdmj.toString());
            }
            if (project.getSqlx().equals("土地抵押权变更登记") || project.getSqlx().equals("土地租赁权变更登记")
                    || project.getSqlx().equals("地役权变更登记") || project.getSqlx().equals("他项权利证明书遗失补发登记")) {
                sqbService.readSPB(sqb, spb, "TXBGDJ");
            } else {
                sqbService.readSPB(sqb, spb, "BGDJ");
            }
            sqbService.insertSQB(sqb);
        } else {
            String oldZslx = "";
            if (project.getQsxz().equals("GY")) {
                if (project.getSqlx().equals("土地抵押权变更登记") || project.getSqlx().equals("土地租赁权变更登记")
                        || project.getSqlx().equals("地役权变更登记") || project.getSqlx().equals("他项权利证明书遗失补发登记")) {
                    oldZslx = "TX";
                } else {
                    oldZslx = "GY";
                }
            } else if (project.getQsxz().equals("JY")) {
                if (project.getSqlx().equals("土地抵押权变更登记") || project.getSqlx().equals("土地租赁权变更登记")
                        || project.getSqlx().equals("地役权变更登记") || project.getSqlx().equals("他项权利证明书遗失补发登记")) {
                    oldZslx = "TX";
                } else {
                    oldZslx = "JY";
                }
            } else if (project.getQsxz().equals("JU")) {
                oldZslx = "JU";
            }
            if (project.getDjh() != null && !project.getDjh().equals("")) {
                //sqb.setZdmj(zd_djdcbService.getFzmj(project.getDjh()));
                Double zdmj = zd_djdcbService.getFzmj(project.getDjh());
                if (zdmj != null) sqb.setZdmj(zdmj.toString());
            }
            ISQBService sqbService = (ISQBService) Container.getBean("sqbService");
            if (oldZslx.equals("GY")) {
                //从国有证考数据


                IGytdsyzService gytdsyzService = (IGytdsyzService) Container.getBean("gyTdsyzService");
                GYTDSYZ gytdsyz = gytdsyzService.getGYTDSYZbyTdzh(project.getTdzh());
                //sqbService.insertSQB(sqb, gytdsyz, rfNum);
                sqbService.readGYTDSYZ(sqb, gytdsyz, 2);
                sqbService.insertSQB(sqb);
            } else if (oldZslx.equals("JY")) {
                //从集体证考数据

                IJttdsyzService jttdsyzService = (IJttdsyzService) Container.getBean("jtTdsyzService");
                JTTDSYZ jttdsyz = jttdsyzService.getJTTDSYZByTdzh(project.getTdzh());
                //sqbService.insertSQB(sqb, jttdsyz, rfNum);
                sqbService.readJTTDSYZ(sqb, jttdsyz, 2);
                sqbService.insertSQB(sqb);
            } else if (oldZslx.equals("JU")) {
                //从集有证考数据


                IJttdsuzService jttdsuzService = (IJttdsuzService) Container.getBean("jtTdsuzService");
                JTTDSUZ jttdsuz = jttdsuzService.getJTTDSUZByTdzh(project.getTdzh());
                //sqbService.insertSQB(sqb, jttdsuz, rfNum);
                sqbService.readJTTDSUZ(sqb, jttdsuz, 2);
                sqbService.insertSQB(sqb);
            } else if (oldZslx.equals("TX")) {
                //从他项证考数据


                ITxqlzmsService txqlzmsService = (ITxqlzmsService) Container.getBean("txqlzmsService");
                TXQLZMS txqlzms = txqlzmsService.getTXQLZMSByTdzh(project.getTdzh());
                //sqbService.insertSQB(sqb, txqlzms, rfNum);
                sqbService.readTXQLZMS(sqb, txqlzms, 2);
                sqbService.insertSQB(sqb);
            }
        }
        sqb_qlyg.setQsxz(qsxz);
        sqb_qlyg.setSqlx(project.getSqlx());
    }

    //名称地址用途变更登记


    public void SaveMCBGDJ() {
        String rf1 = "";
        String qsxz = getQSXZ(project.getSqlx());
        if (qsxz.equals("")) qsxz = getQSXZ(project.getQsxz());
        rf1 = "使用权人";
        SQB sqb = new SQB();
        sqb.setProjectId(project.getProjectId());
        sqb.setBsm(bsm);
        sqb.setSqsbh(bhService.getSQBBH());
        sqb.setSqlx(project.getSqlx());
        sqb.setDjh(project.getDjh());
        sqb.setZl(project.getTdzl());
        sqb.setDwdm(userDwdm);
        sqb.setQsxz(qsxz);
        sqb.setRmzf(CommonUtil.getXZQ().getXzqName());
        sqb.setZtdzh(project.getTdzh());
        sqb.setSyqlx(getSyqlx(project.getSqlx()));
        sqb.setRf1_dwmc(project.getQlr());
        sqb.setRf1(rf1);
        sqb.setRf1_sfzmnum(sfzmNum);
        sqb.setRf1_txdz(address);
        //sqb.setRf2(rf2);
        //看老证是否存在审批表


        ISPBService spbService = (ISPBService) Container.getBean("spbService");
        SPB querySPB = new SPB();
        querySPB.setTdzh(project.getTdzh());
        SPB spb = new SPB();
        try {
            spb = spbService.getSPB(querySPB);
        } catch (Exception e) {
            // TODO: handle exception
            log.error(e.getMessage());
        }
        //
        IZD_DJDCBService zd_djdcbService = (IZD_DJDCBService) Container.getBean("zdDjdcbService");
        if (spb != null && spb.getProjectId() != null) {
            //从老证的审批表中拷贝数据至申请表


            ISQBService sqbService = (ISQBService) Container.getBean("sqbService");
            if ((spb.getZdmj() == null || spb.getZdmj().equals("")) && project.getDjh() != null && !project.getDjh().equals("")) {
                Double zdmj = zd_djdcbService.getFzmj(project.getDjh());
                if (zdmj != null) sqb.setZdmj(zdmj.toString());
            }
            sqbService.readSPB(sqb, spb, "MCBGDJ");
            sqbService.insertSQB(sqb);
        } else {
            String oldZslx = "";
            if (project.getQsxz().equals("GY")) {
                oldZslx = "GY";
            } else if (project.getQsxz().equals("JY")) {
                oldZslx = "JY";
            } else if (project.getQsxz().equals("JU")) {
                oldZslx = "JU";
            }
            if (project.getDjh() != null && !project.getDjh().equals("")) {
                //sqb.setZdmj(zd_djdcbService.getFzmj(project.getDjh()));
                Double zdmj = zd_djdcbService.getFzmj(project.getDjh());
                if (zdmj != null) sqb.setZdmj(zdmj.toString());
            }
            ISQBService sqbService = (ISQBService) Container.getBean("sqbService");
            if (oldZslx.equals("GY")) {
                //从国有证考数据


                IGytdsyzService gytdsyzService = (IGytdsyzService) Container.getBean("gyTdsyzService");
                GYTDSYZ gytdsyz = gytdsyzService.getGYTDSYZbyTdzh(project.getTdzh());
                //sqbService.insertSQB(sqb, gytdsyz, rfNum);
                sqbService.readGYTDSYZ(sqb, gytdsyz, 1);
                sqbService.insertSQB(sqb);
            } else if (oldZslx.equals("JY")) {
                //从集体证考数据

                IJttdsyzService jttdsyzService = (IJttdsyzService) Container.getBean("jtTdsyzService");
                JTTDSYZ jttdsyz = jttdsyzService.getJTTDSYZByTdzh(project.getTdzh());
                //sqbService.insertSQB(sqb, jttdsyz, rfNum);
                sqbService.readJTTDSYZ(sqb, jttdsyz, 1);
                sqbService.insertSQB(sqb);
            } else if (oldZslx.equals("JU")) {
                //从集有证考数据


                IJttdsuzService jttdsuzService = (IJttdsuzService) Container.getBean("jtTdsuzService");
                JTTDSUZ jttdsuz = jttdsuzService.getJTTDSUZByTdzh(project.getTdzh());
                //sqbService.insertSQB(sqb, jttdsuz, rfNum);
                sqbService.readJTTDSUZ(sqb, jttdsuz, 1);
                sqbService.insertSQB(sqb);
            }
        }
        sqb_qlyg.setQsxz(qsxz);
        sqb_qlyg.setSqlx(project.getSqlx());
    }

    //他项登记
    private void SaveTXDJ() {
        String txqllx = "";
        //String qlsx="第壹号";
        if (project.getSqlx().equals("土地使用权抵押权初始登记")) {
            txqllx = "抵押";

        } else if (project.getSqlx().equals("土地使用权出租权初始登记")) {
            txqllx = "出租";
        }
        String rf1 = "抵押权人", rf2 = "抵押人";
        //String qsxz = getQSXZ(project.getSqlx());
        String qsxz = project.getQsxz();
        if (qsxz.equals("JY")) {
            qsxz = "集体土地使用权";
        } else if (qsxz.equals("JU")) {
            qsxz = "集体土地所有权";
        } else {
            qsxz = "国有土地使用权";
        }
        if (project.getSqlx().equals("土地使用权抵押权初始登记")) {
            rf1 = "抵押权人";
            rf2 = "抵押人";
        } else if (project.getSqlx().equals("土地使用权地役权初始登记")) {
            rf1 = "需役地权利人";
            rf2 = "供役地权利人";
        }

        SQB sqb = new SQB();
        sqb.setProjectId(project.getProjectId());
        sqb.setBsm(bsm);
        sqb.setSqsbh(bhService.getSQBBH());
        sqb.setSqlx(project.getSqlx());
        sqb.setDjh(project.getDjh());
        sqb.setZl(project.getTdzl());
        sqb.setDwdm(userDwdm);
        sqb.setQsxz(qsxz);
        //sqb.setSjr(userName);
        //sqb.setSjrq(Calendar.getInstance().getTime());
        sqb.setRmzf(CommonUtil.getXZQ().getXzqName());
        sqb.setZtdzh(project.getTdzh());
        sqb.setSyqlx(getSyqlx(project.getSqlx()));
        sqb.setRf2_dwmc(project.getQlr());

        sqb.setRf1(rf1);
        sqb.setRf2(rf2);
        sqb.setTxqllx(txqllx);
        //sqb.setQlsx(qlsx);
        //看老证是否存在审批表


        ISPBService spbService = (ISPBService) Container.getBean("spbService");
        SPB querySPB = new SPB();
        querySPB.setTdzh(project.getTdzh());
        SPB spb = new SPB();
        try {
            spb = spbService.getSPB(querySPB);
        } catch (Exception e) {
            // TODO: handle exception
            log.error(e.getMessage());
        }

        //
        IZD_DJDCBService zd_djdcbService = (IZD_DJDCBService) Container.getBean("zdDjdcbService");
        //System.out.println(spb.getZdmj()+"---spb.getZdmj()");
        if (spb != null && spb.getProjectId() != null) {
            //从老证的审批表中拷贝数据至申请表


            ISQBService sqbService = (ISQBService) Container.getBean("sqbService");
            if ((spb.getZdmj() == null || spb.getZdmj().equals("")) && project.getDjh() != null && !project.getDjh().equals("")) {
                Double zdmj = zd_djdcbService.getFzmj(project.getDjh());
                if (zdmj != null) sqb.setZdmj(zdmj.toString());
            }
            //sqbService.insertSQB(sqb, spb, rfNum);
            sqbService.readSPB(sqb, spb, "TXDJ");
            sqbService.insertSQB(sqb);
        } else {
            if (project.getDjh() != null && !project.getDjh().equals("")) {
                Double zdmj = zd_djdcbService.getFzmj(project.getDjh());
                if (zdmj != null) sqb.setZdmj(zdmj.toString());
            }
            String oldZslx = project.getQsxz();
            ISQBService sqbService = (ISQBService) Container.getBean("sqbService");
            if (oldZslx.equals("GY")) {
                //从国有证考数据


                IGytdsyzService gytdsyzService = (IGytdsyzService) Container.getBean("gyTdsyzService");
                GYTDSYZ gytdsyz = gytdsyzService.getGYTDSYZbyTdzh(project.getTdzh());
                //sqbService.insertSQB(sqb, gytdsyz, rfNum);
                sqbService.readGYTDSYZ(sqb, gytdsyz, 2);
                sqbService.insertSQB(sqb);
            } else if (oldZslx.equals("JY")) {
                //从集体证考数据


                IJttdsyzService jttdsyzService = (IJttdsyzService) Container.getBean("jtTdsyzService");
                JTTDSYZ jttdsyz = jttdsyzService.getJTTDSYZByTdzh(project.getTdzh());
                //sqbService.insertSQB(sqb, jttdsyz, rfNum);
                sqbService.readJTTDSYZ(sqb, jttdsyz, 2);
                sqbService.insertSQB(sqb);
            }
        }
        sqb_qlyg.setQsxz(qsxz);
        sqb_qlyg.setSqlx(project.getSqlx());
    }

    //分割登记
    public void SaveFGDJ() {
        IFGINFOService fginfoService = (IFGINFOService) Container.getBean("fgInfoService");
        fginfoService.insertFGINFO(project);
        SQB sqb = new SQB();
        String qsxz = getQSXZ(project.getSqlx());
        String rf1 = "";
        if (project.getQsxz().equals("GY")) {
            rf1 = "使用权人";
        } else if (project.getQsxz().equals("JY")) {
            rf1 = "使用权人";
        } else if (project.getQsxz().equals("JU")) {
            rf1 = "所有权人";
        }
        sqb.setProjectId(project.getProjectId());
        sqb.setRf1(rf1);
        sqb.setSqsbh(bhService.getSQBBH());
        //System.out.println(project.getProjectId());
        sqb.setBsm(bsm);
        //System.out.println(bsm+"=========bsm");
        sqb.setSqlx(project.getSqlx());
        sqb.setDjh(project.getDjh());
        sqb.setZl(project.getTdzl());
        sqb.setDwdm(userDwdm);
        sqb.setQsxz(qsxz);
        //sqb.setSjr(userName);
        //sqb.setSjrq(Calendar.getInstance().getTime());
        sqb.setRmzf(CommonUtil.getXZQ().getXzqName());
        sqb.setRf1_dwmc(project.getQlr());
        sqb.setSyqlx(getSyqlx(project.getSqlx()));
        //zdd 2010-1-26 BUG-0002072 人方信息以原证书对应的审批表为准。


        ISQBService sqbService = (ISQBService) Container.getBean("sqbService");
        IGytdsyzService gytdsyzService = (IGytdsyzService) Container.getBean("gyTdsyzService");
        GYTDSYZ gytdsyz = gytdsyzService.getGYTDSYZbyTdzh(project.getTdzh());
        ISPBService spbService = (ISPBService) Container.getBean("spbService");
        SPB spb = new SPB();
        if (gytdsyz != null) spb = spbService.getSPB(gytdsyz.getProjectId());
        if (spb != null) {
            sqb.setRf1_dwxz(spb.getRf1_dwxz());
            sqb.setRf1_dzyj(spb.getRf1_dzyj());
            sqb.setRf1_fddbr(spb.getRf1_fddbr());
            sqb.setRf1_lxdh(spb.getRf1_lxdh());
            sqb.setRf1_lxr(spb.getRf1_lxr());
            sqb.setRf1_sfzmnum(spb.getRf1_sfzmnum());
            sqb.setRf1_sfzmtype(spb.getRf1_sfzmtype());
            sqb.setRf1_txdz(spb.getRf1_txdz());
            sqb.setRf1_yb(spb.getRf1_yb());
            sqb.setSyqlx(spb.getSyqlx());
        } else {
            ZD_DJDCB djdcb = new ZD_DJDCB();
            if (project.getDjh() != null && !project.getDjh().equals("")) {
                djdcb.setDjh(project.getDjh());
                //djdcb.setQlrmc(project.getQlr());
                IZD_DJDCBService djdcbService = (IZD_DJDCBService) Container.getBean("zdDjdcbService");
                djdcb = djdcbService.selectDjdcb(djdcb);
            }
            //sqbService.insertSQB(sqb, djdcb, rfNum);
            sqb = sqbService.readDJDCB(sqb, djdcb, 1);
        }
        sqbService.insertSQB(sqb);
        sqb_qlyg.setQsxz(qsxz);
        sqb_qlyg.setSqlx(project.getSqlx());
    }

    //分割证换发证
    public void SaveFGZHFZ() {
        /**
         * 用途：新建分割证换发证任务时创建 sqb内容
         * 参数：


         * 修改人：刘仲阳


         * 修改时间：2008-12-26
         * 说明：现可以支持同一地号对应的多本分割证同时换发证


         * */
        //保存申请表(人方1单位名称，申请类型，使用权类型，权属性质，土地座落)
        SQB sqb = new SQB();
        String qsxz = "国有土地使用权";
        sqb.setSqsbh(bhService.getSQBBH());
        sqb.setProjectId(project.getProjectId());
        sqb.setBsm(bsm);
        sqb.setSqlx(project.getSqlx());
        sqb.setDjh(project.getDjh());
        sqb.setZl(project.getTdzl());
        sqb.setDwdm(userDwdm);
        sqb.setQsxz(qsxz);
        sqb.setRf1("权利受让人");
        sqb.setRf2("权利转让人");
        //sqb.setSjr(userName);
        //sqb.setSjrq(Calendar.getInstance().getTime());
        sqb.setRmzf(CommonUtil.getXZQ().getXzqName());
        sqb.setRf1_dwmc(project.getQlr());
        sqb.setRf1_sfzmtype("居民身份证");
        sqb.setZtdzh(project.getTdzh());
        sqb.setRf1_sfzmnum(sfzmNum);
        sqb.setRf1_txdz(address);
        FGZ fgz = new FGZ();
        //tdzh,djh 可能是一个 tdzh[] djh[]
        String[] arrayTdzh = project.getTdzh().split(",");
        String[] arrayDjh = project.getDjh().split(",");
        Double zdmj = 0.00;
        double ftmj = 0.00;

        ISQBService sqbService = (ISQBService) Container.getBean("sqbService");
        IFGINFOService fginfoService = (IFGINFOService) Container.getBean("fgInfoService");
        FGINFO fginfo = new FGINFO();
        //根据每个证号 累加 信息
        for (int i = 0; i < arrayTdzh.length; i++) {
            FGZ paramFgz = new FGZ();
            paramFgz.setFgzh(arrayTdzh[i]);
            IFGZService fgzService = (IFGZService) Container.getBean("fgzService");
            fgz = fgzService.getFGZ(paramFgz);
            //累加yt,syqlx,zzrq
            if (fgz != null) {
                if (fgz.getYt() != null && !fgz.getYt().equals(""))
                    if (sqb.getYt() != null && !sqb.getYt().equals("") && !sqb.getYt().contains(fgz.getYt())) {
                        sqb.setYt(sqb.getYt() + "," + fgz.getYt());
                    } else {
                        sqb.setYt(fgz.getYt());
                    }
            }
            if (fgz != null) {
                if (fgz.getSyqlx() != null && !fgz.getSyqlx().equals(""))
                    if (sqb.getSyqlx() != null && !sqb.getSyqlx().equals("") && !sqb.getSyqlx().contains(fgz.getSyqlx())) {
                        sqb.setSyqlx(sqb.getSyqlx() + "," + fgz.getSyqlx());
                    } else {
                        sqb.setSyqlx(fgz.getSyqlx());
                    }
            }
            if (fgz != null) {
                if (fgz.getZzrq() != null && !fgz.getZzrq().equals(""))
                    if (sqb.getZzrq() != null && !sqb.getZzrq().equals("") && !sqb.getZzrq().contains(fgz.getZzrq())) {
                        sqb.setZzrq(sqb.getZzrq() + "," + fgz.getZzrq());
                    } else {
                        sqb.setZzrq(fgz.getZzrq());
                    }
            }
            if (fgz != null) {
                //累加ftmj
                if (fgz.getFtmj() != null)
                    ftmj += fgz.getFtmj();
            }

        }

        sqb.setSyqmj(ftmj);
        sqb.setFtmj(ftmj);
        IZD_DJDCBService djdcbService = (IZD_DJDCBService) Container.getBean("zdDjdcbService");
        //根据每个地号 累加 信息
        if (arrayDjh.length > 0) {
            ZD_DJDCB paramDcb = new ZD_DJDCB();
            paramDcb.setDjh(arrayDjh[0]);
            List dcbList = djdcbService.getDjdcb(paramDcb);
            if (dcbList.size() > 0) {
                ZD_DJDCB djdcb = (ZD_DJDCB) dcbList.get(0);
                zdmj = djdcb.getFzmj();
            }
        }
        if (zdmj != null) sqb.setZdmj(zdmj.toString());
//		for (int i = 0 ; i < arrayDjh.length ; i++) {
//			ZD_DJDCB paramDcb = new ZD_DJDCB();
//			paramDcb.setDjh(arrayDjh[i]);
//			List dcbList = djdcbService.getDjdcb(paramDcb);
//			if (dcbList.size()>0){
//				ZD_DJDCB djdcb = (ZD_DJDCB)dcbList.get(0);
//				//sqb.setZdmj(djdcb.getFzmj());
//				//sqb.setTh(djdcb.getSztfh());
//				zdmj += djdcb.getFzmj();
//				if (djdcb.getSztfh() != null && !djdcb.getSztfh().equals(""))
//					if (sqb.getTh() != null && !sqb.getTh().equals("")){
//						sqb.setTh(sqb.getTh() + "," + djdcb.getSztfh());
//					} else {
//						sqb.setTh(djdcb.getSztfh());
//					}
//			
//			}
//		}	
        fginfo.setProjectId(fgz.getProjectId());
        fginfo = fginfoService.getFGINFO(fginfo);

        sqb.setRf2_dwmc(fgz.getQlr());
        if (fginfo != null) {
            sqb.setRf2_fddbr(fginfo.getFddbr());
            sqb.setRf2_dwxz(fginfo.getDwxz());
            sqb.setRf2_txdz(fginfo.getTxdz());
            sqb.setRf2_lxdh(fginfo.getLxdh());
        }

        sqbService.insertSQB(sqb);
        sqb_qlyg.setQsxz(qsxz);
        sqb_qlyg.setSqlx(project.getSqlx());
    }

    //注销登记
    public void SaveZXDJ() {
        SQB sqb = new SQB();
        sqb.setProjectId(project.getProjectId());
        //System.out.println(project.getProjectId());
        sqb.setSqlx(project.getSqlx());
        sqb.setDjh(project.getDjh());
        sqb.setZl(project.getTdzl());
        sqb.setDwdm(userDwdm);
        sqb.setBsm(bsm);
        String qsxz = "";
        if (project.getQsxz().equals("GY")) {
            qsxz = "国有土地使用权";
        } else if (project.getQsxz().equals("JY")) {
            qsxz = "集体土地使用权";
        } else if (project.getQsxz().equals("JU")) {
            qsxz = "集体土地所有权";
        }
        sqb.setQsxz(qsxz);
        //sqb.setSjr(userName);
        //sqb.setSjrq(Calendar.getInstance().getTime());
        sqb.setRmzf(CommonUtil.getXZQ().getXzqName());
        sqb.setZtdzh(project.getTdzh());
        //sqb.setSqsbh(bhService.getZXBH());
        sqb.setSqsbh(bhService.getSQBBH());
        //看老证是否存在审批表


        ISPBService spbService = (ISPBService) Container.getBean("spbService");
        SPB querySPB = new SPB();
        querySPB.setTdzh(project.getTdzh());
        SPB spb = new SPB();
        try {
            spb = spbService.getSPB(querySPB);
        } catch (Exception e) {
            // TODO: handle exception
            log.error(e.getMessage());
        }
        if (spb != null && spb.getProjectId() != null) {
            //从老证的审批表中拷贝数据至申请表


            ISQBService sqbService = (ISQBService) Container.getBean("sqbService");
            Integer rfNum = 1;
            if (project.getSqlx().equals("他项权利证明书注销登记")) {
                rfNum = 4;
            }
            //sqbService.insertSQB(sqb, spb, rfNum);
            sqbService.readSPB(sqb, spb, "ZXDJ");
            sqbService.insertSQB(sqb);
        } else {
            String oldZslx = "";
            if (project.getQsxz().equals("GY")) {
                if (project.getSqlx().equals("他项权利证明书注销登记")) {
                    oldZslx = "TX";
                } else {
                    oldZslx = "GY";
                }
            } else if (project.getQsxz().equals("JY")) {
                if (project.getSqlx().equals("他项权利证明书注销登记")) {
                    oldZslx = "TX";
                } else {
                    oldZslx = "JY";
                }
            } else if (project.getQsxz().equals("JU")) {
                oldZslx = "JU";
            }
            ISQBService sqbService = (ISQBService) Container.getBean("sqbService");
            if (oldZslx.equals("GY")) {
                //从国有证考数据


                IGytdsyzService gytdsyzService = (IGytdsyzService) Container.getBean("gyTdsyzService");
                GYTDSYZ gytdsyz = gytdsyzService.getGYTDSYZbyTdzh(project.getTdzh());
                //sqbService.insertSQB(sqb, gytdsyz, 1);
                sqbService.readGYTDSYZ(sqb, gytdsyz, 1);
                sqbService.insertSQB(sqb);
            } else if (oldZslx.equals("JY")) {
                //从集体证考数据
                IJttdsyzService jttdsyzService = (IJttdsyzService) Container.getBean("jtTdsyzService");
                JTTDSYZ jttdsyz = jttdsyzService.getJTTDSYZByTdzh(project.getTdzh());
                //sqbService.insertSQB(sqb, jttdsyz, 1);
                sqbService.readJTTDSYZ(sqb, jttdsyz, 1);
                sqbService.insertSQB(sqb);
            } else if (oldZslx.equals("JU")) {
                //从集有证考数据


                IJttdsuzService jttdsuzService = (IJttdsuzService) Container.getBean("jtTdsuzService");
                JTTDSUZ jttdsuz = jttdsuzService.getJTTDSUZByTdzh(project.getTdzh());
                //sqbService.insertSQB(sqb, jttdsuz, 1);
                sqbService.readJTTDSUZ(sqb, jttdsuz, 1);
                sqbService.insertSQB(sqb);
            } else if (oldZslx.equals("TX")) {
                //从他项证考数据


                ITxqlzmsService txqlzmsService = (ITxqlzmsService) Container.getBean("txqlzmsService");
                TXQLZMS txqlzms = txqlzmsService.getTXQLZMSByTdzh(project.getTdzh());
                //sqbService.insertSQB(sqb, txqlzms, 4);
                sqbService.readTXQLZMS(sqb, txqlzms, 2);
                sqb.setRf1("抵押权人");
                sqb.setRf2("抵押人");
                if (txqlzms != null) {
                    sqb.setRf1_dwmc(txqlzms.getQlr());
                }

                sqbService.insertSQB(sqb);
            }
        }
        sqb_qlyg.setQsxz(qsxz);
        sqb_qlyg.setSqlx(project.getSqlx());
    }

    private void SaveZXYYDJ() {
        IYYDJService yydjService = (IYYDJService) Container.getBean("yydjService");
        YYDJ yydj = yydjService.getYYDJ(project.getTdzh());
        ZXYY zxyy = new ZXYY();
        IZXYYService zxyyService = (IZXYYService) Container.getBean("zxyyService");
        zxyy.setProjectId(project.getProjectId());
        if (yydj != null) {
            zxyy.setYyProjectId(yydj.getProjectId());
        }
        zxyy.setShr(project.getCreater());
        zxyy.setZxrq(CommonUtil.getCurrStrDate());
        zxyyService.insertZXYY(zxyy);
        String qsxz = getQSXZ(project.getSqlx());
        if (qsxz.equals("")) {
            qsxz = getQSXZ(project.getQsxz());
        }
        sqb_qlyg.setQsxz(qsxz);
        sqb_qlyg.setSqlx(project.getSqlx());
    }

    //查封登记
    public void SaveCFDJ() {
        if(project.getSqlx().equals("轮候查封")) {
            ICFService cfService = (ICFService) Container.getBean("cfService");
            CF cf = cfService.getCFByProjectId(project.getTdzh());
            CF lhcf = new CF();
            lhcf.setDjh(cf.getDjh());
            lhcf.setTdzh(cf.getTdzh());
            lhcf.setZl(cf.getZl());
            lhcf.setBzxr(cf.getBzxr());
            lhcf.setCflx(cf.getCflx());
            lhcf.setIsjf(2);
            lhcf.setDwdm(userDwdm);
            lhcf.setCfmj(cf.getCfmj());
            lhcf.setProjectId(project.getProjectId());
            lhcf.setYcfprojectId(cf.getProjectId());
            cfService.insertCF(lhcf);
        }else if(isXCF!=null){
             //进行续封
            CF cfParam = new CF();
            cfParam.setDjh(project.getDjh());
            cfParam.setTdzh(project.getTdzh());
            cfParam.setIsjf(0);
            ICFService cfService = (ICFService) Container.getBean("cfService");
            List<CF> ycfList = cfService.getCF(cfParam);
            CF ycf=null;
            if(ycfList.size()>0) {
                ycf= ycfList.get(0);
            }
            if(ycf!=null){
                CF xf = new CF();
                xf.setDjh(ycf.getDjh());
                xf.setTdzh(ycf.getTdzh());
                xf.setZl(ycf.getZl());
                xf.setZxsqr(ycf.getZxsqr());
                xf.setBzxr(ycf.getBzxr());
                xf.setCfmj(ycf.getCfmj());
                xf.setProjectId(project.getProjectId());
                xf.setCflx(project.getSqlx());
                xf.setDwdm(userDwdm);
                xf.setYcfprojectId(ycf.getProjectId());
                xf.setIsjf(3);
                xf.setZxwh(ycf.getZxwh());
                xf.setCddw(ycf.getCddw());
                cfService.insertCF(xf);
            }
        } else{
            CF cf = new CF();
            cf.setProjectId(project.getProjectId());
            cf.setDjh(project.getDjh());
            cf.setTdzh(project.getTdzh());
            cf.setZl(project.getTdzl());
            cf.setBzxr(project.getQlr());
            cf.setCflx(project.getSqlx());
            cf.setIsjf(0);
            cf.setDwdm(userDwdm);
            String cfmj = "";
            if (project.getSqlx().equals("按证查封")) {
                IZSService zsService = (IZSService) Container.getBean("zsService");
                if (project.getQsxz().equals("GY")) {
                    GYTDSYZ gytdsyz = (GYTDSYZ) zsService.getZSByTdzh(project.getTdzh());
                    if (gytdsyz != null)
                        if (gytdsyz.getSyqmj() != null) {
                            cfmj = gytdsyz.getSyqmj().toString();
                        }
                } else if (project.getQsxz().equals("JY")) {
                    JTTDSYZ jttdsyz = (JTTDSYZ) zsService.getZSByTdzh(project.getTdzh());
                    if (jttdsyz != null) cfmj = jttdsyz.getSyqmj().toString();
                } else if (project.getQsxz().equals("JU")) {
                    JTTDSUZ jttdsuz = (JTTDSUZ) zsService.getZSByTdzh(project.getTdzh());
                    if (jttdsuz != null) cfmj = jttdsuz.getTdzmj().toString();
                }
            } else if (project.getSqlx().equals("按宗查封") || project.getSqlx().equals("预查封")) {
                IZD_DJDCBService djdcbService = (IZD_DJDCBService) Container.getBean("zdDjdcbService");
                ZD_DJDCB dcb = new ZD_DJDCB();
                List dcbList = null;
                if (project.getDjh() != null && !project.getDjh().equals("")) {

                    dcb.setDjh(project.getDjh());

                    try {
                        dcbList = djdcbService.getDjdcb(dcb);
                    } catch (Exception e) {
                        // TODO: handle exception
                    }
                }
                if (dcbList != null && dcbList.size() > 0) {
                    dcb = (ZD_DJDCB) dcbList.get(0);
                    cfmj = dcb.getFzmj().toString();
                }
            }
            cf.setCfmj(cfmj);
            ICFService cfService = (ICFService) Container.getBean("cfService");
            cfService.insertCF(cf);
        }
        String qsxz = getQSXZ(project.getSqlx());
        if (qsxz.equals("")) {
            qsxz = getQSXZ(project.getQsxz());
        }

        sqb_qlyg.setQsxz(qsxz);
        sqb_qlyg.setSqlx(project.getSqlx());
    }

    //轮候查封登记
    public void SaveLHCFDJ() {
        //projectid, cfprojectid, jfyy, jfr, jfrq
        //新增页面将解封赋值给project.tdzh
        ICFService cfService = (ICFService) Container.getBean("cfService");
        CF cf = cfService.getCFByProjectId(project.getTdzh());
        CF lhcf = new CF();
        lhcf.setDjh(cf.getDjh());
        lhcf.setTdzh(cf.getTdzh());
        lhcf.setZl(cf.getZl());
        lhcf.setBzxr(cf.getBzxr());
        lhcf.setCflx(cf.getCflx());
        lhcf.setIsjf(2);
        lhcf.setDwdm(userDwdm);
        lhcf.setCfmj(cf.getCfmj());
        lhcf.setProjectId(project.getProjectId());
        lhcf.setYcfprojectId(cf.getProjectId());
        cfService.insertCF(lhcf);

        String qsxz = getQSXZ(project.getSqlx());
        if (qsxz.equals("")) {
            qsxz = getQSXZ(project.getQsxz());
        }
        sqb_qlyg.setQsxz(qsxz);
        sqb_qlyg.setSqlx(project.getSqlx());
    }

    //解封登记
    public void SaveJFDJ() {
        //projectid, cfprojectid, jfyy, jfr, jfrq
        //新增页面将解封赋值给project.tdzh
        ICFService cfService = (ICFService) Container.getBean("cfService");
        CF cf = cfService.getCFByProjectId(project.getTdzh());
        JF jf = new JF();
        IJFService jfService = (IJFService) Container.getBean("jfService");
        jf.setProjectId(project.getProjectId());
        if (cf != null) {
            jf.setCfProjectId(cf.getProjectId());
        }
        jf.setJfr(project.getCreater());
        jf.setJfrq(CommonUtil.getCurrStrDate());
        if(isjfAllLHCF!=null)   {
            jf.setIsjfAllLHCF(isjfAllLHCF);
        }
        jfService.insertJF(jf);
        String qsxz = getQSXZ(project.getSqlx());
        if (qsxz.equals("")) {
            qsxz = getQSXZ(project.getQsxz());
        }
        sqb_qlyg.setQsxz(qsxz);
        sqb_qlyg.setSqlx(project.getSqlx());
    }
    //预告登记_商品房预售预告登记


    public void SaveYGDJ_YSSPF() {
        String rf1 = "预告登记申请人";
        String rf2 = "预告登记义务人";
        SQB sqb = new SQB();
        String qsxz = getQSXZ(project.getSqlx());
        if (qsxz.equals("")) {
            qsxz = getQSXZ(project.getQsxz());
        }
        sqb.setQsxz(qsxz);
        sqb.setProjectId(project.getProjectId());
        sqb.setBsm(bsm);
        sqb.setSqsbh(bhService.getSQBBH());
        sqb.setSqlx(project.getSqlx());
        sqb.setDjh(project.getDjh());
        sqb.setZl(project.getTdzl());
        sqb.setZtdzh(project.getTdzh());
        sqb.setDwdm(userDwdm);
        sqb.setRmzf(CommonUtil.getXZQ().getXzqName());
        sqb.setRf1_dwmc(project.getQlr());
        sqb.setRf1(rf1);
        sqb.setRf2(rf2);

        ISQBService sqbService = (ISQBService) Container.getBean("sqbService");
        IFGZService fgzService = (IFGZService) Container.getBean("fgzService");
        FGZ fgz = new FGZ();
        try {
            fgz = fgzService.getFGZByFgzh(project.getTdzh());
        } catch (Exception e) {
            log.error(e.getMessage());
        }
        if (fgz != null && fgz.getFgzid() != null) {
            String fgzProid = fgz.getProjectId();
            IFGINFOService fginfoService = (IFGINFOService) Container
                    .getBean("fgInfoService");
            FGINFO fginfo = new FGINFO();
            try {
                fginfo = fginfoService.getFGINFO(fgzProid);
            } catch (Exception e) {
                // TODO: handle exception
                log.error(e.getMessage());
            }
            if (fginfo != null && fginfo.getProjectId() != null) {
                sqbService.readFGZ(sqb, fgz, fginfo);
            }
        }
        sqbService.insertSQB(sqb);
        sqb_qlyg.setQsxz(qsxz);
        sqb_qlyg.setSqlx(project.getSqlx());
        return;
    }

    //预告登记
    public void SaveYGDJ() {
        if (!project.getSqlx().equals("预告登记")) {
            SaveYGDJ_YSSPF();
            return;
        } else {
            String rf1 = "预告登记申请人";
            String rf2 = "预告登记义务人";
            SQB sqb = new SQB();
            sqb.setProjectId(project.getProjectId());
            sqb.setBsm(bsm);
            sqb.setSqsbh(bhService.getSQBBH());
            sqb.setSqlx(project.getSqlx());
            sqb.setDjh(project.getDjh());
            sqb.setZl(project.getTdzl());
            sqb.setZtdzh(project.getTdzh());
            sqb.setDwdm(userDwdm);
            sqb.setRmzf(CommonUtil.getXZQ().getXzqName());
            sqb.setRf1_dwmc(project.getQlr());
            sqb.setRf1_sfzmnum(sfzmNum);
            sqb.setRf1_txdz(address);
            sqb.setRf1(rf1);
            sqb.setRf2(rf2);

            ISQBService sqbService = (ISQBService) Container.getBean("sqbService");
            ISPBService spbService = (ISPBService) Container.getBean("spbService");
            SPB querySPB = new SPB();
            querySPB.setTdzh(project.getTdzh());
            SPB spb = new SPB();
            try {
                spb = spbService.getSPB(querySPB);
            } catch (Exception e) {
                // TODO: handle exception
                log.error(e.getMessage());
            }

            if (spb != null && spb.getProjectId() != null) {
                sqbService.readSPB(sqb, spb, "BGDJ");
                sqbService.insertSQB(sqb);
            } else {
                if (project.getQsxz().equals("GY")) {
                    //从国有证考数据


                    IGytdsyzService gytdsyzService = (IGytdsyzService) Container.getBean("gyTdsyzService");
                    if (project.getTdzh() != null && !project.getTdzh().equals("")) {
                        GYTDSYZ gytdsyz = gytdsyzService.getGYTDSYZbyTdzh(project.getTdzh());
                        sqbService.readGYTDSYZ(sqb, gytdsyz, 2);
                    }
                    sqb.setQsxz("国有土地使用权");
                    sqbService.insertSQB(sqb);
                } else if (project.getQsxz().equals("JY")) {
                    //从集体证考数据

                    IJttdsyzService jttdsyzService = (IJttdsyzService) Container.getBean("jtTdsyzService");
                    if (project.getTdzh() != null && !project.getTdzh().equals("")) {
                        JTTDSYZ jttdsyz = jttdsyzService.getJTTDSYZByTdzh(project.getTdzh());
                        sqbService.readJTTDSYZ(sqb, jttdsyz, 2);
                    }
                    sqb.setQsxz("集体土地使用权");
                    sqbService.insertSQB(sqb);
                } else if (project.getQsxz().equals("JU")) {
                    //从集有证考数据


                    IJttdsuzService jttdsuzService = (IJttdsuzService) Container.getBean("jtTdsuzService");
                    if (project.getTdzh() != null && !project.getTdzh().equals("")) {
                        JTTDSUZ jttdsuz = jttdsuzService.getJTTDSUZByTdzh(project.getTdzh());
                        sqbService.readJTTDSUZ(sqb, jttdsuz, 2);
                    }
                    sqb.setQsxz("集体土地所有权");
                    sqbService.insertSQB(sqb);
                }
            }
        }
        String qsxz = getQSXZ(project.getSqlx());
        if (qsxz.equals("")) {
            qsxz = getQSXZ(project.getQsxz());
        }
        sqb_qlyg.setQsxz(qsxz);
        sqb_qlyg.setSqlx(project.getSqlx());
    }

    //异议登记
    public void SaveYYDJ() {
        String rf1 = "异议登记申请人", rf2 = "";
        SQB sqb = new SQB();
        sqb.setProjectId(project.getProjectId());
        sqb.setBsm(bsm);
        sqb.setSqsbh(bhService.getSQBBH());
        sqb.setSqlx(project.getSqlx());
        sqb.setDjh(project.getDjh());
        sqb.setZl(project.getTdzl());
        sqb.setZtdzh(project.getTdzh());
        sqb.setDwdm(userDwdm);
        sqb.setRmzf(CommonUtil.getXZQ().getXzqName());
        sqb.setRf1_dwmc(project.getQlr());
        sqb.setRf1(rf1);
        sqb.setRf2(rf2);


        ISQBService sqbService = (ISQBService) Container.getBean("sqbService");
        //ISPBService spbService = (ISPBService)Container.getBean("spbService");
        /*SPB querySPB = new SPB();
          querySPB.setTdzh(project.getTdzh());
          SPB spb = new SPB();
          try{
              spb = spbService.getSPB(querySPB);
          }catch (Exception e) {
              // TODO: handle exception
              log.error(e.getMessage());
          }
          if (spb!=null && spb.getProjectId() != null){
              sqbService.readSPB(sqb, spb, "BGDJ");
              sqbService.insertSQB(sqb);
          }else{*/
        if (project.getQsxz().equals("GY")) {
            //从国有证考数据


            IGytdsyzService gytdsyzService = (IGytdsyzService) Container.getBean("gyTdsyzService");
            GYTDSYZ gytdsyz = gytdsyzService.getGYTDSYZbyTdzh(project.getTdzh());
            sqbService.readGYTDSYZ(sqb, gytdsyz, 0);
            sqb.setQsxz("国有土地使用权");
            sqbService.insertSQB(sqb);
        } else if (project.getQsxz().equals("JY")) {
            //从集体证考数据

            IJttdsyzService jttdsyzService = (IJttdsyzService) Container.getBean("jtTdsyzService");
            JTTDSYZ jttdsyz = jttdsyzService.getJTTDSYZByTdzh(project.getTdzh());
            sqbService.readJTTDSYZ(sqb, jttdsyz, 0);
            sqb.setQsxz("集体土地使用权");
            sqbService.insertSQB(sqb);
        } else if (project.getQsxz().equals("JU")) {
            //从集有证考数据


            IJttdsuzService jttdsuzService = (IJttdsuzService) Container.getBean("jtTdsuzService");
            JTTDSUZ jttdsuz = jttdsuzService.getJTTDSUZByTdzh(project.getTdzh());
            sqbService.readJTTDSUZ(sqb, jttdsuz, 0);
            sqb.setQsxz("集体土地所有权");
            sqbService.insertSQB(sqb);
        }

        String qsxz = getQSXZ(project.getSqlx());
        if (qsxz.equals("")) {
            qsxz = getQSXZ(project.getQsxz());
        }
        sqb_qlyg.setQsxz(qsxz);
        sqb_qlyg.setSqlx(project.getSqlx());
        //}
    }

    // 保存工作流项目


    public String createWfInstance() {
        IPlatUtil platUtil = (IPlatUtil) Container.getBean("platUtil");
        String taskId = platUtil.createWorkFlowInstance(project, userId);
        return taskId;
    }

    // 保存项目信息
    public void createProject(String taskId) {
        project.setTaskId(taskId);
        project.setProjectId(workflowIntanceId);
        project.setTdzl(project.getTdzl().trim());
        project.setQlr(project.getQlr().trim());
        project.setProjectName(project.getQlr());
        project.setCreater(userName);
        project.setDwdm(userDwdm);
        project.setCreateOrgan(createOrgan);
        project.setBeginTime(Calendar.getInstance().getTime());
        IProjectService projectService = (IProjectService) Container.getBean("projectService");
        projectService.insertProject(project);
    }
    //创建收件单


    public Integer createSJD() {
        SJD sjd = new SJD();
        sjd.setProjectId(project.getProjectId());
        sjd.setSqlx(project.getSqlx());
        if (!project.getDjlx().equals("查封") && !project.getDjlx().equals("解封")) {
            sjd.setJjr(project.getQlr());
        } else {
            sjd.setJjr("");
        }
        sjd.setZl(project.getTdzl());
        sjd.setSjr(userName);
        sjd.setBh(bhService.getSJDBH());
        sjd.setSjrq(Calendar.getInstance().getTime());
        sjd.setDwdm(userDwdm);
        IPlatUtil platUtil = (IPlatUtil) Container.getBean("platUtil");
        sjd.setCnqx(platUtil.getCNQX(project.getWdid()));
        XZQ xzq = new XZQ();
        xzq = CommonUtil.getXZQ();
        sjd.setRmzf(xzq.getXzqName());
        ISJDService sjdService = (ISJDService) Container.getBean("sjdService");
        sjdService.insertSJD(sjd);
        SJD dateSjd = sjdService.getSJD(project.getProjectId());
        return dateSjd.getBsm();
    }

    public String NewProject() {
        HttpServletRequest request = ServletActionContext.getRequest();
        String wdid = request.getParameter("wdid");
        IPlatUtil platUtil = (IPlatUtil) Container.getBean("platUtil");
        String wfRemark = platUtil.getWfRemarkByWdid(wdid);
        //System.out.println(wfRemark.equals("初始登记"));
        if (wfRemark.equals("初始登记")) {
            CreateNewProjectVO(wdid, "CSDJ", "初始登记", "GY,JY,JU", "", "权利人：", "", "none");
        } else if (wfRemark.equals("变更登记") || wfRemark.equals("权属变更登记")) {
            CreateNewProjectVO(wdid, "QSBGDJ", "变更登记", "GY,JY,JU", "none", "受让人：", "土地证号：", "");
        } else if (wfRemark.equals("名称地址用途变更登记")) {
            CreateNewProjectVO(wdid, "MCBGDJ", "名称地址用途变更登记", "GY,JY,JU", "none", "权利人：", "土地证号：", "");
        } else if (wfRemark.equals("他项登记")) {
            CreateNewProjectVO(wdid, "TXDJ", "他项登记", "GY,JY", "none", "抵押人：", "土地证号：", "");
        } else if (wfRemark.equals("分割登记")) {
            CreateNewProjectVO(wdid, "FGDJ", "分割登记", "GY", "", "权利人：", "总土地证号：", "");
        } else if (wfRemark.equals("分割证换发证")) {
            CreateNewProjectVO(wdid, "FGZHFZ", "分割证换发证", "GY", "none", "权利人：", "分割证号：", "");
        } else if (wfRemark.equals("换证与遗失补证")) {
            CreateNewProjectVO(wdid, "YSBF", "换证与遗失补证", "GY,JY,JU", "none", "权利人：", "土地证号：", "");
        } else if (wfRemark.equals("查封")) {
            CreateNewProjectVO(wdid, "CFDJ", "查封", "GY,JY", "none", "权利人：", "土地证号：", "");
        } else if (wfRemark.equals("轮候查封")) {
            CreateNewProjectVO(wdid, "LHCFDJ", "轮候查封", "GY,JY", "none", "权利人：", "查封ID：", "");
        } else if (wfRemark.equals("注销登记")) {
            CreateNewProjectVO(wdid, "ZXDJ", "注销登记", "GY,JY,JU", "none", "权利人：", "土地证号：", "");
        } else if (wfRemark.equals("注销他项登记")) {
            CreateNewProjectVO(wdid, "ZXTXDJ", "注销登记", "GY,JY,JU", "none", "权利人：", "土地证号：", "");
        } else if (wfRemark.equals("异议登记")) {
            CreateNewProjectVO(wdid, "YYDJ", "异议登记", "GY,JY,JU", "none", "申请人：", "土地证号：", "");
        } else if (wfRemark.equals("注销异议登记")) {
            CreateNewProjectVO(wdid, "ZXYYDJ", "注销异议登记", "GY,JY,JU", "none", "申请人：", "异议ID：", "");
        } else if (wfRemark.equals("预告登记")) {
            CreateNewProjectVO(wdid, "YGDJ", "预告登记", "GY,JY,JU", "none", "权利人：", "土地证号：", "");
        } else if (wfRemark.equals("更正登记")) {
            CreateNewProjectVO(wdid, "GZDJ", "更正登记", "GY,JY,JU", "none", "权利人：", "土地证号：", "");
        } else if (wfRemark.equals("解封")) {
            CreateNewProjectVO(wdid, "JFDJ", "解封", "GY,JY,JU", "none", "权利人：", "查封ID：", "");
        } else if (wfRemark.equals("部分转让变更")) {
            CreateNewProjectVO(wdid, "BFZRBG", "部分转让变更登记", "GY,JY", "none", "受让人：", "土地证号：", "");
        } else if (wfRemark.equals("无销售许可证变更登记")) {
            CreateNewProjectVO(wdid, "WZBG", "无销售许可证变更登记", "GY", "none", "受让人：", "土地证号：", "");
        } else if (wfRemark.equals("分割登记标准版")) {
            CreateNewProjectVO(wdid, "FGDJ", "分割登记", "GY", "", "权利人：", "总土地证号：", "");
        } else if (wfRemark.equals("土地总登记")) {
            CreateNewProjectVO(wdid, "TDZDJ", "土地总登记", "GY,JY,JU", "", "权利人：", "", "none");
        } else if (wfRemark.equals("证书挂失")) {
            CreateNewProjectVO(wdid, "ZSGS", "证书挂失", "GY,JY,JU", "none", "权利人：", "土地证号：", "");
        } else if (wfRemark.equals("房改房登记")) {
            CreateNewProjectVO(wdid, "FGFDJ", "房改房登记", "GY", "none", "受让人：", "土地证号：", "");
        } else if (wfRemark.equals("小区变更登记")) {
            CreateNewProjectVO(wdid, "FGFDJ", "小区变更登记", "GY", "none", "受让人：", "土地证号：", "");
        }
        return "success";
    }

    public void CreateNewProjectVO(String wdid, String djlx, String djlxHtml, String qsxz, String djhDisplay, String qlrHtml, String tdzhHtml, String tdzhDisplay) {
        HttpServletRequest request = ServletActionContext.getRequest();
        newProject.setWdid(wdid);
        newProject.setDjlx(djlx);
        newProject.setDjlxHtml(djlxHtml);
        newProject.setQsxz(qsxz);
        newProject.setDjhDisplay(djhDisplay);
        newProject.setQlrHtml(qlrHtml);
        newProject.setTdzhHtml(tdzhHtml);
        newProject.setTdzhDisplay(tdzhDisplay);
        String isXqdj=request.getParameter("isXqdj"); //由于小区登记和初始登记备注是一样的，在此以 isXqdj作区别
        if(djlxHtml.equals("变更登记")||(isXqdj!=null&&isXqdj.equals("yes")))
            newProject.setCrfDisplay("");
        else
            newProject.setCrfDisplay("none");
    }

    private String getSyqlx(String sqlx) {
        String syqlx = "";
        if (sqlx.indexOf("出让") > -1) {
            syqlx = "出让";
        } else if (sqlx.indexOf("划拨") > -1) {
            syqlx = "划拨";
        } else if (sqlx.indexOf("入股") > -1) {
            syqlx = "入股";
        } else if (sqlx.indexOf("租赁") > -1) {
            syqlx = "租赁";
        } else if (sqlx.indexOf("授权经营") > -1) {
            syqlx = "授权经营";
        }
        return syqlx;
    }

    private String getQSXZ(String sqlx) {
        /**
         * 用途：根据参数sqlx 判断 qsxz
         * 参数：sqlx  (可以是【申请类型】也可以是【权属性质】)
         * 修改人：刘仲阳


         * 修改时间：2009-1-12
         * 说明：在【申请类型】 无法判断得到 qsxz 的时候 再传 【权属性质】直接获得


         * */
        String qsxz = "";
        //下面是按 SQLX获得
        if (sqlx.indexOf("国有建设用地使用权") > -1) {
            qsxz = "国有建设用地使用权";
        } else if (sqlx.indexOf("国有农用地使用权") > -1) {
            qsxz = "国有农用地使用权";
        } else if (sqlx.indexOf("集体建设用地使用权") > -1) {
            qsxz = "集体建设用地使用权";
        } else if (sqlx.indexOf("宅基地使用权") > -1) {
            qsxz = "宅基地使用权";
        } else if (sqlx.indexOf("集体农用地使用权") > -1) {
            qsxz = "集体农用地使用权";
        } else if (sqlx.indexOf("集体土地所有权") > -1) {
            qsxz = "集体土地所有权";
        } else if (sqlx.indexOf("集体土地使用证") > -1) {
            qsxz = "集体土地使用权";
        } else if (sqlx.indexOf("国有土地使用证") > -1) {
            qsxz = "国有土地使用权";
        } else if (sqlx.indexOf("集体土地所有证") > -1) {
            qsxz = "集体土地所有权";
            //下面3中是按QSXZ获得
        } else if (sqlx.equals("GY")) {
            qsxz = "国有土地使用权";
        } else if (sqlx.equals("JY")) {
            qsxz = "集体土地使用权";
        } else if (sqlx.equals("JU")) {
            qsxz = "集体土地所有权";
        }
        return qsxz;
    }

    public Project getProject() {
        return project;
    }

    public NewProject getNewProject() {
        return newProject;
    }

    public void setNewProject(NewProject newProject) {
        this.newProject = newProject;
    }

    public void setProject(Project project) {
        this.project = project;
    }

    public IBHService getBhService() {
        return bhService;
    }

    public void setBhService(IBHService bhService) {
        this.bhService = bhService;
    }

    public String getCreateOrgan() {
        return createOrgan;
    }

    public void setCreateOrgan(String createOrgan) {
        this.createOrgan = createOrgan;
    }

    public String getSfzmNum() {
        return sfzmNum;
    }

    public void setSfzmNum(String sfzmNum) {
        this.sfzmNum = sfzmNum;
    }

    public String getAddress() {
        return address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public String getCrf() {
        return crf;
    }

    public void setCrf(String crf) {
        this.crf = crf;
    }

    public String getRf2_sfzmtype() {
        return rf2_sfzmtype;
    }

    public void setRf2_sfzmtype(String rf2_sfzmtype) {
        this.rf2_sfzmtype = rf2_sfzmtype;
    }

    public String getRf2_sfzmnum() {
        return rf2_sfzmnum;
    }

    public void setRf2_sfzmnum(String rf2_sfzmnum) {
        this.rf2_sfzmnum = rf2_sfzmnum;
    }

    public String getRf2_dwxz() {
        return rf2_dwxz;
    }

    public void setRf2_dwxz(String rf2_dwxz) {
        this.rf2_dwxz = rf2_dwxz;
    }

    public String getRf2_txdz() {
        return rf2_txdz;
    }

    public void setRf2_txdz(String rf2_txdz) {
        this.rf2_txdz = rf2_txdz;
    }

    public String getRf2_yb() {
        return rf2_yb;
    }

    public void setRf2_yb(String rf2_yb) {
        this.rf2_yb = rf2_yb;
    }

    public String getRf2_fddbr() {
        return rf2_fddbr;
    }

    public void setRf2_fddbr(String rf2_fddbr) {
        this.rf2_fddbr = rf2_fddbr;
    }

    public String getRf2_lxr() {
        return rf2_lxr;
    }

    public void setRf2_lxr(String rf2_lxr) {
        this.rf2_lxr = rf2_lxr;
    }

    public String getRf2_lxdh() {
        return rf2_lxdh;
    }

    public void setRf2_lxdh(String rf2_lxdh) {
        this.rf2_lxdh = rf2_lxdh;
    }

    public String getRf2_dzyj() {
        return rf2_dzyj;
    }

    public void setRf2_dzyj(String rf2_dzyj) {
        this.rf2_dzyj = rf2_dzyj;
    }

    public String getRf2_dlrxm() {
        return rf2_dlrxm;
    }

    public void setRf2_dlrxm(String rf2_dlrxm) {
        this.rf2_dlrxm = rf2_dlrxm;
    }

    public String getRf2_dlrzsh() {
        return rf2_dlrzsh;
    }

    public void setRf2_dlrzsh(String rf2_dlrzsh) {
        this.rf2_dlrzsh = rf2_dlrzsh;
    }

    public String getRf2_dljgmc() {
        return rf2_dljgmc;
    }

    public void setRf2_dljgmc(String rf2_dljgmc) {
        this.rf2_dljgmc = rf2_dljgmc;
    }

    public String getRf2_dllxdh() {
        return rf2_dllxdh;
    }

    public void setRf2_dllxdh(String rf2_dllxdh) {
        this.rf2_dllxdh = rf2_dllxdh;
    }

    public Integer getIsjfAllLHCF() {
        return isjfAllLHCF;
    }

    public void setIsjfAllLHCF(Integer isjfAllLHCF) {
        this.isjfAllLHCF = isjfAllLHCF;
    }

    public Integer getIsXCF() {
        return isXCF;
    }

    public void setIsXCF(Integer isXCF) {
        this.isXCF = isXCF;
    }
}