package com.jsegov.tddj.action;

import javax.servlet.http.HttpServletRequest;

import org.apache.struts2.ServletActionContext;

import com.gtis.util.UUIDGenerator;
import com.gtis.plat.service.SysUserService;
import com.gtis.spring.Container;
import com.jsegov.tddj.platform.TddjUtil;
import com.jsegov.tddj.services.interf.IGYQDJKService;
import com.jsegov.tddj.services.interf.IGytdsyzService;
import com.jsegov.tddj.services.interf.IJttdsuzService;
import com.jsegov.tddj.services.interf.IJttdsyzService;
import com.jsegov.tddj.services.interf.IOldGytdsyzService;
import com.jsegov.tddj.services.interf.IProjectService;
import com.jsegov.tddj.services.interf.ITxqlzmsService;
import com.jsegov.tddj.util.CommonUtil;
import com.jsegov.tddj.vo.GYQDJK;
import com.jsegov.tddj.vo.GYTDSYZ;
import com.jsegov.tddj.vo.JTTDSUZ;
import com.jsegov.tddj.vo.JTTDSYZ;
import com.jsegov.tddj.vo.OldGYTDSYZ;
import com.jsegov.tddj.vo.Project;
import com.jsegov.tddj.vo.TXQLZMS;
import com.opensymphony.xwork2.ActionSupport;

public class EditTDZAction extends ActionSupport{

	/**
	 * 
	 */
	private static final long serialVersionUID = 569543284318560509L;
	private GYTDSYZ gytdsyz=new GYTDSYZ();
	private String zslx="";
	private String msg="";
	private String js="";
	private String oldProjectId="";
	private String gyqTag="";
	private JTTDSYZ jttdsyz = new JTTDSYZ();
	private JTTDSUZ jttdsuz = new JTTDSUZ();
	private TXQLZMS txqlzms = new TXQLZMS();
	
	public JTTDSYZ getJttdsyz() {
		return jttdsyz;
	}

	public void setJttdsyz(JTTDSYZ jttdsyz) {
		this.jttdsyz = jttdsyz;
	}

	public JTTDSUZ getJttdsuz() {
		return jttdsuz;
	}

	public void setJttdsuz(JTTDSUZ jttdsuz) {
		this.jttdsuz = jttdsuz;
	}

	public TXQLZMS getTxqlzms() {
		return txqlzms;
	}

	public void setTxqlzms(TXQLZMS txqlzms) {
		this.txqlzms = txqlzms;
	}

	public String execute() throws Exception {
		HttpServletRequest request = ServletActionContext.getRequest();
		zslx=request.getParameter("zslx");
		String projectId=request.getParameter("projectId");
		if(projectId!=null && !projectId.equals("")){
			if(zslx.equals("gytdsyz")){
				IGytdsyzService gytdsyzService=(IGytdsyzService)Container.getBean("gyTdsyzService");
				gytdsyz=gytdsyzService.getGYTDSYZ(projectId);
				
				IGYQDJKService gyqdjkService=(IGYQDJKService)Container.getBean("gyqDjkService");
				GYQDJK gyqdjk=gyqdjkService.getGYQDJKbyTdzh(gytdsyz.getTdzh());
				if(gyqdjk!=null){
					gyqTag="gy";
				}
				else {
					gyqTag="dy";
				}
			}else if(zslx.equals("jttdsyz")){
				IJttdsyzService jttdsyzService = (IJttdsyzService)Container.getBean("jtTdsyzService");
				jttdsyz = jttdsyzService.getJTTDSYZ(projectId);
			}else if(zslx.equals("jttdsuz")){
				IJttdsuzService jttdsuzService = (IJttdsuzService)Container.getBean("jtTdsuzService");
				jttdsuz = jttdsuzService.getJTTDSUZ(projectId);
			}else if(zslx.equals("txqlzms")){
				ITxqlzmsService txqlzmsService = (ITxqlzmsService)Container.getBean("txqlzmsService");
				txqlzms = txqlzmsService.getTXQLZMS(projectId);
			}
		}
		return zslx;
	}
	
	public String save() {		
		String userName=TddjUtil.getCurrentUserName();
		
		String userDwdm = TddjUtil.getCurrentUserDwdm();
		
		
		if(zslx.equals("gytdsyz")){
			IProjectService projectService=(IProjectService)Container.getBean("projectService");
			IGytdsyzService gytdsyzService=(IGytdsyzService)Container.getBean("gyTdsyzService");
			
			String projectId=gytdsyz.getProjectId();
			
			gytdsyz.setOlddata(1);
			gytdsyz.setRmzf(CommonUtil.getXZQ().getXzqName());
			gytdsyz.setDwdm(userDwdm);
			
			//修改证书
			if(projectId!=null && !projectId.equals("")){
				Project project=projectService.getProject(projectId);
				project.setProjectName(gytdsyz.getQlr());
				project.setDjh(gytdsyz.getDjh());
				projectService.updateProject(project);
				if(zslx.equals("gytdsyz")){
					gytdsyzService.updateGYTDSYZ(gytdsyz);
				}
				IGYQDJKService gyqdjkService=(IGYQDJKService)Container.getBean("gyqDjkService");
				GYQDJK gyqdjk=gyqdjkService.getGYQDJK(projectId);
				if(gyqTag.equals("gy")){
					if(gyqdjk!=null){
						gyqdjk.setProjectId(projectId);
						gyqdjk.setRq(CommonUtil.getCurrStrDate());
						gyqdjk.setDjh(gytdsyz.getDjh());
						gyqdjk.setTdzh(gytdsyz.getTdzh());
						gyqdjk.setQlr(gytdsyz.getQlr());
						gyqdjk.setYt(gytdsyz.getYt());
						gyqdjk.setTdqlmj(gytdsyz.getSyqmj());
						gyqdjk.setIslogout(0);
						gyqdjk.setDwdm(userDwdm);
						gyqdjkService.updateGYQDJK(gyqdjk);
					}
					else {
						GYQDJK gyqdjk1=new GYQDJK();
						gyqdjk1.setProjectId(projectId);
						gyqdjk1.setRq(CommonUtil.getCurrStrDate());
						gyqdjk1.setDjh(gytdsyz.getDjh());
						gyqdjk1.setTdzh(gytdsyz.getTdzh());
						gyqdjk1.setQlr(gytdsyz.getQlr());
						gyqdjk1.setYt(gytdsyz.getYt());
						gyqdjk1.setTdqlmj(gytdsyz.getSyqmj());
						gyqdjk1.setIslogout(0);
						gyqdjk1.setDwdm(userDwdm);
						gyqdjkService.insertGYQDJK(gyqdjk1);
					}
				}
				else {
					if(gyqdjk!=null){
						gyqdjkService.deleteGYQDJK(projectId);
					}
				}
			}
			else {
				//新增证书
				projectId=UUIDGenerator.generate();			
				Project project=new Project();
				project.setProjectId(projectId);
				project.setProjectName(gytdsyz.getQlr());
				project.setBeginTime(CommonUtil.getCurrDate());
				//project.setEndTime(CommonUtil.getCurrDate());
				project.setDjh(gytdsyz.getDjh());
				project.setCreater(userName);
				project.setDwdm(userDwdm);
				if(zslx.equals("gytdsyz")){
					project.setDjlx("补填国有土地使用证");
					gytdsyz.setProjectId(projectId);
					gytdsyzService.insertGYTDSYZ(gytdsyz);
				}
				projectService.insertProject(project);
				
				//新增共有权登记卡
				if(gyqTag.equals("gy")){
					GYQDJK gyqdjk=new GYQDJK();
					//gyqdjk.setDjh(djh);
					gyqdjk.setProjectId(projectId);
					gyqdjk.setRq(CommonUtil.getCurrStrDate());
					gyqdjk.setDjh(gytdsyz.getDjh());
					gyqdjk.setTdzh(gytdsyz.getTdzh());
					gyqdjk.setQlr(gytdsyz.getQlr());
					gyqdjk.setYt(gytdsyz.getYt());
					gyqdjk.setTdqlmj(gytdsyz.getSyqmj());
					gyqdjk.setIslogout(0);
					gyqdjk.setDwdm(userDwdm);
					IGYQDJKService gyqdjkService=(IGYQDJKService)Container.getBean("GyqDjkService");
					gyqdjkService.insertGYQDJK(gyqdjk);
				}
			}
			//修改老证书标识

			if(oldProjectId!=null && !oldProjectId.equals("")){
				//System.out.println("==="+oldProjectId);
				Integer tempProjectId=Integer.valueOf(oldProjectId);
				IOldGytdsyzService oldGytdsyzService=(IOldGytdsyzService)Container.getBean("oldGyTdsyzService");
				OldGYTDSYZ oldGytdsyz= oldGytdsyzService.getOldGYTDSYZ(tempProjectId);
				Integer isimport=oldGytdsyz.getIsimport();
				if(isimport==null || isimport==0){
					oldGytdsyz.setIsimport(1);
					oldGytdsyzService.updateOldGYTDSYZ(oldGytdsyz);
				}
			}
		}else if(zslx.equals("jttdsyz")){
			
			
		}else if(zslx.equals("jttdsuz")){
			
			
		}else if(zslx.equals("txqlzms")){			
			String projectId=txqlzms.getProjectId();
			IProjectService projectService=(IProjectService)Container.getBean("projectService");
			ITxqlzmsService txqlzmsService=(ITxqlzmsService)Container.getBean("txqlzmsService");
			if(projectId!=null && !projectId.equals("")){
				//修改证书
				//System.out.println("==========="+txqlzms.getIsprinted());
				txqlzmsService.updateTXQLZMS(txqlzms);
			}else{
				//新增
				projectId = UUIDGenerator.generate();
				txqlzms.setOlddata(1);
				txqlzms.setRmzf(CommonUtil.getXZQ().getXzqName());
				txqlzms.setDwdm(userDwdm);
				txqlzms.setIslogout(0);
				txqlzms.setIsprinted(0);
				txqlzms.setProjectId(projectId);
				txqlzmsService.insertTXQLZMS(txqlzms);						
				Project project = new Project();
				project.setProjectId(projectId);
				project.setProjectName(txqlzms.getYwr());
				project.setBeginTime(CommonUtil.getCurrDate());
				project.setEndTime(CommonUtil.getCurrDate());
				project.setDjh(txqlzms.getDjh());
				project.setCreater(userName);
				project.setDwdm(userDwdm);
				projectService.insertProject(project);
			}
			
		}
		setMsg("证书数据保存成功！");
		return zslx; 
	}
	
	public GYTDSYZ getGytdsyz() {
		return gytdsyz;
	}

	public void setGytdsyz(GYTDSYZ gytdsyz) {
		this.gytdsyz = gytdsyz;
	}

	public String getZslx() {
		return zslx;
	}

	public void setZslx(String zslx) {
		this.zslx = zslx;
	}

	public String getMsg() {
		return msg;
	}

	public void setMsg(String msg) {
		this.msg = msg;
	}

	public String getJs() {
		return js;
	}

	public void setJs(String js) {
		this.js = js;
	}

	public String getOldProjectId() {
		return oldProjectId;
	}

	public void setOldProjectId(String oldProjectId) {
		this.oldProjectId = oldProjectId;
	}

	public String getGyqTag() {
		return gyqTag;
	}

	public void setGyqTag(String gyqTag) {
		this.gyqTag = gyqTag;
	}
	
}
