package com.jsegov.tddj.action;

import java.util.HashMap;
import java.util.List;

import javax.servlet.http.HttpServletRequest;

import org.apache.struts2.ServletActionContext;

import com.gtis.spring.Container;
import com.gtis.web.SplitParam;
import com.gtis.web.SplitParamImpl;
import com.jsegov.tddj.dao.SJDCLLISTDAO;
import com.jsegov.tddj.vo.SJDCLLIST;
import com.opensymphony.xwork2.ActionSupport;

public class EditSjdclAction extends ActionSupport{
	
	/**
	 * 
	 */
	private static final long serialVersionUID = 1024936654104826923L;
	private SJDCLLIST sjdcllist;
	private List<SJDCLLIST> lstAllSjdcl;
	private List<SJDCLLIST> lstAllSjlx;
	private List<SJDCLLIST> lstAllOrderid;
	private SplitParam splitParam;
	private String sjlx = "";
	private String sjdcl = "";
	private Integer orderid;
	private String msg;
	private String opttype;
	
	
	public String execute() throws Exception {

		SJDCLLISTDAO sjdcllistdao = (SJDCLLISTDAO) Container
				.getBean("sjdcllistDAO");
		lstAllSjdcl = sjdcllistdao.getAllSjdcl();
		lstAllSjlx = sjdcllistdao.getAllSjlx();
		
		SplitParamImpl s = new SplitParamImpl();
		HashMap<String, Object> map = new HashMap<String, Object>();
		String querySjlx = null;
		String querySjdcl = null;
		
		if (sjlx != null && !sjlx.equals("")) {
			querySjlx = sjlx;
		}
		if (sjdcl != null && !sjdcl.equals("")) {
			querySjdcl = sjdcl;
		}

		map.put("sjlx", querySjlx);
		map.put("sjdcl", querySjdcl);

		s.setQueryString("selectSJDCLLIST");
		s.setQueryParam(map);
		splitParam = s;
		return SUCCESS;
	}

	public String editData() throws Exception {
		HttpServletRequest request = ServletActionContext.getRequest();
		sjdcllist = new SJDCLLIST();
		String clnum = "";
		Integer id = Integer.parseInt(request.getParameter("id"));
		orderid = Integer.parseInt(request.getParameter("orderid"));
        sjlx=java.net.URLDecoder.decode(request.getParameter("sjlx"),"UTF-8");
        sjdcl=java.net.URLDecoder.decode(request.getParameter("sjdcl"),"UTF-8");
        clnum=java.net.URLDecoder.decode(request.getParameter("clnum"),"UTF-8");
		sjdcllist.setId(id);
		sjdcllist.setSjdcl(sjdcl);
		sjdcllist.setSjlx(sjlx);
		sjdcllist.setClnum(clnum);
		sjdcllist.setOrderid(orderid);

		return "INSERT";
	}

	public String insertData() throws Exception {
		HttpServletRequest request = ServletActionContext.getRequest();
		sjdcllist = new SJDCLLIST();
		String clnum = "";
		sjlx = new String(request.getParameter("sjlx").getBytes("ISO8859_1"),"GBK");
		sjdcl = new String(request.getParameter("sjdcl").getBytes("ISO8859_1"),"GBK");
		clnum = "1"; 

		SJDCLLISTDAO sjdcllistdao = (SJDCLLISTDAO) Container.getBean("sjdcllistDAO");
		Integer maxId = 0;
		 //递增Id 做主键

		lstAllOrderid = sjdcllistdao.getSJDCLLIST(); 
		for (int i = 0; i < lstAllOrderid.size(); i++) {
			if (lstAllOrderid.get(i).getId() >= maxId) {
				maxId = lstAllOrderid.get(i).getId();
			}
		}
		sjdcllist.setId(maxId + 1);
		sjdcllist.setOrderid(orderid);
		sjdcllist.setSjdcl(sjdcl);
		sjdcllist.setSjlx(sjlx);
		sjdcllist.setClnum(clnum);
		
		return "INSERT";
	}

	public String save() throws Exception {
		//HttpServletRequest request = ServletActionContext.getRequest();
		//opttype = request.getParameter(opttype);
		SJDCLLISTDAO sjdcllistdao = (SJDCLLISTDAO) Container.getBean("sjdcllistDAO");
		if (opttype.equals("insert")) {
			sjdcllistdao.insertSJDCLLIST(sjdcllist);
		}else if (opttype.equals("edit")) {
			sjdcllistdao.updateSJDCLLIST(sjdcllist);
		}
		msg = "保存成功!";
		opttype = "edit";
		return "INSERT";
	}

	public String delete() throws Exception {
		HttpServletRequest request = ServletActionContext.getRequest();
		Integer id = 0;
		id = Integer.parseInt(request.getParameter("id"));
		SJDCLLISTDAO sjdcllistdao = (SJDCLLISTDAO) Container.getBean("sjdcllistDAO");
		sjdcllistdao.deleteSJDCLLIST(id);
		return execute();
	}
	
	public SJDCLLIST getSjdcllist() {
		return sjdcllist;
	}

	public void setSjdcllist(SJDCLLIST sjdcllist) {
		this.sjdcllist = sjdcllist;
	}

	public List<SJDCLLIST> getLstAllSjdcl() {
		return lstAllSjdcl;
	}

	public void setLstAllSjdcl(List<SJDCLLIST> lstAllSjdcl) {
		this.lstAllSjdcl = lstAllSjdcl;
	}

	public List<SJDCLLIST> getLstAllSjlx() {
		return lstAllSjlx;
	}

	public void setLstAllSjlx(List<SJDCLLIST> lstAllSjlx) {
		this.lstAllSjlx = lstAllSjlx;
	}

	public List<SJDCLLIST> getLstAllOrderid() {
		return lstAllOrderid;
	}

	public void setLstAllOrderid(List<SJDCLLIST> lstAllOrderid) {
		this.lstAllOrderid = lstAllOrderid;
	}

	public SplitParam getSplitParam() {
		return splitParam;
	}

	public void setSplitParam(SplitParam splitParam) {
		this.splitParam = splitParam;
	}

	public String getSjlx() {
		return sjlx;
	}

	public void setSjlx(String sjlx) {
		this.sjlx = sjlx;
	}

	public String getSjdcl() {
		return sjdcl;
	}

	public void setSjdcl(String sjdcl) {
		this.sjdcl = sjdcl;
	}

	public String getMsg() {
		return msg;
	}

	public void setMsg(String msg) {
		this.msg = msg;
	}

	public String getOpttype() {
		return opttype;
	}

	public void setOpttype(String opttype) {
		this.opttype = opttype;
	}

	public Integer getOrderid() {
		return orderid;
	}

	public void setOrderid(Integer orderid) {
		this.orderid = orderid;
	}

}
