package com.jsegov.tddj.action;

import javax.servlet.http.HttpServletRequest;

import org.apache.struts2.ServletActionContext;

import com.gtis.spring.Container;
import com.jsegov.tddj.services.interf.IDJKXBService;
import com.jsegov.tddj.services.interf.ISPBService;
import com.jsegov.tddj.util.CommonUtil;
import com.jsegov.tddj.vo.SPB;
import com.opensymphony.xwork2.ActionSupport;
public class EditSPBAction extends ActionSupport {

	/**
	 * 
	 */
	private static final long serialVersionUID = 2281702444411877307L;
	private String projectId;
	private String scrq;
	private String shrq;
	private String pzrq;
	private String msg;
	private SPB spb;
	
	public String execute() throws Exception {
		HttpServletRequest request = ServletActionContext.getRequest();
		projectId = request.getParameter("projectId");
		String djh = request.getParameter("djh");
		ISPBService spbService=(ISPBService)Container.getBean("spbService");
		
		spb =spbService.getSPB(projectId);
		if (spb!=null){
			if (spb.getShrq()!=null) scrq = CommonUtil.formateDate(spb.getShrq());
			if (spb.getScrq()!=null) shrq = CommonUtil.formateDate(spb.getScrq());
			if (spb.getPzrq()!=null) pzrq = CommonUtil.formateDate(spb.getPzrq());
		}
		
		if (spb==null){
			spb = new SPB();
			spb.setProjectId(projectId);
			spb.setDjh(djh);
		}
		return SUCCESS;
	}

	public String save(){
		ISPBService spbService=(ISPBService)Container.getBean("spbService");
		if (scrq!=null && !scrq.equals("")) spb.setShrq(CommonUtil.formateDateToStr(scrq));
		if (shrq!=null && !shrq.equals("")) spb.setScrq(CommonUtil.formateDateToStr(shrq));
		if (pzrq!=null && !pzrq.equals("")) spb.setPzrq(CommonUtil.formateDateToStr(pzrq));
		spb.setProjectId(projectId);
		HttpServletRequest request = ServletActionContext.getRequest();
		if (request.getParameter("spb.shr")!=null)spb.setShr(request.getParameter("spb.shr"));
		//if (request.getParameter("spb.scr")!=null)spb.setShr(request.getParameter("spb.scr"));
		//System.out.println("qqqqqqqqq------"+request.getParameter("spb.shr"));
//		if(", ".equals(spb.getScr())){
//			spb.setScr("");
//		}
//		System.out.println(spb.getScr());
//		String sd="asdadsaas,asd";
//		System.out.println(sd.split(",")[0]);
	    spb.setScr(spb.getScr().split(",")[0]);
		if(spbService.getSPB(projectId)!=null){
			spbService.updateSPB(spb);
		}else{
			spbService.insertSPB(spb);
		}
		String xbnr = "";
		xbnr = spb.getXbnr();
		if (xbnr!=null && !xbnr.equals("")){
			if (!spb.getDjh().equals("")){
				IDJKXBService djkxbService = (IDJKXBService)Container.getBean("djkXbService");
				if (djkxbService.getDJKXB(projectId) == null){
					djkxbService.insertDJKXB(spb);
				}else{
					djkxbService.updateDJKXB(spb);
				}
			}
		}
		msg = "保存成功！";
		return SUCCESS;
	}
	
	public SPB getSpb() {
		return spb;
	}

	public void setSpb(SPB spb) {
		this.spb = spb;
	}

	public String getProjectId() {
		return projectId;
	}

	public void setProjectId(String projectId) {
		this.projectId = projectId;
	}
	public String getMsg() {
		return msg;
	}

	public void setMsg(String msg) {
		this.msg = msg;
	}

	public String getScrq() {
		return scrq;
	}

	public void setScrq(String scrq) {
		this.scrq = scrq;
	}

	public String getShrq() {
		return shrq;
	}

	public void setShrq(String shrq) {
		this.shrq = shrq;
	}

	public String getPzrq() {
		return pzrq;
	}

	public void setPzrq(String pzrq) {
		this.pzrq = pzrq;
	}
}
