package com.jsegov.tddj.action;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

import javax.servlet.http.HttpServletRequest;

import org.apache.struts2.ServletActionContext;
import org.apache.struts2.json.JSONUtil;

import com.gtis.spring.Container;
import com.gtis.web.SplitParam;
import com.gtis.web.SplitParamImpl;
import com.jsegov.tddj.dao.LimitFieldDAO;
import com.jsegov.tddj.util.CommonUtil;
import com.jsegov.tddj.vo.LimitField;
import com.opensymphony.xwork2.ActionSupport;

public class EditLimitfieldAction extends ActionSupport {
 
	/**
	 * 
	 */
	private static final long serialVersionUID = 3467024682643126175L;

	private LimitField limitField;
	private List<LimitField> lstAllSqlx;
	private List<LimitField> lstAllFieldname;
	private List<LimitField> lstAllNodeid;
	private List<LimitField> lstAllTablename;
	private SplitParam splitParam;
	private String fieldname = "";
	private String projecttype = "";
	private String nodeid = "";
	private String tablename = "";
	private String msg;
	private String opttype;
	
	public String execute() throws Exception {
		LimitFieldDAO limitFieldDAO = (LimitFieldDAO)Container.getBean("limitFieldDAO");
		try{
			//lstAllSqlx = limitFieldDAO.getAllSqlx();
			List<String> paramlstAllSqlx = CommonUtil.getAllSqlx();
			lstAllSqlx = new ArrayList<LimitField>();
			for (int i = 0 ; i < paramlstAllSqlx.size() ; i++){
				LimitField paramLimitField = new LimitField();
				paramLimitField.setProjecttype(paramlstAllSqlx.get(i));
				lstAllSqlx.add(i, paramLimitField);
			}
			//lstAllNodeid = limitFieldDAO.getAllNodeid();
			List<String> paramlstAllNodeid = CommonUtil.getAllNodeid();
			lstAllNodeid = new ArrayList<LimitField>();
			for (int i = 0 ; i < paramlstAllNodeid.size() ; i++){
				LimitField paramLimitField = new LimitField();
				paramLimitField.setNodeid(paramlstAllNodeid.get(i));
				lstAllNodeid.add(i, paramLimitField);
			}
			lstAllFieldname = limitFieldDAO.getAllFieldname();
			
			lstAllTablename = limitFieldDAO.getAllTablename();
		}catch (Exception e) {
			// TODO: handle exception
			LOG.error("NoNo:",e);
		}
		SplitParamImpl s = new SplitParamImpl();
		HashMap<String, Object> map = new HashMap<String, Object>();
		String queryProjecttype = null;
		String queryNodeid = null;
		String queryFieldname = null;
		String queryTablename = null;
		if (projecttype != null && !projecttype.equals("")) {
			queryProjecttype = projecttype;
		}
		if (nodeid != null && !nodeid.equals("")) {
			queryNodeid = nodeid;
		}
		if (fieldname != null && !fieldname.equals("")) {
			queryFieldname = fieldname;
		}
		if (tablename != null && !tablename.equals("")) {
			queryTablename = tablename;
		}

		map.put("projecttype", queryProjecttype);
		map.put("nodeid", queryNodeid);
		map.put("fieldname", queryFieldname);
		map.put("tablename", queryTablename);

		s.setQueryString("queryLimitFieldWithZDB");
		s.setQueryParam(map);
		splitParam = s;
		return SUCCESS;
	}

	public String editData() throws Exception {
		HttpServletRequest request = ServletActionContext.getRequest();
		limitField = new LimitField();
		String memo = "";
		Integer limitlevel = 0;
		limitlevel = Integer.parseInt(request.getParameter("limitlevel"));
        memo=java.net.URLDecoder.decode(request.getParameter("memo"),"UTF-8");
        projecttype=java.net.URLDecoder.decode(request.getParameter("projecttype"),"UTF-8");
        nodeid=java.net.URLDecoder.decode(request.getParameter("nodeid"),"UTF-8");
        fieldname=java.net.URLDecoder.decode(request.getParameter("fieldname"),"UTF-8");
        tablename=java.net.URLDecoder.decode(request.getParameter("tablename"),"UTF-8");

        String tablenameKey=java.net.URLDecoder.decode(request.getParameter("tablenameKey"),"UTF-8");
        String fieldnameKey=java.net.URLDecoder.decode(request.getParameter("fieldnameKey"),"UTF-8");

		LimitFieldDAO limitFieldDAO = (LimitFieldDAO) Container
				.getBean("limitFieldDAO");
		//lstAllSqlx = limitFieldDAO.getAllSqlx();
		List<String> paramlstAllSqlx = CommonUtil.getAllSqlx();
		lstAllSqlx = new ArrayList<LimitField>();
		for (int i = 0 ; i < paramlstAllSqlx.size() ; i++){
			LimitField paramLimitField = new LimitField();
			paramLimitField.setProjecttype(paramlstAllSqlx.get(i));
			lstAllSqlx.add(i, paramLimitField);
		}
		//lstAllNodeid = limitFieldDAO.getAllNodeid();
		List<String> paramlstAllNodeid = CommonUtil.getAllNodeid();
		lstAllNodeid = new ArrayList<LimitField>();
		for (int i = 0 ; i < paramlstAllNodeid.size() ; i++){
			LimitField paramLimitField = new LimitField();
			paramLimitField.setNodeid(paramlstAllNodeid.get(i));
			lstAllNodeid.add(i, paramLimitField);
		}
		
		lstAllFieldname = limitFieldDAO.getAllFieldnameByZDB();
		lstAllTablename = limitFieldDAO.getAllTablenameByZDB();
		
		limitField.setLimitlevel(limitlevel);
		limitField.setProjecttype(projecttype);
		limitField.setMemo(memo);
		limitField.setNodeid(nodeid);
		limitField.setTablename(tablenameKey);
		limitField.setFieldname(fieldnameKey);
		limitField.setFieldname_ch(tablename);
		limitField.setFieldname_ch(fieldname);
		return "INSERT";
	}

	public String insertData() throws Exception {
		HttpServletRequest request = ServletActionContext.getRequest();
		limitField = new LimitField();

		fieldname = new String(request.getParameter("fieldname").getBytes(
				"ISO8859_1"), "GBK");
		projecttype = new String(request.getParameter("projecttype").getBytes(
				"ISO8859_1"), "GBK");
		nodeid = new String(request.getParameter("nodeid")
				.getBytes("ISO8859_1"), "GBK");
		tablename = new String(request.getParameter("tablename").getBytes(
				"ISO8859_1"), "GBK");
		LimitFieldDAO limitFieldDAO = (LimitFieldDAO) Container
				.getBean("limitFieldDAO");
		//lstAllSqlx = limitFieldDAO.getAllSqlx();
		List<String> paramlstAllSqlx = CommonUtil.getAllSqlx();
		lstAllSqlx = new ArrayList<LimitField>();
		for (int i = 0 ; i < paramlstAllSqlx.size() ; i++){
			LimitField paramLimitField = new LimitField();
			paramLimitField.setProjecttype(paramlstAllSqlx.get(i));
			lstAllSqlx.add(i, paramLimitField);
		}
		//lstAllNodeid = limitFieldDAO.getAllNodeid();
		List<String> paramlstAllNodeid = CommonUtil.getAllNodeid();
		lstAllNodeid = new ArrayList<LimitField>();
		for (int i = 0 ; i < paramlstAllNodeid.size() ; i++){
			LimitField paramLimitField = new LimitField();
			paramLimitField.setNodeid(paramlstAllNodeid.get(i));
			lstAllNodeid.add(i, paramLimitField);
		}
		
		lstAllFieldname = limitFieldDAO.getAllFieldnameByZDB();
		lstAllTablename = limitFieldDAO.getAllTablenameByZDB();
		
		limitField.setFieldname(fieldname);
		limitField.setTablename(tablename);
		limitField.setNodeid(nodeid);
		limitField.setProjecttype(projecttype);

		
		Integer maxId = 0;
		List<LimitField> lstAllLimitField = limitFieldDAO.getLimitField();
		for (int i = 0; i < lstAllLimitField.size(); i++) {
			if (lstAllLimitField.get(i).getLimitlevel() >= maxId) {
				maxId = lstAllLimitField.get(i).getLimitlevel();
			}
		}
		limitField.setLimitlevel(maxId + 1);

		return "INSERT";
	}

	public String save() throws Exception {
		//HttpServletRequest request = ServletActionContext.getRequest();
		//opttype = request.getParameter(opttype);
		LimitFieldDAO limitFieldDAO = (LimitFieldDAO) Container
				.getBean("limitFieldDAO");
		//lstAllSqlx = limitFieldDAO.getAllSqlx();
		List<String> paramlstAllSqlx = CommonUtil.getAllSqlx();
		lstAllSqlx = new ArrayList<LimitField>();
		for (int i = 0 ; i < paramlstAllSqlx.size() ; i++){
			LimitField paramLimitField = new LimitField();
			paramLimitField.setProjecttype(paramlstAllSqlx.get(i));
			lstAllSqlx.add(i, paramLimitField);
		}
		//lstAllNodeid = limitFieldDAO.getAllNodeid();
		List<String> paramlstAllNodeid = CommonUtil.getAllNodeid();
		lstAllNodeid = new ArrayList<LimitField>();
		for (int i = 0 ; i < paramlstAllNodeid.size() ; i++){
			LimitField paramLimitField = new LimitField();
			paramLimitField.setNodeid(paramlstAllNodeid.get(i));
			lstAllNodeid.add(i, paramLimitField);
		}
		
		lstAllFieldname = limitFieldDAO.getAllFieldnameByZDB();
		lstAllTablename = limitFieldDAO.getAllTablenameByZDB();
		
		if (opttype.equals("insert")) {
			limitFieldDAO.insertLimitField(limitField);
		}else if (opttype.equals("edit")) {
			limitFieldDAO.updateLimitField(limitField);
		}
		msg = "保存成功!";
		opttype = "edit";
		return "INSERT";
	}

	public String delete() throws Exception {
		HttpServletRequest request = ServletActionContext.getRequest();
		Integer limitlevel = 0;
		limitlevel = Integer.parseInt(request.getParameter("limitlevel"));
		LimitFieldDAO limitFieldDAO = (LimitFieldDAO) Container
				.getBean("limitFieldDAO");
		limitFieldDAO.deleteLimitField(limitlevel);
		return execute();
	}
	
	public String getFieldValueByTableName() throws Exception{
		HttpServletRequest request = ServletActionContext.getRequest();
		//System.out.println(tablename == null?"is Null":tablename);
		String tbName = request.getParameter("tbName").toString();
		
		LimitFieldDAO limitFieldDAO = (LimitFieldDAO)Container.getBean("limitFieldDAO");
		String json = JSONUtil.serialize(limitFieldDAO.getFieldnameByTablename(tbName));
		//System.out.println(json);
		
		ServletActionContext.getResponse().setCharacterEncoding("utf-8");
		ServletActionContext.getResponse().getWriter().write(json);
		ServletActionContext.getResponse().getWriter().close();
		ServletActionContext.getResponse().addHeader("Content-Type", "text/json; charset=utf-8");
		
		return NONE;
	}
	
	public SplitParam getSplitParam() {
		return splitParam;
	}

	public void setSplitParam(SplitParam splitParam) {
		this.splitParam = splitParam;
	}

	public LimitField getLimitField() {
		return limitField;
	}

	public void setLimitField(LimitField limitField) {
		this.limitField = limitField;
	}

	public List<LimitField> getLstAllSqlx() {
		return lstAllSqlx;
	}

	public void setLstAllSqlx(List<LimitField> lstAllSqlx) {
		this.lstAllSqlx = lstAllSqlx;
	}

	public List<LimitField> getLstAllFieldname() {
		return lstAllFieldname;
	}

	public void setLstAllFieldname(List<LimitField> lstAllFieldname) {
		this.lstAllFieldname = lstAllFieldname;
	}

	public List<LimitField> getLstAllNodeid() {
		return lstAllNodeid;
	}

	public void setLstAllNodeid(List<LimitField> lstAllNodeid) {
		this.lstAllNodeid = lstAllNodeid;
	}

	public List<LimitField> getLstAllTablename() {
		return lstAllTablename;
	}

	public void setLstAllTablename(List<LimitField> lstAllTablename) {
		this.lstAllTablename = lstAllTablename;
	}

	public String getFieldname() {
		return fieldname;
	}

	public void setFieldname(String fieldname) {
		this.fieldname = fieldname;
	}

	public String getProjecttype() {
		return projecttype;
	}

	public void setProjecttype(String projecttype) {
		this.projecttype = projecttype;
	}

	public String getNodeid() {
		return nodeid;
	}

	public void setNodeid(String nodeid) {
		this.nodeid = nodeid;
	}

	public String getTablename() {
		return tablename;
	}

	public void setTablename(String tablename) {
		this.tablename = tablename;
	}

	public String getMsg() {
		return msg;
	}

	public void setMsg(String msg) {
		this.msg = msg;
	}
	
	public String getOpttype() {
		return opttype;
	}

	public void setOpttype(String opttype) {
		this.opttype = opttype;
	}

}
