package com.jsegov.tddj.action;

import javax.servlet.http.HttpServletRequest;

import org.apache.struts2.ServletActionContext;

import com.gtis.spring.Container;
import com.jsegov.tddj.platform.IPlatUtil;
import com.jsegov.tddj.services.interf.IDJKService;
import com.jsegov.tddj.services.interf.IGHKService;
import com.jsegov.tddj.services.interf.IGYQDJKService;
import com.jsegov.tddj.services.interf.IGytdsyzService;
import com.jsegov.tddj.services.interf.IJttdsuzService;
import com.jsegov.tddj.services.interf.IJttdsyzService;
import com.jsegov.tddj.services.interf.IProRelationService;
import com.jsegov.tddj.services.interf.IProjectService;
import com.jsegov.tddj.services.interf.ISJDService;
import com.jsegov.tddj.services.interf.ISPBService;
import com.jsegov.tddj.services.interf.ISQBService;
import com.jsegov.tddj.services.interf.ITxqlzmsService;
import com.jsegov.tddj.vo.DJK;
import com.jsegov.tddj.vo.GHK;
import com.jsegov.tddj.vo.GYQDJK;
import com.jsegov.tddj.vo.GYTDSYZ;
import com.jsegov.tddj.vo.JTTDSUZ;
import com.jsegov.tddj.vo.JTTDSYZ;
import com.jsegov.tddj.vo.ProRelation;
import com.jsegov.tddj.vo.Project;
import com.jsegov.tddj.vo.SJD;
import com.jsegov.tddj.vo.SPB;
import com.jsegov.tddj.vo.SQB;
import com.jsegov.tddj.vo.TXQLZMS;
import com.opensymphony.xwork2.ActionSupport;

public class EditAllTDZ extends ActionSupport {

	/**
	 * 
	 */
	private static final long serialVersionUID = 6795208641088217959L;
	private GYTDSYZ gytdsyz = new GYTDSYZ();
	private JTTDSYZ jttdsyz = new JTTDSYZ();
	private TXQLZMS txqlzms = new TXQLZMS();
	private JTTDSUZ jttdsuz = new JTTDSUZ();
	private String zslx = "";
	private String msg = "";

	public String execute() throws Exception {
		HttpServletRequest request = ServletActionContext.getRequest();
		zslx = request.getParameter("zslx");
		String projectId = request.getParameter("projectId");
		if (projectId != null && !projectId.equals("")) {
			if (zslx.equals("gytdsyz")) {
				IGytdsyzService gytdsyzService = (IGytdsyzService) Container
						.getBean("gyTdsyzService");
				gytdsyz = gytdsyzService.getGYTDSYZ(projectId);
			} else if (zslx.equals("jttdsyz")) {
				IJttdsyzService jttdsyzService = (IJttdsyzService) Container
						.getBean("jtTdsyzService");
				jttdsyz = jttdsyzService.getJTTDSYZ(projectId);
			} else if (zslx.equals("txqlzms")) {
				ITxqlzmsService txqlzmsService = (ITxqlzmsService) Container
						.getBean("txqlzmsService");
				txqlzms = txqlzmsService.getTXQLZMS(projectId);
			} else if (zslx.equals("jttdsuz")) {
				IJttdsuzService jttdsuzService = (IJttdsuzService) Container
						.getBean("jtTdsuzService");
				jttdsuz = jttdsuzService.getJTTDSUZ(projectId);
			}
		}
		return zslx;
	}

	public String save() {
		//System.out.println("zslx====" + zslx);
		String qlr="",zl="",djh="",th="",yt="",syqlx="",zzrq="";
		Double syqmj,dymj,ftmj;
		String projectId ="";
		// 修改证书
		if (zslx.equals("gytdsyz")) {
			projectId=gytdsyz.getProjectId();
			if (projectId == null || projectId.equals("")) {
				setMsg("证书数据保存失败！");
				return zslx;
			}
			IGytdsyzService gytdsyzService = (IGytdsyzService) Container.getBean("gyTdsyzService");
			gytdsyzService.updateGYTDSYZ(gytdsyz);
			qlr=gytdsyz.getQlr();
			zl=gytdsyz.getZl();
			djh=gytdsyz.getDjh();
			th=gytdsyz.getTh();
			yt=gytdsyz.getYt();
			syqlx=gytdsyz.getSyqlx();
			zzrq=gytdsyz.getZzrq();
			syqmj=gytdsyz.getSyqmj();
			dymj = gytdsyz.getDymj();
			ftmj = gytdsyz.getFtmj();
			//修改相关表单
			modiSyqRelateSheet(projectId,qlr,zl,djh,th,yt,syqlx,zzrq,syqmj,dymj,ftmj);
		} else if (zslx.equals("jttdsyz")) {
			projectId=jttdsyz.getProjectId();
			if (projectId == null || projectId.equals("")) {
				setMsg("证书数据保存失败！");
				return zslx;
			}
			IJttdsyzService jttdsyzService=(IJttdsyzService)Container.getBean("jtTdsyzService");
			jttdsyzService.updateJTTDSYZ(jttdsyz);
			qlr=jttdsyz.getQlr();
			zl=jttdsyz.getZl();
			djh=jttdsyz.getDjh();
			th=jttdsyz.getTh();
			yt=jttdsyz.getYt();
			syqlx=jttdsyz.getSyqlx();
			zzrq=jttdsyz.getZzrq();
			syqmj=jttdsyz.getSyqmj();
			dymj = jttdsyz.getDymj();
			ftmj = jttdsyz.getFtmj();
			//修改相关表单			
			modiSyqRelateSheet(projectId,qlr,zl,djh,th,yt,syqlx,zzrq,syqmj,dymj,ftmj);
		} else if (zslx.equals("txqlzms")) {
			projectId=txqlzms.getProjectId();
			if (projectId == null || projectId.equals("")) {
				setMsg("证书数据保存失败！");
				return zslx;
			}
			ITxqlzmsService txqlzmsService=(ITxqlzmsService)Container.getBean("txqlzmsService");
			txqlzmsService.updateTXQLZMS(txqlzms);
			qlr=txqlzms.getQlr();
			djh=txqlzms.getDjh();
			String ywr=txqlzms.getYwr();
			String txql=txqlzms.getTxql();
			String sdrq=txqlzms.getSdrq();
			String qlsx=txqlzms.getQlsx();
			String cxqx=txqlzms.getCxqx();
			//修改相关表单			
			modiTxRelateSheet(projectId,qlr,djh,ywr,txql,sdrq,qlsx,cxqx);
		} else if (zslx.equals("jttdsuz")) {

		}
		
		
		setMsg("证书数据保存成功！");
		
		return zslx;
	}
	private void modiSyqRelateSheet(String projectId,String qlr,String zl,String djh,String th,String yt,String syqlx,String zzrq,Double syqmj,Double dymj,Double ftmj){
		//修改项目表	
		IProjectService projectService = (IProjectService) Container.getBean("projectService");
		Project project = projectService.getProject(projectId);
		if(project!=null){
			project.setProjectName(qlr);
			project.setDjh(djh);
			projectService.updateProject(project);
		}
		//修改收件单

		ISJDService sjdService=(ISJDService)Container.getBean("sjdService");
		SJD sjd =sjdService.getSJD(projectId);
		if(sjd!=null){
			sjd.setZl(zl);
			sjdService.updateSJD(sjd);
		}
		//修改申请表

		ISQBService sqbService=(ISQBService)Container.getBean("sqbService");
		SQB sqb=sqbService.getSQB(projectId);
		if(sqb!=null){
			if(sqb.getRf2_dwmc()!=null && !sqb.getRf2_dwmc().equals("")){
				sqb.setRf2_dwmc(qlr);
			}
			else {
				sqb.setRf1_dwmc(qlr);
			}
			sqb.setZl(zl);
			sqb.setDjh(djh);
			sqb.setTh(th);
			sqb.setYt(yt);
			sqb.setSyqlx(syqlx);
			sqb.setZzrq(zzrq);
			//sqb.setTdqlmj(syqmj);
			sqb.setSyqmj(syqmj);
			sqb.setDymj(dymj);
			sqb.setFtmj(ftmj);
			sqbService.updateSQB(sqb);
		}
		//修改审批表

		ISPBService spbService=(ISPBService)Container.getBean("spbService");
		SPB spb=spbService.getSPB(projectId);
		if(spb!=null){
			if(spb.getRf2_dwmc()!=null && !spb.getRf2_dwmc().equals("")){
				spb.setRf2_dwmc(qlr);
			}
			else {
				spb.setRf1_dwmc(qlr);
			}
			spb.setZl(zl);
			spb.setDjh(djh);
			spb.setTh(th);
			spb.setYt(yt);
			spb.setSyqlx(syqlx);
			spb.setZzrq(zzrq);
			//spb.setTdqlmj(syqmj);
			spb.setSyqmj(syqmj);
			spb.setDymj(dymj);
			spb.setFtmj(ftmj);
			spbService.updateSPB(spb);
		}
		//修改登记卡

		IDJKService djkService=(IDJKService)Container.getBean("djkService");
		DJK djk= djkService.getDJK(projectId);
		if(djk!=null){
			djk.setQlr(qlr);
			djk.setZl(zl);
			djk.setDjh(djh);
			djk.setTh(th);
			djk.setYt(yt);
			djk.setSyqlx(syqlx);
			djk.setZzrq(zzrq);
			djkService.updateDJK(djk);
		}
		//修改归户卡

		IGHKService ghkService=(IGHKService)Container.getBean("ghkService");
		GHK ghk=ghkService.getGHK(projectId);
		if(ghk!=null){
			ghk.setQlr(qlr);
			ghk.setDjh(djh);
			ghk.setZl(zl);
			ghk.setTh(th);
			ghk.setYt(yt);
			ghk.setSyqlx(syqlx);
			ghkService.updateGHK(ghk);
		}
		//修改共有权卡
		IGYQDJKService gyqdjkService=(IGYQDJKService)Container.getBean("gyqDjkService");
		GYQDJK gyqdjk=gyqdjkService.getGYQDJK(projectId);
		if(gyqdjk!=null){
			//System.out.println(gyqdjk.getDymj());
			gyqdjk.setQlr(qlr);
			gyqdjk.setDjh(djh);
			gyqdjk.setYt(yt);
			gyqdjkService.updateGYQDJK(gyqdjk);
		}
		//修改项目关系表

		IProRelationService proRelationService=(IProRelationService)Container.getBean("proRelationService");
		ProRelation proRelation=proRelationService.getProRelation(projectId);
		if(proRelation!=null){
			proRelation.setDjh(djh);
			proRelation.setQlr(qlr);
			proRelationService.updateProjectRelation(proRelation);
		}
		//修改平台的项目名称

		IPlatUtil platUtil = (IPlatUtil)Container.getBean("platUtil");
		platUtil.editWorkFlowInstance(projectId, djh+" || "+zl, qlr);
	}
	
	private void modiTxRelateSheet(String projectId,String qlr,String djh,String ywr,String txql,String sdrq,String qlsx,String cxqx){
		//修改项目表	
		IProjectService projectService = (IProjectService) Container.getBean("projectService");
		Project project = projectService.getProject(projectId);
		project.setProjectName(ywr);
		projectService.updateProject(project);
		//修改申请表

		ISQBService sqbService=(ISQBService)Container.getBean("sqbService");
		SQB sqb=sqbService.getSQB(projectId);
		if(sqb!=null){
			sqb.setRf1_dwmc(ywr);
			sqb.setRf2_dwmc(qlr);
			sqb.setTxql(txql);
			sqb.setSdrq(sdrq);
			sqb.setQlsx(qlsx);
			sqb.setCxqx(cxqx);
			sqbService.updateSQB(sqb);
		}
		//修改审批表

		ISPBService spbService=(ISPBService)Container.getBean("spbService");
		SPB spb=spbService.getSPB(projectId);
		if(spb!=null){
			spb.setRf1_dwmc(ywr);
			spb.setRf2_dwmc(qlr);
			spb.setTxql(txql);
			spb.setSdrq(sdrq);
			spb.setQlsx(qlsx);
			spb.setCxqx(cxqx);
			spbService.updateSPB(spb);
		}
		//修改项目关系表

		IProRelationService proRelationService=(IProRelationService)Container.getBean("proRelationService");
		ProRelation proRelation=proRelationService.getProRelation(projectId);
		if(proRelation!=null){
			proRelation.setQlr(qlr);
			proRelationService.updateProjectRelation(proRelation);
		}
		//修改平台的项目名称

		IPlatUtil platUtil = (IPlatUtil)Container.getBean("platUtil");
		platUtil.editWorkFlowInstance(projectId, djh, ywr);
	}
	public GYTDSYZ getGytdsyz() {
		return gytdsyz;
	}

	public void setGytdsyz(GYTDSYZ gytdsyz) {
		this.gytdsyz = gytdsyz;
	}

	public JTTDSYZ getJttdsyz() {
		return jttdsyz;
	}

	public void setJttdsyz(JTTDSYZ jttdsyz) {
		this.jttdsyz = jttdsyz;
	}

	public TXQLZMS getTxqlzms() {
		return txqlzms;
	}

	public void setTxqlzms(TXQLZMS txqlzms) {
		this.txqlzms = txqlzms;
	}

	public JTTDSUZ getJttdsuz() {
		return jttdsuz;
	}

	public void setJttdsuz(JTTDSUZ jttdsuz) {
		this.jttdsuz = jttdsuz;
	}

	public String getZslx() {
		return zslx;
	}

	public void setZslx(String zslx) {
		this.zslx = zslx;
	}

	public String getMsg() {
		return msg;
	}

	public void setMsg(String msg) {
		this.msg = msg;
	}
}
