
package com.jsegov.tddj.action;


import java.io.File;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Enumeration;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts2.ServletActionContext;
import org.apache.struts2.dispatcher.multipart.MultiPartRequestWrapper;
import org.apache.struts2.json.JSONUtil;
import org.apache.tools.zip.ZipEntry;
import org.apache.tools.zip.ZipFile;

import com.gtis.spring.Container;
import com.jsegov.tddj.fileUpload.FileUploadResult;
import com.jsegov.tddj.fileUpload.UploadActivity;
import com.jsegov.tddj.fileUpload.UploadActivityManager;
import com.jsegov.tddj.services.interf.IDataConversionService;
import com.jsegov.tddj.services.interf.IDataImportService;
import com.jsegov.tddj.util.FileUtil;


public class DataImportAction {
	Log log = LogFactory.getLog(this.getClass());
	private String canOverRide; //如果有xzqdm和bgjlh相同的记录是否覆盖,true-覆盖 false-不覆盖

	private IDataImportService dataImportTransService;
	private String actiontype;
	private String message;
	private String uploadId;
	
	public IDataImportService getDataImportTransService() {
		return dataImportTransService;
	}
	public void setDataImportTransService(IDataImportService dataImportTransService) {
		this.dataImportTransService = dataImportTransService;
	}
	public String importData() throws Exception{
		 if ((ServletActionContext.getRequest().getContentType() != null)
				&& ServletActionContext.getRequest().getContentType()
						.startsWith("multipart/form-data")) {
			 
			UploadActivityManager tempUploadActivityManager = UploadActivityManager
					.getInstance();
			tempUploadActivityManager.registerUploadActivity(uploadId,
					UploadActivity.UPLOAD_STATUS_TRANSFER, 0);
			tempUploadActivityManager.writeLog(uploadId, UploadActivityManager.LOG_TYPE_INFO, "文件正在接收!");
			// 进行数据上传server
			FileUploadResult uploadResult = fileUpload();
			
			tempUploadActivityManager.updateUploadActivity(uploadId,
					UploadActivity.UPLOAD_STATUS_TRANSFER, 5, "文件接收完成，准备解压!");
			tempUploadActivityManager.writeLog(uploadId, UploadActivityManager.LOG_TYPE_INFO, "文件接收完成，准备解压!");

			String fileName="";
			String dirPath ="";
			if (uploadResult.getStatus() == FileUploadResult.FILE_UPLOAD_STATUS_ERROR) {
				message = uploadResult.getMessage();
				tempUploadActivityManager.updateUploadActivity(uploadId,
						UploadActivity.UPLOAD_STATUS_FAIL, 5, message);
				tempUploadActivityManager.writeLog(uploadId, UploadActivityManager.LOG_TYPE_ERROR,message);
				message = "文件导入导入失败:"+message;
			}  else {
				
				dirPath = uploadResult.getFilePath();
				fileName = uploadResult.getFileName();
				boolean bOverRide = false;
				if (canOverRide == null || canOverRide.trim().length() == 0) {
					bOverRide = false;
				} else {
					try {
						bOverRide = Boolean.valueOf(canOverRide);
					} catch (Exception ex) {
						ex.printStackTrace();
						bOverRide = true;
					}
				}
				
				

//				Thread.currentThread().sleep(20000);
				String zipPath="";
				try {
					String regionCode =  getRegionCode(uploadId,fileName);
					zipPath=dataImportTransService.importData(regionCode,dirPath, uploadId,
							bOverRide);
				} catch (Exception ex) {
					ex.printStackTrace();
					tempUploadActivityManager.updateUploadActivity(uploadId,
							UploadActivity.UPLOAD_STATUS_FAIL, 100,"文件导入失败:" + ex.getMessage());
					message = "文件导入导入失败:"+ex.getMessage();
				}
				ZipFile zipFile = new ZipFile(new File(dirPath));
				Enumeration enumeration = zipFile.getEntries();
				String flag="flase";
				ZipEntry zipEntry = null;
				Connection con = null;
//				Statement st = null;
//				ResultSet rs = null;
			
				while (enumeration.hasMoreElements()) {
					zipEntry = (ZipEntry) enumeration.nextElement();
					if(zipEntry.getName()!=null && zipEntry.getName().length()>=4){
						if(zipEntry.getName().substring(zipEntry.getName().length()-4, zipEntry.getName().length()).equalsIgnoreCase(".mdb")){
							File loadFile = new File(zipPath +"\\"+ zipEntry.getName());
							String   url="jdbc:odbc:driver={Microsoft Access Driver (*.mdb)};DBQ="+loadFile.getPath();
							try {
								Class.forName("sun.jdbc.odbc.JdbcOdbcDriver");
								con = DriverManager.getConnection(url);  
								DatabaseMetaData meta = con.getMetaData();
								ResultSet rsTables = meta.getTables(null , null, "tbl_project", null);
								if(rsTables.next()){ 
									 IDataConversionService dataConversionService = (IDataConversionService)Container.getBean("dataConversionService");
										message=dataConversionService.dataConvert(loadFile.getPath());
										tempUploadActivityManager.updateUploadActivity(uploadId,
													UploadActivity.UPLOAD_STATUS_FINISH, 100,message);
								 }else{
									 flag="true";
								 } 
								rsTables.close();
								con.close();
							} catch (Exception e){ 
								tempUploadActivityManager.updateUploadActivity(uploadId,
										UploadActivity.UPLOAD_STATUS_FAIL, 100,"导入不是mdb库!" );
									message ="导入不是mdb库!";
							 }
						}
					}
				}
				if(flag!=null && flag.equals("true")){
					FileUtil fileUtil=new FileUtil();
					File zipFile1 = new File(zipPath);
					fileUtil.delFolder(zipFile1.getPath());
					tempUploadActivityManager.updateUploadActivity(uploadId,
						UploadActivity.UPLOAD_STATUS_FAIL, 100,"导入的库结构不对!" );
					message ="导入的库结构不对!";
				}
			}
		}
		return "enter";
	}
	
	public String getRegionCode(String uploadId,String fileName) throws Exception{
		String regionCode = "";
		UploadActivityManager tempUploadActivityManager = UploadActivityManager.getInstance();

		if (fileName == null || fileName.trim().length() == 0){
			tempUploadActivityManager.updateUploadActivity(uploadId,
					UploadActivity.UPLOAD_STATUS_FAIL, 0,"文件名中没有包括行政地区编码，无法导入数据!");
			throw new Exception("文件名中没有包括行政地区编码，无法导入数据!");
		}
		return regionCode;
	}

	
	public String enter() throws Exception{
		message = "";
		if (actiontype==null){
			actiontype =  "";
		}
		return "enter";
	}
	
	
	/**
	 * 
	 * @return
	 * @throws Exception 
	 */
	public String queryProgress() throws Exception{
		UploadActivityManager tempUploadActivityManager = UploadActivityManager.getInstance();
		UploadActivity tempUploadActivity = tempUploadActivityManager.queryUploadActivity(uploadId);
		if (tempUploadActivity == null){
			tempUploadActivity = new UploadActivity();
			tempUploadActivity.setUploadId("0");
			tempUploadActivity.setStatus(UploadActivity.UPLOAD_STATUS_FAIL);
			tempUploadActivity.setMessage("无法获取上载任务的状态，请联系管理员！");
		}
		
		if (tempUploadActivity.getStatus() == UploadActivity.UPLOAD_STATUS_FINISH
				|| tempUploadActivity.getStatus() == UploadActivity.UPLOAD_STATUS_FAIL) {
			//如果已经导入完成或者导入失败，则把日志文件从缓存中输出到文件中。

			createLogFileFromBuffer( uploadId);
//			tempUploadActivityManager.unRegisterUploadActivity(uploadId);
		}
		ServletActionContext.getResponse().setCharacterEncoding("utf-8");
		try {
			ServletActionContext.getResponse().getWriter().write(JSONUtil.serialize(tempUploadActivity));
		} catch (Exception e) {
			e.printStackTrace();
		}
		return null;
	}
	
	
	public void createLogFileFromBuffer(String uploadId) throws Exception{
		UploadActivityManager tempUploadActivityManager = UploadActivityManager.getInstance();
		String logStr = tempUploadActivityManager.getLog(uploadId);
		
	}
	
	
	/**
	 * 实现数据文件上传 返回 boolean 类型数据，表示文件是否上传成功

	 * 
	 */
	public FileUploadResult fileUpload() throws Exception{
	
        MultiPartRequestWrapper multiWrapper = (MultiPartRequestWrapper)ServletActionContext.getRequest(); 
        Enumeration fileParameterNames = multiWrapper.getFileParameterNames();  

        FileUploadResult uploadResult = new FileUploadResult();
        while (fileParameterNames != null && fileParameterNames.hasMoreElements()) {   
            String inputName = (String) fileParameterNames.nextElement();
            String[] contentType = multiWrapper.getContentTypes(inputName); 
            if (contentType!=null && inputName.length() > 0) {   
                String[] fileNames = multiWrapper.getFileNames(inputName); 
                if (fileNames!=null && fileNames.length > 0) {   
                    File[] files = multiWrapper.getFiles(inputName); 
                   
                    if (files != null) {
                        for (int index = 0; index < files.length; index++) {
                        	//System.out.println("hzm:"+getExtension(fileNames[index],"Zip"));
                        	String strtxt = getExtension(fileNames[index],"");
                        	if(!"Zip".equalsIgnoreCase(strtxt)){
                        		uploadResult.setStatus(FileUploadResult.FILE_UPLOAD_STATUS_ERROR);
                        		uploadResult.setMessage("上载文件不是zip文件，请检查后重新上传。");
                        		return uploadResult;
                        	}
                        	else{
                        		//System.out.println("----------filepath="+files[index].getPath());
                            	//System.out.println("----------filename="+fileNames[index]);
                            	uploadResult.setStatus(FileUploadResult.FILE_UPLOAD_STATUS_SUCCESS);
                            	uploadResult.setFilePath(files[index].getPath());
                            	uploadResult.setFileName(fileNames[index]);
                        		return uploadResult;
                        		
                        	}
                        }   
                    }   
                } 
                else{
            		uploadResult.setStatus(FileUploadResult.FILE_UPLOAD_STATUS_ERROR);
            		uploadResult.setMessage("请选取上传文件!");
            		return uploadResult;
                }
            }  
        } 
		uploadResult.setStatus(FileUploadResult.FILE_UPLOAD_STATUS_ERROR);
		uploadResult.setMessage("上传文件出错!");
		return uploadResult;
	}
	//获取扩展名

	public  String getExtension(String filename, String defExt) {
        if ((filename != null) && (filename.length() > 0)) {
            int i = filename.lastIndexOf('.');

            if ((i >-1) && (i < (filename.length() - 1))) {
                return filename.substring(i + 1);
            }
        }
        return defExt;
    }
	public String getCanOverRide() {
		return canOverRide;
	}
	public void setCanOverRide(String canOverRide) {
		this.canOverRide = canOverRide;
	}
	public Log getLog() {
		return log;
	}
	public void setLog(Log log) {
		this.log = log;
	}
	public String getActiontype() {
		return actiontype;
	}
	public void setActiontype(String actiontype) {
		this.actiontype = actiontype;
	}
	public String getMessage() {
		return message;
	}
	public void setMessage(String message) {
		this.message = message;
	}
	public String getUploadId() {
		return uploadId;
	}
	public void setUploadId(String uploadId) {
		this.uploadId = uploadId;
	}
}
