package com.jsegov.tddj.action;

import com.jsegov.tddj.check.CreateTaskCheck;
import com.jsegov.tddj.dao.CFDAO;
import com.jsegov.tddj.services.interf.INewProjectCheckService;
import com.jsegov.tddj.vo.CF;
import com.jsegov.tddj.vo.CheckReturnMsg;
import com.jsegov.tddj.vo.NewProjectCheck;
import com.opensymphony.xwork2.Action;
import org.apache.commons.lang.StringUtils;
import org.apache.struts2.ServletActionContext;
import org.apache.struts2.json.JSONUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Service;

import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * Created by IntelliJ IDEA.
 * User: pyonline
 * Date: 12-4-10
 * Time: 上午11:42
 * To change this template use File | Settings | File Templates.
 */

@Scope("prototype")
@Service
public class CheckAction {

    @Autowired
    INewProjectCheckService newProjectCheckService;
    @Autowired
    CFDAO cfDAO;
    String djlx, wdid, sqlx, djh, tdzh, qlr, tdzl, qsxz;

    /**
     * 在新建项目时，进行相关的检查
     *
     * @return
     * @throws IOException
     */
    public String checkNew() throws IOException {
        try {
            CheckReturnMsg msg = checkNewProject();
            ServletActionContext.getResponse().setCharacterEncoding("utf-8");
            ServletActionContext.getResponse().getWriter().write(JSONUtil.serialize(msg));
        } catch (Exception e) {
            e.printStackTrace();
        }
        return Action.NONE;
    }

    public String checkIsjfLHCF(){
        try{
            CheckReturnMsg msg = new CheckReturnMsg();
            String  checkModel="";
            String  alertMsg ="";
            Integer yisjf=null;
            String ytdzh="";
            String ycflx="";
            String ydjh="";
            List<NewProjectCheck> newProjectCheckList = newProjectCheckService.getNewProjectCheckByDjlx(djlx);
            for (NewProjectCheck newProjectCheck : newProjectCheckList) {

                //获得检查类型的检查代码，提示类型，提示信息
                Integer checkCode = Integer.parseInt(newProjectCheck.getCheckCode());
                if(checkCode==14) {
                    checkModel = newProjectCheck.getCheckModel();
                    alertMsg = newProjectCheck.getAlertMsg();
                    if (StringUtils.isNotBlank(alertMsg)) {
                        alertMsg = alertMsg.replaceAll("#DJH#", djh);
                        alertMsg = alertMsg.replaceAll("#TDZH#", tdzh);
                        alertMsg = alertMsg.replaceAll("#QLR#", qlr);
                        alertMsg = alertMsg.replaceAll("#TDZL#", tdzl);
                    }
                    if(cfDAO.getCF(tdzh)!=null)  {
                        ytdzh=  cfDAO.getCF(tdzh).getTdzh();
                        ycflx =  cfDAO.getCF(tdzh).getCflx();
                        yisjf = cfDAO.getCF(tdzh).getIsjf();
                        ydjh = cfDAO.getCF(tdzh).getDjh();
                    }
                    CF cf = new CF();
                    cf.setIsjf(2);
                    if(ycflx!=null && ycflx.equals("按宗查封"))
                        cf.setDjh(ydjh);
                    else
                        cf.setTdzh(ytdzh);
                    Integer i = (cfDAO.getCF(cf)!=null)?cfDAO.getCF(cf).size():0;
                    if(i>0&&((yisjf!=null&&(yisjf==0||yisjf==3))||yisjf==null)){
                        if(StringUtils.isNotEmpty(alertMsg)) {
                            msg.setReturnMessage(alertMsg);
                        }else{
                            msg.setReturnMessage("本土地证已经被轮候查封了"+i+"次，是否将轮候查封全部解除？");
                        }
                        if (StringUtils.isNotEmpty(checkModel)) {
                            if (StringUtils.equals(checkModel.toUpperCase(), "CONFIRM")) {
                                msg.setCheckModel(CheckReturnMsg.MsgModel.CONFIRM);
                            } else if (StringUtils.equals(checkModel.toUpperCase(), "ALERT")) {
                                msg.setCheckModel(CheckReturnMsg.MsgModel.ALERT);
                            }
                        }else{
                            msg.setCheckModel(CheckReturnMsg.MsgModel.CONFIRM);
                        }
                    }
                    break;
                }
            }
            ServletActionContext.getResponse().setCharacterEncoding("utf-8");
            ServletActionContext.getResponse().getWriter().write(JSONUtil.serialize(msg));
        } catch(Exception e) {
            e.printStackTrace();
        }
        return Action.NONE;
    }

    public String checkIsXCF(){
        try{
            CheckReturnMsg msg = new CheckReturnMsg();
            String  checkModel="";
            String  alertMsg ="";
            List<NewProjectCheck> newProjectCheckList = newProjectCheckService.getNewProjectCheckByDjlx(djlx);
            for (NewProjectCheck newProjectCheck : newProjectCheckList) {

                //获得检查类型的检查代码，提示类型，提示信息
                Integer checkCode = Integer.parseInt(newProjectCheck.getCheckCode());
                if(checkCode==15) {
                    checkModel = newProjectCheck.getCheckModel();
                    alertMsg = newProjectCheck.getAlertMsg();
                    if (StringUtils.isNotBlank(alertMsg)) {
                        alertMsg = alertMsg.replaceAll("#DJH#", djh);
                        alertMsg = alertMsg.replaceAll("#TDZH#", tdzh);
                        alertMsg = alertMsg.replaceAll("#QLR#", qlr);
                        alertMsg = alertMsg.replaceAll("#TDZL#", tdzl);
                    }
                    CF cf = new CF();
                    cf.setIsjf(0);
                    cf.setTdzh(tdzh);
                    cf.setDjh(djh);
                    cf.setZl(tdzl);
                    cf.setBzxr(qlr);
                    Integer i = (cfDAO.CfListByTdzs(cf)!=null)?cfDAO.CfListByTdzs(cf).size():0;
                    if(i>0){
                        if(StringUtils.isNotEmpty(alertMsg)) {
                            msg.setReturnMessage(alertMsg);
                        }else{
                            msg.setReturnMessage("本土地证已被查封，是否进行续查封？");
                        }
                        if (StringUtils.isNotEmpty(checkModel)) {
                            if (StringUtils.equals(checkModel.toUpperCase(), "CONFIRM")) {
                                msg.setCheckModel(CheckReturnMsg.MsgModel.CONFIRM);
                            } else if (StringUtils.equals(checkModel.toUpperCase(), "ALERT")) {
                                msg.setCheckModel(CheckReturnMsg.MsgModel.ALERT);
                            }
                        }else{
                            msg.setCheckModel(CheckReturnMsg.MsgModel.CONFIRM);
                        }
                    }
                    break;
                }
            }
            ServletActionContext.getResponse().setCharacterEncoding("utf-8");
            ServletActionContext.getResponse().getWriter().write(JSONUtil.serialize(msg));
        } catch(Exception e) {
            e.printStackTrace();
        }
        return Action.NONE;
    }
    private CheckReturnMsg checkNewProject() {
        CheckReturnMsg msg = new CheckReturnMsg();

        String checkModel = "";
        String alertMsg = "";

        Map params = new HashMap();
        params.put("djlx", djlx);
        params.put("tdzl", tdzl);
        params.put("djh", djh);
        params.put("tdzh", tdzh);
        params.put("qlr", qlr);
        params.put("qsxz", qsxz);
        params.put("sqlx", sqlx);
        params.put("checkCode", 0);

        List<NewProjectCheck> newProjectCheckList = newProjectCheckService.getNewProjectCheckByDjlx(djlx);
        List returnMsgList = new ArrayList();
        for (NewProjectCheck newProjectCheck : newProjectCheckList) {

            //获得检查类型的检查代码，提示类型，提示信息
            Integer checkCode = Integer.parseInt(newProjectCheck.getCheckCode());
            checkModel = newProjectCheck.getCheckModel();
//            System.out.println(checkModel);

            //获得数据库中默认的提示信息
            alertMsg = newProjectCheck.getAlertMsg();

            if (StringUtils.isNotBlank(alertMsg)) {
                alertMsg = alertMsg.replaceAll("#DJH#", djh);
                alertMsg = alertMsg.replaceAll("#TDZH#", tdzh);
                alertMsg = alertMsg.replaceAll("#QLR#", qlr);
                alertMsg = alertMsg.replaceAll("#TDZL#", tdzl);
            }

            //将检查代码也作为参数传给检查逻辑
            params.remove("checkCode");
            params.put("checkCode", checkCode);

            CreateTaskCheck checkFn = newProjectCheckService.getCheckFn(checkCode);

            //确保代码都有对应的处理类
            if (checkFn != null) {
                //获得检查后返回的参数
                CheckReturnMsg checkMsg = checkFn.run(params);
                //如果检查没有通过，如果数据库中有定义提示信息，则使用数据库中的，如果没有则使用代码的
                if (checkMsg != null && StringUtils.isNotBlank(checkMsg.getReturnMessage())) {
                    msg.setReturnMessage(checkMsg.getReturnMessage());
                    if(StringUtils.isNotBlank(alertMsg)){
                        returnMsgList.add(alertMsg);
                    }else if (StringUtils.isNotBlank(checkMsg.getAlertMsg())){
                        returnMsgList.add(checkMsg.getAlertMsg());
                    } else{
                        break;
                    }
                    msg.setReturnMessageList(returnMsgList);
//                    msg.setReturnMessage(alertMsg);
                    if (StringUtils.isNotEmpty(checkModel)) {
                        if (StringUtils.equals(checkModel.toUpperCase(), "CONFIRM")) {
                            msg.setCheckModel(CheckReturnMsg.MsgModel.CONFIRM);
                        } else if (StringUtils.equals(checkModel.toUpperCase(), "ALERT")) {
                            msg.setCheckModel(CheckReturnMsg.MsgModel.ALERT);
                            returnMsgList.clear();
                            returnMsgList.add(alertMsg);
                            break;
                        }
                    } else if (checkMsg.getCheckModel().toString().toUpperCase().equals("CONFIRM")) {
                        msg.setCheckModel(CheckReturnMsg.MsgModel.CONFIRM);
                    } else if (checkMsg.getCheckModel().toString().toUpperCase().equals("ALERT")) {
                        msg.setCheckModel(CheckReturnMsg.MsgModel.ALERT);
                        returnMsgList.clear();
                        returnMsgList.add(alertMsg);
                        break;
                    }
                }
            }
        }

        //如果提示信息不存在，就返回Null
        return msg;
    }

    public void setDjlx(String djlx) {
        this.djlx = djlx;
    }

    public void setWdid(String wdid) {
        this.wdid = wdid;
    }

    public void setSqlx(String sqlx) {
        this.sqlx = sqlx;
    }

    public void setDjh(String djh) {
        this.djh = djh;
    }

    public void setTdzh(String tdzh) {
        this.tdzh = tdzh;
    }

    public void setQlr(String qlr) {
        this.qlr = qlr;
    }

    public void setTdzl(String tdzl) {
        this.tdzl = tdzl;
    }

    public void setQsxz(String qsxz) {
        this.qsxz = qsxz;
    }

}
