package com.jsegov.fy.util;

import java.util.Date;

import org.apache.cxf.endpoint.Client;
import org.apache.cxf.jaxws.endpoint.dynamic.JaxWsDynamicClientFactory;
import org.apache.cxf.transport.http.HTTPConduit;
import org.apache.cxf.transports.http.configuration.HTTPClientPolicy;
import org.jfree.util.Log;

import com.jsegov.tddj.util.CommonUtil;


/**
 * @author zx
 * @Description: WebService客户端通用类
 */
public class WebServiceClientHelper {
	/**
	 * @Title: callService
	 * @Description: 调用远程的webservice并返回数据
	 * @param wsUrl
	 *            ws地址
	 * @param method
	 *            调用的ws方法名
	 * @param arg
	 *            参数
	 * @return
	 * @return：String
	 * @throws
	 */
	public static final int CXF_CLIENT_TIME_OUT = 60 * 60 * 1000;  
	
	public static StringBuffer callService(String wsUrl, String method, Object... arg) {
		System.out.println((CommonUtil.formateDate(new Date())+"开始调用"+wsUrl));
		if(arg!=null)
			System.out.println("参数"+arg.toString());
		JaxWsDynamicClientFactory dcf = JaxWsDynamicClientFactory.newInstance();
		Client client = dcf.createClient(wsUrl);
		 //设置超时单位为毫秒  
	    HTTPConduit conduit = (HTTPConduit) client.getConduit();     
        HTTPClientPolicy policy = new HTTPClientPolicy();     
        policy.setConnectionTimeout(CXF_CLIENT_TIME_OUT);     
        policy.setReceiveTimeout(CXF_CLIENT_TIME_OUT);     
        conduit.setClient(policy);   
        StringBuffer resultMsg=new StringBuffer();
		Object[] res = null;
		try {
			res = client.invoke(method, arg);
		} catch (Exception e) {
//			e.printStackTrace();
			Log.error(CommonUtil.formateDate(new Date())+"调用"+wsUrl+"失败！",e);
		}
		if(res!=null && res.length>0)
			resultMsg.append(res[0].toString());
		return resultMsg;
	}
}
