package cn.gtmap.exchange.cxf.util;

import java.util.List;

import com.gtis.spring.Container;
import com.jsegov.tddj.services.interf.IJttdsuzService;
import com.jsegov.tddj.services.interf.ITDZJSService;
import com.jsegov.tddj.vo.JTTDSUZ;
import com.jsegov.tddj.vo.TDZJS;

public class PrintJttdsuz {
	public static String getPrintXML(String projectId){
		IJttdsuzService jttdsuzService=(IJttdsuzService)Container.getBean("jtTdsuzService");
		JTTDSUZ jttdsuzVo=jttdsuzService.getJTTDSUZ(projectId);
		//获取省级编号
		String djbh = CommonUtil.getdjbhById(projectId);
		if(jttdsuzVo!=null){
			jttdsuzVo.setDjbhpic(djbh);
		}
		String dataXML= CommonUtil.getZSDataXML(jttdsuzVo);
		
		ITDZJSService tdzjsService=(ITDZJSService)Container.getBean("tdzJsService");
		List<TDZJS>  tdzjsList= tdzjsService.getTDZJSByTdzProjectId(jttdsuzVo.getProjectId());
        for(TDZJS tdzjs : tdzjsList){
            tdzjs.setTdzh(jttdsuzVo.getTdzh());
        }
		String detailXML=CommonUtil.getDetailXML(tdzjsList, "TDZJS");
		
		StringBuffer sb = new StringBuffer();
		sb.append(dataXML);
		sb.append(detailXML);
		return sb.toString();
	} 
}
