<@com.proList import="ext,jquery">
<div id="top">

</div>
    <@com.mainbox></@com.mainbox>

<script type="text/javascript">
var type = '${type}', store, gridPanel;

Ext.onReady(function () {
    Ext.QuickTips.init();

    store = new Ext.data.Store({
        pageSize:20,
        model:'baseBtModel',
        proxy:{
            type:'ajax',
            url:'batch!list.action?type=${type}',
            reader:{
                type:'json',
                root:'items',
                totalProperty:'totalCount'
            }
        },
        autoLoad:true
    });

    gridPanel = new Ext.grid.Panel({
        title:"批次列表",
        height:400,
        store:store,
        stateful:true,
        multiSelect:false,
        columns:[
                <#assign gridShowFields = gridShowFields>
                <#list gridShowFields as field>
                    {text:'${field.title}',dataIndex:'${field.name}',width:200}<#if field_has_next>,</#if>
                </#list>
        ],
        selModel:new Ext.selection.CheckboxModel({mode:'SINGLE'}),
        renderTo:'main_box_content',
        viewConfig:{
            stripeRows:true
        },
        dockedItems:[
            {
                xtype:'toolbar',
                id:'gpToolBar',
                items:[
                    {
                        text:"批次详细信息",
                        iconCls:"ex_detail",
                        handler:function () {
                            openBartchInfo();
                        }
                    },
                    {
                        text:"进入项目列表",
                        iconCls:"ex_prolist",
                        handler:function () {
                            openProList();
                        }
                    },
                    {
                        text:"项目统计",
                        iconCls:"ex_static",
                        handler:function () {
                            openStatistics();
                        }

                    },
                    '-',
                    {
                        xtype:'textfield',
                        name:'searchField',
                        hideLabel:true,
                        width:130,
                        listeners:{
                            change:function () {
                                onSearch(gridPanel);
                            }
                        }
                    },
                    {
                        xtype:'button',
                        text:'条件检索',
                        iconCls:'ex_search',
                        handler:function (e) {
                            onAddCondition(e);
                        }
                    }
                ]
            },
            {
                xtype:'pagingtoolbar',
                pageSize:20,
                store:store,
                dock:'bottom',
                displayInfo:true,
                displayMsg:'{0}-{1}共{2}条',
                emptyMsg:"尚未检测到数据"
            }
        ],
        listeners:{
            itemdblclick:function (grid, item, row) {
                debugger;
                openProList(item.get('id'));
            }
        }

    });

});


/**
 *  获取grid选择项
 */
function getSelection() {
    var selRow = gridPanel.getSelectionModel().getSelection();
    if(selRow.length == 0){
        Ext.MessageBox.show({
            title:'提示',
            msg:'请先选择某一项',
            buttons:Ext.MessageBox.OK
        });
    }
   else if(selRow.length > 1){
        Ext.Msg.show({title:"\u7cfb\u7edf\u63d0\u793a", msg:"只能选择一条记录!", buttons:Ext.MessageBox.OK, icon:Ext.MessageBox.INFO});
    }
    else{
        return selRow[0];
    }

}

/**
 * 打开批次相关信息
 * @param id
 */
function openBartchInfo() {
    var item = getSelection();
    var id = item.get('id');
    window.open('batch!detail.action?type=${type!}&id=' + id, "_blank");

}

/**
 * 打开批次相关的项目列表
 * @param id
 */
function openProList() {
    var item = getSelection();
    var id = item.get('id');
    window.open('pro.action?type=${proType}&id=' + id, "_blank");
}
/**
 * 查看项目的统计信息
 */
function openStatistics() {
    selectFcpWin.show();
}
var selectFcpWin = Ext.create('Ext.window.Window',{
    title:'选择年份、单位',
    modal:true,
    closable:true,
    closeAction:'hide',
    width:250,
    height:160,
    items:[{
        xtype:'combo',
        fieldLabel:'开始年份',
        labelWidth:60,
        width:200,
        padding:'5,10,5,0',
        id:'startyear',
        store:new Ext.data.SimpleStore({
            fields:['year'],
            data:[['2001'],['2002'],['2003'],['2004'],['2005'],['2006'],['2007'],['2008'],['2009'],['2010'],['2011'],['2012'],['2013'],['2014'],['2015'],['2016'],['2017'],['2018'],['2019'],['2020']]
        }),
        displayField:'year',
        queryMode:'local',
        value:'2011',
        valueField:'year'
    }, {
        xtype:'combo',
        fieldLabel:'结束年份',
        labelWidth:60,
        width:200,
        padding:'5,10,5,0',
        id:'endyear',
        store:new Ext.data.SimpleStore({
            fields:['year'],
            data:[['2001'],['2002'],['2003'],['2004'],['2005'],['2006'],['2007'],['2008'],['2009'],['2010'],['2011'],['2012'],['2013'],['2014'],['2015'],['2016'],['2017'],['2018'],['2019'],['2020']]
        }),
        displayField:'year',
        queryMode:'local',
        value:'2012',
        valueField:'year'
    },{
        xtype:'combo',
        fieldLabel:'单位',
        labelWidth:60,
        width:200,
        padding:'5,10,5,0',
        id:'unit',
        store:new Ext.data.SimpleStore({
            fields:['unit'],
            data:[['国务院'],['省厅'],['太原市'],['晋源区'],['尖草坪区'],['万柏林区'],['杏花岭区'],['迎泽区'],['小店区']]
        }),
        displayField:'unit',
        queryMode:'local',
        valueField:'unit'

    }],
    bbar:['->',{
        text:'确定',
        handler:function(){
            var starttime = Ext.getCmp('startyear').getValue();
            var endtime = Ext.getCmp('endyear').getValue();
            var unit = encodeURI(Ext.getCmp('unit').getValue());
            window.open('pro!statisticsInfo.action?type=${proType}' + '&starttime=' +starttime + '&endtime='+endtime+'&unit=' + unit,"_blank");
            selectFcpWin.close();

        }

    },{
        text:'取消',
        handler:function(){
            selectFcpWin.close();

        }
    }]

});

/**
 *
 * @type {*}
 */
var fieldsStore = Ext.create('gtis.store.FieldStore', {
    url:'batch!fields.action?type=${type}'
});

var selectedStore = Ext.create('gtis.store.SelectedFStore', {});

var leftGrid = Ext.create('gtis.panel.LeftDragPanel', {store:fieldsStore});

var rightDrop = Ext.create('gtis.panel.RightDropPanel', {store:selectedStore});


$(function () {
        debugger;
       <#--var showFields = ${showFields};-->
})

</script>
</@com.proList>