/*
 * Decompiled with CFR 0.152.
 */
package com.gtis.sams.web.admin;

import com.alibaba.fastjson.JSON;
import com.gtis.plat.service.SysUserService;
import com.gtis.sams.core.web.BaseAction;
import com.gtis.sams.services.PermissionService;
import com.gtis.sams.vo.LitePerm;
import com.gtis.sams.vo.Permission;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

public class PermissionAction
extends BaseAction {
    @Autowired
    private SysUserService userService;
    @Autowired
    private PermissionService permissionService;
    private String resKey;
    private String roleId;
    private String operation;
    private List<LitePerm> perms;

    public String execute() throws Exception {
        return super.execute();
    }

    public String save() throws IOException {
        try {
            ArrayList<Permission> permissions = new ArrayList<Permission>();
            for (LitePerm perm : this.perms) {
                if (perm == null || perm.getPerms() == null) continue;
                for (String operation : perm.getPerms()) {
                    if (StringUtils.isNotBlank((String)operation)) {
                        Permission permission = new Permission(perm.getKey(), this.roleId, operation);
                        if (this.permissionService.hasPermission(perm.getKey(), this.roleId, operation)) continue;
                        permissions.add(permission);
                        continue;
                    }
                    List granted = this.permissionService.getPermissions(perm.getKey(), this.roleId);
                    this.permissionService.revoke(granted.toArray(new Permission[0]));
                }
            }
            this.permissionService.grant(permissions.toArray(new Permission[0]));
        }
        catch (Exception e) {
            this.logger.error("\u6388\u6743\u4fdd\u5b58\u5f02\u5e38\u3010{}\u3011", (Object)e.getLocalizedMessage());
            this.sendError("\u6388\u6743\u4fdd\u5b58\u5f02\u5e38" + e.getLocalizedMessage());
            return null;
        }
        this.sendOk("OK");
        return null;
    }

    public String insSave() {
        return null;
    }

    public String roleList() throws IOException {
        List roleVos = this.userService.getRoleList();
        this.sendJson((Object)roleVos);
        return null;
    }

    public String getRolePerms() throws IOException {
        List permissions = this.permissionService.getPermissions(null, this.roleId);
        this.sendJson((Object)(permissions != null ? permissions : new ArrayList()));
        return null;
    }

    public String getRoleId() {
        return this.roleId;
    }

    public void setRoleId(String roleId) {
        this.roleId = roleId;
    }

    public void setPermJson(String perm) {
        if (StringUtils.isBlank((String)perm)) {
            return;
        }
        try {
            this.perms = JSON.parseArray((String)perm, LitePerm.class);
        }
        catch (Exception e) {
            this.logger.error("\u89e3\u6790\u6388\u6743JSON\u5f02\u5e38\u3010{}\u3011", (Object)e.getLocalizedMessage());
        }
    }

    public void setResKey(String resKey) {
        this.resKey = resKey;
    }

    public void setOperation(String operation) {
        this.operation = operation;
    }
}

