/*
 * Decompiled with CFR 0.152.
 */
package com.gtis.sams.web;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.gtis.config.AppConfig;
import com.gtis.sams.core.service.ModelService;
import com.gtis.sams.core.web.BaseAction;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletOutputStream;
import jxl.Workbook;
import jxl.write.Label;
import jxl.write.Number;
import jxl.write.WritableCell;
import jxl.write.WritableSheet;
import jxl.write.WritableWorkbook;
import org.apache.struts2.ServletActionContext;
import org.springframework.beans.factory.annotation.Autowired;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MapAction
extends BaseAction {
    @Autowired
    private ModelService modelService;
    protected String resultStr;
    public List<Map> analysisData;
    protected String type;

    public String analysis() {
        return "analysis";
    }

    public List<Map> getAnalysisData() {
        this.analysisData = new ArrayList();
        Map map = ServletActionContext.getRequest().getParameterMap();
        try {
            this.resultStr = URLDecoder.decode(((String[])map.get("analysisresult"))[0], "UTF-8");
            JSONArray resultJson = JSON.parseArray((String)this.resultStr);
            List fields = this.getAnalysisFields();
            for (int i = 0; i < resultJson.size(); ++i) {
                HashMap<String, Object> analysisMap = new HashMap<String, Object>();
                JSONObject temp = resultJson.getJSONObject(i);
                for (int j = 0; j < fields.size(); ++j) {
                    String field = (String)((Map)fields.get(j)).get("field");
                    analysisMap.put(field, temp.get((Object)field));
                }
                this.analysisData.add(analysisMap);
            }
        }
        catch (Exception e) {
            this.logger.error(e.toString());
        }
        return this.analysisData;
    }

    public List<Map> getAnalysisData(String str) {
        this.analysisData = new ArrayList();
        try {
            JSONArray resultJson = JSON.parseArray((String)str);
            List fields = this.getAnalysisFields();
            for (int i = 0; i < resultJson.size(); ++i) {
                HashMap<String, Object> analysisMap = new HashMap<String, Object>();
                JSONObject temp = resultJson.getJSONObject(i);
                for (int j = 0; j < fields.size(); ++j) {
                    String field = (String)((Map)fields.get(j)).get("field");
                    analysisMap.put(field, temp.get((Object)field));
                }
                this.analysisData.add(analysisMap);
            }
        }
        catch (Exception e) {
            this.logger.error(e.toString());
        }
        return this.analysisData;
    }

    public List<Map<String, Object>> getAnalysisFields() {
        return this.modelService.getShowFields(this.type, ModelService.Type.ANALYSIS);
    }

    public String exportExcel() throws Exception {
        String jsonStr = ((String[])ServletActionContext.getRequest().getParameterMap().get("param"))[0];
        List fields = this.getAnalysisFields();
        List analysisData = this.getAnalysisData(jsonStr);
        ServletActionContext.getResponse().setContentType("application/vnd.ms-excel");
        String fileName = "\u9879\u76ee\u5206\u6790\u62a5\u8868.xls";
        ServletActionContext.getResponse().setHeader("Content-Disposition", "attachment;filename=" + URLEncoder.encode(fileName, "UTF-8"));
        try {
            int i;
            ServletOutputStream os = ServletActionContext.getResponse().getOutputStream();
            WritableWorkbook wb = Workbook.createWorkbook((OutputStream)os);
            WritableSheet ws = wb.createSheet("\u9879\u76ee\u5206\u6790\u4fe1\u606f", 0);
            ws.addCell((WritableCell)new Label(0, 0, "\u5e8f\u53f7"));
            for (i = 0; i < fields.size(); ++i) {
                ws.addCell((WritableCell)new Label(i + 1, 0, (String)((Map)fields.get(i)).get("title")));
            }
            for (i = 0; i < analysisData.size(); ++i) {
                Map pro = (Map)analysisData.get(i);
                ws.addCell((WritableCell)new Number(0, i + 1, (double)(i + 1)));
                for (int j = 0; j < fields.size(); ++j) {
                    Map field = (Map)fields.get(j);
                    ws.addCell((WritableCell)new Label(j + 1, i + 1, this.objectToString(pro.get(field.get("field")))));
                }
            }
            wb.write();
            wb.close();
            os.close();
        }
        catch (Exception e) {
            this.logger.error("\u5bfc\u51faexcel\u8868\u51fa\u9519\uff01", (Object)e.getLocalizedMessage());
            this.logger.error("\u9519\u8bef\u8be6\u7ec6\uff1a" + e.toString());
        }
        return null;
    }

    public String objectToString(Object obj) {
        if (obj == null) {
            return "";
        }
        if (obj instanceof Integer) {
            return String.valueOf(obj);
        }
        if (obj instanceof Double) {
            return String.valueOf(obj);
        }
        return obj.toString();
    }

    public String mapConfig() throws IOException {
        if (AppConfig.getProperty((String)"basemap.url") == null) {
            this.logger.error("[{}]\u672a\u914d\u7f6e\uff0c\u67e5\u770b\u914d\u7f6e\u6587\u4ef6\u662f\u5426\u540c\u6b65\u66f4\u65b0!", (Object)"basemap.url");
            return null;
        }
        HashMap<String, String> config = new HashMap<String, String>();
        config.put("url", AppConfig.getProperty((String)"basemap.url"));
        config.put("type", AppConfig.getProperty((String)"basemap.type"));
        this.sendJson(config);
        return null;
    }

    public String getResultStr() {
        return this.resultStr;
    }

    public void setResultStr(String resultStr) {
        this.resultStr = resultStr;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }
}

