/*
 * Decompiled with CFR 0.152.
 */
package com.gtis.sams.utils;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Exception performing whole class analysis ignored.
 */
public class ClassUtils {
    public static final Object getFieldValue(Object owner, String fieldName) throws NoSuchFieldException, IllegalAccessException {
        Field field = ClassUtils.getField(owner.getClass(), (String)fieldName);
        field.setAccessible(true);
        return field.get(owner);
    }

    public static final Field getField(Class clazz, String fieldName) throws NoSuchFieldException {
        try {
            return clazz.getDeclaredField(fieldName);
        }
        catch (NoSuchFieldException ex) {
            Class superClazz = clazz.getSuperclass();
            if (superClazz != null) {
                return ClassUtils.getField(superClazz, (String)fieldName);
            }
            throw ex;
        }
    }

    public static final Map<String, Object> fieldsToMap(Object entity) throws NoSuchFieldException, IllegalAccessException {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        List fields = ClassUtils.getAllDeclaredFields(entity.getClass());
        for (Field field : fields) {
            String fName = field.getName();
            field.setAccessible(true);
            map.put(fName, field.get(entity));
        }
        return map;
    }

    public static final List<Field> getAllDeclaredFields(Class clazz) {
        List pField;
        ArrayList<Field> fields = new ArrayList<Field>(Arrays.asList(clazz.getDeclaredFields()));
        if (clazz.getSuperclass() != null && (pField = ClassUtils.getAllDeclaredFields(clazz.getSuperclass())).size() > 0) {
            fields.addAll(pField);
        }
        return fields;
    }
}

