/*
 * Decompiled with CFR 0.152.
 */
package com.gtis.sams.services.impl;

import com.gtis.sams.services.GeoService;
import com.gtis.sams.utils.AppPropertyUtils;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.io.ParseException;
import com.vividsolutions.jts.io.WKTReader;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class GeoServiceImpl
implements GeoService {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    private WKTReader wktReader;

    public Geometry parseWtkCoords(String coords) throws ParseException {
        return this.getWktReader().read(coords);
    }

    public String transform2GtCoordsFromat(Geometry geometry) {
        String resultStr = "";
        if (geometry instanceof Polygon) {
            resultStr = this.polygon2String((Polygon)geometry);
            System.out.println(resultStr);
        } else if (geometry instanceof MultiPolygon) {
            int polygonNum = geometry.getNumGeometries();
            for (int i = 0; i < polygonNum; ++i) {
                Polygon p = (Polygon)geometry.getGeometryN(i);
                resultStr = resultStr + this.polygon2String(p);
            }
            System.out.println(resultStr);
        } else if (geometry instanceof GeometryCollection) {
            int geometryNum = geometry.getNumGeometries();
            for (int i = 0; i < geometryNum; ++i) {
                String geomType = geometry.getGeometryN(i).getGeometryType();
                if (geomType.equals("Point")) {
                    Coordinate[] points = geometry.getGeometryN(i).getCoordinates();
                    for (int j = 0; j < points.length; ++j) {
                        resultStr = resultStr + String.valueOf(j + 1) + "," + String.valueOf(points[j].x) + "," + String.valueOf(points[j].y) + "\r\n";
                    }
                    System.out.println(resultStr);
                    continue;
                }
                if (geomType.equals("LineString")) {
                    Coordinate[] coordinates = geometry.getGeometryN(i).getCoordinates();
                    for (int m = 0; m < coordinates.length; ++m) {
                        resultStr = resultStr + String.valueOf(m + 1) + "," + String.valueOf(coordinates[m].x) + "," + String.valueOf(coordinates[m].y) + "\r\n";
                    }
                    System.out.println(resultStr);
                    continue;
                }
                if (!geomType.equals("Polygon")) continue;
                resultStr = resultStr + this.polygon2String((Polygon)geometry.getGeometryN(i));
            }
        }
        return resultStr;
    }

    public List coordsToList(Geometry geometry) {
        List result;
        block5: {
            block6: {
                block4: {
                    result = new ArrayList();
                    if (!(geometry instanceof Polygon)) break block4;
                    result = this.polygon2List((Polygon)geometry);
                    break block5;
                }
                if (!(geometry instanceof MultiPolygon)) break block6;
                int polygonNum = geometry.getNumGeometries();
                for (int i = 0; i < polygonNum; ++i) {
                    Polygon p = (Polygon)geometry.getGeometryN(i);
                    List temp = this.polygon2List(p);
                    for (int k = 0; k < temp.size(); ++k) {
                        result.add(temp.get(k));
                    }
                }
                break block5;
            }
            if (!(geometry instanceof GeometryCollection)) break block5;
            int geometryNum = geometry.getNumGeometries();
            for (int j = 0; j < geometryNum; ++j) {
                String gemType = geometry.getGeometryN(j).getGeometryType();
                if (gemType.equals("Polygon")) {
                    result.add(this.coordsToList(geometry.getGeometryN(j)));
                    continue;
                }
                if (!gemType.equals("MultiPolygon")) continue;
                result.add(this.coordsToList(geometry.getGeometryN(j)));
            }
        }
        return result;
    }

    public List polygon2List(Polygon polygon) {
        NumberFormat numberFormat = NumberFormat.getInstance();
        numberFormat.setGroupingUsed(false);
        numberFormat.setMinimumFractionDigits(7);
        numberFormat.setMaximumFractionDigits(9);
        ArrayList result = new ArrayList();
        int ringNum = polygon.getNumInteriorRing() + 1;
        Coordinate[] exteriorRingString = polygon.getExteriorRing().getCoordinates();
        ArrayList exList = new ArrayList();
        ArrayList inList = new ArrayList();
        for (int i = 0; i < exteriorRingString.length; ++i) {
            ArrayList<String> tempList = new ArrayList<String>();
            tempList.add(numberFormat.format(exteriorRingString[i].x - this.getOffsetX()));
            tempList.add(numberFormat.format(exteriorRingString[i].y));
            exList.add(tempList);
        }
        for (int m = 0; m < ringNum - 1; ++m) {
            Coordinate[] temp = polygon.getInteriorRingN(m).getCoordinates();
            ArrayList tempInList = new ArrayList();
            for (int n = 0; n < temp.length; ++n) {
                ArrayList<String> tempXYList = new ArrayList<String>();
                tempXYList.add(numberFormat.format(temp[m].x - this.getOffsetX()));
                tempXYList.add(numberFormat.format(temp[m].y));
                tempInList.add(tempXYList);
            }
            inList.add(tempInList);
        }
        if (exList.size() > 0) {
            result.add(exList);
        }
        if (inList.size() > 0) {
            for (int k = 0; k < inList.size(); ++k) {
                result.add(inList.get(k));
            }
        }
        return result;
    }

    private String polygon2String(Polygon polygon) {
        NumberFormat numberFormat = NumberFormat.getInstance();
        numberFormat.setGroupingUsed(false);
        numberFormat.setMinimumFractionDigits(7);
        numberFormat.setMaximumFractionDigits(9);
        String resultStr = "";
        int ringNum = polygon.getNumInteriorRing() + 1;
        Coordinate[] exteriorRingString = polygon.getExteriorRing().getCoordinates();
        for (int i = 0; i < exteriorRingString.length - 1; ++i) {
            resultStr = resultStr + numberFormat.format(exteriorRingString[i].x) + "," + numberFormat.format(exteriorRingString[i].y);
            resultStr = i + 2 == exteriorRingString.length ? resultStr + ";" : resultStr + ",";
        }
        for (int m = 0; m < ringNum - 1; ++m) {
            Coordinate[] temp = polygon.getInteriorRingN(m).getCoordinates();
            resultStr = resultStr + this.coordinates2String(temp);
        }
        return resultStr;
    }

    private String coordinates2String(Coordinate[] coord) {
        String resultStr = "";
        for (int i = 0; i < coord.length - 1; ++i) {
            resultStr = resultStr + String.valueOf(coord[i].x) + "," + String.valueOf(coord[i].y);
            resultStr = i + 2 == coord.length ? resultStr + ";" : resultStr + ",";
        }
        return resultStr;
    }

    public WKTReader getWktReader() {
        if (this.wktReader == null) {
            this.wktReader = new WKTReader();
        }
        return this.wktReader;
    }

    public double getOffsetX() {
        double offsetX = 0.0;
        if (AppPropertyUtils.getAppEnv((String)"map.coords.offset.x") == null) {
            this.logger.error("[{}]\u672a\u914d\u7f6e\uff0c\u67e5\u770b\u914d\u7f6e\u6587\u4ef6\u662f\u5426\u540c\u6b65\u66f4\u65b0!", (Object)"map.coords.offset.x");
        } else {
            offsetX = Double.parseDouble(AppPropertyUtils.getAppEnv((String)"map.coords.offset.x").toString());
        }
        return offsetX;
    }
}

