/*
 * Decompiled with CFR 0.152.
 */
package com.gtis.sams.core.service.impl;

import com.alibaba.fastjson.JSON;
import com.gtis.sams.core.entity.Field;
import com.gtis.sams.core.entity.Model;
import com.gtis.sams.core.events.ModelFieldNotFoundException;
import com.gtis.sams.core.events.ModelNotFoundException;
import com.gtis.sams.core.service.ModelService;
import com.gtis.sams.core.service.impl.ModelServiceImpl;
import com.gtis.sams.utils.ClassUtils;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModelServiceImpl
implements ModelService {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private Resource location;
    private String content;
    private Map<String, Model> models;

    public synchronized void init() {
        this.models = new LinkedHashMap();
        try {
            this.content = IOUtils.toString((InputStream)this.location.getInputStream(), (String)"utf-8");
            this.logger.debug(this.content);
            List modelList = JSON.parseArray((String)this.content, Model.class);
            for (Model model : modelList) {
                this.models.put(model.getName(), model);
            }
        }
        catch (IOException e) {
            this.logger.error("\u8bfb\u53d6Models\u6587\u4ef6\u5f02\u5e38\uff0c\u6838\u67e5Models\u6587\u4ef6\u662f\u5426\u5b58\u5728\u3010{}\u3011", (Object)e.getLocalizedMessage());
        }
        catch (Exception e) {
            this.logger.error("\u8c8c\u4f3c\u51fa\u73b0\u4e86\u5f02\u5e38\uff0c\u662f\u4e0d\u662f\u79c1\u81ea\u52a8\u8fc7\u4e86models.json\u6587\u4ef6\u4e86\uff1f\u3010{}\u3011", (Object)e.getLocalizedMessage());
        }
    }

    public String getContent() {
        return this.content;
    }

    public Map<String, Model> getModels() {
        return this.models;
    }

    public Model getModel(String modelName) {
        if (this.models == null) {
            throw new RuntimeException("\u672a\u627e\u5230\u6a21\u578b\u914d\u7f6e\u6587\u4ef6~");
        }
        if (StringUtils.isBlank((String)modelName)) {
            throw new RuntimeException("\u6a21\u578b\u540d\u4e0d\u80fd\u4e3a\u7a7a~");
        }
        return (Model)this.models.get(modelName);
    }

    public String getFieldTitle(String modelName, String filedName) {
        Model model = this.getModel(modelName);
        if (model == null) {
            throw new ModelNotFoundException(modelName);
        }
        if (StringUtils.isBlank((String)filedName)) {
            throw new ModelFieldNotFoundException(modelName, filedName);
        }
        return model.getFieldTitle(filedName);
    }

    public Map<String, String> getFields(String modelName) {
        HashMap<String, String> fields = new HashMap<String, String>();
        Model model = this.getModel(modelName);
        for (Field field : model.getFields()) {
            fields.put(field.getName(), field.getTitle());
        }
        return fields;
    }

    public List<Map<String, Object>> getShowFields(String modelName, ModelService.Type showType) {
        Model model = this.getModel(modelName);
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        switch (1.$SwitchMap$com$gtis$sams$core$service$ModelService$Type[showType.ordinal()]) {
            case 1: {
                for (Field field : model.getFields()) {
                    if (!field.isShowInGrid()) continue;
                    list.add(this.field2Map(field));
                }
                break;
            }
            case 2: {
                for (Field field : model.getFields()) {
                    if (!field.isShowInAnalysis()) continue;
                    list.add(this.field2Map(field));
                }
                break;
            }
            case 3: {
                for (Field field : model.getFields()) {
                    if (!field.isShowInStatic()) continue;
                    list.add(this.field2Map(field));
                }
                break;
            }
            default: {
                for (Field field : model.getFields()) {
                    if (!field.isShowInGrid()) continue;
                    list.add(this.field2Map(field));
                }
            }
        }
        return list;
    }

    public String modify(String content) {
        try {
            IOUtils.write((String)content, (OutputStream)new FileOutputStream(this.location.getFile()), (String)"utf-8");
        }
        catch (IOException e) {
            this.logger.error("\u5199\u5165model\u5f02\u5e38\u3010{}\u3011", (Object)e.getLocalizedMessage());
        }
        return content;
    }

    private Map<String, Object> field2Map(Field field) {
        Map map = null;
        try {
            map = ClassUtils.fieldsToMap((Object)field);
            map.remove("showInGrid");
            map.remove("showInAnalysis");
            map.remove("showInStatic");
        }
        catch (Exception e) {
            this.logger.error("\u5b57\u6bb5\u62f7\u8d1d\u5f02\u5e38\u3010{}\u3011", (Object)e.getLocalizedMessage());
        }
        return map;
    }

    public Resource getLocation() {
        return this.location;
    }

    public void setLocation(Resource location) {
        this.location = location;
    }
}

