/*
 * Decompiled with CFR 0.152.
 */
package com.gtis.report;

import com.gtis.report.CfgPath;
import com.runqian.base4.util.ArgumentTokenizer;
import com.runqian.base4.util.DBTypes;
import com.runqian.base4.util.Logger;
import com.runqian.base4.util.MD5;
import com.runqian.base4.util.SegmentSet;
import com.runqian.report4.remote.Const;
import com.runqian.report4.remote.DataSourceDefine;
import com.runqian.report4.remote.LoginRequest;
import com.runqian.report4.remote.LoginResponse;
import com.runqian.report4.remote.LogoutRequest;
import com.runqian.report4.remote.OpenRequest;
import com.runqian.report4.remote.Request;
import com.runqian.report4.remote.SaveRequest;
import com.runqian.report4.remote.example.RemoteManager;
import com.runqian.report4.remote.example.UserInfo;
import com.runqian.report4.remote.example.UserManager;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.dbcp.BasicDataSource;
import org.apache.commons.io.IOUtils;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RemoteServerServlet
extends HttpServlet {
    private static final long serialVersionUID = -2857228140485120665L;
    private static final String[] DB_NAMES = new String[]{"unknown", "oracle", "sqlsvr", "sybase", "sqlany", "infmix", "foxpro", "access", "foxbas", "db2", "mysql", "kingbase", "derby"};

    private String getNodeAttr(Node node, String attrName) {
        NamedNodeMap map = node.getAttributes();
        Node attr = map.getNamedItem(attrName);
        if (attr == null) {
            return "";
        }
        return attr.getNodeValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init() throws ServletException {
        RemoteManager rm = RemoteManager.getInstance();
        UserManager um = rm.getUserManager();
        try {
            Properties p = new Properties();
            FileInputStream is = null;
            try {
                is = new FileInputStream(this.getConfigFile("users.properties"));
                p.load(new InputStreamReader((InputStream)is, "gbk"));
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(is);
                throw throwable;
            }
            IOUtils.closeQuietly((InputStream)is);
            Enumeration<?> em = p.propertyNames();
            while (em.hasMoreElements()) {
                SegmentSet set;
                String userId = (String)em.nextElement();
                UserInfo info = new UserInfo();
                String tmp = p.getProperty(userId);
                ArgumentTokenizer at = new ArgumentTokenizer(tmp, ',');
                String name = at.nextToken();
                try {
                    name = new String(name.getBytes("iso8859-1"), "GBK");
                }
                catch (Exception ignored) {
                    // empty catch block
                }
                info.userName = name;
                info.password = new MD5().getMD5ofStr(at.nextToken());
                info.privilege = Integer.parseInt(at.nextToken(), 2);
                info.alarmRowNum = Integer.parseInt(at.nextToken());
                Logger.info((Object)"\u7cfb\u7edf\u521d\u59cb\u5316\uff0c\u5f00\u59cb\u8bfb\u53d6\u4f1a\u8bdd\u53d8\u91cf");
                tmp = at.nextToken();
                if (tmp != null && tmp.trim().length() > 0) {
                    tmp = new String(tmp.getBytes("iso8859-1"), "GBK");
                    Logger.info((Object)("tmp=" + tmp));
                    set = new SegmentSet(tmp, ';');
                    info.sessionVariables = set.toMap();
                }
                Logger.info((Object)"\u7cfb\u7edf\u521d\u59cb\u5316\uff0c\u5f00\u59cb\u8bfb\u53d6\u8bed\u4e49\u6743\u9650");
                tmp = at.nextToken();
                if (tmp != null && tmp.trim().length() > 0) {
                    tmp = new String(tmp.getBytes("iso8859-1"), "GBK");
                    set = new SegmentSet(tmp, ';');
                    info.semanticsPrivilege = set.toMap();
                }
                um.addUser(userId, info);
            }
            rm.setSemanticsFile("semantics.xml");
            DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
            HashMap dsMap = new HashMap();
            FileInputStream iis = null;
            try {
                iis = new FileInputStream(this.getConfigFile("datasource.xml"));
                Document doc = docBuilder.parse(iis);
                this.putCfgDataSource(doc.getDocumentElement().getChildNodes(), dsMap);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(iis);
                throw throwable;
            }
            IOUtils.closeQuietly((InputStream)iis);
            this.putSpringDataSource(dsMap);
            dsMap.remove("_default");
            rm.dataSources = dsMap;
            Logger.info((Object)"\u8fdc\u7a0b\u8bbe\u8ba1\u670d\u52a1\u5668\u5df2\u542f\u52a8......");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void putCfgDataSource(NodeList list, HashMap<String, DataSourceDefine> map) {
        for (int i = 0; i < list.getLength(); ++i) {
            String dbCharset;
            Node node = list.item(i);
            if (!node.getNodeName().equals("ds")) continue;
            DataSourceDefine dsd = new DataSourceDefine();
            String name = this.getNodeAttr(node, "name");
            dsd.setName(name);
            String caseSense = this.getNodeAttr(node, "CaseSensitive");
            dsd.setCaseSentence("1".equals(caseSense));
            String ideCharset = this.getNodeAttr(node, "ideCharset");
            if (ideCharset.length() > 0) {
                dsd.setClientCharset(ideCharset);
            }
            if ((dbCharset = this.getNodeAttr(node, "dbCharset")).length() > 0) {
                dsd.setDBCharset(dbCharset);
            }
            String dbtype = this.getNodeAttr(node, "dbType");
            dsd.setDBType(DBTypes.getDBType((String)dbtype));
            String driver = this.getNodeAttr(node, "driverClass");
            dsd.setDriver(driver);
            dsd.setDSType((byte)0);
            String transCharset = this.getNodeAttr(node, "transCharset");
            dsd.setNeedTranContent("1".equals(transCharset));
            String transSQLCharset = this.getNodeAttr(node, "transSQLCharset");
            dsd.setNeedTranSentence("1".equals(transSQLCharset));
            String pwd = this.getNodeAttr(node, "password");
            dsd.setPassword(pwd);
            dsd.setUrl(this.getNodeAttr(node, "url"));
            dsd.setUser(this.getNodeAttr(node, "user"));
            String useSchema = this.getNodeAttr(node, "useSchema");
            dsd.setUseSchema("1".equals(useSchema));
            map.put(name, dsd);
        }
    }

    private void putSpringDataSource(HashMap<String, DataSourceDefine> map) {
        WebApplicationContext wac = WebApplicationContextUtils.getWebApplicationContext((ServletContext)this.getServletContext());
        wac.getBeansOfType(BasicDataSource.class);
        for (Map.Entry entry : wac.getBeansOfType(BasicDataSource.class).entrySet()) {
            String name = (String)entry.getKey();
            DataSourceDefine dsd = map.get(name);
            if (dsd == null) {
                dsd = new DataSourceDefine();
                dsd.setName((String)entry.getKey());
                DataSourceDefine df = map.get("_default");
                dsd.setCaseSentence(df.isCaseSentence());
                dsd.setNeedTranContent(df.getNeedTranContent());
                dsd.setNeedTranSentence(df.getNeedTranSentence());
                dsd.setUseSchema(df.isUseSchema());
                dsd.setClientCharset(df.getClientCharset());
                dsd.setDBCharset(df.getDBCharset());
                dsd.setDSType(df.getDSType());
                map.put(name, dsd);
            }
            BasicDataSource bds = (BasicDataSource)entry.getValue();
            dsd.setDBType(this.getDBType(bds.getDriverClassName().toLowerCase()));
            dsd.setDriver(bds.getDriverClassName());
            dsd.setUrl(bds.getUrl());
            dsd.setUser(bds.getUsername());
            dsd.setPassword(bds.getPassword());
        }
    }

    private int getDBType(String className) {
        for (int i = 0; i < DB_NAMES.length; ++i) {
            if (!className.contains(DB_NAMES[i])) continue;
            return i;
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        ServletInputStream is = null;
        OutputStream os = null;
        try {
            is = request.getInputStream();
            ObjectInputStream ois = new ObjectInputStream((InputStream)is);
            Request req = (Request)ois.readObject();
            RemoteManager rm = RemoteManager.getInstance();
            LoginResponse res = null;
            if (req instanceof LoginRequest) {
                res = rm.doLogin((LoginRequest)req);
            } else if (req instanceof LogoutRequest) {
                res = rm.doLogout((LogoutRequest)req);
            } else if (req instanceof OpenRequest) {
                OpenRequest openReq = (OpenRequest)req;
                openReq.fileName = openReq.fileType == Const.FILE_SEMANTICS ? this.getConfigFile(openReq.fileName) : this.getRaqFile(openReq.fileName);
                res = rm.doOpen(openReq);
            } else if (req instanceof SaveRequest) {
                SaveRequest saveReq = (SaveRequest)req;
                saveReq.fileName = saveReq.fileType == Const.FILE_SEMANTICS ? this.getConfigFile(saveReq.fileName) : this.getRaqFile(saveReq.fileName);
                res = rm.doSave(saveReq);
            }
            os = response.getOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(os);
            oos.writeObject(res);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (is != null) {
                is.close();
            }
            if (os != null) {
                os.close();
            }
        }
    }

    private String getConfigFile(String name) {
        return CfgPath.getFile((String[])new String[]{"remote", name});
    }

    private String getRaqFile(String name) {
        return CfgPath.getFile((String[])new String[]{"files", name});
    }
}

