/*
 * Decompiled with CFR 0.152.
 */
package com.gtis.portal.web.config;

import com.alibaba.fastjson.JSON;
import com.gtis.common.util.UUIDGenerator;
import com.gtis.portal.entity.PfPartitionInfo;
import com.gtis.portal.entity.PfResourcePartition;
import com.gtis.portal.entity.PublicVo;
import com.gtis.portal.service.PfPartitionInfoService;
import com.gtis.portal.service.PfResourceGroupService;
import com.gtis.portal.service.PfResourcePartitionService;
import com.gtis.portal.service.PfResourceService;
import com.gtis.portal.util.RequestUtils;
import com.gtis.portal.web.BaseController;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"config/parti"})
public class PartitionController
extends BaseController {
    @Autowired
    PfResourceService resourceService;
    @Autowired
    PfResourceGroupService groupService;
    @Autowired
    PfResourcePartitionService resourcePartitionService;
    @Autowired
    PfPartitionInfoService partitionInfoService;
    @Resource
    @Qualifier(value="boolListNumber")
    List<PublicVo> boolListNumber;
    @Resource
    @Qualifier(value="priorityList")
    List<PublicVo> priorityList;
    @Resource
    @Qualifier(value="partitionTypeList")
    List<PublicVo> partitionTypeList;

    @RequestMapping(value={""})
    public String manage(Model model, String rId) {
        model.addAttribute("partitionTypeList", (Object)this.partitionTypeList);
        model.addAttribute("partitionTypeJson", (Object)JSON.toJSONString((Object)this.partitionTypeList));
        ArrayList rpList = this.resourcePartitionService.getListByRid(rId, Integer.valueOf(0));
        List piList = new ArrayList();
        if (rpList != null && rpList.size() > 0) {
            model.addAttribute("pId", (Object)((PfResourcePartition)rpList.get(0)).getPartitionId());
            piList = this.partitionInfoService.getListByPid(((PfResourcePartition)rpList.get(0)).getPartitionId());
        } else {
            model.addAttribute("pId", (Object)"");
            rpList = new ArrayList();
        }
        if (piList == null) {
            piList = new ArrayList();
        } else if (piList.size() > 0) {
            model.addAttribute("piId", (Object)((PfPartitionInfo)piList.get(0)).getPfPartitionInfoId());
        }
        model.addAttribute("rpList", rpList);
        model.addAttribute("piList", piList);
        model.addAttribute("rId", (Object)rId);
        return "/config/parti/parti-list";
    }

    @RequestMapping(value={"info"})
    @ResponseBody
    public PfResourcePartition getWorkflowDefinition(@RequestParam(value="keyId", required=false) String keyId) {
        PfResourcePartition rp = (PfResourcePartition)this.resourcePartitionService.findById((Object)keyId);
        return rp == null ? new PfResourcePartition() : rp;
    }

    @RequestMapping(value={"save"})
    @ResponseBody
    public Object save(HttpServletRequest req, @ModelAttribute(value="rp") PfResourcePartition rp, Model model) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("isadd", true);
        if (StringUtils.isBlank((String)rp.getPartitionId())) {
            rp.setPartitionId(UUIDGenerator.generate18());
        }
        if (StringUtils.isNotBlank((String)rp.getResourceId())) {
            PfResourcePartition tmprp = (PfResourcePartition)this.resourcePartitionService.findById((Object)rp.getPartitionId());
            if (tmprp == null) {
                this.resourcePartitionService.insert((Object)rp);
            } else {
                rp.setPartitionType(tmprp.getPartitionType());
                this.resourcePartitionService.update((Object)rp);
                result.put("isadd", false);
            }
        }
        rp = (PfResourcePartition)this.resourcePartitionService.findById((Object)rp.getPartitionId());
        result.put("success", true);
        result.put("msg", "\u64cd\u4f5c\u6210\u529f\uff01");
        result.put("rp", rp);
        return result;
    }

    @RequestMapping(value={"del"})
    @ResponseBody
    public Object del(@RequestParam(value="keyId", required=false) String keyId) {
        if (RequestUtils.checkIsAdmin()) {
            if (StringUtils.isNotBlank((String)keyId)) {
                this.resourcePartitionService.deleteRPAndPIByIds(keyId);
                return this.handlerSuccessJson();
            }
        } else {
            return this.handlerErrorJson(this.exceptionService.getExceptionMsg("9001"));
        }
        return this.handlerSuccessJson();
    }

    @RequestMapping(value={"jsonPI"})
    @ResponseBody
    public Object jsonPartitionInfo(Model model, @RequestParam(value="pId", required=false) String pId) {
        ArrayList piList = this.partitionInfoService.getListByPid(pId);
        if (piList == null) {
            piList = new ArrayList();
        }
        return piList;
    }

    @RequestMapping(value={"infoPI"})
    @ResponseBody
    public PfPartitionInfo getPartitionInfo(@RequestParam(value="keyId", required=false) String keyId) {
        PfPartitionInfo pt = (PfPartitionInfo)this.partitionInfoService.findById((Object)keyId);
        return pt == null ? new PfPartitionInfo() : pt;
    }

    @RequestMapping(value={"savePI"})
    @ResponseBody
    public Object savePartitionInfo(HttpServletRequest req, PfPartitionInfo pi, Model model) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("isadd", true);
        if (StringUtils.isBlank((String)pi.getPfPartitionInfoId())) {
            pi.setPfPartitionInfoId(UUIDGenerator.generate18());
        }
        if (StringUtils.isNotBlank((String)pi.getPartitionId())) {
            PfPartitionInfo tmprp = (PfPartitionInfo)this.partitionInfoService.findById((Object)pi.getPfPartitionInfoId());
            if (tmprp == null) {
                this.partitionInfoService.insert((Object)pi);
            } else {
                pi.setElementJs(tmprp.getElementJs());
                pi.setElementIcon(tmprp.getElementIcon());
                this.partitionInfoService.update((Object)pi);
                result.put("isadd", false);
            }
        }
        pi = (PfPartitionInfo)this.partitionInfoService.findById((Object)pi.getPfPartitionInfoId());
        result.put("success", true);
        result.put("msg", "\u64cd\u4f5c\u6210\u529f\uff01");
        result.put("pi", pi);
        return result;
    }

    @RequestMapping(value={"delPI"})
    @ResponseBody
    public Object delPartitionInfo(@RequestParam(value="keyId", required=false) String keyId) {
        if (RequestUtils.checkIsAdmin()) {
            if (StringUtils.isNotBlank((String)keyId)) {
                this.partitionInfoService.deleteByIds(keyId);
                return this.handlerSuccessJson();
            }
        } else {
            return this.handlerErrorJson(this.exceptionService.getExceptionMsg("9001"));
        }
        return this.handlerSuccessJson();
    }
}

