/*
 * Decompiled with CFR 0.152.
 */
package com.gtis.portal.web;

import com.alibaba.fastjson.JSONObject;
import com.gtis.config.AppConfig;
import com.gtis.plat.service.SysActivityService;
import com.gtis.plat.service.SysTaskService;
import com.gtis.plat.service.SysWorkFlowInstanceService;
import com.gtis.plat.service.WorkFlowCoreService;
import com.gtis.plat.vo.PfActivityVo;
import com.gtis.plat.vo.PfTaskVo;
import com.gtis.plat.vo.PfWorkFlowInstanceVo;
import com.gtis.plat.wf.WorkFlowInfo;
import com.gtis.plat.wf.model.ActivityModel;
import com.gtis.portal.entity.BDCGG;
import com.gtis.portal.service.TaskActionService;
import com.gtis.portal.util.HttpClientUtil;
import com.gtis.portal.util.WorkFlowXml;
import com.gtis.portal.util.WorkFlowXmlUtil;
import com.gtis.portal.web.BaseController;
import com.gtis.util.UUIDGenerator;
import java.io.IOException;
import java.io.InputStream;
import java.net.URLDecoder;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/taskAction"})
public class TaskActionController
extends BaseController {
    @Autowired
    TaskActionService taskActionService;
    @Autowired
    SysWorkFlowInstanceService sysWorkFlowInstanceService;
    @Autowired
    SysTaskService sysTaskService;
    @Autowired
    SysActivityService sysActivityService;
    @Autowired
    WorkFlowCoreService workFlowCoreService;

    @RequestMapping(value={"delTask"})
    @ResponseBody
    public Object delTask(HttpServletRequest request, @RequestParam(value="wiid", required=false) String wiid, @RequestParam(value="taskid", required=false) String taskid, @RequestParam(value="reason", required=false) String reason, @RequestParam(value="userid", required=false) String userid) throws Exception {
        PfActivityVo pfActivityVo;
        PfTaskVo pfTaskVo;
        if (StringUtils.isNotBlank((String)reason)) {
            reason = URLDecoder.decode(reason, "UTF-8");
        }
        PfWorkFlowInstanceVo pfWorkFlowInstanceVo = null;
        if (StringUtils.isNotBlank((String)wiid)) {
            pfWorkFlowInstanceVo = this.sysWorkFlowInstanceService.getWorkflowInstance(wiid);
        } else if (StringUtils.isNotBlank((String)taskid) && (pfTaskVo = this.sysTaskService.getTask(taskid)) != null && StringUtils.isNotBlank((String)pfTaskVo.getActivityId()) && (pfActivityVo = this.sysActivityService.getActivityById(pfTaskVo.getActivityId())) != null && StringUtils.isNotBlank((String)pfActivityVo.getWorkflowInstanceId())) {
            pfWorkFlowInstanceVo = this.sysWorkFlowInstanceService.getWorkflowInstance(pfActivityVo.getWorkflowInstanceId());
        }
        String msg = "";
        try {
            msg = this.taskActionService.delTask(pfWorkFlowInstanceVo.getWorkflowIntanceId(), taskid, userid, reason, pfWorkFlowInstanceVo.getProId(), pfWorkFlowInstanceVo, request);
        }
        catch (Exception e) {
            try {
                return this.handlerJSONException(e);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.handlerSuccessJson(msg);
    }

    @RequestMapping(value={"retrieveTask"})
    @ResponseBody
    public Object retrieveTask(HttpServletRequest request, @RequestParam(value="taskid", required=false) String taskid, @RequestParam(value="userid", required=false) String userid) {
        try {
            PfTaskVo pfTaskVo;
            String wiid = "";
            PfWorkFlowInstanceVo pfWorkFlowInstanceVo = null;
            if (StringUtils.isNotBlank((String)taskid) && (pfTaskVo = this.sysTaskService.getHistoryTask(taskid)) != null && StringUtils.isNotBlank((String)pfTaskVo.getActivityId())) {
                PfActivityVo pfActivityVo = this.sysActivityService.getActivityById(pfTaskVo.getActivityId());
                if (pfActivityVo != null && StringUtils.isNotBlank((String)pfActivityVo.getWorkflowInstanceId())) {
                    pfWorkFlowInstanceVo = this.sysWorkFlowInstanceService.getWorkflowInstance(pfActivityVo.getWorkflowInstanceId());
                }
                if (pfWorkFlowInstanceVo != null) {
                    wiid = pfWorkFlowInstanceVo.getWorkflowIntanceId();
                }
            }
            this.taskActionService.retrieveTask(wiid, taskid, userid, pfWorkFlowInstanceVo, request);
        }
        catch (Exception e) {
            try {
                return this.handlerJSONException(e);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.handlerSuccessJson();
    }

    @RequestMapping(value={"turnTask"})
    @ResponseBody
    public Object turnTask(HttpServletRequest request, @RequestParam(value="wiid", required=false) String wiid, @RequestParam(value="taskid", required=false) String taskid, @RequestParam(value="turnXml", required=false) String turnXml, @RequestParam(value="userid", required=false) String userid) {
        try {
            PfTaskVo pfTaskVo;
            PfWorkFlowInstanceVo pfWorkFlowInstanceVo = null;
            if (StringUtils.isNotBlank((String)taskid) && (pfTaskVo = this.sysTaskService.getTask(taskid)) != null && StringUtils.isNotBlank((String)pfTaskVo.getActivityId())) {
                PfActivityVo pfActivityVo = this.sysActivityService.getActivityById(pfTaskVo.getActivityId());
                if (pfActivityVo != null && StringUtils.isNotBlank((String)pfActivityVo.getWorkflowInstanceId())) {
                    pfWorkFlowInstanceVo = this.sysWorkFlowInstanceService.getWorkflowInstance(pfActivityVo.getWorkflowInstanceId());
                }
                if (pfWorkFlowInstanceVo != null) {
                    wiid = pfWorkFlowInstanceVo.getWorkflowIntanceId();
                }
            }
            String xml = turnXml;
            if (StringUtils.isBlank((String)turnXml)) {
                xml = this.inputStream2String((InputStream)request.getInputStream());
            }
            if (StringUtils.isNotBlank((String)taskid)) {
                WorkFlowInfo info = this.workFlowCoreService.getWorkFlowTurnInfo(userid, taskid);
                WorkFlowXml workXml = WorkFlowXmlUtil.getInstanceModel((PfWorkFlowInstanceVo)info.getWorkFlowIntanceVo());
                String activityDefineId = info.getSourceActivity().getActivityDefinitionId();
                if (info.getTransInfo().getTranActivitys() != null && info.getTransInfo().getTranActivitys().size() == 0) {
                    ActivityModel aModel = workXml.getActivity(activityDefineId);
                    PfActivityVo sourceActivityVo = info.getSourceActivity();
                    String endActivityDefine = workXml.getEndActivityDefine();
                    if (StringUtils.isBlank((String)endActivityDefine)) {
                        endActivityDefine = "";
                    }
                    if (endActivityDefine.equals(activityDefineId) || aModel.isCanFinish()) {
                        this.taskActionService.endTask(wiid, taskid, userid, pfWorkFlowInstanceVo, request, xml, null);
                    } else if (workXml.getActivitiesCount() == 1) {
                        this.taskActionService.endTask(wiid, taskid, userid, pfWorkFlowInstanceVo, request, xml, null);
                    } else {
                        this.taskActionService.turnTaskByXml(wiid, taskid, userid, pfWorkFlowInstanceVo, request, xml);
                    }
                } else if (StringUtils.indexOf((String)xml, (String)"<Activity Id=\"-1\">") > -1) {
                    this.taskActionService.endTask(wiid, taskid, userid, pfWorkFlowInstanceVo, request, xml, null);
                } else {
                    this.taskActionService.turnTaskByXml(wiid, taskid, userid, pfWorkFlowInstanceVo, request, xml);
                }
            }
        }
        catch (Exception e) {
            try {
                return this.handlerJSONException(e);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.handlerSuccessJson();
    }

    @RequestMapping(value={"turnBackTask"})
    @ResponseBody
    public Object turnBackTask(HttpServletRequest request, @RequestParam(value="wiid", required=false) String wiid, @RequestParam(value="taskid", required=false) String taskid, @RequestParam(value="adids", required=false) String adids, @RequestParam(value="remark", required=false) String remark, @RequestParam(value="userid", required=false) String userid) {
        try {
            PfTaskVo pfTaskVo;
            PfWorkFlowInstanceVo pfWorkFlowInstanceVo = null;
            if (StringUtils.isNotBlank((String)taskid) && (pfTaskVo = this.sysTaskService.getTask(taskid)) != null && StringUtils.isNotBlank((String)pfTaskVo.getActivityId())) {
                PfActivityVo pfActivityVo = this.sysActivityService.getActivityById(pfTaskVo.getActivityId());
                if (pfActivityVo != null && StringUtils.isNotBlank((String)pfActivityVo.getWorkflowInstanceId())) {
                    pfWorkFlowInstanceVo = this.sysWorkFlowInstanceService.getWorkflowInstance(pfActivityVo.getWorkflowInstanceId());
                }
                if (pfWorkFlowInstanceVo != null) {
                    wiid = pfWorkFlowInstanceVo.getWorkflowIntanceId();
                }
            }
            this.taskActionService.turnBackTask(wiid, taskid, userid, pfWorkFlowInstanceVo, request, adids, remark);
        }
        catch (Exception e) {
            try {
                return this.handlerJSONException(e);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.handlerSuccessJson();
    }

    @RequestMapping(value={"endTask"})
    @ResponseBody
    public Object endTask(HttpServletRequest request, @RequestParam(value="wiid", required=false) String wiid, @RequestParam(value="taskid", required=false) String taskid, @RequestParam(value="userid", required=false) String userid) {
        try {
            PfTaskVo pfTaskVo;
            PfWorkFlowInstanceVo pfWorkFlowInstanceVo = null;
            if (StringUtils.isNotBlank((String)taskid) && (pfTaskVo = this.sysTaskService.getTask(taskid)) != null && StringUtils.isNotBlank((String)pfTaskVo.getActivityId())) {
                PfActivityVo pfActivityVo = this.sysActivityService.getActivityById(pfTaskVo.getActivityId());
                if (pfActivityVo != null && StringUtils.isNotBlank((String)pfActivityVo.getWorkflowInstanceId())) {
                    pfWorkFlowInstanceVo = this.sysWorkFlowInstanceService.getWorkflowInstance(pfActivityVo.getWorkflowInstanceId());
                }
                if (pfWorkFlowInstanceVo != null) {
                    wiid = pfWorkFlowInstanceVo.getWorkflowIntanceId();
                }
            }
            this.taskActionService.endTask(wiid, taskid, userid, pfWorkFlowInstanceVo, request, "", null);
        }
        catch (Exception e) {
            try {
                return this.handlerJSONException(e);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.handlerSuccessJson();
    }

    @RequestMapping(value={"stopTask"})
    @ResponseBody
    public Object stopTask(HttpServletRequest request, @RequestParam(value="wiid", required=false) String wiid, @RequestParam(value="taskid", required=false) String taskid, @RequestParam(value="userid", required=false) String userid) {
        try {
            PfTaskVo pfTaskVo;
            PfWorkFlowInstanceVo pfWorkFlowInstanceVo = null;
            if (StringUtils.isNotBlank((String)taskid) && (pfTaskVo = this.sysTaskService.getHistoryTask(taskid)) != null && StringUtils.isNotBlank((String)pfTaskVo.getActivityId())) {
                PfActivityVo pfActivityVo = this.sysActivityService.getActivityById(pfTaskVo.getActivityId());
                if (pfActivityVo != null && StringUtils.isNotBlank((String)pfActivityVo.getWorkflowInstanceId())) {
                    pfWorkFlowInstanceVo = this.sysWorkFlowInstanceService.getWorkflowInstance(pfActivityVo.getWorkflowInstanceId());
                }
                if (pfWorkFlowInstanceVo != null) {
                    wiid = pfWorkFlowInstanceVo.getWorkflowIntanceId();
                }
            }
            this.taskActionService.stopTask(wiid, taskid, userid, pfWorkFlowInstanceVo, request);
        }
        catch (Exception e) {
            try {
                return this.handlerJSONException(e);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.handlerSuccessJson();
    }

    @RequestMapping(value={"beginTask"})
    @ResponseBody
    public Object beginTask(HttpServletRequest request, @RequestParam(value="wiid", required=false) String wiid, @RequestParam(value="taskid", required=false) String taskid, @RequestParam(value="userid", required=false) String userid) {
        try {
            PfTaskVo pfTaskVo;
            PfWorkFlowInstanceVo pfWorkFlowInstanceVo = null;
            if (StringUtils.isNotBlank((String)taskid) && (pfTaskVo = this.sysTaskService.getHistoryTask(taskid)) != null && StringUtils.isNotBlank((String)pfTaskVo.getActivityId())) {
                PfActivityVo pfActivityVo = this.sysActivityService.getActivityById(pfTaskVo.getActivityId());
                if (pfActivityVo != null && StringUtils.isNotBlank((String)pfActivityVo.getWorkflowInstanceId())) {
                    pfWorkFlowInstanceVo = this.sysWorkFlowInstanceService.getWorkflowInstance(pfActivityVo.getWorkflowInstanceId());
                }
                if (pfWorkFlowInstanceVo != null) {
                    wiid = pfWorkFlowInstanceVo.getWorkflowIntanceId();
                }
            }
            this.taskActionService.createTask(wiid, taskid, userid, pfWorkFlowInstanceVo, request);
        }
        catch (Exception e) {
            try {
                return this.handlerJSONException(e);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.handlerSuccessJson();
    }

    @RequestMapping(value={"batchTurnTask"})
    @ResponseBody
    public Object batchTurnTask(HttpServletRequest request, @RequestParam(value="taskids", required=false) String taskids, @RequestParam(value="userid", required=false) String userid) {
        try {
            String xml = this.inputStream2String((InputStream)request.getInputStream());
            if (StringUtils.isNotBlank((String)taskids)) {
                String[] taskIds;
                for (String value : taskIds = taskids.split(",")) {
                    this.turnTask(request, "", value, xml, userid);
                }
            }
        }
        catch (Exception e) {
            try {
                return this.handlerJSONException(e);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.handlerSuccessJson();
    }

    @RequestMapping(value={"turnTaskByWorkFlowInfo"})
    @ResponseBody
    public Object turnTaskByWorkFlowInfo(HttpServletRequest request, @RequestParam(value="wiid", required=false) String wiid, @RequestParam(value="taskid", required=false) String taskid, @RequestParam(value="userid", required=false) String userid) {
        try {
            PfTaskVo pfTaskVo;
            PfWorkFlowInstanceVo pfWorkFlowInstanceVo = null;
            if (StringUtils.isNotBlank((String)taskid) && (pfTaskVo = this.sysTaskService.getTask(taskid)) != null && StringUtils.isNotBlank((String)pfTaskVo.getActivityId())) {
                PfActivityVo pfActivityVo = this.sysActivityService.getActivityById(pfTaskVo.getActivityId());
                if (pfActivityVo != null && StringUtils.isNotBlank((String)pfActivityVo.getWorkflowInstanceId())) {
                    pfWorkFlowInstanceVo = this.sysWorkFlowInstanceService.getWorkflowInstance(pfActivityVo.getWorkflowInstanceId());
                }
                if (pfWorkFlowInstanceVo != null) {
                    wiid = pfWorkFlowInstanceVo.getWorkflowIntanceId();
                }
            }
            WorkFlowInfo info = this.workFlowCoreService.getWorkFlowTurnInfo(userid, taskid);
            List lstActivityModel = info.getTransInfo().getTranActivitys();
            WorkFlowXml workXml = WorkFlowXmlUtil.getInstanceModel((PfWorkFlowInstanceVo)info.getWorkFlowIntanceVo());
            String activityDefineId = info.getSourceActivity().getActivityDefinitionId();
            if (info.getTransInfo().getTranActivitys() != null && info.getTransInfo().getTranActivitys().size() == 0) {
                ActivityModel aModel = workXml.getActivity(activityDefineId);
                String endActivityDefine = workXml.getEndActivityDefine();
                if (StringUtils.isBlank((String)endActivityDefine)) {
                    endActivityDefine = "";
                }
                if (endActivityDefine.equals(activityDefineId) || aModel.isCanFinish()) {
                    this.taskActionService.endTask(wiid, taskid, userid, pfWorkFlowInstanceVo, request, "", info);
                } else if (workXml.getActivitiesCount() == 1) {
                    this.taskActionService.endTask(wiid, taskid, userid, pfWorkFlowInstanceVo, request, "", info);
                }
            } else {
                this.taskActionService.turnTaskByWorkFlowInfo(wiid, taskid, userid, pfWorkFlowInstanceVo, request, "");
            }
        }
        catch (Exception e) {
            try {
                return this.handlerJSONException(e);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.handlerSuccessJson();
    }

    @RequestMapping(value={"postTask"})
    @ResponseBody
    public Object postTask(HttpServletRequest request, @RequestParam(value="wiid", required=false) String wiid, @RequestParam(value="taskid", required=false) String taskid, @RequestParam(value="remark", required=false) String remark, @RequestParam(value="userid", required=false) String userid) {
        try {
            PfTaskVo pfTaskVo;
            PfWorkFlowInstanceVo pfWorkFlowInstanceVo = null;
            if (StringUtils.isNotBlank((String)taskid) && (pfTaskVo = this.sysTaskService.getTask(taskid)) != null && StringUtils.isNotBlank((String)pfTaskVo.getActivityId())) {
                PfActivityVo pfActivityVo = this.sysActivityService.getActivityById(pfTaskVo.getActivityId());
                if (pfActivityVo != null && StringUtils.isNotBlank((String)pfActivityVo.getWorkflowInstanceId())) {
                    pfWorkFlowInstanceVo = this.sysWorkFlowInstanceService.getWorkflowInstance(pfActivityVo.getWorkflowInstanceId());
                }
                if (pfWorkFlowInstanceVo != null) {
                    wiid = pfWorkFlowInstanceVo.getWorkflowIntanceId();
                }
            }
            this.taskActionService.postTask(wiid, taskid, userid, remark, pfWorkFlowInstanceVo, request);
        }
        catch (Exception e) {
            try {
                return this.handlerJSONException(e);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.handlerSuccessJson();
    }

    @RequestMapping(value={"unPostTask"})
    @ResponseBody
    public Object unPostTask(HttpServletRequest request, @RequestParam(value="wiid", required=false) String wiid, @RequestParam(value="taskid", required=false) String taskid, @RequestParam(value="userid", required=false) String userid) {
        try {
            PfTaskVo pfTaskVo;
            PfWorkFlowInstanceVo pfWorkFlowInstanceVo = null;
            if (StringUtils.isNotBlank((String)taskid) && (pfTaskVo = this.sysTaskService.getTask(taskid)) != null && StringUtils.isNotBlank((String)pfTaskVo.getActivityId())) {
                PfActivityVo pfActivityVo = this.sysActivityService.getActivityById(pfTaskVo.getActivityId());
                if (pfActivityVo != null && StringUtils.isNotBlank((String)pfActivityVo.getWorkflowInstanceId())) {
                    pfWorkFlowInstanceVo = this.sysWorkFlowInstanceService.getWorkflowInstance(pfActivityVo.getWorkflowInstanceId());
                }
                if (pfWorkFlowInstanceVo != null) {
                    wiid = pfWorkFlowInstanceVo.getWorkflowIntanceId();
                }
            }
            this.taskActionService.upPostTask(wiid, taskid, userid, pfWorkFlowInstanceVo, request);
        }
        catch (Exception e) {
            try {
                return this.handlerJSONException(e);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.handlerSuccessJson();
    }

    @RequestMapping(value={"priorityTask"})
    @ResponseBody
    public Object priorityTask(HttpServletRequest request, @RequestParam(value="wiids", required=false) String wiids, @RequestParam(value="priority", required=false) String priority, @RequestParam(value="userid", required=false) String userid) {
        try {
            if (StringUtils.isNotBlank((String)wiids)) {
                for (String wiid : wiids.split(",")) {
                    PfWorkFlowInstanceVo pfWorkFlowInstanceVo = this.sysWorkFlowInstanceService.getWorkflowInstance(wiid);
                    this.taskActionService.priorityTask(wiid, "", userid, priority, pfWorkFlowInstanceVo, request);
                }
            }
        }
        catch (Exception e) {
            try {
                return this.handlerJSONException(e);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.handlerSuccessJson();
    }

    @RequestMapping(value={"autoTurnTask"})
    @ResponseBody
    public Object autoTurnTask(HttpServletRequest request, @RequestParam(value="wiid", required=false) String wiid, @RequestParam(value="taskid", required=false) String taskid, @RequestParam(value="userid", required=false) String userid) {
        try {
            PfTaskVo pfTaskVo;
            PfWorkFlowInstanceVo pfWorkFlowInstanceVo = null;
            if (StringUtils.isNotBlank((String)taskid) && (pfTaskVo = this.sysTaskService.getTask(taskid)) != null && StringUtils.isNotBlank((String)pfTaskVo.getActivityId())) {
                PfActivityVo pfActivityVo = this.sysActivityService.getActivityById(pfTaskVo.getActivityId());
                if (pfActivityVo != null && StringUtils.isNotBlank((String)pfActivityVo.getWorkflowInstanceId())) {
                    pfWorkFlowInstanceVo = this.sysWorkFlowInstanceService.getWorkflowInstance(pfActivityVo.getWorkflowInstanceId());
                }
                if (pfWorkFlowInstanceVo != null) {
                    wiid = pfWorkFlowInstanceVo.getWorkflowIntanceId();
                }
            }
            this.taskActionService.autoTurnTask(wiid, taskid, userid, pfWorkFlowInstanceVo, request, "");
        }
        catch (Exception e) {
            try {
                return this.handlerJSONException(e);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.handlerSuccessJson();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String inputStream2String(InputStream is) throws IOException {
        String result = "";
        try {
            result = IOUtils.toString((InputStream)is, (String)"UTF-8");
            result = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>" + result;
        }
        catch (Exception exception) {
        }
        finally {
            is.close();
        }
        return result;
    }

    @RequestMapping(value={"usedTask"})
    @ResponseBody
    public Object usedTask(HttpServletRequest request, @RequestParam(value="taskIds", required=false) String taskIds, @RequestParam(value="userid", required=false) String userid) {
        try {
            if (StringUtils.isNotBlank((String)taskIds)) {
                String[] taskIdArray;
                for (String taskid : taskIdArray = taskIds.split(",")) {
                    if (!StringUtils.isNotBlank((String)taskid)) continue;
                    this.taskActionService.usedTask(taskid, userid);
                }
            }
        }
        catch (Exception e) {
            try {
                return this.handlerJSONException(e);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.handlerSuccessJson();
    }

    @RequestMapping(value={"noUsedTask"})
    @ResponseBody
    public Object noUsedTask(HttpServletRequest request, @RequestParam(value="taskIds", required=false) String taskIds, @RequestParam(value="userid", required=false) String userid) {
        try {
            if (StringUtils.isNotBlank((String)taskIds)) {
                String[] taskIdArray;
                for (String taskid : taskIdArray = taskIds.split(",")) {
                    if (!StringUtils.isNotBlank((String)taskid)) continue;
                    this.taskActionService.noUsedTask(taskid, userid);
                }
            }
        }
        catch (Exception e) {
            try {
                return this.handlerJSONException(e);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.handlerSuccessJson();
    }

    @RequestMapping(value={"endTaskRestFul"})
    @ResponseBody
    public Object endTaskRestFul(@RequestParam(value="wiid", required=false) String wiid, @RequestParam(value="taskid", required=false) String taskid, @RequestParam(value="userid", required=false) String userid) {
        try {
            PfTaskVo pfTaskVo;
            PfWorkFlowInstanceVo pfWorkFlowInstanceVo = null;
            if (StringUtils.isNotBlank((String)taskid) && (pfTaskVo = this.sysTaskService.getTask(taskid)) != null && StringUtils.isNotBlank((String)pfTaskVo.getActivityId())) {
                PfActivityVo pfActivityVo = this.sysActivityService.getActivityById(pfTaskVo.getActivityId());
                if (pfActivityVo != null && StringUtils.isNotBlank((String)pfActivityVo.getWorkflowInstanceId())) {
                    pfWorkFlowInstanceVo = this.sysWorkFlowInstanceService.getWorkflowInstance(pfActivityVo.getWorkflowInstanceId());
                }
                if (pfWorkFlowInstanceVo != null) {
                    wiid = pfWorkFlowInstanceVo.getWorkflowIntanceId();
                }
            }
            String turnXml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><Activitys><ReMark><text/></ReMark></Activitys>";
            this.taskActionService.endTask(wiid, taskid, userid, pfWorkFlowInstanceVo, null, turnXml, null);
        }
        catch (Exception e) {
            try {
                return this.handlerJSONException(e);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.handlerSuccessJson();
    }

    @RequestMapping(value={"dutyPaidTask"})
    @ResponseBody
    public Object dutyPaidTask(@RequestParam(value="taskid", required=false) String taskid) {
        PfWorkFlowInstanceVo pfWorkFlowInstanceVo = null;
        String slbh = null;
        HashMap<String, String> map = new HashMap<String, String>();
        String url = AppConfig.getProperty((String)"server.url") + "/" + AppConfig.getProperty((String)"bdcdj.version") + "/ysl/checkWsInfo";
        try {
            if (StringUtils.isNotBlank((String)taskid)) {
                PfTaskVo pfTaskVo = this.sysTaskService.getTask(taskid);
                if (pfTaskVo != null && StringUtils.isNotBlank((String)pfTaskVo.getActivityId())) {
                    String remark;
                    PfActivityVo pfActivityVo = this.sysActivityService.getActivityById(pfTaskVo.getActivityId());
                    if (pfActivityVo != null && StringUtils.isNotBlank((String)pfActivityVo.getWorkflowInstanceId())) {
                        pfWorkFlowInstanceVo = this.sysWorkFlowInstanceService.getWorkflowInstance(pfActivityVo.getWorkflowInstanceId());
                    }
                    if (pfWorkFlowInstanceVo != null && StringUtils.isNotBlank((String)(remark = pfWorkFlowInstanceVo.getRemark()))) {
                        slbh = remark.split("\\$")[0];
                    }
                }
                map.put("slbh", slbh);
                map.put("taskid", taskid);
                String result = HttpClientUtil.doGet((String)url, map);
                if (StringUtils.isNotBlank((String)result)) {
                    JSONObject jsonObject = JSONObject.parseObject((String)result);
                    String msg = (String)jsonObject.get((Object)"msg");
                    return this.handlerSuccessJson(msg);
                }
            }
        }
        catch (Exception e) {
            try {
                return this.handlerJSONException(e);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.handlerSuccessJson();
    }

    @RequestMapping(value={"publicTask"})
    @ResponseBody
    public Object publicTask(HttpServletRequest request, @RequestParam(value="wiid", required=false) String wiid, @RequestParam(value="taskid", required=false) String taskid, @RequestParam(value="begindate", required=false) String begindate, @RequestParam(value="enddate", required=false) String enddate, @RequestParam(value="userid", required=false) String userid) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        try {
            PfTaskVo pfTaskVo;
            Date kssj = sdf.parse(begindate);
            Date jssj = sdf.parse(enddate);
            BDCGG bdcgg = new BDCGG();
            bdcgg.setGgid(UUIDGenerator.generate());
            bdcgg.setWiid(wiid);
            bdcgg.setProid(wiid);
            bdcgg.setKssj(kssj);
            bdcgg.setJssj(jssj);
            bdcgg.setSffb("1");
            this.taskActionService.saveBdcgg(bdcgg);
            PfWorkFlowInstanceVo pfWorkFlowInstanceVo = null;
            if (StringUtils.isNotBlank((String)taskid) && (pfTaskVo = this.sysTaskService.getTask(taskid)) != null && StringUtils.isNotBlank((String)pfTaskVo.getActivityId())) {
                PfActivityVo pfActivityVo = this.sysActivityService.getActivityById(pfTaskVo.getActivityId());
                if (pfActivityVo != null && StringUtils.isNotBlank((String)pfActivityVo.getWorkflowInstanceId())) {
                    pfWorkFlowInstanceVo = this.sysWorkFlowInstanceService.getWorkflowInstance(pfActivityVo.getWorkflowInstanceId());
                }
                if (pfWorkFlowInstanceVo != null) {
                    wiid = pfWorkFlowInstanceVo.getWorkflowIntanceId();
                }
            }
            this.taskActionService.postTask(wiid, taskid, userid, "", pfWorkFlowInstanceVo, request);
        }
        catch (Exception e) {
            try {
                return this.handlerJSONException(e);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.handlerSuccessJson();
    }

    @RequestMapping(value={"getPublicList"})
    @ResponseBody
    public List<BDCGG> getPublicList(HttpServletRequest request, @RequestParam(value="wiid", required=false) String wiid) {
        List<Object> listgg = new ArrayList<BDCGG>();
        try {
            listgg = this.taskActionService.getbdcggListByCondition(wiid, "1");
        }
        catch (Exception exception) {
            // empty catch block
        }
        return listgg;
    }

    @RequestMapping(value={"unPublicTask"})
    @ResponseBody
    public Object unPublicTask(HttpServletRequest request, @RequestParam(value="wiid", required=false) String wiid, @RequestParam(value="taskid", required=false) String taskid, @RequestParam(value="userid", required=false) String userid) {
        try {
            PfTaskVo pfTaskVo;
            PfWorkFlowInstanceVo pfWorkFlowInstanceVo = null;
            if (StringUtils.isNotBlank((String)taskid) && (pfTaskVo = this.sysTaskService.getTask(taskid)) != null && StringUtils.isNotBlank((String)pfTaskVo.getActivityId())) {
                PfActivityVo pfActivityVo = this.sysActivityService.getActivityById(pfTaskVo.getActivityId());
                if (pfActivityVo != null && StringUtils.isNotBlank((String)pfActivityVo.getWorkflowInstanceId())) {
                    pfWorkFlowInstanceVo = this.sysWorkFlowInstanceService.getWorkflowInstance(pfActivityVo.getWorkflowInstanceId());
                }
                if (pfWorkFlowInstanceVo != null) {
                    wiid = pfWorkFlowInstanceVo.getWorkflowIntanceId();
                }
            }
            this.taskActionService.upPostTask(wiid, taskid, userid, pfWorkFlowInstanceVo, request);
            List listgg = this.taskActionService.getbdcggListByCondition(wiid, "1");
            if (listgg.size() > 0) {
                BDCGG bdcgg = new BDCGG();
                bdcgg.setWiid(((BDCGG)listgg.get(0)).getWiid());
                bdcgg.setProid(((BDCGG)listgg.get(0)).getProid());
                bdcgg.setGgid(((BDCGG)listgg.get(0)).getGgid());
                bdcgg.setSffb("0");
                bdcgg.setKssj(((BDCGG)listgg.get(0)).getKssj());
                bdcgg.setJssj(((BDCGG)listgg.get(0)).getJssj());
                this.taskActionService.update(bdcgg);
            }
        }
        catch (Exception e) {
            try {
                return this.handlerJSONException(e);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.handlerSuccessJson();
    }
}

