/*
 * Decompiled with CFR 0.152.
 */
package com.gtis.portal.web;

import cn.gtmap.estateplat.utils.ClientInfoUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.gtis.common.util.UUIDGenerator;
import com.gtis.config.AppConfig;
import com.gtis.fileCenter.model.Node;
import com.gtis.fileCenter.model.Space;
import com.gtis.fileCenter.service.NodeService;
import com.gtis.generic.util.JsonUtils;
import com.gtis.plat.service.SysUserService;
import com.gtis.portal.entity.PfMessageAccept;
import com.gtis.portal.entity.PfMessageSend;
import com.gtis.portal.service.PfMessageService;
import com.gtis.web.SessionUtil;
import java.net.URLDecoder;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class MessageController {
    @Autowired
    PfMessageService messageService;
    @Autowired
    NodeService nodeService;
    @Autowired
    SysUserService sysUserService;
    @Autowired
    SysUserService userService;
    private static final int PAGE_SIZE = 10;

    @RequestMapping(value={"message"})
    public String enter(String title, Date beginDate, Date endDate, Pageable page, Model model) {
        return "message";
    }

    @RequestMapping(value={"message/messageStatus"})
    public String messageStatus(String messagesendId, Model model) {
        model.addAttribute("messagesendId", (Object)messagesendId);
        return "message-acceptStatus";
    }

    @RequestMapping(value={"message/sendList"})
    public String sendList(Model model) {
        return "message-sendlist";
    }

    @RequestMapping(value={"message/acceptList"})
    public String acceptList(Model model) {
        return "message-acceptlist";
    }

    @RequestMapping(value={"message/ycqAcceptList"})
    public String ycqAcceptList(Model model) {
        return "message-ycqAcceptList";
    }

    @RequestMapping(value={"message/jjcqAcceptList"})
    public String jjcqAcceptList(Model model) {
        return "message-jjcqAcceptList";
    }

    @RequestMapping(value={"message/dbAcceptList"})
    public String dbAcceptList(Model model) {
        return "message-dbAcceptList";
    }

    @ResponseBody
    @RequestMapping(value={"message/sendlistPage"})
    public Object sendlistPage(Model model, Pageable page, String dcxc) {
        String userId = SessionUtil.getCurrentUserId();
        Page messageSendPage = null;
        int size = page == null ? 10 : page.getPageSize();
        int pagenum = page == null ? 1 : page.getPageNumber();
        try {
            page = new PageRequest(pagenum, size, Sort.Direction.DESC, new String[]{"messagesendDate"});
            messageSendPage = this.messageService.queryMessageSendList(userId, dcxc, null, null, page);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (messageSendPage == null) {
            return null;
        }
        JSONObject json = new JSONObject();
        json.put("rows", (Object)messageSendPage.getContent());
        json.put("total", (Object)messageSendPage.getTotalPages());
        json.put("records", (Object)messageSendPage.getTotalElements());
        json.put("page", (Object)(messageSendPage.getNumber() + 1));
        json.put("pageSize", (Object)messageSendPage.getSize());
        return json;
    }

    @RequestMapping(value={"message/send"})
    @ResponseBody
    public Object send(@RequestParam(value="messageId", required=true) String messageId, String acceptId, String messageType, Model model) {
        if ("accept".equals(messageType)) {
            this.messageService.updateAcceptMessageById(acceptId);
        }
        Space space = this.nodeService.getWorkSpace("MESSAGE_FILE", true);
        Node msgNode = this.nodeService.getNode(space.getId(), messageId, true);
        Integer nodeId = msgNode.getId();
        String token = this.nodeService.getToken(msgNode);
        PfMessageSend pfMessageSend = this.messageService.getMessageSend(messageId);
        HashMap<String, Object> result = new HashMap<String, Object>(3);
        result.put("token", token);
        result.put("nodeId", nodeId);
        result.put("pfMessageSend", pfMessageSend);
        Map messageSendContentMap = null;
        if (StringUtils.isNotBlank((String)pfMessageSend.getMessagesendContent())) {
            messageSendContentMap = (Map)JSON.parseObject((String)pfMessageSend.getMessagesendContent(), Map.class);
        }
        result.put("messageSendContent", messageSendContentMap);
        return result;
    }

    @RequestMapping(value={"message/accept"})
    @ResponseBody
    public PfMessageAccept accept(@RequestParam(value="messageId", required=true) String messageId, Model model) {
        return this.messageService.getMessageAccept(messageId);
    }

    @RequestMapping(value={"message/queryAcceptList"})
    @ResponseBody
    public List<PfMessageAccept> queryAcceptList(@RequestParam(value="messageId", required=true) String messageId, Model model) {
        return this.messageService.queryPfMessageAcceptByMessageId(messageId);
    }

    @ResponseBody
    @RequestMapping(value={"message/acceptlistPage"})
    public Object acceptlistPage(String messagesendId, String userId, String userName, String dcxc, String statusList, String messageTitle, Pageable page) {
        Page messageAcceptPage = null;
        int size = page == null ? 10 : page.getPageSize();
        int pagenum = page == null ? 1 : page.getPageNumber();
        try {
            if (StringUtils.isBlank((String)userId) && !Boolean.valueOf(statusList).booleanValue()) {
                userId = SessionUtil.getCurrentUserId();
            }
            page = new PageRequest(pagenum, size, Sort.Direction.DESC, new String[]{"messageacceptDate"});
            messageAcceptPage = this.messageService.queryMessageAcceptList(userId, dcxc, userName, messageTitle, messagesendId, null, null, page);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (messageAcceptPage == null) {
            return null;
        }
        JSONObject json = new JSONObject();
        json.put("rows", (Object)messageAcceptPage.getContent());
        json.put("total", (Object)messageAcceptPage.getTotalPages());
        json.put("records", (Object)messageAcceptPage.getTotalElements());
        json.put("page", (Object)(messageAcceptPage.getNumber() + 1));
        json.put("pageSize", (Object)messageAcceptPage.getSize());
        return json;
    }

    @ResponseBody
    @RequestMapping(value={"message/deleteSendMsg"})
    public Object deleteSendMsg(PfMessageSend pfMessageSend) {
        boolean result = false;
        if (pfMessageSend != null && StringUtils.isNotBlank((String)pfMessageSend.getMessagesendId())) {
            List pfMessageAcceptList = this.messageService.queryPfMessageAcceptByMessageId(pfMessageSend.getMessagesendId());
            if (CollectionUtils.isNotEmpty((Collection)pfMessageAcceptList)) {
                for (PfMessageAccept pfMessageAccept : pfMessageAcceptList) {
                    this.messageService.deleteAcceptMessage(pfMessageAccept);
                }
            }
            this.messageService.deleteSendMessage(pfMessageSend);
            result = true;
        }
        return result;
    }

    @ResponseBody
    @RequestMapping(value={"message/deleteAcceptMsg"})
    public Object deleteAcceptMsg(PfMessageAccept pfMessageAccept) {
        boolean result = false;
        if (pfMessageAccept != null && StringUtils.isNotBlank((String)pfMessageAccept.getMessageacceptId())) {
            this.messageService.deleteAcceptMessage(pfMessageAccept);
            result = true;
        }
        return result;
    }

    @ResponseBody
    @RequestMapping(value={"message/createMessage"})
    public Object createMessage(PfMessageSend pfMessageSend, String users, HttpServletRequest request) {
        HashMap<String, Object> result = new HashMap<String, Object>(3);
        try {
            if (StringUtils.isBlank((String)pfMessageSend.getMessagesendId())) {
                String messagesendId = UUIDGenerator.generate18();
                Space space = this.nodeService.getWorkSpace("MESSAGE_FILE", true);
                Node msgNode = this.nodeService.getNode(space.getId(), messagesendId, true);
                Integer nodeId = msgNode.getId();
                String token = this.nodeService.getToken(msgNode);
                result.put("messagesendId", messagesendId);
                result.put("nodeId", nodeId);
                result.put("token", token);
            } else {
                this.messageService.addSendMessageAndAcceptMessage(pfMessageSend, users);
                this.messageService.addPfLogBySendMessage(pfMessageSend, ClientInfoUtil.getIpAddr((HttpServletRequest)request));
                result.put("result", true);
            }
        }
        catch (Exception e) {
            result.put("result", false);
            e.printStackTrace();
        }
        return result;
    }

    @ResponseBody
    @RequestMapping(value={"message/updateMessage"})
    public Object updateMessage(PfMessageSend pfMessageSend, String users, HttpServletRequest request) {
        boolean result = false;
        try {
            this.messageService.updateSendMessage(pfMessageSend);
            result = true;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    @RequestMapping(value={"message/messageFile"}, method={RequestMethod.GET})
    public String createAllFileFolder(Model model, String title, @RequestParam(value="messagesendId", required=false) String messagesendId) {
        String fileCenterUrl = "fcm";
        Integer projectFileId = null;
        fileCenterUrl = fileCenterUrl + AppConfig.getFileCenterUrl().substring(4);
        try {
            projectFileId = this.messageService.getProjectFileId(messagesendId);
            if (StringUtils.isNotBlank((String)title)) {
                title = URLDecoder.decode(title, "UTF-8");
                projectFileId = this.messageService.createFileFolderByMessage(projectFileId, title);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        model.addAttribute("fileCenterUrl", (Object)fileCenterUrl);
        model.addAttribute("nodeId", (Object)projectFileId);
        return "file-browse";
    }

    @RequestMapping(value={"message/userlist"})
    public String roleSelect(Model model) {
        List organVoList = this.userService.getOrganList();
        List roleVoList = this.userService.getRoleList();
        if (CollectionUtils.isNotEmpty((Collection)organVoList)) {
            model.addAttribute("organList", (Object)organVoList);
        }
        if (CollectionUtils.isNotEmpty((Collection)roleVoList)) {
            model.addAttribute("roleList", (Object)roleVoList);
        }
        return "message-users";
    }

    @RequestMapping(value={"/message/getuser"})
    @ResponseBody
    public String getuser(String organId, String roleId) throws Exception {
        List lstUsers = null;
        if (StringUtils.isNotBlank((String)organId)) {
            lstUsers = this.userService.getUserListByOragn(organId);
        }
        if (StringUtils.isNotBlank((String)roleId)) {
            lstUsers = this.userService.getUserListByRole(roleId);
        }
        return JsonUtils.toString((Object)lstUsers);
    }

    @RequestMapping(value={"/message/countMessage/{userId}"}, method={RequestMethod.GET})
    @ResponseBody
    public Object countMessage(Model model, @PathVariable String userId) throws Exception {
        return String.valueOf(this.messageService.countPfMessageAccept(userId, Integer.valueOf(0), ""));
    }

    @RequestMapping(value={"/message/countYcqMessage/{userId}"}, method={RequestMethod.GET})
    @ResponseBody
    public Object countYcqMessage(Model model, @PathVariable String userId) throws Exception {
        return String.valueOf(this.messageService.countPfMessageAccept(userId, Integer.valueOf(0), "\u5f85\u529e\u4efb\u52a1\u65f6\u9650\u5df2\u8d85\u671f\u63d0\u9192"));
    }

    @RequestMapping(value={"/message/countJjcqMessage/{userId}"}, method={RequestMethod.GET})
    @ResponseBody
    public Object countJjcqMessage(Model model, @PathVariable String userId) throws Exception {
        return String.valueOf(this.messageService.countPfMessageAccept(userId, Integer.valueOf(0), "\u5f85\u529e\u4efb\u52a1\u65f6\u9650\u5373\u5c06\u5230\u671f\u63d0\u9192"));
    }

    @RequestMapping(value={"/message/countDBMessage/{userId}"}, method={RequestMethod.GET})
    @ResponseBody
    public Object countDbMessage(@PathVariable String userId) {
        return String.valueOf(this.messageService.countPfMessageAccept(userId, Integer.valueOf(0), "\u5f85\u529e\u4efb\u52a1\u63d0\u9192"));
    }
}

