/*
 * Decompiled with CFR 0.152.
 */
package com.gtis.portal.service.impl;

import cn.gtmap.estateplat.service.portal.TaskPerformerFilterService;
import com.google.common.collect.Lists;
import com.gtis.config.AppConfig;
import com.gtis.plat.service.SysTaskService;
import com.gtis.plat.service.SysUserService;
import com.gtis.plat.service.SysWorkFlowDefineService;
import com.gtis.plat.service.SysWorkFlowInstanceService;
import com.gtis.plat.service.WorkFlowCoreService;
import com.gtis.plat.vo.PfTaskVo;
import com.gtis.plat.vo.PfUserVo;
import com.gtis.plat.vo.PfWorkFlowDefineVo;
import com.gtis.plat.vo.PfWorkFlowInstanceVo;
import com.gtis.plat.wf.WorkFlowInfo;
import com.gtis.plat.wf.model.ActivityModel;
import com.gtis.plat.wf.model.PerformerModel;
import com.gtis.portal.entity.BdcXm;
import com.gtis.portal.service.TaskAfterTurnGeneralService;
import com.gtis.portal.service.server.AutoTurnTaskService;
import com.gtis.portal.service.server.BdcXmService;
import com.gtis.portal.util.WorkFlowXml;
import com.gtis.portal.util.WorkFlowXmlUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

public class TaskPerformerMinWorkloadFilterServiceImpl
implements TaskPerformerFilterService {
    @Autowired
    SysWorkFlowInstanceService sysWorkFlowInstanceService;
    @Autowired
    AutoTurnTaskService autoTurnTaskService;
    @Autowired
    SysUserService sysUserService;
    @Autowired
    BdcXmService bdcXmService;
    @Autowired
    WorkFlowCoreService workFlowService;
    @Resource(name="taskPerformerMinWorkloadFilterService")
    TaskPerformerFilterService taskPerformerFilterService;
    @Autowired
    SysWorkFlowDefineService sysWorkFlowDefineService;
    @Autowired
    SysTaskService taskService;
    @Resource(name="taskAfterTurnGeneralServiceImpl")
    TaskAfterTurnGeneralService taskAfterTurnGeneralServiceImpl;

    public List<PfUserVo> getTaskPerformers(String wiid, String targetActivityDefinitionId, PfTaskVo sourceTask, List<PfUserVo> sourceUsers, String wdid) {
        PfUserVo pfUserVo;
        String userid;
        PfWorkFlowInstanceVo pfWorkFlowInstanceVo;
        String onlyYhsq = AppConfig.getProperty((String)"yhsq.only.autoTurnTask.enble");
        if (StringUtils.equals((String)onlyYhsq, (String)"true") && StringUtils.isNotBlank((String)wiid)) {
            List bdcXmList = this.bdcXmService.getBdcXmList(wiid);
            boolean isyhsq = false;
            if (CollectionUtils.isNotEmpty((Collection)bdcXmList)) {
                for (BdcXm bdcXm : bdcXmList) {
                    if (bdcXm == null || !StringUtils.isNotBlank((String)bdcXm.getYhsqywh())) continue;
                    isyhsq = true;
                    break;
                }
            } else {
                isyhsq = true;
            }
            if (!isyhsq) {
                return null;
            }
        }
        if ((pfWorkFlowInstanceVo = this.sysWorkFlowInstanceService.getWorkflowInstance(wiid)) != null && StringUtils.isBlank((String)wiid)) {
            wdid = pfWorkFlowInstanceVo.getWorkflowDefinitionId();
        }
        if (StringUtils.isNotBlank((String)(userid = this.autoTurnTaskService.getZdpjYhid(wdid, targetActivityDefinitionId, sourceUsers))) && (pfUserVo = this.sysUserService.getUserVo(userid)) != null) {
            return Lists.newArrayList((Object[])new PfUserVo[]{pfUserVo});
        }
        return null;
    }

    public WorkFlowInfo createWorkFlowInstance(PfWorkFlowInstanceVo intanceVo, String userId) throws Exception {
        WorkFlowInfo workFlowInfo = null;
        PfWorkFlowDefineVo pfWorkFlowDefineVo = null;
        if (intanceVo == null || StringUtils.isBlank((String)intanceVo.getWorkflowDefinitionId())) {
            return null;
        }
        pfWorkFlowDefineVo = this.sysWorkFlowDefineService.getWorkFlowDefine(intanceVo.getWorkflowDefinitionId());
        WorkFlowXml workXml = WorkFlowXmlUtil.getDefineModel((PfWorkFlowDefineVo)pfWorkFlowDefineVo);
        List activityModelList = workXml.getActivityList();
        ActivityModel activityModel = null;
        if (CollectionUtils.isNotEmpty((Collection)activityModelList)) {
            activityModel = (ActivityModel)activityModelList.get(0);
        }
        String autoTurnTaskEnable = AppConfig.getProperty((String)"autoTurnTask.enble");
        if (activityModel != null && StringUtils.equals((String)autoTurnTaskEnable, (String)"true")) {
            List performerUsers = null;
            ArrayList pfUserVoList = Lists.newArrayList();
            for (PerformerModel performerModel : activityModel.getPerformerList()) {
                List pfUserVoList1;
                if (StringUtils.isNotBlank((String)performerModel.getUserId())) {
                    PfUserVo pfUserVo = new PfUserVo();
                    pfUserVo.setUserId(performerModel.getUserId());
                    pfUserVo.setUserName(this.sysUserService.getUserVo(performerModel.getUserId()).getUserName());
                    pfUserVoList.add(pfUserVo);
                }
                if (StringUtils.isNotBlank((String)performerModel.getRoleId()) && CollectionUtils.isNotEmpty((Collection)(pfUserVoList1 = this.sysUserService.getUserListByRole(performerModel.getRoleId())))) {
                    pfUserVoList.addAll(pfUserVoList1);
                }
                if (!StringUtils.isNotBlank((String)performerModel.getOrganId()) || !CollectionUtils.isNotEmpty((Collection)(pfUserVoList1 = this.sysUserService.getUserListByOragn(performerModel.getOrganId())))) continue;
                pfUserVoList.addAll(pfUserVoList1);
            }
            performerUsers = this.taskPerformerFilterService.getTaskPerformers(intanceVo.getWorkflowIntanceId(), activityModel.getDefineId(), null, (List)pfUserVoList, intanceVo.getWorkflowDefinitionId());
            workFlowInfo = CollectionUtils.isNotEmpty((Collection)performerUsers) ? this.workFlowService.createWorkFlowInstance(intanceVo, ((PfUserVo)performerUsers.get(0)).getUserId()) : this.workFlowService.createWorkFlowInstance(intanceVo, userId);
            if (workFlowInfo != null) {
                this.taskAfterTurnGeneralServiceImpl.doWork(workFlowInfo);
            }
        }
        return workFlowInfo;
    }
}

