/*
 * Decompiled with CFR 0.152.
 */
package com.gtis.portal.service.impl;

import com.gtis.plat.service.SysTaskService;
import com.gtis.plat.service.SysWorkFlowDefineService;
import com.gtis.plat.service.SysWorkFlowInstanceService;
import com.gtis.plat.vo.PfActivityVo;
import com.gtis.plat.vo.PfTaskVo;
import com.gtis.plat.vo.PfWorkFlowDefineVo;
import com.gtis.plat.vo.PfWorkFlowInstanceVo;
import com.gtis.plat.wf.WorkFlowInfo;
import com.gtis.portal.ex.ExceptionCode;
import com.gtis.portal.ex.PortalException;
import com.gtis.portal.service.TaskAfterTurnGeneralService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.concurrent.ThreadPoolTaskScheduler;

public class TaskAfterTurnGeneralServiceImpl
implements TaskAfterTurnGeneralService {
    @Autowired
    SysWorkFlowInstanceService sysWorkFlowInstanceService;
    @Autowired
    SysTaskService taskService;
    @Autowired
    SysWorkFlowDefineService sysWorkFlowDefineService;
    @Autowired
    ThreadPoolTaskScheduler taskScheduler;
    private List<Map<TaskAfterTurnGeneralService, String>> taskAfterTurnGeneralServiceList;
    Map.Entry<TaskAfterTurnGeneralService, String> taskAfterTurnGeneralServiceMapEntry;
    public WorkFlowInfo workFlowInfo;

    public List<Map<TaskAfterTurnGeneralService, String>> getTaskAfterTurnGeneralServiceList() {
        return this.taskAfterTurnGeneralServiceList;
    }

    public void setTaskAfterTurnGeneralServiceList(List<Map<TaskAfterTurnGeneralService, String>> taskAfterTurnGeneralServiceList) {
        this.taskAfterTurnGeneralServiceList = taskAfterTurnGeneralServiceList;
    }

    public boolean doWork(WorkFlowInfo info) throws PortalException {
        this.workFlowInfo = info;
        boolean turnEnable = false;
        try {
            if (CollectionUtils.isNotEmpty((Collection)this.taskAfterTurnGeneralServiceList)) {
                for (Map workFlowEventServiceMap : this.taskAfterTurnGeneralServiceList) {
                    Iterator iterator = workFlowEventServiceMap.entrySet().iterator();
                    while (iterator.hasNext()) {
                        Map.Entry workFlowEventServiceEntry;
                        this.taskAfterTurnGeneralServiceMapEntry = workFlowEventServiceEntry = iterator.next();
                        String async = (String)workFlowEventServiceEntry.getValue();
                        if (StringUtils.equals((String)async, (String)"true")) {
                            this.taskScheduler.execute((Runnable)new /* Unavailable Anonymous Inner Class!! */);
                            continue;
                        }
                        ((TaskAfterTurnGeneralService)this.taskAfterTurnGeneralServiceMapEntry.getKey()).doWork(this.workFlowInfo);
                    }
                }
            }
            turnEnable = true;
        }
        catch (PortalException e) {
            throw new PortalException(ExceptionCode.TASK_AFTERTURN_GENERAL_ERROR);
        }
        return turnEnable;
    }

    public WorkFlowInfo getInfoObj(String taskid, String userid) {
        WorkFlowInfo info = new WorkFlowInfo();
        info.setUserId(userid);
        PfTaskVo pfTaskVo = this.taskService.getHistoryTask(taskid);
        if (pfTaskVo != null) {
            PfActivityVo pfActivityVo;
            info.setSourceTask(pfTaskVo);
            if (StringUtils.isNotBlank((String)pfTaskVo.getActivityId()) && (pfActivityVo = this.taskService.getActivity(pfTaskVo.getActivityId())) != null) {
                info.setSourceActivity(pfActivityVo);
                if (StringUtils.isNotBlank((String)pfActivityVo.getWorkflowInstanceId())) {
                    List targetActivityVoList;
                    PfWorkFlowInstanceVo pfWorkFlowInstanceVo = this.sysWorkFlowInstanceService.getWorkflowInstance(pfActivityVo.getWorkflowInstanceId());
                    if (pfWorkFlowInstanceVo != null) {
                        info.setWorkFlowIntanceVo(pfWorkFlowInstanceVo);
                        if (StringUtils.isNotBlank((String)pfWorkFlowInstanceVo.getWorkflowDefinitionId())) {
                            PfWorkFlowDefineVo pfWorkFlowDefineVo = this.sysWorkFlowDefineService.getWorkFlowDefine(pfWorkFlowInstanceVo.getWorkflowDefinitionId());
                            info.setWorkFlowDefineVo(pfWorkFlowDefineVo);
                        }
                    }
                    if (CollectionUtils.isNotEmpty((Collection)(targetActivityVoList = this.taskService.getWorkFlowInstanceActivityList(pfActivityVo.getWorkflowInstanceId())))) {
                        ArrayList<PfActivityVo> targetActivityList = new ArrayList<PfActivityVo>();
                        for (PfActivityVo activityVo : targetActivityVoList) {
                            if (activityVo.getActivityState() != 1) continue;
                            List targetTaskList = this.taskService.getTaskListByActivity(activityVo.getActivityId());
                            targetActivityList.add(activityVo);
                            info.setTargetTasks(targetTaskList);
                        }
                        info.setTargetActivitys(targetActivityList);
                    }
                }
            }
        }
        return info;
    }
}

