/*
 * Decompiled with CFR 0.152.
 */
package com.gtis.portal.service.impl;

import com.gtis.common.util.UUIDGenerator;
import com.gtis.fileCenter.ex.NodeNotFoundException;
import com.gtis.fileCenter.model.Node;
import com.gtis.fileCenter.model.Space;
import com.gtis.fileCenter.service.NodeService;
import com.gtis.plat.service.SysUserService;
import com.gtis.plat.vo.PfUserVo;
import com.gtis.portal.dao.BaseDao;
import com.gtis.portal.dao.MessageAcceptDao;
import com.gtis.portal.dao.MessageSendDao;
import com.gtis.portal.entity.PfLog;
import com.gtis.portal.entity.PfMessageAccept;
import com.gtis.portal.entity.PfMessageSend;
import com.gtis.portal.entity.PfUser;
import com.gtis.portal.entity.QPfMessageAccept;
import com.gtis.portal.entity.QPfMessageSend;
import com.gtis.portal.service.PfMessageService;
import com.gtis.web.SessionUtil;
import com.mysema.query.jpa.JPQLQuery;
import com.mysema.query.jpa.impl.JPAQuery;
import com.mysema.query.types.EntityPath;
import com.mysema.query.types.Expression;
import com.mysema.query.types.OrderSpecifier;
import com.mysema.query.types.Predicate;
import com.mysema.query.types.expr.BooleanExpression;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.StringTokenizer;
import javax.annotation.Resource;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service
public class PfMessageServiceImpl
implements PfMessageService {
    @Autowired
    MessageSendDao messageSendDao;
    @Autowired
    MessageAcceptDao messageAcceptDao;
    @Autowired
    NodeService nodeService;
    @Resource(name="baseDaoImpl")
    BaseDao baseDao;
    @Autowired
    SysUserService sysUserService;
    @PersistenceContext(unitName="entityManagerFactory")
    EntityManager em;

    public Page<PfMessageSend> queryMessageSendList(String userId, String title, Date beginDate, Date endDate, @PageableDefault(size=10) Pageable page) {
        BooleanExpression expression = null;
        if (StringUtils.isNotBlank((String)userId)) {
            expression = QPfMessageSend.pfMessageSend.messagesendUser.userId.eq((Object)userId);
        }
        if (StringUtils.isNotBlank((String)title)) {
            expression = expression == null ? QPfMessageSend.pfMessageSend.messagesendTitle.like("%" + title + "%") : expression.and((Predicate)QPfMessageSend.pfMessageSend.messagesendTitle.like("%" + title + "%"));
        }
        return this.messageSendDao.findAll((Predicate)expression, page);
    }

    public Page<PfMessageAccept> queryMessageAcceptList(String userId, String slbh, String userName, String title, String sendMessageId, Date beginDate, Date endDate, Pageable page) {
        BooleanExpression expression = null;
        if (StringUtils.isNotBlank((String)userId)) {
            expression = QPfMessageAccept.pfMessageAccept.messageacceptUser.userId.eq((Object)userId);
        }
        if (StringUtils.isNotBlank((String)sendMessageId)) {
            BooleanExpression booleanExpression = expression = expression == null ? QPfMessageAccept.pfMessageAccept.messageSend.messagesendId.eq((Object)sendMessageId) : expression.and((Predicate)QPfMessageAccept.pfMessageAccept.messageSend.messagesendId.eq((Object)sendMessageId));
        }
        if (StringUtils.isNotBlank((String)title)) {
            BooleanExpression booleanExpression = expression = expression == null ? QPfMessageAccept.pfMessageAccept.messageSend.messagesendTitle.like("%" + title + "%") : expression.and((Predicate)QPfMessageAccept.pfMessageAccept.messageSend.messagesendTitle.like("%" + title + "%"));
        }
        if (StringUtils.isNotBlank((String)userName)) {
            BooleanExpression booleanExpression = expression = expression == null ? QPfMessageAccept.pfMessageAccept.messageacceptUser.userName.like("%" + userName + "%") : expression.and((Predicate)QPfMessageAccept.pfMessageAccept.messageacceptUser.userName.like("%" + userName + "%"));
        }
        if (StringUtils.isNotBlank((String)slbh)) {
            expression = expression == null ? QPfMessageAccept.pfMessageAccept.messageSend.messagesendContent.like("%" + slbh + "%") : expression.and((Predicate)QPfMessageAccept.pfMessageAccept.messageSend.messagesendContent.like("%" + slbh + "%"));
        }
        return this.messageAcceptDao.findAll((Predicate)expression, page);
    }

    public PfMessageSend getMessageSend(String messageId) {
        return (PfMessageSend)this.messageSendDao.findOne((Serializable)((Object)messageId));
    }

    public PfMessageAccept getMessageAccept(String messageId) {
        return (PfMessageAccept)this.messageAcceptDao.findOne((Serializable)((Object)messageId));
    }

    public List<PfMessageAccept> queryPfMessageAcceptByMessageId(String messageId) {
        QPfMessageAccept qPfMessageAccept = QPfMessageAccept.pfMessageAccept;
        JPAQuery query = new JPAQuery(this.em);
        List pfMessageAcceptList = ((JPQLQuery)((JPQLQuery)((JPQLQuery)query.from(new EntityPath[]{qPfMessageAccept})).where(new Predicate[]{qPfMessageAccept.messageSend.messagesendId.eq((Object)messageId)})).orderBy(new OrderSpecifier[]{qPfMessageAccept.messageacceptDate.desc()})).list((Expression)qPfMessageAccept);
        return pfMessageAcceptList;
    }

    public void addSendMessage(PfMessageSend pfMessageSend) {
        PfUser pfUser = new PfUser();
        pfUser.setUserId(SessionUtil.getCurrentUserId());
        pfMessageSend.setMessagesendUser(pfUser);
        pfMessageSend.setMessagesendDate(new Date());
        this.messageSendDao.saveAndFlush((Object)pfMessageSend);
    }

    public void updateSendMessage(PfMessageSend pfMessageSend) {
        PfUser pfUser = new PfUser();
        pfUser.setUserId(SessionUtil.getCurrentUserId());
        pfMessageSend.setMessagesendUser(pfUser);
        pfMessageSend.setMessagesendDate(new Date());
        this.baseDao.update((Object)pfMessageSend);
    }

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class})
    public void addSendMessageAndAcceptMessage(PfMessageSend pfMessageSend, String users) {
        this.addSendMessage(pfMessageSend);
        this.addAcceptMessageByUser(users, pfMessageSend);
    }

    public void addPfLogBySendMessage(PfMessageSend pfMessageSend, String ip) {
        if (pfMessageSend != null) {
            PfLog pfLog = new PfLog();
            pfLog.setId(UUIDGenerator.generate18());
            pfLog.setUserId(SessionUtil.getCurrentUserId());
            pfLog.setAction("\u6d88\u606f");
            pfLog.setContent(pfMessageSend.getMessagesendContent());
            pfLog.setIp(ip);
            pfLog.setCreateTime(new Date());
            this.addPfLog(pfLog);
        }
    }

    public void addAcceptMessage(PfMessageAccept pfMessageAccept) {
        this.baseDao.save((Object)pfMessageAccept);
    }

    public void updateAcceptMessageById(String messageacceptId) {
        PfMessageAccept pfMessageAccept = (PfMessageAccept)this.messageAcceptDao.findOne((Serializable)((Object)messageacceptId));
        if (pfMessageAccept != null && pfMessageAccept.getMessageacceptStatus() == 0) {
            pfMessageAccept.setMessageacceptStatus(1);
            pfMessageAccept.setMessageacceptDate(new Date());
            this.baseDao.update((Object)pfMessageAccept);
        }
    }

    public boolean addAcceptMessageByUser(String users, PfMessageSend pfMessageSend) {
        boolean result = false;
        if (StringUtils.isBlank((String)users)) {
            return result;
        }
        ArrayList<PfMessageAccept> pfMessageAcceptList = new ArrayList<PfMessageAccept>();
        List userList = null;
        if (users.equals("1")) {
            userList = this.sysUserService.getAllUsers();
        }
        if (CollectionUtils.isEmpty(userList)) {
            StringTokenizer st = new StringTokenizer(users, ",");
            while (st.hasMoreTokens()) {
                pfMessageAcceptList.add(this.createNewPfMessageAccept(st.nextToken(), pfMessageSend));
            }
        } else {
            for (PfUserVo pfUserVo : userList) {
                pfMessageAcceptList.add(this.createNewPfMessageAccept(pfUserVo.getUserId(), pfMessageSend));
            }
        }
        if (CollectionUtils.isNotEmpty(pfMessageAcceptList)) {
            for (PfMessageAccept pfMessageAccept : pfMessageAcceptList) {
                this.baseDao.save((Object)pfMessageAccept);
            }
        }
        result = true;
        return result;
    }

    public void addPfLog(PfLog pfLog) {
        this.baseDao.save((Object)pfLog);
    }

    public void deleteAcceptMessage(PfMessageAccept pfMessageAccept) {
        this.baseDao.delete(PfMessageAccept.class, (Object)pfMessageAccept.getMessageacceptId());
    }

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class})
    public void deleteSendMessage(PfMessageSend pfMessageSend) {
        this.baseDao.delete(PfMessageSend.class, (Object)pfMessageSend.getMessagesendId());
        this.deleteFileByMessage(pfMessageSend.getMessagesendId(), pfMessageSend.getMessagesendTitle());
    }

    public boolean deleteFile(String messagesendId) {
        boolean result = false;
        try {
            Space space = this.nodeService.getWorkSpace("MESSAGE_FILE", true);
            Node node = this.nodeService.getNode(space.getId(), messagesendId, true);
            this.nodeService.remove(node.getId());
        }
        catch (Exception e) {
            LoggerFactory.getLogger(PfMessageServiceImpl.class).info("\u5220\u9664\u9644\u4ef6\u5f02\u5e38", (Throwable)e);
        }
        result = true;
        return result;
    }

    public PfMessageAccept createNewPfMessageAccept(String userId, PfMessageSend pfMessageSend) {
        PfUser pfUser = new PfUser();
        pfUser.setUserId(userId);
        PfMessageAccept pfMessageAccept = new PfMessageAccept();
        pfMessageAccept.setMessageacceptId(UUIDGenerator.generate());
        pfMessageAccept.setMessageacceptStatus(0);
        pfMessageAccept.setMessageacceptUser(pfUser);
        pfMessageAccept.setMessageSend(pfMessageSend);
        return pfMessageAccept;
    }

    public Long countPfMessageAccept(String userId, Integer status, String messageTitle) {
        QPfMessageAccept qPfMessageAccept = QPfMessageAccept.pfMessageAccept;
        JPAQuery query = new JPAQuery(this.em);
        Long count = StringUtils.isNotBlank((String)messageTitle) ? Long.valueOf(((JPQLQuery)((JPQLQuery)((JPQLQuery)((JPQLQuery)query.from(new EntityPath[]{qPfMessageAccept})).where(new Predicate[]{qPfMessageAccept.messageacceptStatus.eq((Object)0)})).where(new Predicate[]{qPfMessageAccept.messageacceptUser.userId.eq((Object)userId)})).where(new Predicate[]{qPfMessageAccept.messageSend.messagesendTitle.eq((Object)messageTitle)})).count()) : Long.valueOf(((JPQLQuery)((JPQLQuery)((JPQLQuery)query.from(new EntityPath[]{qPfMessageAccept})).where(new Predicate[]{qPfMessageAccept.messageacceptStatus.eq((Object)0)})).where(new Predicate[]{qPfMessageAccept.messageacceptUser.userId.eq((Object)userId)})).count());
        return count;
    }

    public Integer createFileFolderByMessage(Integer parentId, String folderNodeName) {
        Node tempNode = null;
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)folderNodeName)) {
            try {
                tempNode = this.nodeService.getNode(parentId, folderNodeName, true);
            }
            catch (NodeNotFoundException e) {
                e.printStackTrace();
            }
            return tempNode != null ? tempNode.getId() : -1;
        }
        return -1;
    }

    public Integer getProjectFileId(String projectId) {
        Space space = this.nodeService.getWorkSpace("MESSAGE_FILE");
        Integer nodeId = this.createFileFolderByMessage(space.getId(), projectId);
        return nodeId;
    }

    public void deleteFileByMessage(String messageId, String title) {
        Integer nodeId = this.getProjectFileId(messageId);
        try {
            Node node = this.nodeService.getNode(nodeId, title, false);
            this.nodeService.remove(node.getId());
        }
        catch (NodeNotFoundException e) {
            LoggerFactory.getLogger(PfMessageServiceImpl.class).info("\u5220\u9664\u9644\u4ef6\u5f02\u5e38", (Throwable)e);
            e.printStackTrace();
        }
    }
}

