/*
 * Decompiled with CFR 0.152.
 */
package com.gtis.portal.dao.server;

import com.gtis.portal.dao.BaseDao;
import com.gtis.portal.util.QueryCondition;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import org.hibernate.SQLQuery;
import org.hibernate.transform.ResultTransformer;
import org.hibernate.transform.Transformers;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository
public class ServerBaseDaoImpl
implements BaseDao {
    @PersistenceContext(unitName="entityManagerFactory_server")
    EntityManager em;

    public <T> T getById(Class<T> clazz, Object id) {
        return (T)this.em.find(clazz, id);
    }

    @Transactional(value="transactionManager_server")
    public <T> void delete(Class<T> clazz, Object id) {
        Object entity;
        if (id != null && (entity = this.getById(clazz, id)) != null) {
            this.delete(entity);
        }
    }

    @Transactional(value="transactionManager_server")
    public <T> void delete(Object entity) {
        this.em.remove(entity);
    }

    @Transactional(value="transactionManager_server")
    public <T> void delete(Class<T> clazz, Object[] ids) {
        if (ids != null) {
            for (Object id : ids) {
                this.delete(clazz, id);
            }
        }
    }

    public <T> List<T> getAll(Class<T> clazz) {
        String className = clazz.getSimpleName();
        StringBuffer jpql = new StringBuffer("select o from ");
        jpql.append(className).append(" o ");
        return this.em.createQuery(jpql.toString()).getResultList();
    }

    @Transactional(value="transactionManager_server")
    public void save(Object entity) {
        this.em.persist(entity);
    }

    @Transactional(value="transactionManager_server")
    public void update(Object entity) {
        this.em.merge(entity);
    }

    public <T> List<T> get(Class<T> clazz, List<QueryCondition> queryConditions, String orderBy, int currentPage, int pageSize) {
        Query query = this.getQuery(clazz, queryConditions, orderBy, false);
        if (currentPage == 0 && pageSize == 0) {
            return query.getResultList();
        }
        return query.setFirstResult((currentPage - 1) * pageSize).setMaxResults(pageSize).getResultList();
    }

    private Query getQuery(Class clazz, List<QueryCondition> queryConditions, String orderBy, boolean isQueryTotal) {
        String className = clazz.getSimpleName();
        String preJPQL = isQueryTotal ? "select count(*) from " : "select o from ";
        StringBuffer jpql = new StringBuffer(preJPQL);
        jpql.append(className).append(" o where 1=1 ");
        Query query = null;
        if (queryConditions != null && queryConditions.size() > 0) {
            for (QueryCondition queryCondition : queryConditions) {
                if (queryCondition == null) continue;
                if (queryCondition.getOperator().equals("custom")) {
                    jpql.append(" and (").append(queryCondition.getCustomJPQL()).append(")");
                }
                if (queryCondition.getValue() == null || "".equals(queryCondition.getValue())) continue;
                String placeholder = queryCondition.getField().indexOf(".") != -1 ? queryCondition.getField().replace(".", "_") : queryCondition.getField();
                jpql.append(" and o.").append(queryCondition.getField().trim()).append(" ").append(queryCondition.getOperator()).append(":").append(placeholder.trim());
            }
        }
        if (orderBy != null && !"".equals(orderBy)) {
            jpql.append(" ").append(orderBy);
        }
        query = this.em.createQuery(jpql.toString());
        if (queryConditions != null && queryConditions.size() > 0) {
            for (QueryCondition queryCondition : queryConditions) {
                if (queryCondition == null || queryCondition.getValue() == null || "".equals(queryCondition.getValue())) continue;
                queryCondition.setField(queryCondition.getField().indexOf(".") != -1 ? queryCondition.getField().replace(".", "_") : queryCondition.getField());
                if (queryCondition.getOperator().equals("like")) {
                    query.setParameter(queryCondition.getField(), (Object)("%" + queryCondition.getValue() + "%"));
                    continue;
                }
                query.setParameter(queryCondition.getField(), queryCondition.getValue());
            }
        }
        return query;
    }

    public <T> List<T> get(Class<T> clazz, List<QueryCondition> queryConditions) {
        return this.get(clazz, queryConditions, null, 0, 0);
    }

    public <T> List<T> get(Class<T> clazz, List<QueryCondition> queryConditions, String orderBy) {
        return this.get(clazz, queryConditions, orderBy, 0, 0);
    }

    public Object getSingleResult(Class clazz, List<QueryCondition> queryConditions) {
        Query query = this.getQuery(clazz, queryConditions, null, true);
        return query.getSingleResult();
    }

    public long getRecordCount(Class clazz, List<QueryCondition> queryConditions) {
        Query query = this.getQuery(clazz, queryConditions, null, true);
        Object result = query.getSingleResult();
        long recordCount = 0L;
        if (result != null) {
            recordCount = (Long)result;
        }
        return recordCount;
    }

    public <T> List<T> getByJpql(String jpql, Object ... objects) {
        Query query = this.em.createQuery(jpql);
        if (objects != null && objects != null) {
            for (int i = 0; i < objects.length; ++i) {
                query.setParameter(i, objects[i]);
            }
        }
        return query.getResultList();
    }

    public int executeJpql(String jpql, Object ... objects) {
        Query query = this.em.createQuery(jpql);
        if (objects != null) {
            for (int i = 0; i < objects.length; ++i) {
                query.setParameter(i, objects[i]);
            }
        }
        return query.executeUpdate();
    }

    public Object getUniqueResultByJpql(String jpql, Object ... objects) {
        Query query = this.em.createQuery(jpql);
        if (objects != null) {
            for (int i = 0; i < objects.length; ++i) {
                query.setParameter(i, objects[i]);
            }
        }
        try {
            return query.getSingleResult();
        }
        catch (NoResultException e) {
            return null;
        }
    }

    public <T> List<T> getMapBySql(String sql, Object ... objects) {
        Query query = this.em.createNativeQuery(sql);
        SQLQuery impl = (SQLQuery)query.unwrap(SQLQuery.class);
        impl.setResultTransformer((ResultTransformer)Transformers.ALIAS_TO_ENTITY_MAP);
        if (objects != null && objects != null) {
            for (int i = 0; i < query.getParameters().size(); ++i) {
                query.setParameter(i, objects[i]);
            }
        }
        return query.getResultList();
    }

    public <T> List<T> getBySql(String sql, Object ... objects) {
        Query query = this.em.createNativeQuery(sql);
        if (objects != null && objects != null) {
            for (int i = 0; i < query.getParameters().size(); ++i) {
                query.setParameter(i, objects[i]);
            }
        }
        return query.getResultList();
    }
}

