package com.gtis.portal.web;

import cn.gtmap.estateplat.core.support.cas.UserService;
import com.alibaba.fastjson.JSONArray;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.gtis.common.http.Utf8PostMethod;
import com.gtis.common.util.CommonUtil;
import com.gtis.config.AppConfig;
import com.gtis.fileCenter.service.NodeService;
import com.gtis.plat.service.*;
import com.gtis.plat.vo.PfRoleVo;
import com.gtis.plat.vo.PfUserVo;
import com.gtis.plat.wf.WorkFlowInfo;
import com.gtis.plat.wf.WorkFlowTransInfo;
import com.gtis.plat.wf.model.ActivityModel;
import com.gtis.plat.wf.model.PerformerTaskModel;
import com.gtis.portal.ex.ExceptionCode;
import com.gtis.portal.ex.PortalException;
import com.gtis.portal.service.MsgReminderProvider;
import com.gtis.portal.service.MsgReminderService;
import com.gtis.portal.service.TaskBeforeTurnValidationService;
import com.gtis.portal.service.impl.TaskPerformerFilterServiceContext;
import com.gtis.portal.util.WorkFlowXml;
import com.gtis.portal.util.WorkFlowXmlUtil;
import com.gtis.web.SessionUtil;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpStatus;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.tree.DefaultText;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.client.RestTemplate;

import javax.annotation.Resource;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 消息提醒
 * @author <a href="mailto:zhangxing@gtmap.cn">zhangxing</a>
 * @version 1.0, 2015/1/8
 */
@Controller
@RequestMapping("/reminder")
public class ReminderController extends BaseController{
    private static final Log log = LogFactory.getLog(ReminderController.class);
    @Autowired
    MsgReminderService msgReminderService;
    @Resource(name = "fyReminderService")
    MsgReminderProvider fyReminderService;
    @Autowired
    SysUserService sysUserService;
    @ResponseBody
    @RequestMapping(value = "")
    public Object reminder() throws Exception {
        List<Map> reminderList = Lists.newArrayList();
        List<Map>  msgReminderList=msgReminderService.getAllMsgReminder();
        if(CollectionUtils.isNotEmpty(msgReminderList)){
            for(Map map:msgReminderList){
                if(map.get("count")!=null && (Integer)map.get("count")!=0){
                    Map reminderMap = Maps.newHashMap();
                    reminderMap.put("name",map.get("name"));
                    reminderMap.put("count",map.get("count"));
                    reminderMap.put("moreUrl",map.get("moreUrl"));
                    reminderList.add(reminderMap);
                }
            }
        }
        return reminderList;
    }

    @ResponseBody
    @RequestMapping(value = "fyReminder")
    public Object fyReminder(String userId) throws Exception {
        boolean reminderBool = false;
        if (StringUtils.isNotBlank(userId)) {
            List<PfRoleVo> pfRoleVos = sysUserService.getRoleListByUser(userId);
            String fyRoles = AppConfig.getProperty("fyReminder.roleIds");
            if (StringUtils.isNotBlank(fyRoles)) {
                for (PfRoleVo pfRoleVo : pfRoleVos) {
                    if (StringUtils.indexOf(fyRoles, pfRoleVo.getRoleId()) > -1) {
                        reminderBool = true;
                    }
                }
            }
        }

        Map reminderMap = Maps.newHashMap();
        reminderMap.put("name", fyReminderService.getName());
        int count = 0;
        if (reminderBool)
            count = fyReminderService.getCount();
        reminderMap.put("count", count);
        reminderMap.put("moreUrl", fyReminderService.getMoreUrl());

        return reminderMap;
    }

    @ResponseBody
    @RequestMapping(value = "test")
    public Object test(String userId) throws Exception {
   String count="1";

        return count;
    }
}
