/*
 * Project:  onemap
 * Module:   server
 * File:     IndexConfigController.java
 * Modifier: xyang
 * Modified: 2013-05-23 08:48:17
 *
 * Copyright (c) 2013 Gtmap Ltd. All Rights Reserved.
 *
 * Copying of this document or code and giving it to others and the
 * use or communication of the contents thereof, are forbidden without
 * expressed authority. Offenders are liable to the payment of damages.
 * All rights reserved in the event of the grant of a invention patent or the
 * registration of a utility model, design or code.
 */
package com.gtis.portal.web;

import cn.gtmap.estateplat.utils.ClientInfoUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.gtis.common.util.UUIDGenerator;
import com.gtis.config.AppConfig;
import com.gtis.fileCenter.model.Node;
import com.gtis.fileCenter.model.Space;
import com.gtis.fileCenter.service.NodeService;
import com.gtis.generic.util.JsonUtils;
import com.gtis.plat.service.SysUserService;
import com.gtis.plat.vo.PfOrganVo;
import com.gtis.plat.vo.PfRoleVo;
import com.gtis.plat.vo.PfUserVo;
import com.gtis.portal.entity.PfMessageAccept;
import com.gtis.portal.entity.PfMessageSend;
import com.gtis.portal.entity.PfUser;
import com.gtis.portal.service.PfMessageService;
import com.gtis.portal.util.Constants;
import com.gtis.web.SessionUtil;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import java.net.URLDecoder;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;


@Controller
public class MessageController {
    @Autowired
    PfMessageService messageService;
    @Autowired
    NodeService nodeService;
    @Autowired
    SysUserService sysUserService;
    @Autowired
    SysUserService userService;


    private final static int PAGE_SIZE = 10;

    @RequestMapping("message")
    public String enter(String title, Date beginDate, Date endDate, Pageable page, Model model) {

        return "message";
    }

    @RequestMapping("message/messageStatus")
    public String messageStatus(String messagesendId, Model model) {
        model.addAttribute("messagesendId", messagesendId);
        return "message-acceptStatus";
    }

    @RequestMapping("message/sendList")
    public String sendList(Model model) {
        return "message-sendlist";
    }

    @RequestMapping("message/acceptList")
    public String acceptList(Model model) {
        return "message-acceptlist";
    }

    /**
     * @author <a href="mailto:wenyuanwu@gtmap.cn">wenyuanwu</a>
     * @description 已超期消息列表
     */
    @RequestMapping("message/ycqAcceptList")
    public String ycqAcceptList(Model model) {
        return "message-ycqAcceptList";
    }

    /**
     * @author <a href="mailto:wenyuanwu@gtmap.cn">wenyuanwu</a>
     * @description 即将到期消息列表
     */
    @RequestMapping("message/jjcqAcceptList")
    public String jjcqAcceptList(Model model) {
        return "message-jjcqAcceptList";
    }

    /**
     * @author <a href="mailto:dingweiwei@gtmap.cn">dingweiwei</a>
     * @description 待办任务消息列表
     */
    @RequestMapping("message/dbAcceptList")
    public String dbAcceptList(Model model) {
        return "message-dbAcceptList";
    }

    /**
     * @author <a href="mailto:wenyuanwu@gtmap.cn">wenyuanwu</a>
     * @description 外网申请待匹配提醒
     */
    @RequestMapping("message/wwsqAcceptList")
    public String wwsqAcceptList(Model model) {
        return "message-wwsqAcceptList";
    }



    @ResponseBody
    @RequestMapping("message/sendlistPage")
    public Object sendlistPage(Model model, Pageable page, String dcxc) {
        String userId = SessionUtil.getCurrentUserId();
        Page<PfMessageSend> messageSendPage = null;
        int size = (page == null) ? PAGE_SIZE : page.getPageSize();
        int pagenum = (page == null) ? 1 : page.getPageNumber();
        try {
            page = new PageRequest(pagenum, size, Sort.Direction.DESC, "messagesendDate");
            messageSendPage = messageService.queryMessageSendList(userId, dcxc, null, null, page);
        } catch (Exception e) {
            e.printStackTrace();
        }
        if (messageSendPage == null) {
            return null;
        }
        JSONObject json = new JSONObject();
        json.put("rows", messageSendPage.getContent());
        json.put("total", messageSendPage.getTotalPages());
        json.put("records", messageSendPage.getTotalElements());
        json.put("page", messageSendPage.getNumber() + 1);
        json.put("pageSize", messageSendPage.getSize());
        return json;
    }

    @RequestMapping("message/send")
    @ResponseBody
    public Object send(@RequestParam(value = "messageId", required = true) String messageId, String acceptId, String messageType, Model model) {
        if (Constants.MESSAGE_TYPE_ACCEPT.equals(messageType)) {
            messageService.updateAcceptMessageById(acceptId);
        }
        Space space = nodeService.getWorkSpace(Constants.MESSAGE_FILE, true);
        Node msgNode = nodeService.getNode(space.getId(), messageId, true);
        Integer nodeId = msgNode.getId();
        String token = nodeService.getToken(msgNode);
        PfMessageSend pfMessageSend = messageService.getMessageSend(messageId);
        Map<String, Object> result = new HashMap<String, Object>(3);
        result.put("token", token);
        result.put("nodeId", nodeId);
        result.put("pfMessageSend", pfMessageSend);
        Map messageSendContentMap = null;
        if (StringUtils.isNotBlank(pfMessageSend.getMessagesendContent())) {
            messageSendContentMap = JSON.parseObject(pfMessageSend.getMessagesendContent(), Map.class);
        }
        result.put("messageSendContent", messageSendContentMap);
        return result;
    }

    @RequestMapping("message/accept")
    @ResponseBody
    public PfMessageAccept accept(@RequestParam(value = "messageId", required = true) String messageId, Model model) {
        return messageService.getMessageAccept(messageId);
    }

    @RequestMapping("message/queryAcceptList")
    @ResponseBody
    public List<PfMessageAccept> queryAcceptList(@RequestParam(value = "messageId", required = true) String messageId, Model model) {
        return messageService.queryPfMessageAcceptByMessageId(messageId);
    }


    @ResponseBody
    @RequestMapping("message/acceptlistPage")
    public Object acceptlistPage(String messagesendId, String userId, String userName, String dcxc, String statusList, String messageTitle, Pageable page) {
        Page<PfMessageAccept> messageAcceptPage = null;
        int size = (page == null) ? PAGE_SIZE : page.getPageSize();
        int pagenum = (page == null) ? 1 : page.getPageNumber();
        try {
            if (StringUtils.isBlank(userId) && (!Boolean.valueOf(statusList))) {
                userId = SessionUtil.getCurrentUserId();
            }
            page = new PageRequest(pagenum, size, Sort.Direction.DESC, "messageacceptDate");
            messageAcceptPage = messageService.queryMessageAcceptList(userId, dcxc, userName, messageTitle, messagesendId, null, null, page);
        } catch (Exception e) {
            e.printStackTrace();
        }
        if (messageAcceptPage == null) {
            return null;
        }
        JSONObject json = new JSONObject();
        json.put("rows", messageAcceptPage.getContent());
        json.put("total", messageAcceptPage.getTotalPages());
        json.put("records", messageAcceptPage.getTotalElements());
        json.put("page", messageAcceptPage.getNumber() + 1);
        json.put("pageSize", messageAcceptPage.getSize());
        return json;
    }


    @ResponseBody
    @RequestMapping("message/deleteSendMsg")
    public Object deleteSendMsg(PfMessageSend pfMessageSend) {
        boolean result = false;
        if (pfMessageSend != null && StringUtils.isNotBlank(pfMessageSend.getMessagesendId())) {
            List<PfMessageAccept> pfMessageAcceptList = messageService.queryPfMessageAcceptByMessageId(pfMessageSend.getMessagesendId());
            if (CollectionUtils.isNotEmpty(pfMessageAcceptList)) {
                for (PfMessageAccept pfMessageAccept : pfMessageAcceptList) {
                    messageService.deleteAcceptMessage(pfMessageAccept);
                }
            }
            messageService.deleteSendMessage(pfMessageSend);
            result = true;
        }
        return result;
    }

    @ResponseBody
    @RequestMapping("message/deleteAcceptMsg")
    public Object deleteAcceptMsg(PfMessageAccept pfMessageAccept) {
        boolean result = false;
        if (pfMessageAccept != null && StringUtils.isNotBlank(pfMessageAccept.getMessageacceptId())) {
            messageService.deleteAcceptMessage(pfMessageAccept);
            result = true;
        }
        return result;
    }

    @ResponseBody
    @RequestMapping("message/createMessage")
    public Object createMessage(PfMessageSend pfMessageSend, String users, HttpServletRequest request) {
        Map<String, Object> result = new HashMap<String, Object>(3);
        try {
            if (StringUtils.isBlank(pfMessageSend.getMessagesendId())) {
                String messagesendId = UUIDGenerator.generate18();
                Space space = nodeService.getWorkSpace(Constants.MESSAGE_FILE, true);
                Node msgNode = nodeService.getNode(space.getId(), messagesendId, true);
                Integer nodeId = msgNode.getId();
                String token = nodeService.getToken(msgNode);
                result.put("messagesendId", messagesendId);
                result.put("nodeId", nodeId);
                result.put("token", token);
            } else {
                messageService.addSendMessageAndAcceptMessage(pfMessageSend, users);
                //保存日志
                messageService.addPfLogBySendMessage(pfMessageSend, ClientInfoUtil.getIpAddr(request));
                result.put("result", true);
            }
        } catch (Exception e) {
            result.put("result", false);
            e.printStackTrace();
        }

        return result;
    }

    @ResponseBody
    @RequestMapping("message/updateMessage")
    public Object updateMessage(PfMessageSend pfMessageSend, String users, HttpServletRequest request) {
        boolean result = false;
        try {
            messageService.updateSendMessage(pfMessageSend);
            result = true;
        } catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    @RequestMapping(value = "message/messageFile", method = RequestMethod.GET)
    public String createAllFileFolder(Model model, String title, @RequestParam(value = "messagesendId", required = false) String messagesendId) {
        String fileCenterUrl = "fcm";
        Integer projectFileId = null;
        fileCenterUrl = fileCenterUrl + AppConfig.getFileCenterUrl().substring(4);
        try {
            projectFileId = messageService.getProjectFileId(messagesendId);
            if (StringUtils.isNotBlank(title)) {
                title = URLDecoder.decode(title, "UTF-8");
                projectFileId = messageService.createFileFolderByMessage(projectFileId, title);
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
        model.addAttribute("fileCenterUrl", fileCenterUrl);
        model.addAttribute("nodeId", projectFileId);
        model.addAttribute("username",SessionUtil.getCurrentUser().getUsername());
        return "file-browse";
    }

    @RequestMapping("message/userlist")
    public String roleSelect(Model model) {
        List<PfOrganVo> organVoList = userService.getOrganList();
        List<PfRoleVo> roleVoList = userService.getRoleList();
        if (CollectionUtils.isNotEmpty(organVoList)) {
            model.addAttribute("organList", organVoList);
        }
        if (CollectionUtils.isNotEmpty(roleVoList)) {
            model.addAttribute("roleList", roleVoList);
        }
        return "message-users";
    }

    @RequestMapping(value = "/message/getuser")
    @ResponseBody
    public String getuser(String organId, String roleId) throws Exception {
        List<PfUserVo> lstUsers = null;
        if (StringUtils.isNotBlank(organId)) {
            lstUsers = userService.getUserListByOragn(organId);
        }
        if (StringUtils.isNotBlank(roleId)) {
            lstUsers = userService.getUserListByRole(roleId);
        }
        return JsonUtils.toString(lstUsers);
    }

    @RequestMapping(value = "/message/countMessage/{userId}", method = RequestMethod.GET)
    @ResponseBody
    public Object countMessage(Model model, @PathVariable String userId) throws Exception {
        return String.valueOf(messageService.countPfMessageAccept(userId, 0, ""));
    }

    @RequestMapping(value = "/message/countYcqMessage/{userId}", method = RequestMethod.GET)
    @ResponseBody
    public Object countYcqMessage(Model model, @PathVariable String userId) throws Exception {
        return String.valueOf(messageService.countPfMessageAccept(userId, 0, "待办任务时限已超期提醒"));
    }

    @RequestMapping(value = "/message/countJjcqMessage/{userId}", method = RequestMethod.GET)
    @ResponseBody
    public Object countJjcqMessage(Model model, @PathVariable String userId) throws Exception {
        return String.valueOf(messageService.countPfMessageAccept(userId, 0, "待办任务时限即将到期提醒"));
    }

    @RequestMapping(value = "/message/countDBMessage/{userId}", method = RequestMethod.GET)
    @ResponseBody
    public Object countDbMessage(@PathVariable String userId) {
        return String.valueOf(messageService.countPfMessageAccept(userId, 0, "待办任务提醒"));
    }

    @RequestMapping(value = "/message/countWwsqMessage/{userId}", method = RequestMethod.GET)
    @ResponseBody
    public Object countWwsqMessage(@PathVariable String userId) {
        return String.valueOf(messageService.countPfMessageAccept(userId, 0, "外网申请待匹配提醒"));
    }
    /**
     * 创建消息接口
     *@param messagesendUserId 发送人id
     *
     *@param messagesendTitle 标题
     *
     *@param messagesendContent 内容
     *
     *@param users 接收人
     *
     * @param request request
     * @return
     */
    @ResponseBody
    @RequestMapping("message/createMessageInterface")
    public Object createMessageInterface(@RequestParam(value="messagesendUserId" ) String messagesendUserId,@RequestParam(value="messagesendTitle")String messagesendTitle,@RequestParam(value="messagesendContent")String messagesendContent ,@RequestParam(value="users")String users, HttpServletRequest request) {
        Map<String, Object> result = new HashMap<String, Object>(3);
        try {
            String messagesendId = UUIDGenerator.generate18();
            PfMessageSend pfMessageSend = new PfMessageSend();
            pfMessageSend.setMessagesendId(messagesendId);
            pfMessageSend.setMessagesendDate(new Date());

            PfUser pfUser = new PfUser();
            PfUserVo pfUserVo = sysUserService.getUserVo(messagesendUserId);
            if(pfUserVo != null){
                pfUser.setUserId(messagesendUserId);
            }
            pfMessageSend.setMessagesendUser(pfUser);
            pfMessageSend.setMessagesendTitle(messagesendTitle);
            pfMessageSend.setMessagesendContent(messagesendContent);

            messageService.addSendMessageAndAcceptMessageInterface(pfMessageSend, users);
                //保存日志
            messageService.addPfLogBySendMessageInterface(pfMessageSend, ClientInfoUtil.getIpAddr(request),messagesendUserId);
            result.put("result", true);

        } catch (Exception e) {
            result.put("result", false);
            e.printStackTrace();
        }

        return result;
    }
}