package com.gtis.portal.web;

import cn.gtmap.estateplat.log.AuditLogService;
import cn.gtmap.estateplat.utils.ClientInfoUtil;
import com.gtis.config.AppConfig;
import com.gtis.plat.service.*;
import com.gtis.plat.vo.*;
import com.gtis.portal.entity.BdcXtLog;
import com.gtis.portal.service.server.impl.AuditLogServiceImpl;
import com.gtis.web.SessionUtil;
import org.apache.commons.lang.StringUtils;
import org.apache.http.client.utils.HttpClientUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.servlet.http.HttpServletRequest;
import java.util.*;

/**
 * .
 * <p/>记录日志
 *
 * @author <a href="mailto:zhangxing@gtmap.cn">zhangxing</a>
 * @version 1.0, 2017/1/4
 */
@Controller
@RequestMapping("/log")
public class LogController {
    @Autowired
    AuditLogServiceImpl auditLogService;
    @Autowired
    SysWorkFlowInstanceService sysWorkFlowInstanceService;
    @Autowired
    SysTaskService sysTaskService;
    @Autowired
    SysActivityService sysActivityService;
    @Autowired
    SysUserService sysUserService;

    @RequestMapping("saveLog")
    @ResponseBody
    public Object saveLog(HttpServletRequest request, @RequestParam(value = "wiid", required = false) String wiid, @RequestParam(value = "taskid", required = false) String taskid, @RequestParam(value = "reason", required = false) String reason) {
        String msg = "ok";
        String content = "";
        String ip = "";
        String mac = "";
        String computername = "";
        String username = "";
        try {
            if (StringUtils.isNotBlank(wiid)) {
                PfWorkFlowInstanceVo pfWorkFlowInstanceVo = sysWorkFlowInstanceService.getWorkflowInstance(wiid);
                if (pfWorkFlowInstanceVo != null)
                    content = "用户删除" + pfWorkFlowInstanceVo.getProId() + "备注：" + pfWorkFlowInstanceVo.getRemark();
            }
            if (StringUtils.isNotBlank(taskid)) {
                PfTaskVo pfTaskVo = sysTaskService.getTask(taskid);
                if (pfTaskVo != null && StringUtils.isNotBlank(pfTaskVo.getActivityId())) {
                    PfActivityVo pfActivityVo = sysActivityService.getActivityById(pfTaskVo.getActivityId());
                    if (pfActivityVo != null && StringUtils.isNotBlank(pfActivityVo.getWorkflowInstanceId())) {
                        PfWorkFlowInstanceVo pfWorkFlowInstanceVo = sysWorkFlowInstanceService.getWorkflowInstance(pfActivityVo.getWorkflowInstanceId());
                        if (pfWorkFlowInstanceVo != null)
                            content = "用户删除" + pfWorkFlowInstanceVo.getProId() + "备注：" + pfWorkFlowInstanceVo.getRemark();
                    }
                }
            }
            String macEnable = AppConfig.getProperty("save.log.mac.enable");

            try {
                ip = ClientInfoUtil.getIpAddr(request);

            } catch (Exception e) {
            }

            String userid = SessionUtil.getCurrentUserId();
            if (StringUtils.isNotBlank(userid)) {
                PfUserVo pfUserVo = sysUserService.getUserVo(userid);
                if (pfUserVo != null)
                    username = pfUserVo.getUserName();
            }
            BdcXtLog bdcXtLog = new BdcXtLog();
            bdcXtLog.setUserid(userid);
            bdcXtLog.setUsername(username);
            bdcXtLog.setIp(ip);
            bdcXtLog.setMac(mac);
            bdcXtLog.setComputername(computername);
            bdcXtLog.setController("删除");
            bdcXtLog.setCzrq(new Date());
            bdcXtLog.setParmjson(content);
            bdcXtLog.setReason(reason);
            auditLogService.saveAuditLog(bdcXtLog);
        } catch (Exception e) {
            msg = "error";
        }

        return msg;
    }

}
